/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.banco_brasil_api;

import br.com.java_brasil.boleto.model.Configuracao;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;

public class ConfiguracaoBancoBrasilAPI
implements Configuracao {
    @NotEmpty
    private String clientId;
    @NotEmpty
    private String clientSecret;
    @NotEmpty
    private String developerKey;
    @NotNull
    private AmbienteEnum ambiente;
    @NotEmpty
    private String urlDevAppKey = "?gw-dev-app-key=";
    @NotEmpty
    private String urlTokenProducao = "https://oauth.bb.com.br/oauth/token";
    @NotEmpty
    private String urlTokenHomologacao = "https://oauth.hm.bb.com.br/oauth/token";
    @NotEmpty
    private String urlBaseProducao = "https://api.bb.com.br/cobrancas/v2";
    @NotEmpty
    private String urlBaseHomologacao = "https://api.hm.bb.com.br/cobrancas/v2";
    private final String arquivoJasper = "BoletoBancoBrasil";
    private final String logo = "LogoBancoBrasil.png";
    private InputStream modeloImpressaoBoleto;
    private HashMap<String, Object> parametrosImpressaoBoleto = new HashMap();

    public HashMap<String, Object> getParametrosImpressaoBoleto() {
        return this.parametrosImpressaoBoleto;
    }

    public void setModeloImpressaoBoleto(InputStream modeloImpressaoBoleto) {
        this.modeloImpressaoBoleto = modeloImpressaoBoleto;
    }

    @Override
    public InputStream modeloImpressaoBoleto() {
        if (this.modeloImpressaoBoleto == null) {
            try {
                this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoBancoBrasil.jasper");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.modeloImpressaoBoleto;
    }

    @Override
    public void usarModeloImpressaoBoletoCarne() {
        try {
            this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoCarne.jasper");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public HashMap<String, Object> parametrosImpressaoBoleto() {
        Image imageLogo = null;
        try {
            InputStream inputStreamLogo = this.getClass().getResourceAsStream("/logo/LogoBancoBrasil.png");
            imageLogo = new ImageIcon(IOUtils.toByteArray((InputStream)inputStreamLogo)).getImage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.parametrosImpressaoBoleto.put("LogoBanco", imageLogo);
        this.parametrosImpressaoBoleto.put("REPORT_LOCALE", new Locale("pt", "BR"));
        return this.parametrosImpressaoBoleto;
    }

    @Override
    public List<String> camposObrigatoriosBoleto() {
        return Arrays.asList("beneficiario.numeroConvenio", "beneficiario.carteira", "beneficiario.variacaoCarteira", "codigoModalidade", "dataVencimento", "valorBoleto", "aceite", "especieDocumento", "numeroDocumento", "numeroDaParcelaCarne,max:3", "pagador.documento", "pagador.nome", "pagador.endereco.logradouro", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.cep", "pagador.endereco.uf", "pagador");
    }

    public String getURLBase() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlBaseProducao : this.urlBaseHomologacao;
    }

    public String getURLToken() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlTokenProducao : this.urlTokenHomologacao;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getDeveloperKey() {
        return this.developerKey;
    }

    @NotNull
    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    public String getUrlDevAppKey() {
        return this.urlDevAppKey;
    }

    public String getUrlTokenProducao() {
        return this.urlTokenProducao;
    }

    public String getUrlTokenHomologacao() {
        return this.urlTokenHomologacao;
    }

    public String getUrlBaseProducao() {
        return this.urlBaseProducao;
    }

    public String getUrlBaseHomologacao() {
        return this.urlBaseHomologacao;
    }

    public String getArquivoJasper() {
        return this.arquivoJasper;
    }

    public String getLogo() {
        return this.logo;
    }

    public InputStream getModeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setDeveloperKey(String developerKey) {
        this.developerKey = developerKey;
    }

    public void setAmbiente(@NotNull AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public void setUrlDevAppKey(String urlDevAppKey) {
        this.urlDevAppKey = urlDevAppKey;
    }

    public void setUrlTokenProducao(String urlTokenProducao) {
        this.urlTokenProducao = urlTokenProducao;
    }

    public void setUrlTokenHomologacao(String urlTokenHomologacao) {
        this.urlTokenHomologacao = urlTokenHomologacao;
    }

    public void setUrlBaseProducao(String urlBaseProducao) {
        this.urlBaseProducao = urlBaseProducao;
    }

    public void setUrlBaseHomologacao(String urlBaseHomologacao) {
        this.urlBaseHomologacao = urlBaseHomologacao;
    }

    public void setParametrosImpressaoBoleto(HashMap<String, Object> parametrosImpressaoBoleto) {
        this.parametrosImpressaoBoleto = parametrosImpressaoBoleto;
    }
}

