/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.banco_brasil_cnab240;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.Beneficiario;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Pagador;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.TipoJurosEnum;
import br.com.java_brasil.boleto.model.enums.TipoMultaEnum;
import br.com.java_brasil.boleto.service.bancos.banco_brasil_cnab240.BancoBrasilUtil;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.ValidaUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang3.StringUtils;

public class BancoBrasilCnab240
extends BoletoController {
    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            boletos.forEach(this::preparaValidaBoletoImpressao);
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        return this.gerarArquivo(remessaRetornoModel);
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        return this.importarArquivo(arquivo);
    }

    public String gerarArquivo(List<RemessaRetornoModel> list) {
        list.forEach(boleto -> ValidaUtils.validaBoletoModel(boleto.getBoleto(), this.getConfiguracao().camposObrigatoriosBoleto()));
        int contador = 0;
        int contadorLinhas = 0;
        BigDecimal valorTotalTitulos = BigDecimal.ZERO;
        StringBuilder linhaArquivo = new StringBuilder();
        ++contadorLinhas;
        linhaArquivo.append("001");
        linhaArquivo.append("0000");
        linhaArquivo.append("0");
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)9));
        linhaArquivo.append(list.get(0).getBoleto().getBeneficiario().isClienteCpf() ? "1" : "2");
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getDocumento(), 14, "0"));
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getNumeroConvenio(), 9, "0"));
        linhaArquivo.append("0014");
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getCarteira(), 2, "0"));
        linhaArquivo.append(BoletoUtil.rightPad(list.get(0).getBoleto().getBeneficiario().getVariacaoCarteira(), 3, " "));
        linhaArquivo.append("  ");
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getAgencia(), 5, "0"));
        linhaArquivo.append(BoletoUtil.rightPad(list.get(0).getBoleto().getBeneficiario().getDigitoAgencia(), 1, " "));
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getConta(), 12, "0"));
        linhaArquivo.append(BoletoUtil.rightPad(list.get(0).getBoleto().getBeneficiario().getDigitoConta(), 1, " "));
        linhaArquivo.append(" ");
        linhaArquivo.append(BoletoUtil.rightPad(list.get(0).getBoleto().getBeneficiario().getNomeBeneficiario(), 30, " "));
        linhaArquivo.append(BoletoUtil.rightPad("BANCO DO BRASIL S.A.", 30, " "));
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)10));
        linhaArquivo.append("1");
        linhaArquivo.append(BoletoUtil.getDataFormato(LocalDate.now(), "ddMMyyyy"));
        linhaArquivo.append(BoletoUtil.getHoraFormato(LocalTime.now(), "HHmmss"));
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getNumeroRemessa(), 6, "0"));
        linhaArquivo.append("000");
        linhaArquivo.append("00000");
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)20));
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)20));
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)29));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        ++contadorLinhas;
        linhaArquivo.append("001");
        linhaArquivo.append("0001");
        linhaArquivo.append("1");
        linhaArquivo.append("R");
        linhaArquivo.append("01");
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)2));
        linhaArquivo.append("000");
        linhaArquivo.append(" ");
        linhaArquivo.append(list.get(0).getBoleto().getBeneficiario().isClienteCpf() ? "1" : "2");
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getDocumento(), 15, "0"));
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getNumeroConvenio(), 9, "0"));
        linhaArquivo.append("0014");
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getCarteira(), 2, "0"));
        linhaArquivo.append(BoletoUtil.rightPad(list.get(0).getBoleto().getBeneficiario().getVariacaoCarteira(), 3, " "));
        linhaArquivo.append("  ");
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getAgencia(), 5, "0"));
        linhaArquivo.append(BoletoUtil.rightPad(list.get(0).getBoleto().getBeneficiario().getDigitoAgencia(), 1, " "));
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getConta(), 12, "0"));
        linhaArquivo.append(BoletoUtil.rightPad(list.get(0).getBoleto().getBeneficiario().getDigitoConta(), 1, " "));
        linhaArquivo.append(" ");
        linhaArquivo.append(BoletoUtil.rightPad(list.get(0).getBoleto().getBeneficiario().getNomeBeneficiario(), 30, " "));
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)40));
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)40));
        linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getNumeroRemessa(), 8, "0"));
        linhaArquivo.append(BoletoUtil.getDataFormato(LocalDate.now(), "ddMMyyyy"));
        linhaArquivo.append(StringUtils.repeat((String)"0", (int)8));
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)33));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        for (RemessaRetornoModel boleto2 : list) {
            ++contador;
            ++contadorLinhas;
            linhaArquivo.append("001");
            linhaArquivo.append("0001");
            linhaArquivo.append("3");
            linhaArquivo.append(BoletoUtil.leftPad(Integer.toString(contador), 5, "0"));
            linhaArquivo.append("P");
            linhaArquivo.append(" ");
            linhaArquivo.append(BoletoUtil.leftPad(boleto2.getInstrucao(), 2, "0"));
            linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getAgencia(), 5, "0"));
            linhaArquivo.append(BoletoUtil.rightPad(list.get(0).getBoleto().getBeneficiario().getDigitoAgencia(), 1, " "));
            linhaArquivo.append(BoletoUtil.leftPad(list.get(0).getBoleto().getBeneficiario().getConta(), 12, "0"));
            linhaArquivo.append(BoletoUtil.rightPad(list.get(0).getBoleto().getBeneficiario().getDigitoConta(), 1, " "));
            linhaArquivo.append(" ");
            String nossoNumeroEnvio = boleto2.getBoleto().getNossoNumero();
            if (boleto2.getBoleto().getDigitoNossoNumero() != null) {
                nossoNumeroEnvio = nossoNumeroEnvio + boleto2.getBoleto().getDigitoNossoNumero();
            }
            linhaArquivo.append(BoletoUtil.rightPad(nossoNumeroEnvio, 20, " "));
            linhaArquivo.append(boleto2.getBoleto().getBeneficiario().getCodigoCarteira());
            linhaArquivo.append("1");
            linhaArquivo.append("1");
            linhaArquivo.append(boleto2.getImpressaoTitulo());
            linhaArquivo.append(boleto2.getPostagemTitulo());
            linhaArquivo.append(BoletoUtil.rightPad(boleto2.getBoleto().getNumeroDocumento(), 15, " "));
            linhaArquivo.append(BoletoUtil.getDataFormato(boleto2.getBoleto().getDataVencimento(), "ddMMyyyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorBoleto(), 2, 15));
            valorTotalTitulos = valorTotalTitulos.add(boleto2.getBoleto().getValorBoleto());
            linhaArquivo.append("00000");
            linhaArquivo.append(" ");
            linhaArquivo.append(BoletoUtil.leftPad(boleto2.getBoleto().getEspecieDocumento(), 2, "0"));
            linhaArquivo.append(boleto2.getBoleto().isAceite() ? "A" : "N");
            linhaArquivo.append(BoletoUtil.getDataFormato(boleto2.getBoleto().getDataEmissao(), "ddMMyyyy"));
            if (!boleto2.getBoleto().getTipoJuros().equals((Object)TipoJurosEnum.ISENTO) && BoletoUtil.isNotNullEMaiorQZero(boleto2.getBoleto().getValorPercentualJuros())) {
                linhaArquivo.append(boleto2.getBoleto().getTipoJuros().equals((Object)TipoJurosEnum.VALOR_DIA) ? "1" : "2");
                if (boleto2.getBoleto().getDiasJuros() > 0) {
                    LocalDate dataParaInicioJuros = BoletoUtil.adicionarDiasData(boleto2.getBoleto().getDataVencimento(), boleto2.getBoleto().getDiasJuros());
                    linhaArquivo.append(BoletoUtil.getDataFormato(dataParaInicioJuros, "ddMMyyyy"));
                } else {
                    linhaArquivo.append(BoletoUtil.getDataFormato(boleto2.getBoleto().getDataVencimento(), "ddMMyyyy"));
                }
                linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualJuros(), 2, 15));
            } else {
                linhaArquivo.append("3");
                linhaArquivo.append(StringUtils.repeat((String)"0", (int)8));
                linhaArquivo.append(StringUtils.repeat((String)"0", (int)15));
            }
            String codigoDesconto = "0";
            switch (boleto2.getBoleto().getTipoDesconto()) {
                case VALOR_FIXO: {
                    linhaArquivo.append("1");
                    codigoDesconto = "1";
                    break;
                }
                case PERCENTUAL_FIXO: {
                    linhaArquivo.append("2");
                    codigoDesconto = "2";
                    break;
                }
                case VALOR_DIA: {
                    linhaArquivo.append("3");
                    codigoDesconto = "3";
                    break;
                }
                default: {
                    linhaArquivo.append("0");
                }
            }
            linhaArquivo.append(boleto2.getBoleto().getDataLimiteParaDesconto() == null ? "00000000" : BoletoUtil.getDataFormato(boleto2.getBoleto().getDataLimiteParaDesconto(), "ddMMyyyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualDescontos(), 2, 15));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorIof(), 2, 15));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorDeducoes(), 2, 15));
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)25));
            linhaArquivo.append(boleto2.getBoleto().isProtesto() ? "1" : "3");
            linhaArquivo.append(BoletoUtil.leftPad(String.valueOf(boleto2.getBoleto().getDiasProtesto()), 2, "0"));
            linhaArquivo.append("0");
            linhaArquivo.append(StringUtils.repeat((String)"0", (int)3));
            linhaArquivo.append("00");
            linhaArquivo.append(BoletoUtil.leftPad(boleto2.getBoleto().getContratoEspecie(), 10, "0"));
            linhaArquivo.append(" ");
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
            ++contadorLinhas;
            linhaArquivo.append("001");
            linhaArquivo.append("0001");
            linhaArquivo.append("3");
            linhaArquivo.append(BoletoUtil.leftPad(Integer.toString(++contador), 5, "0"));
            linhaArquivo.append("Q");
            linhaArquivo.append(" ");
            linhaArquivo.append(BoletoUtil.leftPad(boleto2.getInstrucao(), 2, "0"));
            linhaArquivo.append(boleto2.getBoleto().getPagador().isClienteCpf() ? "1" : "2");
            linhaArquivo.append(BoletoUtil.leftPad(boleto2.getBoleto().getPagador().getDocumento(), 15, "0"));
            linhaArquivo.append(BoletoUtil.rightPad(boleto2.getBoleto().getPagador().getNome(), 40, " "));
            String enderecoCompleto = boleto2.getBoleto().getPagador().getEndereco().getLogradouro();
            enderecoCompleto = enderecoCompleto + ", " + boleto2.getBoleto().getPagador().getEndereco().getNumero();
            if (boleto2.getBoleto().getPagador().getEndereco().getComplemento() != null) {
                enderecoCompleto = enderecoCompleto + " " + boleto2.getBoleto().getPagador().getEndereco().getComplemento();
            }
            linhaArquivo.append(BoletoUtil.rightPad(enderecoCompleto, 40, " "));
            linhaArquivo.append(BoletoUtil.rightPad(boleto2.getBoleto().getPagador().getEndereco().getBairro(), 15, " "));
            linhaArquivo.append(BoletoUtil.leftPad(boleto2.getBoleto().getPagador().getEndereco().getCep(), 8, "0"));
            linhaArquivo.append(BoletoUtil.rightPad(boleto2.getBoleto().getPagador().getEndereco().getCidade(), 15, " "));
            linhaArquivo.append(boleto2.getBoleto().getPagador().getEndereco().getUf());
            if (boleto2.getBoleto().getBeneficiarioFinal() != null) {
                linhaArquivo.append(boleto2.getBoleto().getBeneficiarioFinal().isClienteCpf() ? "1" : "2");
                linhaArquivo.append(BoletoUtil.leftPad(boleto2.getBoleto().getBeneficiarioFinal().getDocumento(), 15, "0"));
                linhaArquivo.append(BoletoUtil.rightPad(boleto2.getBoleto().getBeneficiarioFinal().getNome(), 40, " "));
            } else {
                linhaArquivo.append("0");
                linhaArquivo.append(StringUtils.repeat((String)"0", (int)15));
                linhaArquivo.append(StringUtils.repeat((String)" ", (int)40));
            }
            linhaArquivo.append("000");
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)20));
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)8));
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
            ++contadorLinhas;
            linhaArquivo.append("001");
            linhaArquivo.append("0001");
            linhaArquivo.append("3");
            linhaArquivo.append(BoletoUtil.leftPad(Integer.toString(++contador), 5, "0"));
            linhaArquivo.append("R");
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)1));
            linhaArquivo.append(BoletoUtil.leftPad(boleto2.getInstrucao(), 2, "0"));
            linhaArquivo.append(codigoDesconto);
            linhaArquivo.append(boleto2.getBoleto().getDataLimiteParaDesconto2() == null ? "00000000" : BoletoUtil.getDataFormato(boleto2.getBoleto().getDataLimiteParaDesconto2(), "ddMMyyyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualDescontos2(), 2, 15));
            linhaArquivo.append(codigoDesconto);
            linhaArquivo.append(boleto2.getBoleto().getDataLimiteParaDesconto3() == null ? "00000000" : BoletoUtil.getDataFormato(boleto2.getBoleto().getDataLimiteParaDesconto3(), "ddMMyyyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualDescontos3(), 2, 15));
            if (BoletoUtil.isNotNullEMaiorQZero(boleto2.getBoleto().getValorPercentualMulta())) {
                linhaArquivo.append(boleto2.getBoleto().getTipoMulta().equals((Object)TipoMultaEnum.VALOR) ? "1" : "2");
            } else {
                linhaArquivo.append("0");
            }
            if (boleto2.getBoleto().getDiasMulta() > 0) {
                LocalDate dataParaInicioMulta = BoletoUtil.adicionarDiasData(boleto2.getBoleto().getDataVencimento(), boleto2.getBoleto().getDiasMulta());
                linhaArquivo.append(BoletoUtil.getDataFormato(dataParaInicioMulta, "ddMMyyyy"));
            } else {
                linhaArquivo.append(StringUtils.repeat((String)"0", (int)8));
            }
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualMulta(), 2, 15));
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)10));
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)40));
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)40));
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)20));
            linhaArquivo.append("00000000");
            linhaArquivo.append(StringUtils.repeat((String)"0", (int)3));
            linhaArquivo.append(StringUtils.repeat((String)"0", (int)5));
            linhaArquivo.append(" ");
            linhaArquivo.append(StringUtils.repeat((String)"0", (int)12));
            linhaArquivo.append(" ");
            linhaArquivo.append(" ");
            linhaArquivo.append("0");
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)9));
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
        }
        linhaArquivo.append("001");
        linhaArquivo.append("0001");
        linhaArquivo.append("5");
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)9));
        linhaArquivo.append(BoletoUtil.leftPad(Integer.toString(contadorLinhas), 6, "0"));
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)217));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        ++contadorLinhas;
        ++contadorLinhas;
        linhaArquivo.append("001");
        linhaArquivo.append("9999");
        linhaArquivo.append("9");
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)9));
        linhaArquivo.append("000001");
        linhaArquivo.append(BoletoUtil.leftPad(Integer.toString(contadorLinhas), 6, "0"));
        linhaArquivo.append("000000");
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)205));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        String arquivoRemessa = linhaArquivo.toString();
        StringBuilder sbRemessa = new StringBuilder();
        for (int i = 0; i < arquivoRemessa.length(); ++i) {
            char ch = arquivoRemessa.charAt(i);
            if (BancoBrasilUtil.isASCIIBancoBrasil(ch)) {
                sbRemessa.append(ch);
                continue;
            }
            sbRemessa.append(' ');
        }
        return sbRemessa.toString();
    }

    private List<RemessaRetornoModel> importarArquivo(String arquivo) {
        ArrayList<RemessaRetornoModel> list = new ArrayList<RemessaRetornoModel>();
        try (Scanner scanner = new Scanner(arquivo);){
            String numeroRetorno = null;
            String beneficiarioDocumento = null;
            String beneficiarioAgencia = null;
            String beneficiarioAgenciaDigito = null;
            String beneficiarioConta = null;
            String beneficiarioContaDigito = null;
            while (scanner.hasNextLine()) {
                String linha = scanner.nextLine();
                if (linha.length() <= 1) continue;
                if (linha.charAt(7) == '0') {
                    if (linha.charAt(142) != '2') {
                        throw new BoletoException("Formato do aquivo inv\u00e1lido.");
                    }
                    if (!linha.substring(0, 3).equals("001")) {
                        throw new BoletoException("N\u00famero do Banco inv\u00e1lido.");
                    }
                    numeroRetorno = linha.substring(157, 163);
                    beneficiarioDocumento = linha.substring(18, 32);
                    beneficiarioAgencia = linha.substring(52, 57);
                    beneficiarioAgenciaDigito = linha.substring(57, 58);
                    beneficiarioConta = linha.substring(58, 70);
                    beneficiarioContaDigito = linha.substring(70, 71);
                }
                if (linha.charAt(7) != '3') continue;
                String tipoRegistro = linha.substring(13, 14);
                if (tipoRegistro.equals("T")) {
                    RemessaRetornoModel remessaRetornoModel = new RemessaRetornoModel();
                    remessaRetornoModel.setBoleto(new BoletoModel());
                    remessaRetornoModel.getBoleto().setPagador(new Pagador());
                    Beneficiario beneficiario = new Beneficiario();
                    beneficiario.setDocumento(beneficiarioDocumento);
                    beneficiario.setAgencia(beneficiarioAgencia);
                    beneficiario.setDigitoAgencia(beneficiarioAgenciaDigito);
                    beneficiario.setConta(beneficiarioConta);
                    beneficiario.setDigitoConta(beneficiarioContaDigito);
                    remessaRetornoModel.getBoleto().setBeneficiario(beneficiario);
                    remessaRetornoModel.getBoleto().setCodRetorno(numeroRetorno);
                    remessaRetornoModel.getBoleto().getPagador().setDocumento(linha.substring(133, 148));
                    remessaRetornoModel.getBoleto().getPagador().setNome(linha.substring(148, 188));
                    String nossoNumero = linha.substring(37, 57);
                    if (nossoNumero.length() == 1) {
                        remessaRetornoModel.getBoleto().setNossoNumero(nossoNumero.substring(4, 11));
                        remessaRetornoModel.getBoleto().setDigitoNossoNumero(nossoNumero.substring(11));
                    } else if (nossoNumero.length() == 12) {
                        remessaRetornoModel.getBoleto().setNossoNumero(nossoNumero.substring(6, 11));
                        remessaRetornoModel.getBoleto().setDigitoNossoNumero(nossoNumero.substring(11));
                    } else {
                        remessaRetornoModel.getBoleto().setNossoNumero(nossoNumero.substring(7, 17));
                    }
                    remessaRetornoModel.setOcorrencia(linha.substring(15, 17));
                    remessaRetornoModel.getBoleto().setNumeroDocumento(linha.substring(58, 73));
                    remessaRetornoModel.getBoleto().setDataVencimento(BoletoUtil.formataStringPadraoDDMMYYYYParaLocalDate(linha.substring(73, 81)));
                    remessaRetornoModel.getBoleto().setValorBoleto(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(81, 96)));
                    remessaRetornoModel.setDespesaCobranca(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(198, 213)));
                    remessaRetornoModel.setMotivoOcorrencia(linha.substring(213, 223));
                    list.add(remessaRetornoModel);
                    continue;
                }
                if (!tipoRegistro.equals("U")) continue;
                ((RemessaRetornoModel)list.get(list.size() - 1)).setAbatimentoConcedido(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(47, 62)));
                String previsaoConta = linha.substring(145, 153);
                if (!previsaoConta.replaceAll("\\D", "").equals("00000000")) {
                    ((RemessaRetornoModel)list.get(list.size() - 1)).setDataPrevisaoLancamento(BoletoUtil.formataStringPadraoDDMMYYYYParaLocalDate(previsaoConta));
                }
                ((RemessaRetornoModel)list.get(list.size() - 1)).setDataOcorrencia(BoletoUtil.formataStringPadraoDDMMYYYYParaLocalDate(linha.substring(137, 145)));
                ((RemessaRetornoModel)list.get(list.size() - 1)).setDescontoConcedido(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(32, 47)));
                ((RemessaRetornoModel)list.get(list.size() - 1)).setDespesaCobranca(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(107, 122)));
                ((RemessaRetornoModel)list.get(list.size() - 1)).setJuroDeMora(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(17, 32)));
                ((RemessaRetornoModel)list.get(list.size() - 1)).setOcorrencia(linha.substring(15, 17));
                ((RemessaRetornoModel)list.get(list.size() - 1)).setValorEfetivamentePago(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(92, 107)));
            }
        }
        return list;
    }

    private void preparaValidaBoletoImpressao(BoletoModel boletoModel) {
        boletoModel.getBeneficiario().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiario().getDocumento()));
        boletoModel.getPagador().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getPagador().getDocumento()));
        if (boletoModel.getBeneficiarioFinal() != null) {
            boletoModel.getBeneficiarioFinal().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiarioFinal().getDocumento()));
        }
        StringBuilder codigoBarras = new StringBuilder();
        codigoBarras.append("0019");
        codigoBarras.append("X");
        codigoBarras.append(BancoBrasilUtil.fatorData(boletoModel.getDataVencimento()));
        codigoBarras.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
        StringBuilder campoLivre = new StringBuilder();
        Integer numeroConvenio = Integer.parseInt(boletoModel.getBeneficiario().getNumeroConvenio());
        if (numeroConvenio.compareTo(999999) <= 0) {
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getNossoNumero(), 11, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getAgencia(), 4, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getConta(), 8, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getCarteira(), 2, "0"));
        } else {
            campoLivre.append("000000");
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getNossoNumero(), 17, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getCarteira(), 2, "0"));
        }
        codigoBarras.append((CharSequence)campoLivre);
        String dvCodigoBarras = BancoBrasilUtil.modulo11BB(codigoBarras.toString().replace("X", ""));
        boletoModel.setLinhaDigitavel(codigoBarras.toString().replace("X", dvCodigoBarras));
        boletoModel.setCodigoBarras(codigoBarras.toString().replace("X", dvCodigoBarras));
        StringBuilder linhaParte1 = new StringBuilder();
        linhaParte1.append(boletoModel.getLinhaDigitavel(), 0, 4);
        linhaParte1.append(boletoModel.getLinhaDigitavel(), 19, 21);
        linhaParte1.append(boletoModel.getLinhaDigitavel(), 21, 24);
        linhaParte1.append(BancoBrasilUtil.modulo10BB(linhaParte1.toString()));
        StringBuilder linhaParte2 = new StringBuilder();
        linhaParte2.append(boletoModel.getLinhaDigitavel(), 24, 34);
        linhaParte2.append(BancoBrasilUtil.modulo10BB(linhaParte2.toString()));
        StringBuilder linhaParte3 = new StringBuilder();
        linhaParte3.append(boletoModel.getLinhaDigitavel(), 34, 44);
        linhaParte3.append(BancoBrasilUtil.modulo10BB(linhaParte3.toString()));
        StringBuilder linhaParte4 = new StringBuilder();
        linhaParte4.append(boletoModel.getLinhaDigitavel().charAt(4));
        linhaParte4.append(boletoModel.getLinhaDigitavel(), 5, 9);
        linhaParte4.append(boletoModel.getLinhaDigitavel(), 9, 19);
        StringBuilder linhaDigitavel = new StringBuilder();
        linhaDigitavel.append(linhaParte1, 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte1, 5, 10);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte2, 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte2, 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte3, 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte3, 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte4.toString().charAt(0));
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte4.toString(), 1, 15);
        boletoModel.setLinhaDigitavel(linhaDigitavel.toString());
        this.validaDadosImpressao(boletoModel);
    }

    private void validaDadosImpressao(BoletoModel boleto) {
        ValidaUtils.validaBoletoModel(boleto, Arrays.asList("locaisDePagamento", "dataVencimento", "dataEmissao", "numeroDocumento", "especieDocumento", "aceite", "especieMoeda", "valorBoleto", "linhaDigitavel", "codigoBarras", "nossoNumero", "beneficiario", "beneficiario.numeroConvenio", "beneficiario.nomeBeneficiario", "beneficiario.documento", "beneficiario.agencia", "beneficiario.digitoConta", "beneficiario.conta", "beneficiario.carteira", "beneficiario.variacaoCarteira", "beneficiario.endereco", "beneficiario.endereco.logradouro", "beneficiario.endereco.numero", "beneficiario.endereco.bairro", "beneficiario.endereco.cidade", "beneficiario.endereco.uf", "beneficiario.endereco.cep", "pagador", "pagador.nome", "pagador.documento", "pagador.endereco.logradouro", "pagador.endereco.cep", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.uf"));
    }
}

