/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.banco_brasil_cnab240;

import br.com.java_brasil.boleto.util.BoletoUtil;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BancoBrasilUtil {
    public static String modulo11BB(String linha) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < linha.length(); ++i) {
            total += (linha.charAt(linha.length() - 1 - i) - 48) * peso;
            if (++peso != 10) continue;
            peso = 2;
        }
        int resto = total % 11;
        if ((resto = 11 - resto) == 0 || resto == 10 || resto == 11) {
            return "1";
        }
        return "" + resto;
    }

    public static String geraNossoNumero(String numeroConvenio, String nossoNumero) {
        Integer convenio = Integer.parseInt(numeroConvenio);
        if (convenio.compareTo(9999) <= 0) {
            return BoletoUtil.leftPad(numeroConvenio, 4, "0").concat(BoletoUtil.leftPad(nossoNumero, 7, "0"));
        }
        if (convenio.compareTo(9999) > 0 && convenio.compareTo(999999) <= 0) {
            return BoletoUtil.leftPad(numeroConvenio, 6, "0").concat(BoletoUtil.leftPad(nossoNumero, 5, "0"));
        }
        return BoletoUtil.leftPad(numeroConvenio, 7, "0").concat(BoletoUtil.leftPad(nossoNumero, 10, "0"));
    }

    public static String geraDigitoNossoNumero(String nossoNumero) {
        int total = 0;
        int peso = 9;
        for (int i = 0; i < nossoNumero.length(); ++i) {
            total += (nossoNumero.charAt(nossoNumero.length() - 1 - i) - 48) * peso;
            if (--peso != 1) continue;
            peso = 9;
        }
        int resto = total % 11;
        if (resto < 10) {
            return "" + resto;
        }
        return "X";
    }

    public static Integer modulo10BB(String codigo) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < codigo.length(); ++i) {
            int valor = (codigo.charAt(codigo.length() - 1 - i) - 48) * peso;
            valor = BancoBrasilUtil.ajustaPesoBB(valor);
            total += valor;
            if (peso == 2) {
                --peso;
                continue;
            }
            ++peso;
        }
        int resto = total % 10;
        int dezena = total + (10 - resto);
        int digito = dezena - total;
        if (digito == 10) {
            digito = 0;
        }
        return digito;
    }

    private static int ajustaPesoBB(int valor) {
        if (valor <= 9) {
            return valor;
        }
        char[] digitos = String.valueOf(valor).toCharArray();
        int novoValor = 0;
        for (char d : digitos) {
            novoValor += Character.getNumericValue(d);
        }
        return novoValor;
    }

    public static String fatorData(LocalDate dataVencimento) {
        LocalDate dataBase = LocalDate.of(1997, 10, 7);
        if (dataVencimento.isAfter(LocalDate.of(2025, 2, 21))) {
            dataBase = dataBase.plusDays(9000L);
        }
        long difDia = ChronoUnit.DAYS.between(dataBase, dataVencimento);
        return StringUtils.leftPad((String)("" + difDia), (int)4, (char)'0');
    }

    public static boolean isASCIIBancoBrasil(char ch) {
        if (ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9') {
            return true;
        }
        if (ch == ' ' || ch == '!' || ch == '#' || ch == '$' || ch == '%' || ch == '&' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == '-' || ch == '.' || ch == '/' || ch == ':' || ch == ';' || ch == '@' || ch == '[' || ch == '\\' || ch == ']' || ch == '{' || ch == '}') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        return ch == '\n' || ch == '\r';
    }

    public static Map<String, String> getMapOcorrencia() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("02", "Entrada confirmada");
            map.put("03", "Entrada rejeitada");
            map.put("04", "Transfer\u00eancia de Carteira/Entrada");
            map.put("05", "Transfer\u00eancia de Carteira/Baixa");
            map.put("06", "Liquida\u00e7\u00e3o");
            map.put("09", "Baixa");
            map.put("11", "T\u00edtulos em Carteira (Em Ser)");
            map.put("12", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Abatimento");
            map.put("13", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Cancelamento Abatimento");
            map.put("14", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o Altera\u00e7\u00e3o de Vencimento");
            map.put("15", "Franco de Pagamento");
            map.put("17", "Liquida\u00e7\u00e3o Ap\u00f3s Baixa ou Liquida\u00e7\u00e3o T\u00edtulo N\u00e3o Registrado");
            map.put("19", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Protesto");
            map.put("20", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Susta\u00e7\u00e3o/Cancelamento de Protesto");
            map.put("23", "Remessa a Cart\u00f3rio (Aponte em Cart\u00f3rio)");
            map.put("24", "Retirada de Cart\u00f3rio e Manuten\u00e7\u00e3o em Carteira");
            map.put("25", "Protestado e Baixado (Baixa por Ter Sido Protestado)");
            map.put("26", "Instru\u00e7\u00e3o Rejeitada");
            map.put("27", "Confirma\u00e7\u00e3o do Pedido de Altera\u00e7\u00e3o de Outros Dados");
            map.put("28", "D\u00e9bito de Tarifas/Custas");
            map.put("29", "Ocorr\u00eancias do Pagador");
            map.put("30", "Altera\u00e7\u00e3o de Dados Rejeitada");
            map.put("44", "T\u00edtulo pago com cheque devolvido");
            map.put("50", "T\u00edtulo pago com cheque pendente de liquida\u00e7\u00e3o");
            map.put("61", "Confirma\u00e7\u00e3o de Altera\u00e7\u00e3o de Valor Nominal do Boleto");
            map.put("85", "Inclus\u00e3o de Negativa\u00e7\u00e3o");
            map.put("86", "Exclus\u00e3o de Negativa\u00e7\u00e3o");
            map.put("93", "Baixa Operacional");
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static String getOcorrencia(String ocorrencia) {
        try {
            Map<String, String> map = BancoBrasilUtil.getMapOcorrencia();
            return map.get(ocorrencia) == null ? "Ocorr\u00eancia n\u00e3o catalogada" : map.get(ocorrencia);
        }
        catch (Exception e) {
            return "Error - Ocorr\u00eancia n\u00e3o catalogada";
        }
    }

    public static Map<String, String> getMapMotivoOcorrencia(String ocorrencia) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            switch (ocorrencia) {
                case "02": 
                case "03": 
                case "26": 
                case "30": {
                    map.put("01", "C\u00f3digo do Banco Inv\u00e1lido");
                    map.put("02", "C\u00f3digo do Registro Detalhe Inv\u00e1lido");
                    map.put("03", "C\u00f3digo do Segmento Inv\u00e1lido");
                    map.put("04", "C\u00f3digo de Movimento N\u00e3o Permitido para Carteira");
                    map.put("05", "C\u00f3digo de Movimento Inv\u00e1lido");
                    map.put("06", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Benefici\u00e1rio Inv\u00e1lidos");
                    map.put("07", "Ag\u00eancia/Conta/DV Inv\u00e1lido");
                    map.put("08", "Nosso n\u00famero inv\u00e1lido");
                    map.put("09", "Nosso n\u00famero duplicado");
                    map.put("10", "Carteira inv\u00e1lida");
                    map.put("11", "Forma de Cadastramento do T\u00edtulo Inv\u00e1lido");
                    map.put("12", "Tipo de Documento Inv\u00e1lido");
                    map.put("13", "Identifica\u00e7\u00e3o da emiss\u00e3o do bloqueto inv\u00e1lida");
                    map.put("14", "Identifica\u00e7\u00e3o da Distribui\u00e7\u00e3o do Boleto de Pagamento Inv\u00e1lida");
                    map.put("15", "Caracter\u00edsticas da Cobran\u00e7a Incompat\u00edveis");
                    map.put("16", "Data de vencimento inv\u00e1lida");
                    map.put("17", "Data de Vencimento Anterior a Data de Emiss\u00e3o");
                    map.put("18", "Vencimento fora do prazo de opera\u00e7\u00e3o");
                    map.put("19", "T\u00edtulo a Cargo de Bancos Correspondentes com Vencimento Inferior a XX Dias");
                    map.put("20", "Valor do T\u00edtulo inv\u00e1lido");
                    map.put("21", "Esp\u00e9cie do T\u00edtulo Inv\u00e1lida");
                    map.put("22", "Esp\u00e9cie do T\u00edtulo N\u00e3o Permitida para a Carteira");
                    map.put("23", "Aceite Inv\u00e1lido");
                    map.put("24", "Data da Emiss\u00e3o Inv\u00e1lida");
                    map.put("25", "Data da Emiss\u00e3o Posterior a Data de Entrada");
                    map.put("26", "C\u00f3digo de Juros de Mora Inv\u00e1lido");
                    map.put("27", "Valor/Taxa de Juros de Mora Inv\u00e1lido");
                    map.put("28", "C\u00f3digo do Desconto Inv\u00e1lido");
                    map.put("29", "Valor do Desconto Maior ou Igual ao Valor do T\u00edtulo");
                    map.put("30", "Desconto a Conceder N\u00e3o Confere");
                    map.put("31", "Concess\u00e3o de Desconto - J\u00e1 Existe Desconto Anterior");
                    map.put("32", "Valor do IOF Inv\u00e1lido");
                    map.put("33", "Valor do Abatimento Inv\u00e1lido");
                    map.put("34", "Valor do Abatimento Maior ou Igual ao Valor do T\u00edtulo");
                    map.put("35", "Valor a Conceder N\u00e3o Confere");
                    map.put("36", "Concess\u00e3o de Abatimento - J\u00e1 Existe Abatimento Anterior");
                    map.put("37", "C\u00f3digo para Protesto Inv\u00e1lido");
                    map.put("38", "Prazo para Protesto Inv\u00e1lido");
                    map.put("39", "Pedido de Protesto N\u00e3o Permitido para o T\u00edtulo");
                    map.put("40", "T\u00edtulo com Ordem de Protesto Emitida");
                    map.put("41", "Pedido de Cancelamento/Susta\u00e7\u00e3o para T\u00edtulos sem Instru\u00e7\u00e3o de Protesto");
                    map.put("42", "C\u00f3digo para Baixa/Devolu\u00e7\u00e3o Inv\u00e1lido");
                    map.put("43", "Prazo para Baixa/Devolu\u00e7\u00e3o Inv\u00e1lido");
                    map.put("44", "C\u00f3digo da Moeda Inv\u00e1lido");
                    map.put("45", "Nome do Pagador N\u00e3o Informado");
                    map.put("46", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Pagador Inv\u00e1lidos");
                    map.put("47", "Endere\u00e7o do Pagador N\u00e3o Informado");
                    map.put("48", "CEP Inv\u00e1lido");
                    map.put("49", "CEP Sem Pra\u00e7a de Cobran\u00e7a (N\u00e3o Localizado)");
                    map.put("50", "CEP Referente a um Banco Correspondente");
                    map.put("51", "CEP incompat\u00edvel com a Unidade da Federa\u00e7\u00e3o");
                    map.put("52", "Registro de T\u00edtulo j\u00e1 liquidado Cart. 17");
                    map.put("53", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Sacador/Avalista Inv\u00e1lidos");
                    map.put("54", "Sacador/Avalista N\u00e3o Informado");
                    map.put("55", "Nosso n\u00famero no Banco Correspondente N\u00e3o Informado");
                    map.put("56", "C\u00f3digo do Banco Correspondente N\u00e3o Informado");
                    map.put("57", "C\u00f3digo da Multa Inv\u00e1lido");
                    map.put("58", "Data da Multa Inv\u00e1lida");
                    map.put("59", "Valor/Percentual da Multa Inv\u00e1lido");
                    map.put("60", "Movimento para T\u00edtulo N\u00e3o Cadastrado");
                    map.put("61", "Altera\u00e7\u00e3o da Ag\u00eancia Cobradora/DV Inv\u00e1lida");
                    map.put("62", "Tipo de Impress\u00e3o Inv\u00e1lido");
                    map.put("63", "Entrada para T\u00edtulo j\u00e1 Cadastrado");
                    map.put("64", "N\u00famero da Linha Inv\u00e1lido");
                    map.put("65", "C\u00f3digo do Banco para D\u00e9bito Inv\u00e1lido");
                    map.put("66", "Ag\u00eancia/Conta/DV para D\u00e9bito Inv\u00e1lido");
                    map.put("67", "Dados para D\u00e9bito incompat\u00edvel com a Identifica\u00e7\u00e3o da Emiss\u00e3o do Boleto de Pagamento");
                    map.put("68", "D\u00e9bito Autom\u00e1tico Agendado");
                    map.put("69", "D\u00e9bito N\u00e3o Agendado - Erro nos Dados da Remessa");
                    map.put("70", "D\u00e9bito N\u00e3o Agendado - Pagador N\u00e3o Consta do Cadastro de Autorizante");
                    map.put("71", "D\u00e9bito N\u00e3o Agendado - Benefici\u00e1rio N\u00e3o Autorizado pelo Pagador");
                    map.put("72", "D\u00e9bito N\u00e3o Agendado - Benefici\u00e1rio N\u00e3o Participa da Modalidade D\u00e9bito Autom\u00e1tico");
                    map.put("73", "D\u00e9bito N\u00e3o Agendado - C\u00f3digo de Moeda Diferente de Real (R$)");
                    map.put("74", "D\u00e9bito N\u00e3o Agendado - Data Vencimento Inv\u00e1lida");
                    map.put("75", "D\u00e9bito N\u00e3o Agendado, Conforme seu Pedido, T\u00edtulo N\u00e3o Registrado");
                    map.put("76", "D\u00e9bito N\u00e3o Agendado, Tipo/Num. Inscri\u00e7\u00e3o do Debitado, Inv\u00e1lido");
                    map.put("77", "Transfer\u00eancia para Desconto N\u00e3o Permitida para a Carteira do T\u00edtulo");
                    map.put("78", "Data Inferior ou Igual ao Vencimento para D\u00e9bito Autom\u00e1tico");
                    map.put("79", "Data Juros de Mora Inv\u00e1lido");
                    map.put("80", "Data do Desconto Inv\u00e1lida");
                    map.put("81", "Tentativas de D\u00e9bito Esgotadas - Baixado");
                    map.put("82", "Tentativas de D\u00e9bito Esgotadas - Pendente");
                    map.put("83", "Limite Excedido");
                    map.put("84", "N\u00famero Autoriza\u00e7\u00e3o Inexistente");
                    map.put("85", "T\u00edtulo com Pagamento Vinculado");
                    map.put("86", "Seu N\u00famero Inv\u00e1lido");
                    map.put("87", "e-mail/SMS enviado");
                    map.put("88", "e-mail Lido");
                    map.put("89", "e-mail/SMS devolvido - endere\u00e7o de e-mail ou n\u00famero do celular incorreto");
                    map.put("90", "e-mail devolvido - caixa postal cheia");
                    map.put("91", "e-mail/n\u00famero do celular do Pagador n\u00e3o informado");
                    map.put("92", "Pagador optante por Boleto de Pagamento Eletr\u00f4nico - e-mail n\u00e3o enviado");
                    map.put("93", "C\u00f3digo para emiss\u00e3o de Boleto de Pagamento n\u00e3o permite envio de e-mail");
                    map.put("94", "C\u00f3digo da Carteira inv\u00e1lido para envio e-mail.");
                    map.put("95", "Contrato n\u00e3o permite o envio de e-mail");
                    map.put("96", "N\u00famero de contrato inv\u00e1lido");
                    map.put("97", "Rejei\u00e7\u00e3o da altera\u00e7\u00e3o do prazo limite de recebimento (a data deve ser informada no campo 28.3.p)");
                    map.put("98", "Rejei\u00e7\u00e3o de dispensa de prazo limite de recebimento");
                    map.put("99", "Rejei\u00e7\u00e3o da altera\u00e7\u00e3o do n\u00famero do t\u00edtulo dado pelo Benefici\u00e1rio");
                    map.put("A1", "Rejei\u00e7\u00e3o da altera\u00e7\u00e3o do n\u00famero controle do participante");
                    map.put("A2", "Rejei\u00e7\u00e3o da altera\u00e7\u00e3o dos dados do Pagador");
                    map.put("A3", "Rejei\u00e7\u00e3o da altera\u00e7\u00e3o dos dados do Sacador/avalista");
                    map.put("A4", "Pagador DDA");
                    map.put("A5", "Registro Rejeitado \u2013 T\u00edtulo j\u00e1 Liquidado");
                    map.put("A6", "C\u00f3digo do Convenente Inv\u00e1lido ou Encerrado");
                    map.put("A7", "T\u00edtulo j\u00e1 se encontra na situa\u00e7\u00e3o Pretendida");
                    map.put("A8", "Valor do Abatimento inv\u00e1lido para cancelamento");
                    map.put("A9", "N\u00e3o autoriza pagamento parcial");
                    map.put("B1", "Autoriza recebimento parcial");
                    map.put("B2", "Valor Nominal do T\u00edtulo Conflitante");
                    map.put("B3", "Tipo de Pagamento Inv\u00e1lido");
                    map.put("B4", "Valor M\u00e1ximo/Percentual Inv\u00e1lido");
                    map.put("B5", "Valor M\u00ednimo/Percentual Inv\u00e1lido");
                    map.put("P1", "Registro com QR Code Pix");
                    map.put("P2", "Registro sem QR Code Pix");
                    break;
                }
                case "28": {
                    map.put("01", "Tarifa de Extrato de Posi\u00e7\u00e3o");
                    map.put("02", "Tarifa de Manuten\u00e7\u00e3o de T\u00edtulo Vencido");
                    map.put("03", "Tarifa de Susta\u00e7\u00e3o");
                    map.put("04", "Tarifa de Protesto");
                    map.put("05", "Tarifa de Outras Instru\u00e7\u00f5es");
                    map.put("06", "Tarifa de Outras Ocorr\u00eancias");
                    map.put("07", "Tarifa de Envio de Duplicata ao Pagador");
                    map.put("08", "Custas de Protesto");
                    map.put("09", "Custas de Susta\u00e7\u00e3o de Protesto");
                    map.put("10", "Custas de Cart\u00f3rio Distribuidor");
                    map.put("11", "Custas de Edital");
                    map.put("12", "Tarifa Sobre Devolu\u00e7\u00e3o de T\u00edtulo Vencido");
                    map.put("13", "Tarifa Sobre Registro Cobrada na Baixa/Liquida\u00e7\u00e3o");
                    map.put("14", "Tarifa Sobre Reapresenta\u00e7\u00e3o Autom\u00e1tica");
                    map.put("15", "Tarifa Sobre Rateio de Cr\u00e9dito");
                    map.put("16", "Tarifa Sobre Informa\u00e7\u00f5es Via Fax");
                    map.put("17", "Tarifa Sobre Prorroga\u00e7\u00e3o de Vencimento");
                    map.put("18", "Tarifa Sobre Altera\u00e7\u00e3o de Abatimento/Desconto");
                    map.put("19", "Tarifa Sobre Arquivo mensal (Em Ser)");
                    map.put("20", "Tarifa Sobre Emiss\u00e3o de Boleto de Pagamento Pr\u00e9-Emitido pelo Banco");
                    break;
                }
                case "06": 
                case "09": 
                case "17": {
                    map.put("01", "Por Saldo");
                    map.put("02", "Por Conta");
                    map.put("03", "Liquida\u00e7\u00e3o no Guich\u00ea de Caixa em Dinheiro");
                    map.put("04", "Compensa\u00e7\u00e3o Eletr\u00f4nica");
                    map.put("05", "Compensa\u00e7\u00e3o Convencional");
                    map.put("06", "Por Meio Eletr\u00f4nico");
                    map.put("07", "Ap\u00f3s Feriado Local");
                    map.put("08", "Em Cart\u00f3rio");
                    map.put("30", "Liquida\u00e7\u00e3o no Guich\u00ea de Caixa em Cheque");
                    map.put("31", "Liquida\u00e7\u00e3o em banco correspondente");
                    map.put("32", "Liquida\u00e7\u00e3o Terminal de Auto-Atendimento");
                    map.put("33", "Liquida\u00e7\u00e3o na Internet (Home banking)");
                    map.put("34", "Liquidado Office Banking");
                    map.put("35", "Liquidado Correspondente em Dinheiro");
                    map.put("36", "Liquidado Correspondente em Cheque");
                    map.put("37", "Liquidado por meio de Central de Atendimento (Telefone) Baixa:");
                    map.put("09", "Comandada Banco");
                    map.put("10", "Comandada Cliente Arquivo");
                    map.put("11", "Comandada Cliente On-line");
                    map.put("12", "Decurso Prazo - Cliente");
                    map.put("13", "Decurso Prazo - Banco");
                    map.put("14", "Protestado");
                    map.put("15", "T\u00edtulo Exclu\u00eddo");
                    map.put("61", "Liquida\u00e7\u00e3o Pix");
                    break;
                }
                case "93": {
                    map.put("01", "Baixa Operacional BB");
                    map.put("02", "Baixa Operacional Outros Bancos");
                    map.put("10", "Cancelamento de Baixa Operacional");
                    map.put("03", "Liquida\u00e7\u00e3o no Guich\u00ea de Caixa em Dinheiro");
                    map.put("06", "Por Meio Eletr\u00f4nico");
                    map.put("31", "Liquida\u00e7\u00e3o em banco correspondente");
                    map.put("32", "Liquida\u00e7\u00e3o Terminal de Auto-Atendimento");
                    map.put("33", "Liquida\u00e7\u00e3o na Internet (Home banking)");
                    map.put("37", "Liquidado Central de Atendimento (Telefone)");
                    map.put("61", "Liquida\u00e7\u00e3o Pix");
                    break;
                }
                case "AB": {
                    map.put("01", "Por Saldo - Reservado");
                    map.put("02", "Por Conta (Parcial)");
                    map.put("03", "No pr\u00f3prio Banco");
                    map.put("04", "Compensa\u00e7\u00e3o Eletr\u00f4nica");
                    map.put("05", "Compensa\u00e7\u00e3o Convencional");
                    map.put("06", "Por Meio Eletr\u00f4nico");
                    map.put("07", "Reservado");
                    map.put("08", "Em Cart\u00f3rio");
                    break;
                }
                default: {
                    map.put("70", "T\u00edtulo n\u00e3o selecionado por erro no CNPJ/CPF ou endere\u00e7o");
                    map.put("76", "Banco aguarda c\u00f3pia autenticada do documento");
                    map.put("77", "T\u00edtulo selecionado falta seu n\u00famero");
                    map.put("78", "T\u00edtulo rejeitado pelo cart\u00f3rio por estar irregular");
                    map.put("79", "T\u00edtulo n\u00e3o selecionado - pra\u00e7a n\u00e3o atendida");
                    map.put("80", "Cart\u00f3rio aguarda autoriza\u00e7\u00e3o para protestar por edital");
                    map.put("90", "Protesto sustado por solicita\u00e7\u00e3o do Benefici\u00e1rio");
                    map.put("91", "Protesto sustado por altera\u00e7\u00e3o no vencimento");
                    map.put("92", "Aponte cobrado de t\u00edtulo sustado");
                    map.put("93", "Protesto sustado por altera\u00e7\u00e3o no prazo do protesto");
                    map.put("95", "Entidade P\u00fablica");
                    map.put("97", "T\u00edtulo em cart\u00f3rio");
                }
            }
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static String getMotivoOcorrenciaSicredi(String ocorrencia, String motivoOcorrencia) {
        try {
            Map<String, String> map = BancoBrasilUtil.getMapMotivoOcorrencia(ocorrencia);
            return map.get(motivoOcorrencia) == null ? "Motivo Ocorr\u00eancia n\u00e3o catalogada" : map.get(motivoOcorrencia);
        }
        catch (Exception e) {
            return "Error - Motivo Ocorr\u00eancia n\u00e3o catalogada";
        }
    }
}

