/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.banrisul_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.InformacaoModel;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.TipoJurosEnum;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.BancoBanrisulAlterarTitulo;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.BancoBanrisulBaixarTitulo;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.BancoBanrisulConsultarTitulo;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.BancoBanrisulEmitirTitulo;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.BancoBanrisulRegistrarTitulo;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.BanrisulUtil;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.ConfiguracaoBanrisulAPI;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.ValidaUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang3.StringUtils;

public class BancoBanrisulAPI
extends BoletoController {
    private static final Logger log = Logger.getLogger(BancoBanrisulAPI.class.getName());

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            boletos.forEach(this::preparaValidaBoletoImpressao);
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoBanrisulAPI configuracao = (ConfiguracaoBanrisulAPI)this.getConfiguracao();
            String xmlEnvio = this.montaBoletoXml(boletoModel, "EmitirBoleto");
            String retorno = BanrisulUtil.comunicacaoHttpsURLConnection(xmlEnvio, configuracao);
            return new BancoBanrisulEmitirTitulo().validaXmlRetorno(retorno);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoBanrisulAPI configuracao = (ConfiguracaoBanrisulAPI)this.getConfiguracao();
            String xmlEnvio = this.montaBoletoXml(boletoModel, "RegistrarTitulo");
            String retorno = BanrisulUtil.comunicacaoHttpsURLConnection(xmlEnvio, configuracao);
            return new BancoBanrisulRegistrarTitulo().validaXmlRetorno(retorno, boletoModel);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoBanrisulAPI configuracao = (ConfiguracaoBanrisulAPI)this.getConfiguracao();
            String xmlEnvio = this.montaBoletoXml(boletoModel, "AlterarTitulo");
            String retorno = BanrisulUtil.comunicacaoHttpsURLConnection(xmlEnvio, configuracao);
            return new BancoBanrisulAlterarTitulo().validaXmlRetorno(retorno, boletoModel);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoBanrisulAPI configuracao = (ConfiguracaoBanrisulAPI)this.getConfiguracao();
            String xmlEnvio = this.montaBoletoXml(boletoModel, "ConsultarTitulo");
            String retorno = BanrisulUtil.comunicacaoHttpsURLConnection(xmlEnvio, configuracao);
            return new BancoBanrisulConsultarTitulo().validaXmlRetorno(retorno, boletoModel);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoBanrisulAPI configuracao = (ConfiguracaoBanrisulAPI)this.getConfiguracao();
            String xmlEnvio = this.montaBoletoXml(boletoModel, "BaixarTitulo");
            String retorno = BanrisulUtil.comunicacaoHttpsURLConnection(xmlEnvio, configuracao);
            return new BancoBanrisulBaixarTitulo().validaXmlRetorno(retorno, boletoModel);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    private String montaBoletoXml(BoletoModel boletoModel, String servico) throws Exception {
        String xmlEntrada;
        ConfiguracaoBanrisulAPI configuracao = (ConfiguracaoBanrisulAPI)this.getConfiguracao();
        switch (servico) {
            case "RegistrarTitulo": {
                xmlEntrada = new BancoBanrisulRegistrarTitulo().montaXmlRegistrarTitulo(boletoModel, configuracao.getAmbiente());
                break;
            }
            case "AlterarTitulo": {
                xmlEntrada = new BancoBanrisulAlterarTitulo().montaXmlAlterarTitulo(boletoModel, configuracao.getAmbiente());
                break;
            }
            case "ConsultarTitulo": {
                xmlEntrada = new BancoBanrisulConsultarTitulo().montaXmlConsultarTitulo(boletoModel);
                break;
            }
            case "BaixarTitulo": {
                xmlEntrada = new BancoBanrisulBaixarTitulo().montaXmlBaixarTitulo(boletoModel, configuracao.getAmbiente());
                break;
            }
            case "EmitirBoleto": {
                xmlEntrada = new BancoBanrisulEmitirTitulo().montaXmlEmitirBoleto(boletoModel, configuracao.getAmbiente());
                break;
            }
            default: {
                throw new Exception("Servi\u00e7o n\u00e3o encontrado");
            }
        }
        String xmlEnvio = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><" + servico + " xmlns=\"Bergs.Boc.Bocswsxn\"><xmlEntrada>" + xmlEntrada + "</xmlEntrada></" + servico + "></soap:Body></soap:Envelope>";
        log.config("Xml Envio: " + xmlEnvio);
        return xmlEnvio;
    }

    private void preparaValidaBoletoImpressao(BoletoModel boletoModel) {
        boletoModel.getBeneficiario().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiario().getDocumento()));
        boletoModel.getPagador().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getPagador().getDocumento()));
        if (boletoModel.getBeneficiarioFinal() != null) {
            boletoModel.getBeneficiarioFinal().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiarioFinal().getDocumento()));
        }
        boletoModel.getBeneficiario().setAgencia(StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (String)"0"));
        boletoModel.getBeneficiario().setConta(StringUtils.leftPad((String)boletoModel.getBeneficiario().getConta(), (int)7, (String)"0"));
        boletoModel.getBeneficiario().setDigitoConta(StringUtils.leftPad((String)boletoModel.getBeneficiario().getDigitoConta(), (int)2, (String)"0"));
        boletoModel.getBeneficiario().getEndereco().setComplemento(boletoModel.getBeneficiario().getEndereco().getComplemento() == null ? "" : boletoModel.getBeneficiario().getEndereco().getComplemento());
        if (StringUtils.isBlank((CharSequence)boletoModel.getCodigoBarras())) {
            StringBuilder codigoBarras = new StringBuilder();
            codigoBarras.append("0419");
            codigoBarras.append("X");
            codigoBarras.append(BanrisulUtil.fatorData(boletoModel.getDataVencimento()));
            codigoBarras.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
            StringBuilder campoLivre = new StringBuilder();
            campoLivre.append("21");
            campoLivre.append(StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (String)"0"));
            campoLivre.append(StringUtils.leftPad((String)boletoModel.getBeneficiario().getConta(), (int)7, (String)"0"));
            campoLivre.append(StringUtils.leftPad((String)boletoModel.getNossoNumero(), (int)8, (String)"0"));
            campoLivre.append("40");
            Integer digito10 = BanrisulUtil.modulo10Banrisul(campoLivre.toString());
            codigoBarras.append(BanrisulUtil.modulo11Banrisul(campoLivre.toString(), digito10));
            String dac = BanrisulUtil.modulo11Dac(codigoBarras.toString().replace("X", ""));
            boletoModel.setCodigoBarras(codigoBarras.toString().replace("X", dac));
            if (StringUtils.isBlank((CharSequence)boletoModel.getLinhaDigitavel())) {
                boletoModel.setLinhaDigitavel(codigoBarras.toString().replace("X", dac));
            }
        }
        if (StringUtils.isBlank((CharSequence)boletoModel.getLinhaDigitavel())) {
            StringBuilder linhaParte1 = new StringBuilder();
            linhaParte1.append(boletoModel.getLinhaDigitavel(), 0, 4);
            linhaParte1.append(boletoModel.getLinhaDigitavel(), 19, 21);
            linhaParte1.append(boletoModel.getLinhaDigitavel(), 21, 24);
            linhaParte1.append(BanrisulUtil.modulo10Banrisul(linhaParte1.toString()));
            StringBuilder linhaParte2 = new StringBuilder();
            linhaParte2.append(boletoModel.getLinhaDigitavel().charAt(24));
            linhaParte2.append(boletoModel.getLinhaDigitavel(), 25, 32);
            linhaParte2.append(boletoModel.getLinhaDigitavel(), 32, 34);
            linhaParte2.append(BanrisulUtil.modulo10Banrisul(linhaParte2.toString()));
            StringBuilder linhaParte3 = new StringBuilder();
            linhaParte3.append(boletoModel.getLinhaDigitavel(), 34, 40);
            linhaParte3.append("40");
            linhaParte3.append(boletoModel.getLinhaDigitavel(), 42, 44);
            linhaParte3.append(BanrisulUtil.modulo10Banrisul(linhaParte3.toString()));
            StringBuilder linhaParte4 = new StringBuilder();
            linhaParte4.append(boletoModel.getLinhaDigitavel().charAt(4));
            linhaParte4.append(boletoModel.getLinhaDigitavel(), 5, 9);
            linhaParte4.append(boletoModel.getLinhaDigitavel(), 9, 19);
            StringBuilder linhaDigitavel = new StringBuilder();
            linhaDigitavel.append(linhaParte1.substring(0, 5));
            linhaDigitavel.append(".");
            linhaDigitavel.append(linhaParte1.substring(5, 10));
            linhaDigitavel.append("  ");
            linhaDigitavel.append(linhaParte2.substring(0, 5));
            linhaDigitavel.append(".");
            linhaDigitavel.append(linhaParte2.substring(5, 11));
            linhaDigitavel.append("  ");
            linhaDigitavel.append(linhaParte3.substring(0, 5));
            linhaDigitavel.append(".");
            linhaDigitavel.append(linhaParte3.substring(5, 11));
            linhaDigitavel.append("  ");
            linhaDigitavel.append(linhaParte4.substring(0, 1));
            linhaDigitavel.append("  ");
            linhaDigitavel.append(linhaParte4.substring(1, 15));
            boletoModel.setLinhaDigitavel(linhaDigitavel.toString());
        }
        if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorPercentualMulta())) {
            String instrucaoMulta = "APOS VENCIMENTO COBRAR MULTA DE " + BoletoUtil.formatarCasasDecimais(boletoModel.getValorPercentualMulta(), 2) + "%";
            boletoModel.getInstrucoes().add(new InformacaoModel(instrucaoMulta));
        }
        if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorPercentualJuros())) {
            BigDecimal valorPercentualJuros = boletoModel.getValorPercentualJuros();
            BigDecimal valorMoraDia = boletoModel.getValorPercentualJuros();
            if (boletoModel.getTipoJuros().equals((Object)TipoJurosEnum.PERCENTUAL_MENSAL) && BoletoUtil.isNotNullEMaiorQZero(valorPercentualJuros)) {
                valorPercentualJuros = valorPercentualJuros.divide(BigDecimal.valueOf(30L), MathContext.DECIMAL32);
                valorMoraDia = boletoModel.getValorBoleto().multiply(valorPercentualJuros, MathContext.DECIMAL32);
                valorMoraDia = valorMoraDia.divide(BigDecimal.valueOf(100L), MathContext.DECIMAL32);
            }
            String instrucaoJuros = "APOS VENCIMENTO COBRAR MORA DIARIA DE R$ " + BoletoUtil.formatarCasasDecimais(valorMoraDia, 2);
            boletoModel.getInstrucoes().add(new InformacaoModel(instrucaoJuros));
        }
        this.validaDadosImpressao(boletoModel);
    }

    private void validaDadosImpressao(BoletoModel boleto) {
        ValidaUtils.validaBoletoModel(boleto, Arrays.asList("locaisDePagamento", "dataVencimento", "dataEmissao", "numeroDocumento", "especieDocumento", "aceite", "especieMoeda", "valorBoleto", "linhaDigitavel", "codigoBarras", "beneficiario", "beneficiario.nomeBeneficiario", "beneficiario.documento", "beneficiario.agencia", "beneficiario.digitoConta", "beneficiario.conta", "beneficiario.endereco", "beneficiario.endereco.logradouro", "beneficiario.endereco.numero", "beneficiario.endereco.bairro", "beneficiario.endereco.cidade", "beneficiario.endereco.uf", "beneficiario.endereco.cep", "nossoNumero", "digitoNossoNumero", "pagador", "pagador.nome", "pagador.documento", "pagador.endereco.logradouro", "pagador.endereco.cep", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.uf"));
    }
}

