/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.banrisul_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.BanrisulUtil;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.baixar.Beneficiario;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.baixar.Dados;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.baixar.Titulo;
import org.apache.commons.lang3.StringUtils;

public class BancoBanrisulBaixarTitulo {
    public String montaXmlBaixarTitulo(BoletoModel boletoModel, AmbienteEnum ambiente) throws Exception {
        Dados dados = new Dados();
        dados.setAmbiente(ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? "P" : "T");
        Titulo titulo = new Titulo();
        if (!StringUtils.isBlank((CharSequence)boletoModel.getNossoNumero())) {
            titulo.setNossoNumero(Long.valueOf(boletoModel.getNossoNumero()));
        } else if (!StringUtils.isBlank((CharSequence)boletoModel.getCodigoBarras())) {
            titulo.setCodigoBarras(boletoModel.getCodigoBarras());
        } else {
            titulo.setLinhaDigitavel(boletoModel.getLinhaDigitavel());
        }
        if (boletoModel.getBeneficiario() != null && !StringUtils.isBlank((CharSequence)boletoModel.getBeneficiario().getAgencia()) && !StringUtils.isBlank((CharSequence)boletoModel.getBeneficiario().getConta())) {
            Beneficiario beneficiario = new Beneficiario();
            String codigoBeneficiario = StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (String)"0");
            codigoBeneficiario = codigoBeneficiario + StringUtils.leftPad((String)boletoModel.getBeneficiario().getConta(), (int)9, (String)"0");
            beneficiario.setCodigo(Long.parseLong(codigoBeneficiario));
            titulo.setBeneficiario(beneficiario);
        }
        dados.setTitulo(titulo);
        return BanrisulUtil.transformarObjetoParaXml(dados, "BaixarTitulo");
    }

    public BoletoModel validaXmlRetorno(String xmlRetorno, BoletoModel boletoModel) throws Exception {
        Dados dadosBaixar = BanrisulUtil.transformarXmlParaObjeto(xmlRetorno = BanrisulUtil.extrairNoXmlRetorno(xmlRetorno), Dados.class);
        if (dadosBaixar.getRetorno() == 3) {
            StringBuilder erro = new StringBuilder();
            dadosBaixar.getOcorrencias().getOcorrencia().forEach(ocorrencia -> {
                erro.append(ocorrencia.getCodigo());
                erro.append(" - ");
                erro.append(ocorrencia.getMensagem());
                if (ocorrencia.getComplemento() != null) {
                    erro.append(" - ");
                    erro.append(ocorrencia.getComplemento());
                }
                erro.append("\n");
            });
            throw new BoletoException(erro.toString());
        }
        boletoModel.setCodRetorno(dadosBaixar.getRetorno().toString());
        return boletoModel;
    }
}

