/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.banrisul_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Endereco;
import br.com.java_brasil.boleto.model.InformacaoModel;
import br.com.java_brasil.boleto.model.Pagador;
import br.com.java_brasil.boleto.model.enums.TipoDescontoEnum;
import br.com.java_brasil.boleto.model.enums.TipoJurosEnum;
import br.com.java_brasil.boleto.model.enums.TipoMultaEnum;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.BanrisulUtil;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.consultar.Beneficiario;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.consultar.Dados;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.consultar.Instrucoes;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.consultar.Mensagem;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.consultar.Titulo;
import br.com.java_brasil.boleto.util.BoletoUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class BancoBanrisulConsultarTitulo {
    public String montaXmlConsultarTitulo(BoletoModel boletoModel) throws Exception {
        Dados dados = new Dados();
        Titulo titulo = new Titulo();
        if (!StringUtils.isBlank((CharSequence)boletoModel.getNossoNumero())) {
            titulo.setNossoNumero(Long.valueOf(boletoModel.getNossoNumero()));
        } else if (!StringUtils.isBlank((CharSequence)boletoModel.getCodigoBarras())) {
            titulo.setCodigoBarras(boletoModel.getCodigoBarras());
        } else {
            titulo.setLinhaDigitavel(boletoModel.getLinhaDigitavel());
        }
        if (boletoModel.getBeneficiario() != null && !StringUtils.isBlank((CharSequence)boletoModel.getBeneficiario().getAgencia()) && !StringUtils.isBlank((CharSequence)boletoModel.getBeneficiario().getConta())) {
            Beneficiario beneficiario = new Beneficiario();
            String codigoBeneficiario = StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (String)"0");
            codigoBeneficiario = codigoBeneficiario + StringUtils.leftPad((String)boletoModel.getBeneficiario().getConta(), (int)9, (String)"0");
            beneficiario.setCodigo(Long.parseLong(codigoBeneficiario));
            titulo.setBeneficiario(beneficiario);
        }
        dados.setTitulo(titulo);
        return BanrisulUtil.transformarObjetoParaXml(dados, "ConsultarTitulo");
    }

    public BoletoModel validaXmlRetorno(String xmlRetorno, BoletoModel boletoModel) throws Exception {
        Dados dadosConsultar = BanrisulUtil.transformarXmlParaObjeto(xmlRetorno = BanrisulUtil.extrairNoXmlRetorno(xmlRetorno), Dados.class);
        if (dadosConsultar.getRetorno() == 3) {
            StringBuilder erro = new StringBuilder();
            dadosConsultar.getOcorrencias().getOcorrencia().forEach(ocorrencia -> {
                erro.append(ocorrencia.getCodigo());
                erro.append(" - ");
                erro.append(ocorrencia.getMensagem());
                if (ocorrencia.getComplemento() != null) {
                    erro.append(" - ");
                    erro.append(ocorrencia.getComplemento());
                }
                erro.append("\n");
            });
            throw new BoletoException(erro.toString());
        }
        return this.montaRetornoConsulta(dadosConsultar, boletoModel);
    }

    private BoletoModel montaRetornoConsulta(Dados dados, BoletoModel boletoModel) {
        boletoModel.setCodRetorno(dados.getRetorno().toString());
        boletoModel.setBeneficiario(this.getBeneficiario(dados.getTitulo()));
        boletoModel.setPagador(this.getPagador(dados.getTitulo()));
        boletoModel.setNossoNumero(dados.getTitulo().getNossoNumero().toString());
        boletoModel.setNumeroDocumento(dados.getTitulo().getSeuNumero());
        boletoModel.setDataVencimento(BoletoUtil.converteXMLGregorianCalendarData(dados.getTitulo().getDataVencimento()));
        boletoModel.setValorBoleto(dados.getTitulo().getValorNominal());
        boletoModel.setEspecieDocumento(StringUtils.leftPad((String)dados.getTitulo().getEspecie().toString(), (int)2, (String)"0"));
        boletoModel.setDataEmissao(BoletoUtil.converteXMLGregorianCalendarData(dados.getTitulo().getDataEmissao()));
        boletoModel.setValorIof(dados.getTitulo().getValorIof());
        boletoModel.setCodigoBarras(dados.getTitulo().getCodigoBarras());
        boletoModel.setLinhaDigitavel(dados.getTitulo().getLinhaDigitavel());
        boletoModel.setAceite(dados.getTitulo().getPagador().getAceite().equals("A"));
        this.verificaInstrucoes(dados.getTitulo(), boletoModel);
        this.verificaPagParcial(dados.getTitulo(), boletoModel);
        if (dados.getTitulo().getMensagens() != null) {
            boletoModel.setInstrucoes(new ArrayList<InformacaoModel>());
            for (Mensagem mensagem : dados.getTitulo().getMensagens().getMensagem()) {
                boletoModel.getInstrucoes().add(new InformacaoModel(mensagem.getTexto()));
            }
        }
        return boletoModel;
    }

    private br.com.java_brasil.boleto.model.Beneficiario getBeneficiario(Titulo titulo) {
        br.com.java_brasil.boleto.model.Beneficiario beneficiario = new br.com.java_brasil.boleto.model.Beneficiario();
        beneficiario.setCarteira(titulo.getCarteira().toString());
        if (titulo.getBeneficiario().getTipoPessoa().equals("F")) {
            beneficiario.setDocumento(StringUtils.leftPad((String)titulo.getBeneficiario().getCpfCnpj().toString(), (int)11, (String)"0"));
        } else {
            beneficiario.setDocumento(StringUtils.leftPad((String)titulo.getBeneficiario().getCpfCnpj().toString(), (int)14, (String)"0"));
        }
        beneficiario.setNomeBeneficiario(titulo.getBeneficiario().getNome());
        return beneficiario;
    }

    private Pagador getPagador(Titulo titulo) {
        Pagador pagador = new Pagador();
        if (titulo.getPagador().getTipoPessoa().equals("F")) {
            pagador.setDocumento(StringUtils.leftPad((String)String.valueOf(titulo.getPagador().getCpfCnpj()), (int)11, (String)"0"));
        } else {
            pagador.setDocumento(StringUtils.leftPad((String)String.valueOf(titulo.getPagador().getCpfCnpj()), (int)14, (String)"0"));
        }
        pagador.setNome(titulo.getPagador().getNome());
        pagador.setEndereco(new Endereco());
        pagador.getEndereco().setLogradouro(titulo.getPagador().getEndereco());
        pagador.getEndereco().setCep(StringUtils.leftPad((String)String.valueOf(titulo.getPagador().getCep()), (int)8, (String)"0"));
        pagador.getEndereco().setCidade(titulo.getPagador().getCidade());
        pagador.getEndereco().setUf(titulo.getPagador().getUf());
        return pagador;
    }

    private void verificaInstrucoes(Titulo titulo, BoletoModel boletoModel) {
        Instrucoes instrucoes = titulo.getInstrucoes();
        if (instrucoes.getJuros() != null) {
            boletoModel.setDiasJuros(0);
            boletoModel.setTipoJuros(TipoJurosEnum.ISENTO);
            boletoModel.setValorPercentualJuros(BigDecimal.ZERO);
            if (instrucoes.getJuros().getCodigo() != 3) {
                LocalDate dataJuros = BoletoUtil.converteXMLGregorianCalendarData(instrucoes.getJuros().getData());
                boletoModel.setDiasJuros((int)BoletoUtil.difEntreDatasEmDias(boletoModel.getDataVencimento(), dataJuros));
                boletoModel.setTipoJuros(instrucoes.getJuros().getCodigo() == 1 ? TipoJurosEnum.VALOR_DIA : TipoJurosEnum.PERCENTUAL_MENSAL);
                boletoModel.setValorPercentualJuros(instrucoes.getJuros().getCodigo() == 1 ? instrucoes.getJuros().getValor() : instrucoes.getJuros().getTaxa());
            }
        }
        if (instrucoes.getMulta() != null) {
            boletoModel.setDiasMulta(0);
            boletoModel.setTipoMulta(instrucoes.getMulta().getCodigo() == 1 ? TipoMultaEnum.VALOR : TipoMultaEnum.PERCENTUAL);
            boletoModel.setValorPercentualMulta(instrucoes.getMulta().getValor());
            if (instrucoes.getMulta().getData() != null) {
                LocalDate dataMulta = BoletoUtil.converteXMLGregorianCalendarData(instrucoes.getMulta().getData());
                boletoModel.setDiasMulta((int)BoletoUtil.difEntreDatasEmDias(boletoModel.getDataVencimento(), dataMulta));
            }
        }
        if (instrucoes.getDesconto() != null) {
            switch (instrucoes.getDesconto().getCodigo()) {
                case 1: {
                    boletoModel.setTipoDesconto(TipoDescontoEnum.VALOR_FIXO);
                    boletoModel.setValorPercentualDescontos(instrucoes.getDesconto().getValor());
                    break;
                }
                case 2: {
                    boletoModel.setTipoDesconto(TipoDescontoEnum.PERCENTUAL_FIXO);
                    boletoModel.setValorPercentualDescontos(instrucoes.getDesconto().getTaxa());
                    break;
                }
                case 3: {
                    boletoModel.setTipoDesconto(TipoDescontoEnum.VALOR_DIA);
                    boletoModel.setValorPercentualDescontos(instrucoes.getDesconto().getValor());
                }
                default: {
                    boletoModel.setTipoDesconto(TipoDescontoEnum.PERCENTUAL_DIA);
                    boletoModel.setValorPercentualDescontos(instrucoes.getDesconto().getTaxa());
                }
            }
            if (instrucoes.getDesconto().getData() != null) {
                boletoModel.setDataLimiteParaDesconto(BoletoUtil.converteXMLGregorianCalendarData(instrucoes.getDesconto().getData()));
            }
        }
        if (instrucoes.getAbatimento() != null) {
            boletoModel.setValorDeducoes(instrucoes.getAbatimento().getValor());
        }
        if (instrucoes.getProtesto() != null) {
            boletoModel.setProtesto(instrucoes.getProtesto().getCodigo() == 1);
            boletoModel.setDiasProtesto(instrucoes.getProtesto().getPrazo().shortValue());
        }
        if (instrucoes.getBaixa() != null) {
            boletoModel.setDiasParaBaixaDevolver(instrucoes.getBaixa().getPrazo());
        }
    }

    private void verificaPagParcial(Titulo titulo, BoletoModel boletoModel) {
        boletoModel.setAutorizaPagamentoParcial(false);
        boletoModel.setCodigoPagamentoParcial(3);
        boletoModel.setQuantidadePagamentoParcial(0);
        boletoModel.setTipoPagamentoParcial(1);
        boletoModel.setValorMinPagamentoParcial(BigDecimal.ZERO);
        boletoModel.setValorMaxPagamentoParcial(BigDecimal.ZERO);
        boletoModel.setPercentualMinPagamentoParcial(BigDecimal.ZERO);
        boletoModel.setPercentualMaxPagamentoParcial(BigDecimal.ZERO);
        if (titulo.getPagParcial() != null) {
            boletoModel.setAutorizaPagamentoParcial(titulo.getPagParcial().getAutoriza() == 2);
            boletoModel.setCodigoPagamentoParcial(titulo.getPagParcial().getCodigo());
            if (boletoModel.getCodigoPagamentoParcial() == 2) {
                boletoModel.setQuantidadePagamentoParcial(titulo.getPagParcial().getQuantidade().shortValue());
                boletoModel.setTipoPagamentoParcial(titulo.getPagParcial().getTipo().shortValue());
                if (boletoModel.getTipoPagamentoParcial() == 2) {
                    boletoModel.setValorMinPagamentoParcial(titulo.getPagParcial().getValorMin());
                    boletoModel.setValorMaxPagamentoParcial(titulo.getPagParcial().getValorMax());
                }
                if (boletoModel.getTipoPagamentoParcial() == 1) {
                    boletoModel.setPercentualMinPagamentoParcial(titulo.getPagParcial().getPercentualMin());
                    boletoModel.setPercentualMaxPagamentoParcial(titulo.getPagParcial().getPercentualMax());
                }
            }
        }
    }
}

