/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.banrisul_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.BanrisulUtil;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.emitir.Beneficiario;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.emitir.Dados;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.emitir.Titulo;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class BancoBanrisulEmitirTitulo {
    public String montaXmlEmitirBoleto(BoletoModel boletoModel, AmbienteEnum ambiente) throws Exception {
        Dados dados = new Dados();
        dados.setAmbiente(ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? "P" : "T");
        Titulo titulo = new Titulo();
        if (!StringUtils.isBlank((CharSequence)boletoModel.getNossoNumero())) {
            titulo.setNossoNumero(Long.valueOf(boletoModel.getNossoNumero()));
        } else if (!StringUtils.isBlank((CharSequence)boletoModel.getCodigoBarras())) {
            titulo.setCodigoBarras(boletoModel.getCodigoBarras());
        } else {
            titulo.setLinhaDigitavel(boletoModel.getLinhaDigitavel());
        }
        if (boletoModel.getBeneficiario() != null && !StringUtils.isBlank((CharSequence)boletoModel.getBeneficiario().getAgencia()) && !StringUtils.isBlank((CharSequence)boletoModel.getBeneficiario().getConta())) {
            Beneficiario beneficiario = new Beneficiario();
            String codigoBeneficiario = StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (String)"0");
            codigoBeneficiario = codigoBeneficiario + StringUtils.leftPad((String)boletoModel.getBeneficiario().getConta(), (int)9, (String)"0");
            beneficiario.setCodigo(Long.parseLong(codigoBeneficiario));
            titulo.setBeneficiario(beneficiario);
        }
        dados.setTitulo(titulo);
        return BanrisulUtil.transformarObjetoParaXml(dados, "EmitirBoleto");
    }

    public byte[] validaXmlRetorno(String xmlRetorno) throws Exception {
        Dados dadosEmitir = BanrisulUtil.transformarXmlParaObjeto(xmlRetorno = BanrisulUtil.extrairNoXmlRetorno(xmlRetorno), Dados.class);
        if (dadosEmitir.getRetorno() == 3) {
            StringBuilder erro = new StringBuilder();
            dadosEmitir.getOcorrencias().getOcorrencia().forEach(ocorrencia -> {
                erro.append(ocorrencia.getCodigo());
                erro.append(" - ");
                erro.append(ocorrencia.getMensagem());
                if (ocorrencia.getComplemento() != null) {
                    erro.append(" - ");
                    erro.append(ocorrencia.getComplemento());
                }
                erro.append("\n");
            });
            throw new BoletoException(erro.toString());
        }
        return Base64.decodeBase64((byte[])dadosEmitir.getTitulo().getBoleto().getBytes());
    }
}

