/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.banrisul_api;

import br.com.java_brasil.boleto.service.bancos.banrisul_api.ConfiguracaoBanrisulAPI;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.baixar.Dados;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BanrisulUtil {
    public static String transformarObjetoParaXml(Object objeto, String tipo) throws Exception {
        JAXBContext context;
        switch (tipo) {
            case "RegistrarTitulo": {
                context = JAXBContext.newInstance((Class[])new Class[]{br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.registra.Dados.class});
                break;
            }
            case "AlterarTitulo": {
                context = JAXBContext.newInstance((Class[])new Class[]{br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.alterar.Dados.class});
                break;
            }
            case "ConsultarTitulo": {
                context = JAXBContext.newInstance((Class[])new Class[]{br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.consultar.Dados.class});
                break;
            }
            case "BaixarTitulo": {
                context = JAXBContext.newInstance((Class[])new Class[]{Dados.class});
                break;
            }
            case "EmitirBoleto": {
                context = JAXBContext.newInstance((Class[])new Class[]{br.com.java_brasil.boleto.service.bancos.banrisul_api.xsd.emitir.Dados.class});
                break;
            }
            default: {
                throw new Exception("Objeto n\u00e3o mapeado!");
            }
        }
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"Unicode");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        marshaller.marshal(objeto, (Writer)sw);
        return sw.toString();
    }

    public static <T> T transformarXmlParaObjeto(String xml, Class<T> classe) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{classe});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (T)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xml)), classe).getValue();
    }

    public static String extrairNoXmlRetorno(String xml) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        ByteArrayInputStream biteArray = new ByteArrayInputStream(xml.getBytes());
        Document doc = dbf.newDocumentBuilder().parse(biteArray);
        NodeList elements = doc.getElementsByTagName("dados");
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(elements.item(0)), new StreamResult(writer));
        return writer.toString();
    }

    public static String comunicacaoHttpsURLConnection(String envelopeSoap, ConfiguracaoBanrisulAPI configuracao) throws IOException {
        System.setProperty("javax.net.ssl.keyStore", configuracao.getCaminhoCertificado());
        System.setProperty("javax.net.ssl.keyStorePassword", configuracao.getSenhaCertificado());
        URL url = new URL(configuracao.getURLBase());
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-type", "text/xml; charset=\"utf-8\"");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        PrintWriter printWriter = new PrintWriter(connection.getOutputStream(), true);
        printWriter.println(envelopeSoap);
        printWriter.close();
        StringBuilder response = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        String line = bufferedReader.readLine();
        while (line != null) {
            response.append(line);
            response.append(System.getProperty("line.separator"));
            line = bufferedReader.readLine();
        }
        System.out.println("Response: " + response);
        return response.toString();
    }

    public static String fatorData(LocalDate dataVencimento) {
        LocalDate dataBase = LocalDate.of(1997, 10, 7);
        if (dataVencimento.isAfter(LocalDate.of(2025, 2, 21))) {
            dataBase = dataBase.plusDays(9000L);
        }
        long difDia = ChronoUnit.DAYS.between(dataBase, dataVencimento);
        return StringUtils.leftPad((String)("" + difDia), (int)4, (char)'0');
    }

    public static String geraDigitoNossoNumero(String nossoNumero) {
        nossoNumero = StringUtils.leftPad((String)nossoNumero, (int)8, (String)"0");
        Integer digito10 = BanrisulUtil.modulo10Banrisul(nossoNumero);
        nossoNumero = BanrisulUtil.modulo11Banrisul(nossoNumero, digito10);
        return nossoNumero.substring(8);
    }

    public static Integer modulo10Banrisul(String codigo) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < codigo.length(); ++i) {
            int valor = (codigo.charAt(codigo.length() - 1 - i) - 48) * peso;
            if (valor > 9) {
                valor -= 9;
            }
            total += valor;
            if (peso == 2) {
                --peso;
                continue;
            }
            ++peso;
        }
        int resto = total < 10 ? total : total % 10;
        return resto == 0 ? 0 : 10 - resto;
    }

    public static String modulo11Banrisul(String codigo, Integer digitoModulo10) {
        int total = 0;
        int peso = 2;
        String codigoModulo10 = codigo + digitoModulo10;
        for (int i = 0; i < codigoModulo10.length(); ++i) {
            total += (codigoModulo10.charAt(codigoModulo10.length() - 1 - i) - 48) * peso;
            if (++peso != 8) continue;
            peso = 2;
        }
        int resto = total < 11 ? total : total % 11;
        switch (resto) {
            case 0: {
                int digito = 0;
                return codigoModulo10 + digito;
            }
            case 1: {
                if (digitoModulo10 == 9) {
                    digitoModulo10 = 0;
                    return BanrisulUtil.modulo11Banrisul(codigo, digitoModulo10);
                }
                Integer n = digitoModulo10;
                Integer n2 = digitoModulo10 = Integer.valueOf(digitoModulo10 + 1);
                return BanrisulUtil.modulo11Banrisul(codigo, digitoModulo10);
            }
        }
        int digito = 11 - resto;
        return codigoModulo10 + digito;
    }

    public static String modulo11Dac(String linha) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < linha.length(); ++i) {
            total += (linha.charAt(linha.length() - 1 - i) - 48) * peso;
            if (++peso != 10) continue;
            peso = 2;
        }
        int resto = total % 11;
        if (resto == 0 || resto == 1 || resto == 10 || resto == 11) {
            return "1";
        }
        return "" + (11 - resto);
    }

    public static boolean isASCIIBanrisul(char ch) {
        if (ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9') {
            return true;
        }
        if (ch == ' ' || ch == '!' || ch == '#' || ch == '$' || ch == '%' || ch == '&' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == '-' || ch == '.' || ch == '/' || ch == ':' || ch == ';' || ch == '@' || ch == '[' || ch == '\\' || ch == ']' || ch == '{' || ch == '}') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        return ch == '\n' || ch == '\r';
    }

    public static Map<String, String> getMapOcorrencia() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("02", "Entrada confirmada");
            map.put("03", "Entrada rejeitada");
            map.put("04", "Transfer\u00eancia de Carteira/Entrada");
            map.put("05", "Transfer\u00eancia de Carteira/Baixa");
            map.put("06", "Liquida\u00e7\u00e3o");
            map.put("07", "Confirma\u00e7\u00e3o do Recebimento da Instru\u00e7\u00e3o de Desconto");
            map.put("08", "Confirma\u00e7\u00e3o do Recebimento do Cancelamento do Desconto");
            map.put("09", "Baixa");
            map.put("11", "T\u00edtulos em Carteira (Em Ser)");
            map.put("12", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Abatimento");
            map.put("13", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Cancelamento Abatimento");
            map.put("14", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o Altera\u00e7\u00e3o de Vencimento");
            map.put("15", "Franco de Pagamento");
            map.put("17", "Liquida\u00e7\u00e3o Ap\u00f3s Baixa ou Liquida\u00e7\u00e3o T\u00edtulo N\u00e3o Registrado");
            map.put("19", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Protesto");
            map.put("20", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Susta\u00e7\u00e3o/Cancelamento de Protesto");
            map.put("23", "Remessa a Cart\u00f3rio (Aponte em Cart\u00f3rio)");
            map.put("24", "Retirada de Cart\u00f3rio e Manuten\u00e7\u00e3o em Carteira");
            map.put("25", "Protestado e Baixado (Baixa por Ter Sido Protestado)");
            map.put("26", "Instru\u00e7\u00e3o Rejeitada");
            map.put("27", "Confirma\u00e7\u00e3o do Pedido de Altera\u00e7\u00e3o de Outros Dados");
            map.put("28", "D\u00e9bito de Tarifas/Custas");
            map.put("29", "Ocorr\u00eancias do Pagador");
            map.put("30", "Altera\u00e7\u00e3o de Dados Rejeitada");
            map.put("33", "Confirma\u00e7\u00e3o da Altera\u00e7\u00e3o dos Dados do Rateio de Cr\u00e9dito");
            map.put("34", "Confirma\u00e7\u00e3o do Cancelamento dos Dados do Rateio de Cr\u00e9dito");
            map.put("35", "Confirma\u00e7\u00e3o do Desagendamento do D\u00e9bito Autom\u00e1tico");
            map.put("36", "Confirma\u00e7\u00e3o de envio de e-mail/SMS");
            map.put("37", "Envio de e-mail/SMS rejeitado");
            map.put("38", "Confirma\u00e7\u00e3o de altera\u00e7\u00e3o do Prazo Limite de Recebimento (a data deve ser\"");
            map.put("39", "Confirma\u00e7\u00e3o de Dispensa de Prazo Limite de Recebimento");
            map.put("40", "Confirma\u00e7\u00e3o da altera\u00e7\u00e3o do n\u00famero do t\u00edtulo dado pelo Benefici\u00e1rio");
            map.put("41", "Confirma\u00e7\u00e3o da altera\u00e7\u00e3o do n\u00famero controle do Participante");
            map.put("42", "Confirma\u00e7\u00e3o da altera\u00e7\u00e3o dos dados do Pagador");
            map.put("43", "Confirma\u00e7\u00e3o da altera\u00e7\u00e3o dos dados do Pagadorr/Avalista");
            map.put("44", "T\u00edtulo pago com cheque devolvido");
            map.put("45", "T\u00edtulo pago com cheque compensado");
            map.put("46", "Instru\u00e7\u00e3o para cancelar protesto confirmada");
            map.put("47", "Instru\u00e7\u00e3o para protesto para fins falimentares confirmada");
            map.put("48", "Confirma\u00e7\u00e3o de instru\u00e7\u00e3o de transfer\u00eancia de carteira/modalidade de cobran\u00e7a");
            map.put("49", "Altera\u00e7\u00e3o de contrato de cobran\u00e7a");
            map.put("50", "T\u00edtulo pago com cheque pendente de liquida\u00e7\u00e3o");
            map.put("51", "T\u00edtulo DDA reconhecido pelo Pagador");
            map.put("52", "T\u00edtulo DDA n\u00e3o reconhecido pelo Pagador");
            map.put("53", "T\u00edtulo DDA recusado pela CIP");
            map.put("54", "Confirma\u00e7\u00e3o da Instru\u00e7\u00e3o de Baixa/Cancelamento de T\u00edtulo Negativado sem Protesto");
            map.put("55", "Confirma\u00e7\u00e3o de Pedido de Dispensa de Multa");
            map.put("56", "Confirma\u00e7\u00e3o do Pedido de Cobran\u00e7a de Multa");
            map.put("57", "Confirma\u00e7\u00e3o do Pedido de Altera\u00e7\u00e3o de Cobran\u00e7a de Juros");
            map.put("58", "Confirma\u00e7\u00e3o do Pedido de Altera\u00e7\u00e3o do Valor/Data de Desconto");
            map.put("59", "Confirma\u00e7\u00e3o do Pedido de Altera\u00e7\u00e3o do Benefici\u00e1rio do T\u00edtulo");
            map.put("60", "Confirma\u00e7\u00e3o do Pedido de Dispensa de Juros de Mora");
            map.put("61", "Confirma\u00e7\u00e3o de Altera\u00e7\u00e3o do Valor Nominal do T\u00edtulo");
            map.put("63", "T\u00edtulo Sustado Judicialmente");
            map.put("64", "Confirma\u00e7\u00e3o de altera\u00e7\u00e3o do valor m\u00ednimo/percentual");
            map.put("65", "Confirma\u00e7\u00e3o de altera\u00e7\u00e3o do valor m\u00e1ximo/percentual");
            map.put("AB", "Cobran\u00e7a a Creditar (em tr\u00e2nsito)");
            map.put("AC", "Situa\u00e7\u00e3o do T\u00edtulo \u2013 Cart\u00f3rio");
            map.put("RI", "Retorno Intradia Banrisul");
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static String getOcorrencia(String ocorrencia) {
        try {
            Map<String, String> map = BanrisulUtil.getMapOcorrencia();
            return map.get(ocorrencia) == null ? "Ocorr\u00eancia n\u00e3o catalogada" : map.get(ocorrencia);
        }
        catch (Exception e) {
            return "Error - Ocorr\u00eancia n\u00e3o catalogada";
        }
    }

    public static Map<String, String> getMapMotivoOcorrencia(String ocorrencia) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            switch (ocorrencia) {
                case "02": 
                case "03": 
                case "26": 
                case "30": {
                    map.put("01", "C\u00f3digo do Banco Inv\u00e1lido");
                    map.put("02", "C\u00f3digo do Registro Detalhe Inv\u00e1lido");
                    map.put("03", "C\u00f3digo do Segmento Inv\u00e1lido");
                    map.put("04", "C\u00f3digo de Movimento N\u00e3o Permitido para Carteira");
                    map.put("05", "C\u00f3digo de Movimento Inv\u00e1lido");
                    map.put("06", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Benefici\u00e1rio Inv\u00e1lidos");
                    map.put("07", "Ag\u00eancia/Conta/DV Inv\u00e1lido");
                    map.put("08", "Nosso n\u00famero inv\u00e1lido");
                    map.put("09", "Nosso n\u00famero duplicado");
                    map.put("10", "Carteira inv\u00e1lida");
                    map.put("11", "Forma de Cadastramento do T\u00edtulo Inv\u00e1lido");
                    map.put("12", "Tipo de Documento Inv\u00e1lido");
                    map.put("13", "Identifica\u00e7\u00e3o da emiss\u00e3o do bloqueto inv\u00e1lida");
                    map.put("14", "Identifica\u00e7\u00e3o da Distribui\u00e7\u00e3o do Boleto de Pagamento Inv\u00e1lida");
                    map.put("15", "Caracter\u00edsticas da Cobran\u00e7a Incompat\u00edveis");
                    map.put("16", "Data de vencimento inv\u00e1lida");
                    map.put("17", "Data de Vencimento Anterior a Data de Emiss\u00e3o");
                    map.put("18", "Vencimento fora do prazo de opera\u00e7\u00e3o");
                    map.put("19", "T\u00edtulo a Cargo de Bancos Correspondentes com Vencimento Inferior a XX Dias");
                    map.put("20", "Valor do T\u00edtulo inv\u00e1lido");
                    map.put("21", "Esp\u00e9cie do T\u00edtulo Inv\u00e1lida");
                    map.put("22", "Esp\u00e9cie do T\u00edtulo N\u00e3o Permitida para a Carteira");
                    map.put("23", "Aceite Inv\u00e1lido");
                    map.put("24", "Data da Emiss\u00e3o Inv\u00e1lida");
                    map.put("25", "Data da Emiss\u00e3o Posterior a Data de Entrada");
                    map.put("26", "C\u00f3digo de Juros de Mora Inv\u00e1lido");
                    map.put("27", "Valor/Taxa de Juros de Mora Inv\u00e1lido");
                    map.put("28", "C\u00f3digo do Desconto Inv\u00e1lido");
                    map.put("29", "Valor do Desconto Maior ou Igual ao Valor do T\u00edtulo");
                    map.put("30", "Desconto a Conceder N\u00e3o Confere");
                    map.put("31", "Concess\u00e3o de Desconto - J\u00e1 Existe Desconto Anterior");
                    map.put("32", "Valor do IOF Inv\u00e1lido");
                    map.put("33", "Valor do Abatimento Inv\u00e1lido");
                    map.put("34", "Valor do Abatimento Maior ou Igual ao Valor do T\u00edtulo");
                    map.put("35", "Valor a Conceder N\u00e3o Confere");
                    map.put("36", "Concess\u00e3o de Abatimento - J\u00e1 Existe Abatimento Anterior");
                    map.put("37", "C\u00f3digo para Protesto Inv\u00e1lido");
                    map.put("38", "Prazo para Protesto Inv\u00e1lido");
                    map.put("39", "Pedido de Protesto N\u00e3o Permitido para o T\u00edtulo");
                    map.put("40", "T\u00edtulo com Ordem de Protesto Emitida");
                    map.put("41", "Pedido de Cancelamento/Susta\u00e7\u00e3o para T\u00edtulos sem Instru\u00e7\u00e3o de Protesto");
                    map.put("42", "C\u00f3digo para Baixa/Devolu\u00e7\u00e3o Inv\u00e1lido");
                    map.put("43", "Prazo para Baixa/Devolu\u00e7\u00e3o Inv\u00e1lido");
                    map.put("44", "C\u00f3digo da Moeda Inv\u00e1lido");
                    map.put("45", "Nome do Pagador N\u00e3o Informado");
                    map.put("46", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Pagador Inv\u00e1lidos");
                    map.put("47", "Endere\u00e7o do Pagador N\u00e3o Informado");
                    map.put("48", "CEP Inv\u00e1lido");
                    map.put("49", "CEP Sem Pra\u00e7a de Cobran\u00e7a (N\u00e3o Localizado)");
                    map.put("50", "CEP Referente a um Banco Correspondente");
                    map.put("51", "CEP incompat\u00edvel com a Unidade da Federa\u00e7\u00e3o");
                    map.put("52", "Unidade da Federa\u00e7\u00e3o Inv\u00e1lida");
                    map.put("53", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Sacador/Avalista Inv\u00e1lidos");
                    map.put("54", "Sacador/Avalista N\u00e3o Informado");
                    map.put("55", "Nosso n\u00famero no Banco Correspondente N\u00e3o Informado");
                    map.put("56", "C\u00f3digo do Banco Correspondente N\u00e3o Informado");
                    map.put("57", "C\u00f3digo da Multa Inv\u00e1lido");
                    map.put("58", "Data da Multa Inv\u00e1lida");
                    map.put("59", "Valor/Percentual da Multa Inv\u00e1lido");
                    map.put("60", "Movimento para T\u00edtulo N\u00e3o Cadastrado");
                    map.put("61", "Altera\u00e7\u00e3o da Ag\u00eancia Cobradora/DV Inv\u00e1lida");
                    map.put("62", "Tipo de Impress\u00e3o Inv\u00e1lido");
                    map.put("63", "Entrada para T\u00edtulo j\u00e1 Cadastrado");
                    map.put("64", "N\u00famero da Linha Inv\u00e1lido");
                    map.put("65", "C\u00f3digo do Banco para D\u00e9bito Inv\u00e1lido");
                    map.put("66", "Ag\u00eancia/Conta/DV para D\u00e9bito Inv\u00e1lido");
                    map.put("67", "Dados para D\u00e9bito incompat\u00edvel com a Identifica\u00e7\u00e3o da Emiss\u00e3o do Boleto de Pagamento");
                    map.put("68", "D\u00e9bito Autom\u00e1tico Agendado");
                    map.put("69", "D\u00e9bito N\u00e3o Agendado - Erro nos Dados da Remessa");
                    map.put("70", "D\u00e9bito N\u00e3o Agendado - Pagador N\u00e3o Consta do Cadastro de Autorizante");
                    map.put("71", "D\u00e9bito N\u00e3o Agendado - Benefici\u00e1rio N\u00e3o Autorizado pelo Pagador");
                    map.put("72", "D\u00e9bito N\u00e3o Agendado - Benefici\u00e1rio N\u00e3o Participa da Modalidade D\u00e9bito Autom\u00e1tico");
                    map.put("73", "D\u00e9bito N\u00e3o Agendado - C\u00f3digo de Moeda Diferente de Real (R$)");
                    map.put("74", "D\u00e9bito N\u00e3o Agendado - Data Vencimento Inv\u00e1lida");
                    map.put("75", "D\u00e9bito N\u00e3o Agendado, Conforme seu Pedido, T\u00edtulo N\u00e3o Registrado");
                    map.put("76", "D\u00e9bito N\u00e3o Agendado, Tipo/Num. Inscri\u00e7\u00e3o do Debitado, Inv\u00e1lido");
                    map.put("77", "Transfer\u00eancia para Desconto N\u00e3o Permitida para a Carteira do T\u00edtulo");
                    map.put("78", "Data Inferior ou Igual ao Vencimento para D\u00e9bito Autom\u00e1tico");
                    map.put("79", "Data Juros de Mora Inv\u00e1lido");
                    map.put("80", "Data do Desconto Inv\u00e1lida");
                    map.put("81", "Tentativas de D\u00e9bito Esgotadas - Baixado");
                    map.put("82", "Tentativas de D\u00e9bito Esgotadas - Pendente");
                    map.put("83", "Limite Excedido");
                    map.put("84", "N\u00famero Autoriza\u00e7\u00e3o Inexistente");
                    map.put("85", "T\u00edtulo com Pagamento Vinculado");
                    map.put("86", "Seu N\u00famero Inv\u00e1lido");
                    map.put("87", "e-mail/SMS enviado");
                    map.put("88", "e-mail Lido");
                    map.put("89", "e-mail/SMS devolvido - endere\u00e7o de e-mail ou n\u00famero do celular incorreto");
                    map.put("90", "e-mail devolvido - caixa postal cheia");
                    map.put("91", "e-mail/n\u00famero do celular do Pagador n\u00e3o informado");
                    map.put("92", "Pagador optante por Boleto de Pagamento Eletr\u00f4nico - e-mail n\u00e3o enviado");
                    map.put("93", "C\u00f3digo para emiss\u00e3o de Boleto de Pagamento n\u00e3o permite envio de e-mail");
                    map.put("94", "C\u00f3digo da Carteira inv\u00e1lido para envio e-mail.");
                    map.put("95", "Contrato n\u00e3o permite o envio de e-mail");
                    map.put("96", "N\u00famero de contrato inv\u00e1lido");
                    map.put("97", "Rejei\u00e7\u00e3o da altera\u00e7\u00e3o do prazo limite de recebimento (a data deve ser informada no campo 28.3.p)");
                    map.put("98", "Rejei\u00e7\u00e3o de dispensa de prazo limite de recebimento");
                    map.put("99", "Rejei\u00e7\u00e3o da altera\u00e7\u00e3o do n\u00famero do t\u00edtulo dado pelo Benefici\u00e1rio");
                    map.put("A1", "Rejei\u00e7\u00e3o da altera\u00e7\u00e3o do n\u00famero controle do participante");
                    map.put("A2", "Rejei\u00e7\u00e3o da altera\u00e7\u00e3o dos dados do Pagador");
                    map.put("A3", "Rejei\u00e7\u00e3o da altera\u00e7\u00e3o dos dados do Sacador/avalista");
                    map.put("A4", "Pagador DDA");
                    map.put("A5", "Registro Rejeitado \u2013 T\u00edtulo j\u00e1 Liquidado");
                    map.put("A6", "C\u00f3digo do Convenente Inv\u00e1lido ou Encerrado");
                    map.put("A7", "T\u00edtulo j\u00e1 se encontra na situa\u00e7\u00e3o Pretendida");
                    map.put("A8", "Valor do Abatimento inv\u00e1lido para cancelamento");
                    map.put("A9", "N\u00e3o autoriza pagamento parcial");
                    map.put("B1", "Autoriza recebimento parcial");
                    map.put("B2", "Valor Nominal do T\u00edtulo Conflitante");
                    map.put("B3", "Tipo de Pagamento Inv\u00e1lido");
                    map.put("B4", "Valor M\u00e1ximo/Percentual Inv\u00e1lido");
                    map.put("B5", "Valor M\u00ednimo/Percentual Inv\u00e1lido");
                    break;
                }
                case "28": {
                    map.put("01", "Tarifa de Extrato de Posi\u00e7\u00e3o");
                    map.put("02", "Tarifa de Manuten\u00e7\u00e3o de T\u00edtulo Vencido");
                    map.put("03", "Tarifa de Susta\u00e7\u00e3o");
                    map.put("04", "Tarifa de Protesto");
                    map.put("05", "Tarifa de Outras Instru\u00e7\u00f5es");
                    map.put("06", "Tarifa de Outras Ocorr\u00eancias");
                    map.put("07", "Tarifa de Envio de Duplicata ao Pagador");
                    map.put("08", "Custas de Protesto");
                    map.put("09", "Custas de Susta\u00e7\u00e3o de Protesto");
                    map.put("10", "Custas de Cart\u00f3rio Distribuidor");
                    map.put("11", "Custas de Edital");
                    map.put("12", "Tarifa Sobre Devolu\u00e7\u00e3o de T\u00edtulo Vencido");
                    map.put("13", "Tarifa Sobre Registro Cobrada na Baixa/Liquida\u00e7\u00e3o");
                    map.put("14", "Tarifa Sobre Reapresenta\u00e7\u00e3o Autom\u00e1tica");
                    map.put("15", "Tarifa Sobre Rateio de Cr\u00e9dito");
                    map.put("16", "Tarifa Sobre Informa\u00e7\u00f5es Via Fax");
                    map.put("17", "Tarifa Sobre Prorroga\u00e7\u00e3o de Vencimento");
                    map.put("18", "Tarifa Sobre Altera\u00e7\u00e3o de Abatimento/Desconto");
                    map.put("19", "Tarifa Sobre Arquivo mensal (Em Ser)");
                    map.put("20", "Tarifa Sobre Emiss\u00e3o de Boleto de Pagamento Pr\u00e9-Emitido pelo Banco");
                    break;
                }
                case "06": 
                case "09": 
                case "17": {
                    map.put("01", "Por Saldo");
                    map.put("02", "Por Conta");
                    map.put("03", "Liquida\u00e7\u00e3o no Guich\u00ea de Caixa em Dinheiro");
                    map.put("04", "Compensa\u00e7\u00e3o Eletr\u00f4nica");
                    map.put("05", "Compensa\u00e7\u00e3o Convencional");
                    map.put("06", "Por Meio Eletr\u00f4nico");
                    map.put("07", "Ap\u00f3s Feriado Local");
                    map.put("08", "Em Cart\u00f3rio");
                    map.put("30", "Liquida\u00e7\u00e3o no Guich\u00ea de Caixa em Cheque");
                    map.put("31", "Liquida\u00e7\u00e3o em banco correspondente");
                    map.put("32", "Liquida\u00e7\u00e3o Terminal de Auto-Atendimento");
                    map.put("33", "Liquida\u00e7\u00e3o na Internet (Home banking)");
                    map.put("34", "Liquidado Office Banking");
                    map.put("35", "Liquidado Correspondente em Dinheiro");
                    map.put("36", "Liquidado Correspondente em Cheque");
                    map.put("37", "Liquidado por meio de Central de Atendimento (Telefone) Baixa:");
                    map.put("09", "Comandada Banco");
                    map.put("10", "Comandada Cliente Arquivo");
                    map.put("11", "Comandada Cliente On-line");
                    map.put("12", "Decurso Prazo - Cliente");
                    map.put("13", "Decurso Prazo - Banco");
                    map.put("14", "Protestado");
                    map.put("15", "T\u00edtulo Exclu\u00eddo");
                    break;
                }
                case "AB": {
                    map.put("01", "Por Saldo - Reservado");
                    map.put("02", "Por Conta (Parcial)");
                    map.put("03", "No pr\u00f3prio Banco");
                    map.put("04", "Compensa\u00e7\u00e3o Eletr\u00f4nica");
                    map.put("05", "Compensa\u00e7\u00e3o Convencional");
                    map.put("06", "Por Meio Eletr\u00f4nico");
                    map.put("07", "Reservado");
                    map.put("08", "Em Cart\u00f3rio");
                    break;
                }
                default: {
                    map.put("70", "T\u00edtulo n\u00e3o selecionado por erro no CNPJ/CPF ou endere\u00e7o");
                    map.put("76", "Banco aguarda c\u00f3pia autenticada do documento");
                    map.put("77", "T\u00edtulo selecionado falta seu n\u00famero");
                    map.put("78", "T\u00edtulo rejeitado pelo cart\u00f3rio por estar irregular");
                    map.put("79", "T\u00edtulo n\u00e3o selecionado - pra\u00e7a n\u00e3o atendida");
                    map.put("80", "Cart\u00f3rio aguarda autoriza\u00e7\u00e3o para protestar por edital");
                    map.put("90", "Protesto sustado por solicita\u00e7\u00e3o do Benefici\u00e1rio");
                    map.put("91", "Protesto sustado por altera\u00e7\u00e3o no vencimento");
                    map.put("92", "Aponte cobrado de t\u00edtulo sustado");
                    map.put("93", "Protesto sustado por altera\u00e7\u00e3o no prazo do protesto");
                    map.put("95", "Entidade P\u00fablica");
                    map.put("97", "T\u00edtulo em cart\u00f3rio");
                }
            }
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static String getMotivoOcorrenciaSicredi(String ocorrencia, String motivoOcorrencia) {
        try {
            Map<String, String> map = BanrisulUtil.getMapMotivoOcorrencia(ocorrencia);
            return map.get(motivoOcorrencia) == null ? "Motivo Ocorr\u00eancia n\u00e3o catalogada" : map.get(motivoOcorrencia);
        }
        catch (Exception e) {
            return "Error - Motivo Ocorr\u00eancia n\u00e3o catalogada";
        }
    }
}

