/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.bradesco_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.ConfiguracaoBradescoAPI;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.Util.ModelConverter;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.Token;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.baixaBoleto.BoletoBradescoBaixaAPIRequest;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.changeBoleto.ChangeBoletoBradescoAPIRequest;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.createBoleto.BoletoBradescoAPIRequest;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.queryBoleto.BoletoBradescoConsultaAPIRequest;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.response.BoletoBradescoAPIResponse;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.response.ChangeBoletoBradescoAPIResponse;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.response.QueryBoletoBradescoAPIResponse;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.response.baixaBoleto.BoletoBaixaBoletoAPIResponse;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.RestUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class BancoBradescoAPI
extends BoletoController {
    private static final Logger log = Logger.getLogger("BancoBradescoAPI");
    private Token tk;
    ConfiguracaoBradescoAPI configuracao;
    ObjectMapper ob = JsonUtil.createObjectMapper();

    void init() {
        this.configuracao = (ConfiguracaoBradescoAPI)this.getConfiguracao();
        if (this.configuracao == null) {
            throw new BoletoException("Favor inicializar a configura\u00e7\u00e3o primeiro");
        }
        this.tk = this.configuracao.getToken();
        if (this.tk == null) {
            this.tk = this.novoToken(this.configuracao);
            this.tk.setGenerationTimestamp(LocalDateTime.now());
        }
        if (!this.tk.isValido()) {
            this.tk = this.novoToken(this.configuracao);
            this.tk.setGenerationTimestamp(LocalDateTime.now());
        }
        this.configuracao.setToken(this.tk);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token novoToken(ConfiguracaoBradescoAPI configuracao) {
        String urlToken = configuracao.getURLBase() + configuracao.getUrlToken();
        HttpPost comando = new HttpPost(urlToken);
        ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
        data.add(new BasicNameValuePair("grant_type", "client_credentials"));
        data.add(new BasicNameValuePair("client_id", configuracao.getClientId()));
        data.add(new BasicNameValuePair("client_secret", configuracao.getClientSecret()));
        comando.setEntity((HttpEntity)new UrlEncodedFormEntity(data, StandardCharsets.UTF_8));
        try (CloseableHttpResponse closeableHttpResponse = RestUtil.enviaComandoCertificadoByteArr((HttpUriRequest)comando, configuracao.getCertificadoByteArr(), configuracao.getSenhaCertificado());){
            Token token = RestUtil.JsonToObject(RestUtil.validaResponseERetornaBody(closeableHttpResponse), Token.class);
            return token;
        }
        catch (IOException e) {
            throw new BoletoException("Falha ao gerar um novo token", e);
        }
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            boletoModel.setDigitoNossoNumero(ModelConverter.geraDigitoNossoNumero(Integer.parseInt(boletoModel.getBeneficiario().getCarteira()), BigDecimal.valueOf(Long.parseLong(boletoModel.getNossoNumero()))));
            boletoModel.setNossoNumero(StringUtils.leftPad((String)boletoModel.getNossoNumero(), (int)11, (String)"0"));
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        BoletoBradescoAPIResponse boletoBradescoAPIResponse;
        String resp;
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        this.init();
        String urlBoleto = this.configuracao.getURLBase() + this.configuracao.getUrlRegistroBoleto();
        HttpPost comando = new HttpPost(urlBoleto);
        comando.setHeaders(this.getBasicHeaders());
        BoletoBradescoAPIRequest boletoBradescoAPIRequest = ModelConverter.request(boletoModel);
        try {
            comando.setEntity((HttpEntity)new StringEntity(this.ob.writeValueAsString((Object)boletoBradescoAPIRequest), "UTF-8"));
            resp = RestUtil.validaResponseERetornaBody(RestUtil.enviaComandoCertificadoByteArr((HttpUriRequest)comando, this.configuracao.getCertificadoByteArr(), this.configuracao.getSenhaCertificado()));
        }
        catch (IOException e) {
            throw new BoletoException(e);
        }
        try {
            boletoBradescoAPIResponse = RestUtil.JsonToObject(resp, BoletoBradescoAPIResponse.class);
        }
        catch (IOException e) {
            throw new BoletoException(e);
        }
        assert (boletoBradescoAPIResponse != null);
        return ModelConverter.response(boletoBradescoAPIResponse);
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        ChangeBoletoBradescoAPIResponse changeBoletoBradescoAPIResponse;
        String resp;
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        this.init();
        String urlBoleto = this.configuracao.getURLAlteraBoleto();
        HttpPost comando = new HttpPost(urlBoleto);
        comando.setHeaders(this.getBasicHeaders());
        comando.setHeader((Header)new BasicHeader("txId", boletoModel.getTxId()));
        ChangeBoletoBradescoAPIRequest boletoChange = ModelConverter.changeRequest(boletoModel);
        try {
            comando.setEntity((HttpEntity)new StringEntity(this.ob.writeValueAsString((Object)boletoChange), "UTF-8"));
        }
        catch (JsonProcessingException e) {
            throw new BoletoException(e);
        }
        try {
            resp = RestUtil.validaResponseERetornaBody(RestUtil.enviaComandoCertificadoByteArr((HttpUriRequest)comando, this.configuracao.getCertificadoByteArr(), this.configuracao.getSenhaCertificado()));
        }
        catch (IOException e) {
            throw new BoletoException(e);
        }
        try {
            changeBoletoBradescoAPIResponse = RestUtil.JsonToObject(resp, ChangeBoletoBradescoAPIResponse.class);
        }
        catch (IOException e) {
            throw new BoletoException(e);
        }
        assert (changeBoletoBradescoAPIResponse != null);
        ModelConverter.changeBoletoResponse(boletoModel, changeBoletoBradescoAPIResponse);
        return boletoModel;
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        this.init();
        String urlConsulta = this.configuracao.getURLBase() + this.configuracao.getUrlConsultaBoleto2Via();
        HttpPost comando = new HttpPost(urlConsulta);
        comando.setHeaders(this.getBasicHeaders());
        BoletoBradescoConsultaAPIRequest consultaRequest = ModelConverter.queryBoletoRequest(boletoModel);
        return this.getBoletoModel(comando, consultaRequest, null);
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        this.init();
        String urlBaixa = this.configuracao.getURLBase() + this.configuracao.getUrlBaixaBoleto();
        HttpPost comando = new HttpPost(urlBaixa);
        Header[] headers = new Header[]{new BasicHeader("Authorization", this.tk.getAccess_token()), new BasicHeader("Content-Type", "application/json")};
        comando.setHeaders(headers);
        BoletoBradescoBaixaAPIRequest boletoBaixaRequest = ModelConverter.baixaBoletoRequest(boletoModel);
        return this.getBoletoModel(comando, null, boletoBaixaRequest);
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        return "";
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        return Collections.emptyList();
    }

    private String getResponseString(Object requestObj, HttpPost comando, ConfiguracaoBradescoAPI configuracao) {
        String resp;
        try {
            comando.setEntity((HttpEntity)new StringEntity(this.ob.writeValueAsString(requestObj), "UTF-8"));
        }
        catch (JsonProcessingException e) {
            throw new BoletoException(e);
        }
        try {
            resp = RestUtil.validaResponseERetornaBody(RestUtil.enviaComandoCertificadoByteArr((HttpUriRequest)comando, configuracao.getCertificadoByteArr(), configuracao.getSenhaCertificado()));
        }
        catch (IOException e) {
            throw new BoletoException(e);
        }
        return resp;
    }

    private BoletoModel getBoletoModel(HttpPost comando, BoletoBradescoConsultaAPIRequest boletoBradescoConsultaAPIRequest, BoletoBradescoBaixaAPIRequest boletoBradescoBaixaAPIRequest) {
        BoletoBaixaBoletoAPIResponse baixaBoletoResponse;
        if (boletoBradescoConsultaAPIRequest != null) {
            QueryBoletoBradescoAPIResponse queryBoletoBradescoAPIResponse;
            String resp = this.getResponseString(boletoBradescoConsultaAPIRequest, comando, this.configuracao);
            try {
                queryBoletoBradescoAPIResponse = RestUtil.JsonToObject(resp, QueryBoletoBradescoAPIResponse.class);
            }
            catch (IOException e) {
                throw new BoletoException(e);
            }
            assert (queryBoletoBradescoAPIResponse != null);
            return ModelConverter.queryBoletoResponse(queryBoletoBradescoAPIResponse);
        }
        String resp = this.getResponseString(boletoBradescoBaixaAPIRequest, comando, this.configuracao);
        try {
            baixaBoletoResponse = RestUtil.JsonToObject(resp, BoletoBaixaBoletoAPIResponse.class);
        }
        catch (IOException e) {
            throw new BoletoException(e);
        }
        assert (baixaBoletoResponse != null);
        return ModelConverter.baixaBoletoResponse(baixaBoletoResponse);
    }

    private Header[] getBasicHeaders() {
        Header[] headers = new Header[]{new BasicHeader("Authorization", this.tk.getAccess_token()), new BasicHeader("Content-Type", "application/json")};
        return headers;
    }

    public void setTk(Token tk) {
        this.tk = tk;
    }

    public void setConfiguracao(ConfiguracaoBradescoAPI configuracao) {
        this.configuracao = configuracao;
    }

    public void setOb(ObjectMapper ob) {
        this.ob = ob;
    }
}

