/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.bradesco_api;

import br.com.java_brasil.boleto.model.Configuracao;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.Token;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;

public class ConfiguracaoBradescoAPI
implements Configuracao {
    @NotEmpty
    private String clientId;
    @NotEmpty
    private String clientSecret;
    private Token token;
    private String expTokenTime;
    @NotEmpty
    private String cpfCnpj;
    @NotNull
    private AmbienteEnum ambiente;
    @NotNull
    private byte[] certificadoByteArr;
    @NotEmpty
    private String senhaCertificado = "";
    @NotEmpty
    private String urlRegistroBoleto = "/boleto-hibrido/cobranca-registro/v1/gerarBoleto";
    @NotEmpty
    private String urlRegistroAlteraBoleto = "/boleto-hibrido/cobranca-alteracao/v1/alteraBoletoConsulta";
    @NotEmpty
    private String urlConsultaBoleto2Via = "/boleto-hibrido/cobranca-consulta-titulo/v1/consultar";
    @NotEmpty
    private String urlBaixaBoleto = "/boleto/cobranca-baixa/v1/baixar";
    @NotEmpty
    private String urlToken = "/auth/server-mtls/v2/token";
    @NotEmpty
    private String urlBaseProducao = "https://openapi.bradesco.com.br";
    @NotEmpty
    private String urlBaseHomologacao = "https://openapisandbox.prebanco.com.br";
    private InputStream modeloImpressaoBoleto;
    private HashMap<String, Object> parametrosImpressaoBoleto = new HashMap();

    public String getURLBase() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlBaseProducao : this.urlBaseHomologacao;
    }

    public String getURLAlteraBoleto() {
        return this.getURLBase() + this.urlRegistroAlteraBoleto;
    }

    @Override
    public InputStream modeloImpressaoBoleto() {
        if (this.modeloImpressaoBoleto == null) {
            try {
                this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoBradesco.jasper");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.modeloImpressaoBoleto;
    }

    @Override
    public void usarModeloImpressaoBoletoCarne() {
    }

    @Override
    public HashMap<String, Object> parametrosImpressaoBoleto() throws IOException {
        Image imageLogo = null;
        try {
            InputStream inputStreamLogo = this.getClass().getResourceAsStream("/logo/LogoBradesco.jpg");
            assert (inputStreamLogo != null);
            imageLogo = new ImageIcon(IOUtils.toByteArray((InputStream)inputStreamLogo)).getImage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.parametrosImpressaoBoleto.put("LogoBanco", imageLogo);
        this.parametrosImpressaoBoleto.put("REPORT_LOCALE", new Locale("pt", "BR"));
        return this.parametrosImpressaoBoleto;
    }

    @Override
    public List<String> camposObrigatoriosBoleto() {
        return Arrays.asList("beneficiario.agencia", "beneficiario.digitoAgencia", "beneficiario.conta", "beneficiario.digitoConta", "beneficiario.documento", "beneficiario.carteira", "nossoNumero", "pagador.nome", "pagador.documento", "pagador.codigo", "pagador.endereco.logradouro", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cep", "pagador.endereco.cidade", "pagador.endereco.uf", "valorBoleto", "dataVencimento", "beneficiario", "pagador");
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Token getToken() {
        return this.token;
    }

    public String getExpTokenTime() {
        return this.expTokenTime;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @NotNull
    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    @NotNull
    public byte[] getCertificadoByteArr() {
        return this.certificadoByteArr;
    }

    public String getSenhaCertificado() {
        return this.senhaCertificado;
    }

    public String getUrlRegistroBoleto() {
        return this.urlRegistroBoleto;
    }

    public String getUrlRegistroAlteraBoleto() {
        return this.urlRegistroAlteraBoleto;
    }

    public String getUrlConsultaBoleto2Via() {
        return this.urlConsultaBoleto2Via;
    }

    public String getUrlBaixaBoleto() {
        return this.urlBaixaBoleto;
    }

    public String getUrlToken() {
        return this.urlToken;
    }

    public String getUrlBaseProducao() {
        return this.urlBaseProducao;
    }

    public String getUrlBaseHomologacao() {
        return this.urlBaseHomologacao;
    }

    public InputStream getModeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    public HashMap<String, Object> getParametrosImpressaoBoleto() {
        return this.parametrosImpressaoBoleto;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setExpTokenTime(String expTokenTime) {
        this.expTokenTime = expTokenTime;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public void setAmbiente(@NotNull AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public void setCertificadoByteArr(@NotNull byte[] certificadoByteArr) {
        this.certificadoByteArr = certificadoByteArr;
    }

    public void setSenhaCertificado(String senhaCertificado) {
        this.senhaCertificado = senhaCertificado;
    }

    public void setUrlRegistroBoleto(String urlRegistroBoleto) {
        this.urlRegistroBoleto = urlRegistroBoleto;
    }

    public void setUrlRegistroAlteraBoleto(String urlRegistroAlteraBoleto) {
        this.urlRegistroAlteraBoleto = urlRegistroAlteraBoleto;
    }

    public void setUrlConsultaBoleto2Via(String urlConsultaBoleto2Via) {
        this.urlConsultaBoleto2Via = urlConsultaBoleto2Via;
    }

    public void setUrlBaixaBoleto(String urlBaixaBoleto) {
        this.urlBaixaBoleto = urlBaixaBoleto;
    }

    public void setUrlToken(String urlToken) {
        this.urlToken = urlToken;
    }

    public void setUrlBaseProducao(String urlBaseProducao) {
        this.urlBaseProducao = urlBaseProducao;
    }

    public void setUrlBaseHomologacao(String urlBaseHomologacao) {
        this.urlBaseHomologacao = urlBaseHomologacao;
    }

    public void setModeloImpressaoBoleto(InputStream modeloImpressaoBoleto) {
        this.modeloImpressaoBoleto = modeloImpressaoBoleto;
    }

    public void setParametrosImpressaoBoleto(HashMap<String, Object> parametrosImpressaoBoleto) {
        this.parametrosImpressaoBoleto = parametrosImpressaoBoleto;
    }
}

