/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.bradesco_api.Util;

import br.com.java_brasil.boleto.model.Beneficiario;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Endereco;
import br.com.java_brasil.boleto.model.InformacaoModel;
import br.com.java_brasil.boleto.model.Pagador;
import br.com.java_brasil.boleto.model.enums.SituacaoEnum;
import br.com.java_brasil.boleto.model.enums.TipoDescontoEnum;
import br.com.java_brasil.boleto.model.enums.TipoJurosEnum;
import br.com.java_brasil.boleto.model.enums.TipoMultaEnum;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.baixaBoleto.BoletoBradescoBaixaAPIRequest;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.baixaBoleto.CpfCnpj;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.changeBoleto.ChangeBoletoBradescoAPIRequest;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.changeBoleto.ChaveChangeBoletoAPIRequest;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.changeBoleto.DadosTituloBradescoAPIRequest;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.createBoleto.BoletoBradescoAPIRequest;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.request.queryBoleto.BoletoBradescoConsultaAPIRequest;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.response.BoletoBradescoAPIResponse;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.response.ChangeBoletoBradescoAPIResponse;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.response.QueryBoletoBradescoAPIResponse;
import br.com.java_brasil.boleto.service.bancos.bradesco_api.model.response.baixaBoleto.BoletoBaixaBoletoAPIResponse;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.RestUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModelConverter {
    private static final Log log = LogFactory.getLog(ModelConverter.class);
    private static final Set<String> LIQUIDADO = new HashSet<String>(Arrays.asList("13", "30", "51", "61", "62", "66", "67", "70", "72"));
    private static final Set<String> BAIXADO = new HashSet<String>(Arrays.asList("7", "8", "10", "11", "12", "19", "20", "21", "23", "24", "25", "26", "27", "28", "34", "35", "52", "53", "54", "55", "57", "59", "63", "64", "65", "68", "69", "71", "73", "98", "99"));

    private ModelConverter() {
    }

    public static BoletoBradescoAPIRequest request(BoletoModel source) {
        BoletoBradescoAPIRequest boleto = new BoletoBradescoAPIRequest();
        boleto.setRegistrarTitulo(1);
        boleto.setCodUsuario("APISERVIC");
        boleto.setTipoAcesso(2);
        boleto.setCodigoBanco(237);
        boleto.setCidtfdTpoVcto("0");
        boleto.setCindcdEconmMoeda(6);
        boleto.setQmoedaNegocTitlo(0);
        boleto.setCindcdAceitSacdo("N");
        boleto.setCtpoPrzDecurs("0");
        boleto.setCformaEmisPplta("02");
        boleto.setBancoCentProt("0");
        boleto.setAgenciaDvCentPr("0");
        boleto.setFiller3("0");
        boleto.setFase("1");
        boleto.setCindcdCobrMisto("S");
        boleto.setCpssoaJuridContr("0");
        boleto.setCtpoContrNegoc("0");
        boleto.setNseqContrNegoc("0");
        boleto.setENseqContrNegoc("0");
        boleto.setFiller("");
        boleto.setTipoRegistro(1);
        boleto.setCctrlPartcTitlo("");
        boleto.setCtpoPrzCobr("1");
        boleto.setVabtmtTitloCobr("");
        boleto.setFiller2("");
        boleto.setViofPgtoTitlo("0");
        boleto.setQtdDecurPrz("0");
        boleto.setIconcPgtoSpi("");
        boleto.setIaliasAdsaoCta("");
        boleto.setIlinkGeracQrcd("");
        boleto.setCaliasAdsaoCta("");
        boleto.setWqrcdPdraoMercd("");
        boleto.setValidadeAposVencimento("");
        boleto.setFiller4("");
        boleto.setIdLoc("");
        boleto.setCtpoProteTitlo("");
        boleto.setCtpoPrzProte("");
        boleto.setCtpoProteDecurs("");
        boleto.setFiller1("");
        boleto.setCindcdPgtoParcial("N");
        boleto.setQtdePgtoParcial("0");
        boleto.setCtitloCobrCdent(source.getNossoNumero());
        String doc = source.getBeneficiario().getDocumento().replaceAll("\\D", "");
        CpfCnpj cpfCnpj = ModelConverter.divideCPFCNPJ(doc);
        boleto.setNroCpfCnpjBenef(String.valueOf(cpfCnpj.getCpfCnpj()));
        boleto.setDigCpfCnpjBenef(String.valueOf(cpfCnpj.getControle()));
        boleto.setFilCpfCnpjBenef(String.valueOf(cpfCnpj.getFilial()));
        boleto.setCidtfdProdCobr(source.getBeneficiario().getCarteira());
        boleto.setAgenciaDebDv("");
        boleto.setAgenciaDeb("");
        String agencia = StringUtils.leftPad((String)source.getBeneficiario().getAgencia(), (int)4, (String)"0");
        String conta = StringUtils.leftPad((String)source.getBeneficiario().getConta(), (int)14, (String)"0");
        String cnegocCobr = agencia + conta;
        boleto.setCnegocCobr(cnegocCobr);
        boleto.setDemisTitloCobr(ModelConverter.formataDataBradesco(source.getDataEmissao(), "dd.MM.yyyy"));
        boleto.setCtitloCliCdent(source.getNumeroBoleto());
        boleto.setDvctoTitloCobr(ModelConverter.formataDataBradesco(source.getDataVencimento(), "dd.MM.yyyy"));
        boleto.setVnmnalTitloCobr(BoletoUtil.formatarValorSemPonto(source.getValorBoleto(), 2, 0));
        boleto.setCespceTitloCobr(source.getEspecieDocumento());
        switch (source.getTipoMulta()) {
            case VALOR: {
                boleto.setVmultaAtrsoPgto(ModelConverter.formataValorBradesco(source.getValorMulta()));
                break;
            }
            case PERCENTUAL: {
                boleto.setPmultaAplicVcto(ModelConverter.formataPercentualBradesco(source.getValorPercentualMulta()));
            }
        }
        boleto.setQdiaInicMulta(source.getDiasMulta());
        switch (source.getTipoMulta()) {
            case PERCENTUAL: {
                boleto.setPtxJuroVcto(ModelConverter.formataPercentualBradesco(source.getValorPercentualMulta()));
                break;
            }
            case VALOR: {
                boleto.setVdiaJuroMora(ModelConverter.formataValorBradesco(source.getValorJuros()));
            }
        }
        boleto.setQdiaInicJuro(source.getDiasJuros());
        boleto.setVdescBonifPgto(ModelConverter.formataValorBradesco(source.getValorDescontos()));
        boleto.setVdescBonifPgto01("0");
        boleto.setVdescBonifPgto02("0");
        boleto.setVdescBonifPgto03("0");
        boleto.setPdescBonifPgto(ModelConverter.formataPercentualBradesco(source.getValorPercentualDescontos()));
        boleto.setPdescBonifPgto01(ModelConverter.formataPercentualBradesco(source.getValorPercentualDescontos2()));
        boleto.setPdescBonifPgto02(ModelConverter.formataPercentualBradesco(source.getValorPercentualDescontos3()));
        boleto.setPdescBonifPgto03("0");
        boleto.setDlimBonifPgto("");
        boleto.setDlimDescBonif1(ModelConverter.formataDataBradesco(source.getDataLimiteParaDesconto(), "dd.MM.yyyy"));
        boleto.setDlimDescBonif2(ModelConverter.formataDataBradesco(source.getDataLimiteParaDesconto2(), "dd.MM.yyyy"));
        boleto.setDlimDescBonif3(ModelConverter.formataDataBradesco(source.getDataLimiteParaDesconto3(), "dd.MM.yyyy"));
        boleto.setIsacdoTitloCobr(source.getPagador().getNome());
        boleto.setEnroLogdrSacdo(source.getPagador().getEndereco().getNumero());
        boleto.setElogdrSacdoTitlo(source.getPagador().getEndereco().getLogradouro());
        boleto.setEcomplLogdrSacdo(Optional.ofNullable(source.getPagador().getEndereco().getComplemento()).map(c -> c.length() > 15 ? c.substring(0, 15) : c).orElse(""));
        boleto.setCcepSacdoTitlo(Integer.valueOf(BoletoUtil.manterApenasNumeros(source.getPagador().getEndereco().getCep().substring(0, 5))));
        boleto.setEbairoLogdrSacdo(source.getPagador().getEndereco().getBairro());
        boleto.setCcomplCepSacdo("0");
        boleto.setImunSacdoTitlo(source.getPagador().getEndereco().getCidade());
        boleto.setIndCpfCnpjSacdo(source.getPagador().isClienteCpf() ? 1 : 2);
        boleto.setCsglUfSacdo(source.getPagador().getEndereco().getUf());
        boleto.setRenderEletrSacdo(source.getPagador().getEmail());
        boleto.setCdddFoneSacdo(source.getPagador().getDdd());
        boleto.setCodNegativacao("0");
        boleto.setDiasNegativacao("0");
        boleto.setNroCpfCnpjSacdo(source.getPagador().getDocumento());
        boleto.setEnroLogdrSacdr("0");
        boleto.setCfoneSacdoTitlo(source.getPagador().getTelefone());
        boleto.setContaDeb(source.getBeneficiario().getConta());
        if (source.getBeneficiarioFinal() != null) {
            Pagador bnfinal = source.getBeneficiarioFinal();
            boleto.setIsacdrAvalsTitlo(bnfinal.getNome());
            boleto.setElogdrSacdrAvals(bnfinal.getEndereco().getLogradouro());
            boleto.setEcomplLogdrSacdr(bnfinal.getEndereco().getComplemento());
            boleto.setCcomplCepSacdr(bnfinal.getEndereco().getEnderecoCompleto());
            boleto.setEbairoLogdrSacdr(bnfinal.getEndereco().getBairro());
            boleto.setCsglUfSacdr(bnfinal.getEndereco().getUf());
            boleto.setCcepSacdrTitlo(bnfinal.getEndereco().getCep());
            boleto.setImunSacdrAvals(bnfinal.getEndereco().getCidade());
            boleto.setIndCpfCnpjSacdr(bnfinal.isClienteCpf() ? 1 : 2);
            boleto.setRenderEletrSacdr(bnfinal.getEmail());
            boleto.setNroCpfCnpjSacdr(bnfinal.getDocumento());
            boleto.setCdddFoneSacdr(bnfinal.getDdd());
            boleto.setCfoneSacdrTitlo(bnfinal.getTelefone());
        }
        return boleto;
    }

    private static CpfCnpj divideCPFCNPJ(String doc) {
        CpfCnpj cpfCnpj = new CpfCnpj();
        if (doc.length() == 11) {
            doc = String.format("%011d", Long.parseLong(doc));
            cpfCnpj.setCpfCnpj(Integer.parseInt(doc.substring(0, 9)));
            cpfCnpj.setFilial(0);
            cpfCnpj.setControle(Integer.parseInt(doc.substring(9, 11)));
            return cpfCnpj;
        }
        if (doc.length() == 14) {
            cpfCnpj.setCpfCnpj(Integer.parseInt(doc.substring(0, 8)));
            cpfCnpj.setFilial(Integer.parseInt(doc.substring(8, 12)));
            cpfCnpj.setControle(Integer.parseInt(doc.substring(12, 14)));
            return cpfCnpj;
        }
        throw new IllegalArgumentException("Documento do Beneficiario inv\u00e1lido: deve ter 11 (CPF) ou 14 (CNPJ) d\u00edgitos.");
    }

    public static BoletoModel response(BoletoBradescoAPIResponse source) {
        BoletoModel boleto = new BoletoModel();
        Pagador pagador = new Pagador();
        Endereco endereco = new Endereco();
        Beneficiario beneficiario = new Beneficiario();
        pagador.setEndereco(endereco);
        beneficiario.setEndereco(endereco);
        boleto.setBeneficiario(beneficiario);
        boleto.setPagador(pagador);
        beneficiario.setCarteira(String.valueOf(source.getCidtfdProdCobr()));
        beneficiario.setAgencia(String.valueOf(source.getAgencCred10()));
        beneficiario.setConta(String.valueOf(source.getCtaCred10()));
        beneficiario.setDigitoConta(source.getDigCred10());
        beneficiario.setNomeBeneficiario(source.getCedente10());
        beneficiario.setDocumento(source.getCnpjCpfCedente10());
        pagador.setNome(source.getNomeSacado10());
        pagador.setDocumento(String.valueOf(source.getCnpjSacado10()));
        pagador.getEndereco().setComplemento(source.getEndSacado10());
        pagador.getEndereco().setBairro(source.getBaiSacado10());
        pagador.getEndereco().setCidade(source.getCidSacado10());
        pagador.getEndereco().setUf(source.getUfSacado10());
        pagador.getEndereco().setCep(String.valueOf(source.getCepSacado10()));
        boleto.setCodRetorno(String.valueOf(source.getStatusHttp()));
        boleto.setCodigosEmpresa(String.valueOf(source.getCpssoaJuridContr()));
        boleto.setNumeroDocumento(source.getSnumero10());
        boleto.setDataVencimento(ModelConverter.desFormataDataBradesco(source.getDataVencto10(), "dd.MM.yyyy"));
        boleto.setValorBoleto(new BigDecimal(source.getValMoeda10()).movePointLeft(source.getQtdeCas10()));
        boleto.setValorDescontos(new BigDecimal(source.getValAbat10()).movePointLeft(source.getQtdeCas10()));
        boleto.setValorIof(new BigDecimal(source.getValorIof10()).movePointLeft(source.getQtdeCas10()));
        boleto.setDataEmissao(ModelConverter.desFormataDataBradesco(source.getDataEmis10(), "dd.MM.yyyy"));
        boleto.setDataProcessamento(ModelConverter.desFormataDataBradesco(source.getDataReg10(), "ddMMyyyy"));
        boleto.setAceite("A".equals(source.getAceite10()));
        boleto.setDiasJuros(source.getDiasJuros10());
        boleto.setValorMulta(BigDecimal.valueOf(source.getValMulta10()).movePointLeft(source.getQtdeCasMul10()));
        boleto.setDiasMulta(source.getDiasMulta10());
        boleto.setDataMulta(ModelConverter.desFormataDataBradesco(source.getDataMulta10(), "ddMMyyyy"));
        boleto.setEspecieDocumento(source.getEspecDocto10());
        boleto.setEspecieMoeda(source.getEspecMoeda10());
        boleto.setCodigoEspecieMoeda(Integer.parseInt(source.getQtdeMoeda10() == 0 ? "0" : String.valueOf(source.getQtdeMoeda10())));
        boleto.setCodigoBarras(BoletoUtil.formatarParaCodigoBarrasI25(source.getCodBarras10()));
        boleto.setLinhaDigitavel(source.getLinhaDig10());
        boleto.setAutorizaPagamentoParcial("S".equals(source.getPermPgtoParcial()));
        boleto.setQuantidadePagamentoParcial(source.getQtdePgtoParcial());
        boleto.setSituacao(ModelConverter.getSituacao(source.getStatus10()));
        boleto.setPixTxidQrCode(source.getIconcPgtoSpi());
        boleto.setPixUrlQrCode(source.getIlinkGeracQrcd());
        boleto.setPixCopiaCola(source.getWqrcdPdraoMercd());
        boleto.setSituacaoBoletoBanco(source.getStatus10());
        boleto.setTxId(source.getIconcPgtoSpi());
        if (source.getCodValMul10() == 1) {
            boleto.setTipoMulta(TipoMultaEnum.PERCENTUAL);
        } else if (source.getCodValMul10() == 2) {
            boleto.setTipoMulta(TipoMultaEnum.VALOR);
        }
        boleto.setValorPercentualMulta(boleto.getValorMulta());
        boleto.setProtesto(source.getDiasProt10() > 0);
        boleto.setDiasProtesto(source.getDiasProt10());
        boleto.setNossoNumero(String.valueOf(source.getCtitloCobrCdent()));
        boleto.setDigitoNossoNumero(ModelConverter.geraDigitoNossoNumero(source.getCidtfdProdCobr(), BigDecimal.valueOf(source.getCtitloCobrCdent())));
        boleto.setDataLimiteParaDesconto(ModelConverter.desFormataDataBradesco(source.getDataLimitePgt10(), "dd/MM/yyyy"));
        boleto.setInstrucoes(Collections.singletonList(new InformacaoModel("Status: " + source.getStatus10())));
        boleto.setRetorno(source);
        return boleto;
    }

    public static ChangeBoletoBradescoAPIRequest changeRequest(BoletoModel boletoModel) {
        ChangeBoletoBradescoAPIRequest changeReq = new ChangeBoletoBradescoAPIRequest();
        ChaveChangeBoletoAPIRequest chave = new ChaveChangeBoletoAPIRequest();
        chave.setNossoNumero(StringUtils.leftPad((String)boletoModel.getNossoNumero(), (int)11, (String)"0"));
        chave.setIdprod(boletoModel.getBeneficiario().getCarteira());
        String agencia = StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (String)"0");
        String conta = StringUtils.leftPad((String)boletoModel.getBeneficiario().getConta(), (int)7, (String)"0");
        chave.setCtaprod(agencia + conta);
        CpfCnpj cpfCnpj = ModelConverter.divideCPFCNPJ(boletoModel.getBeneficiario().getDocumento());
        chave.setCnpjCpf(cpfCnpj.getCpfCnpj());
        chave.setFilial(Integer.parseInt(StringUtils.leftPad((String)String.valueOf(cpfCnpj.getFilial()), (int)4, (String)"0")));
        chave.setControle(StringUtils.leftPad((String)String.valueOf(cpfCnpj.getControle()), (int)2, (String)"0"));
        changeReq.setChave(chave);
        DadosTituloBradescoAPIRequest dt = new DadosTituloBradescoAPIRequest();
        dt.setSeuNumero(boletoModel.getNossoNumero());
        dt.setDataEmissao(0);
        dt.setDataVencimento(Integer.parseInt(ModelConverter.formataDataBradesco(boletoModel.getDataVencimento(), "ddMMyyyy")));
        dt.setEspecie(boletoModel.getEspecieDocumento());
        dt.setCodVencimento(0);
        dt.setCodInstrucaoProtesto(boletoModel.isProtesto() ? 1 : 9);
        dt.setDiasProtesto(boletoModel.getDiasProtesto());
        dt.setCodDecurso(boletoModel.getNumeroDiasNegativacao() > 0 ? 1 : 0);
        dt.setDiasDecurso(boletoModel.getNumeroDiasNegativacao());
        if (boletoModel.getValorDescontos().compareTo(BigDecimal.ZERO) > 0) {
            dt.setCodAbatimento(1);
            dt.setValorAbatimentoTitulo(boletoModel.getValorDescontos().movePointRight(2).intValue());
        } else {
            dt.setCodAbatimento(0);
            dt.setValorAbatimentoTitulo(0);
        }
        if (boletoModel.getDataLimiteParaDesconto() != null) {
            dt.setDataPrimeiroDesc(Integer.parseInt(ModelConverter.formataDataBradesco(boletoModel.getDataLimiteParaDesconto(), "ddMMyyyy")));
            dt.setValorPrimeiroDesc(boletoModel.getValorPercentualDescontos().movePointRight(2).intValue());
            dt.setCodPrimeiroDesc(ModelConverter.mapTipoDescontoToCod(boletoModel.getTipoDesconto()));
            dt.setAcaoPrimeiroDesc(1);
        } else {
            dt.setDataPrimeiroDesc(0);
            dt.setValorPrimeiroDesc(0);
            dt.setCodPrimeiroDesc(0);
            dt.setAcaoPrimeiroDesc(0);
        }
        if (boletoModel.getDiasJuros() > 0 && boletoModel.getValorJuros().compareTo(BigDecimal.ZERO) > 0) {
            dt.setDiasAposVencidoJuros(boletoModel.getDiasJuros());
            dt.setValorJuros(ModelConverter.formataValorBradesco(boletoModel.getValorJuros()));
            dt.setCodJuros(ModelConverter.mapTipoJuros(boletoModel.getTipoJuros()));
        } else {
            dt.setDiasAposVencidoJuros(0);
            dt.setValorJuros(String.valueOf(0));
            dt.setCodJuros(0);
        }
        if (boletoModel.getDiasMulta() > 0 && boletoModel.getValorMulta().compareTo(BigDecimal.ZERO) > 0) {
            dt.setDiasAposVencimentoMulta(boletoModel.getDiasMulta());
            dt.setValorMulta(ModelConverter.formataValorBradesco(boletoModel.getValorMulta()));
            dt.setCodMulta(ModelConverter.mapTipoMulta(boletoModel.getTipoMulta()));
        } else {
            dt.setDiasAposVencimentoMulta(0);
            dt.setValorMulta(String.valueOf(0));
            dt.setCodMulta(0);
        }
        dt.setCodNegativacao(boletoModel.isNegativacaoAutomatica() ? 1 : 0);
        dt.setDiasNegativacao(boletoModel.getNumeroDiasNegativacao());
        dt.setCodPagamentoParcial(boletoModel.isAutorizaPagamentoParcial() ? "S" : "N");
        dt.setQtdePagamentosParciais(boletoModel.getQuantidadePagamentoParcial());
        dt.setSacado(boletoModel.getPagador().getNome());
        dt.setCgcCpfSacado(boletoModel.getPagador().getDocumento());
        dt.setEndereco(boletoModel.getPagador().getEndereco().getEnderecoCompleto());
        String cep = BoletoUtil.manterApenasNumeros(boletoModel.getPagador().getEndereco().getCep());
        if (cep.length() == 8) {
            dt.setCep(Integer.parseInt(cep.substring(0, 5)));
            dt.setCepSuf(Integer.parseInt(cep.substring(5, 8)));
        } else {
            dt.setCep(0);
            dt.setCepSuf(0);
        }
        if (boletoModel.getBeneficiarioFinal() != null) {
            dt.setCgcCpfAvalista(boletoModel.getBeneficiarioFinal().getDocumento());
            dt.setSacadorAvalista(boletoModel.getBeneficiarioFinal().getNome());
        } else {
            dt.setCgcCpfAvalista("");
            dt.setSacadorAvalista("");
        }
        dt.setAceite("N");
        dt.setIdAvisoSacado("S");
        dt.setControleParticipante(agencia + "0000000" + conta);
        changeReq.setDadosTitulo(dt);
        changeReq.setCodUsuario("OPENAPI");
        BoletoBradescoAPIRequest boletoReq = ModelConverter.request(boletoModel);
        changeReq.setVnmnalTitloCobr(StringUtils.leftPad((String)boletoReq.getVnmnalTitloCobr(), (int)17, (String)"0"));
        return changeReq;
    }

    public static BoletoBradescoConsultaAPIRequest queryBoletoRequest(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        BoletoBradescoConsultaAPIRequest bl = new BoletoBradescoConsultaAPIRequest();
        CpfCnpj cpfCnpj = ModelConverter.divideCPFCNPJ(boletoModel.getBeneficiario().getDocumento());
        bl.setCpfCnpjUsuario(String.valueOf(cpfCnpj.getCpfCnpj()));
        bl.setFilialCnpjUsuario(String.valueOf(cpfCnpj.getFilial()));
        bl.setControleCpfCnpjUsuario(String.valueOf(cpfCnpj.getControle()));
        bl.setNossoNumero(boletoModel.getNossoNumero());
        bl.setSeqTitulo(boletoModel.getNumeroBoleto());
        bl.setStatus("0");
        bl.setNomePersonalizado("");
        bl.setIdProduto(boletoModel.getBeneficiario().getCarteira());
        bl.setContaProduto(String.format("%s", boletoModel.getBeneficiario().getAgencia().replace(' ', '0')) + String.format("%s", boletoModel.getBeneficiario().getConta().replace(' ', '0')));
        bl.setContaProduto(StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (char)'0') + StringUtils.leftPad((String)boletoModel.getBeneficiario().getConta(), (int)7, (char)'0'));
        return bl;
    }

    public static BoletoBradescoBaixaAPIRequest baixaBoletoRequest(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        BoletoBradescoBaixaAPIRequest request = new BoletoBradescoBaixaAPIRequest();
        CpfCnpj cpfCnpjInstance = new CpfCnpj();
        request.setNossoNumero(boletoModel.getNossoNumero());
        cpfCnpjInstance.setCpfCnpj(Integer.parseInt(boletoModel.getBeneficiario().getDocumento().substring(0, 8)));
        cpfCnpjInstance.setFilial(Integer.parseInt(boletoModel.getBeneficiario().getDocumento().substring(8, 12)));
        cpfCnpjInstance.setControle(Integer.parseInt(boletoModel.getBeneficiario().getDocumento().substring(boletoModel.getBeneficiario().getDocumento().length() - 2)));
        request.setCpfCnpj(cpfCnpjInstance);
        request.setNegociacao(StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (char)'0') + StringUtils.leftPad((String)boletoModel.getBeneficiario().getConta(), (int)7, (char)'0'));
        request.setProduto(Integer.parseInt(boletoModel.getBeneficiario().getCarteira()));
        request.setCodigoBaixa(57);
        request.setStatus(null);
        return request;
    }

    public static BoletoModel queryBoletoResponse(QueryBoletoBradescoAPIResponse source) {
        BoletoModel boleto = new BoletoModel();
        Pagador pagador = new Pagador();
        Endereco endereco = new Endereco();
        Beneficiario beneficiario = new Beneficiario();
        pagador.setEndereco(endereco);
        beneficiario.setEndereco(endereco);
        boleto.setBeneficiario(beneficiario);
        boleto.setPagador(pagador);
        beneficiario.setAgencia(source.getAgencCred());
        beneficiario.setConta(source.getCtaCred());
        beneficiario.setDigitoConta(source.getDigCred());
        beneficiario.setNomeBeneficiario(source.getNomeCedente());
        beneficiario.setDocumento(source.getCnpjCpfCedente());
        beneficiario.getEndereco().setComplemento(source.getComEndCed());
        beneficiario.getEndereco().setBairro(source.getBaiCedente());
        beneficiario.getEndereco().setCidade(source.getCidCedente());
        beneficiario.getEndereco().setUf(source.getUfCedente());
        beneficiario.getEndereco().setCep(source.getCepEndCed());
        pagador.setNome(source.getNomeSacado());
        pagador.setDocumento(source.getCnpjSacado());
        pagador.getEndereco().setComplemento(source.getEndSacado());
        pagador.getEndereco().setBairro(source.getBaiSacado());
        pagador.getEndereco().setCidade(source.getCidSacado());
        pagador.getEndereco().setUf(source.getUfSacado());
        pagador.getEndereco().setCep(source.getCepSacado());
        boleto.setNumeroDocumento(source.getSnumero());
        boleto.setDataVencimento(ModelConverter.desFormataDataBradesco(source.getDataVencto(), "dd.MM.yyyy"));
        boleto.setDataEmissao(ModelConverter.desFormataDataBradesco(source.getDataEmis(), "dd.MM.yyyy"));
        boleto.setDataProcessamento(ModelConverter.desFormataDataBradesco(source.getDataReg(), "ddMMyyyy"));
        boleto.setLinhaDigitavel(source.getLinhaDig());
        boleto.setCodigoBarras(BoletoUtil.formatarParaCodigoBarrasI25(source.getCodBarras()));
        boleto.setEspecieDocumento(source.getEspecDocto());
        boleto.setEspecieMoeda(source.getEspecMoeda());
        boleto.setSituacao(ModelConverter.getSituacao(source.getCodStatus()));
        if (source.getValMoeda() != null && source.getQtdeCas() != null) {
            boleto.setValorBoleto(new BigDecimal(source.getValMoeda()).movePointLeft(Integer.parseInt(source.getQtdeCas())));
        }
        if (source.getValAbat() != null && source.getQtdeCas() != null) {
            boleto.setValorDescontos(new BigDecimal(source.getValAbat()).movePointLeft(Integer.parseInt(source.getQtdeCas())));
        }
        if (source.getValorIof() != null && source.getQtdeCas() != null) {
            boleto.setValorIof(new BigDecimal(source.getValorIof()).movePointLeft(Integer.parseInt(source.getQtdeCas())));
        }
        if (source.getValMulta() != null && source.getQtdeCasMul() != null) {
            boleto.setValorMulta(new BigDecimal(source.getValMulta()).movePointLeft(Integer.parseInt(source.getQtdeCasMul())));
        }
        boleto.setDataMulta(ModelConverter.desFormataDataBradesco(source.getDataMulta(), "ddMMyyyy"));
        boleto.setDataLimiteParaDesconto(ModelConverter.desFormataDataBradesco(source.getDataLimitePgt(), "dd/MM/yyyy"));
        if ("1".equals(source.getCodValMul())) {
            boleto.setTipoMulta(TipoMultaEnum.PERCENTUAL);
        } else if ("2".equals(source.getCodValMul())) {
            boleto.setTipoMulta(TipoMultaEnum.VALOR);
        }
        boleto.setValorPercentualMulta(boleto.getValorMulta());
        boleto.setProtesto(source.getDiasProt() != null && Integer.parseInt(source.getDiasProt()) > 0);
        boleto.setDiasProtesto(source.getDiasProt() != null ? Integer.parseInt(source.getDiasProt()) : 0);
        boleto.setAceite("A".equalsIgnoreCase(source.getAceite()));
        boleto.setAutorizaPagamentoParcial("S".equalsIgnoreCase(source.getPermitePgtoParcial()));
        boleto.setQuantidadePagamentoParcial(source.getQtdePgtoParcial() != null ? Integer.parseInt(source.getQtdePgtoParcial()) : 0);
        boleto.setPixBase64(source.getBase64());
        boleto.setPixCopiaCola(source.getSemvQrcode());
        boleto.setInstrucoes(Collections.singletonList(new InformacaoModel("Status: " + source.getStatus())));
        try {
            boleto.setRetorno(RestUtil.ObjectToJson(source));
        }
        catch (Exception e) {
            log.error((Object)"Falha ao definir o retorno do boleto", (Throwable)e);
        }
        return boleto;
    }

    public static BoletoModel baixaBoletoResponse(@NonNull BoletoBaixaBoletoAPIResponse source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        BoletoModel boleto = new BoletoModel();
        Pagador pagador = new Pagador();
        Beneficiario beneficiario = new Beneficiario();
        Endereco enderecoPagador = new Endereco();
        Endereco enderecoBenef = new Endereco();
        pagador.setEndereco(enderecoPagador);
        beneficiario.setEndereco(enderecoBenef);
        boleto.setBeneficiario(beneficiario);
        boleto.setPagador(pagador);
        boleto.setMensagemRetorno(source.getMensagem());
        boleto.setCodRetorno(source.getTransacao());
        if (source.getTitulo() != null) {
            boleto.setCodigoBarras(source.getTitulo().getCodBarras());
            boleto.setValorBoleto(BigDecimal.valueOf(source.getTitulo().getValMoeda()));
            beneficiario.setNomeBeneficiario(source.getTitulo().getCedente().getNome());
            beneficiario.setDocumento(String.valueOf(source.getTitulo().getCedente().getCnpj()));
            ModelConverter.mapEnderecoQB(source, enderecoBenef);
            pagador.setNome(source.getTitulo().getSacado().getNome());
            pagador.setDocumento(String.valueOf(source.getTitulo().getSacado().getCnpj()));
            ModelConverter.mapEnderecoQB(source, enderecoPagador);
        }
        return boleto;
    }

    public static void changeBoletoResponse(BoletoModel boletoModel, ChangeBoletoBradescoAPIResponse changeBoletoBradescoAPIResponse) {
        boletoModel.setCodRetorno(changeBoletoBradescoAPIResponse.getCodigo());
        if (changeBoletoBradescoAPIResponse.getCausa() != null) {
            boletoModel.setMensagemRetorno(changeBoletoBradescoAPIResponse.getMensagem() + changeBoletoBradescoAPIResponse.getCausa());
        } else {
            boletoModel.setMensagemRetorno(changeBoletoBradescoAPIResponse.getMensagem());
        }
        boletoModel.setSituacao(SituacaoEnum.EM_ABERTO);
    }

    private static void mapEnderecoQB(BoletoBaixaBoletoAPIResponse source, Endereco enderecoBenef) {
        enderecoBenef.setLogradouro(source.getTitulo().getCedente().getEndereco());
        enderecoBenef.setNumero(source.getTitulo().getCedente().getNumero());
        enderecoBenef.setComplemento(source.getTitulo().getCedente().getComplemento());
        enderecoBenef.setBairro(source.getTitulo().getCedente().getBairro());
        enderecoBenef.setCidade(source.getTitulo().getCedente().getCidade());
        enderecoBenef.setCep(String.valueOf(source.getTitulo().getCedente().getCep()));
        enderecoBenef.setUf(String.valueOf(source.getTitulo().getCedente().getUf()));
    }

    private static int mapTipoJuros(TipoJurosEnum tipoJuros) {
        if (tipoJuros == null) {
            return 9;
        }
        switch (tipoJuros) {
            case VALOR_DIA: {
                return 1;
            }
            case PERCENTUAL_MENSAL: {
                return 2;
            }
        }
        return 9;
    }

    private static int mapTipoMulta(TipoMultaEnum tipoMulta) {
        if (tipoMulta == null) {
            return 0;
        }
        switch (tipoMulta) {
            case VALOR: {
                return 1;
            }
            case PERCENTUAL: {
                return 2;
            }
        }
        return 9;
    }

    private static int mapTipoDescontoToCod(TipoDescontoEnum tipoDesconto) {
        if (tipoDesconto == null) {
            return 0;
        }
        switch (tipoDesconto) {
            case VALOR_FIXO: {
                return 1;
            }
            case PERCENTUAL_FIXO: {
                return 2;
            }
            case VALOR_DIA: {
                return 3;
            }
            case PERCENTUAL_DIA: {
                return 5;
            }
        }
        return 0;
    }

    public static SituacaoEnum getSituacao(String codigo) {
        if (LIQUIDADO.contains(codigo)) {
            return SituacaoEnum.LIQUIDADO;
        }
        if (BAIXADO.contains(codigo)) {
            return SituacaoEnum.BAIXADO;
        }
        return SituacaoEnum.EM_ABERTO;
    }

    private static String formataValorBradesco(BigDecimal valor) {
        return BoletoUtil.bigDecimalSemCasas(valor);
    }

    private static String formataPercentualBradesco(BigDecimal valor) {
        return BoletoUtil.formatarCasasDecimais(valor, 5);
    }

    private static String formataDataBradesco(LocalDate data, String formato) {
        try {
            return data.format(DateTimeFormatter.ofPattern(formato));
        }
        catch (Exception e) {
            return "";
        }
    }

    private static LocalDate desFormataDataBradesco(String data, String formato) {
        try {
            return LocalDate.from(DateTimeFormatter.ofPattern(formato).parse(data));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String geraDigitoNossoNumero(int carteira, BigDecimal nossoNumero) {
        String carteiraNossoNumero = StringUtils.leftPad((String)String.valueOf(carteira), (int)2, (String)"0") + StringUtils.leftPad((String)String.valueOf(nossoNumero), (int)11, (String)"0");
        int s = 0;
        int p = 2;
        int cont = 13;
        for (int i = carteiraNossoNumero.length() - 1; i >= 0; --i) {
            s += Integer.parseInt(carteiraNossoNumero.substring(i, cont)) * p;
            p = p == 7 ? 2 : ++p;
            --cont;
        }
        int r = s % 11;
        switch (r) {
            case 0: {
                return "0";
            }
            case 1: {
                return "P";
            }
        }
        return String.valueOf(11 - r);
    }
}

