/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.bradesco_api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;

public class Token {
    private String access_token;
    private String token_type;
    private String expires_in;
    private String scope;
    private LocalDateTime generationTimestamp;

    @JsonIgnore
    public boolean isValido() {
        if (this.access_token == null || this.access_token.isEmpty()) {
            return false;
        }
        if (this.token_type == null || this.token_type.isEmpty()) {
            return false;
        }
        if (this.scope == null || this.scope.isEmpty()) {
            return false;
        }
        if (this.expires_in == null || this.expires_in.isEmpty()) {
            return false;
        }
        if (this.generationTimestamp == null) {
            return false;
        }
        try {
            long exp = Long.parseLong(this.expires_in);
            LocalDateTime expiryTime = this.generationTimestamp.plusSeconds(exp);
            return LocalDateTime.now().isBefore(expiryTime);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getAccess_token() {
        return this.access_token;
    }

    public String getToken_type() {
        return this.token_type;
    }

    public String getExpires_in() {
        return this.expires_in;
    }

    public String getScope() {
        return this.scope;
    }

    public LocalDateTime getGenerationTimestamp() {
        return this.generationTimestamp;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public void setToken_type(String token_type) {
        this.token_type = token_type;
    }

    public void setExpires_in(String expires_in) {
        this.expires_in = expires_in;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setGenerationTimestamp(LocalDateTime generationTimestamp) {
        this.generationTimestamp = generationTimestamp;
    }

    public Token(String access_token, String token_type, String expires_in, String scope, LocalDateTime generationTimestamp) {
        this.access_token = access_token;
        this.token_type = token_type;
        this.expires_in = expires_in;
        this.scope = scope;
        this.generationTimestamp = generationTimestamp;
    }

    public Token() {
    }
}

