/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.caixa_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.service.bancos.caixa_api.BancoCaixaApiConverterBaixa;
import br.com.java_brasil.boleto.service.bancos.caixa_api.BancoCaixaApiConverterConsulta;
import br.com.java_brasil.boleto.service.bancos.caixa_api.BancoCaixaApiConverterInclusao;
import br.com.java_brasil.boleto.service.bancos.caixa_api.ConfiguracaoCaixa;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.SoapEnvelope;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.SERVICOSAIDANEGOCIALTYPE;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JaxbXmlUtil;
import br.com.java_brasil.boleto.util.SoapUtil;
import java.io.IOException;
import java.util.List;
import javax.print.PrintService;
import javax.xml.bind.JAXBException;
import javax.xml.soap.SOAPException;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class BancoCaixaApi
extends BoletoController {
    @Override
    public JasperPrint imprimirBoleto(BoletoModel boletoModel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JasperPrint imprimirBoleto(List<BoletoModel> boletos) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] imprimirBoletoByte(BoletoModel boletoModel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] imprimirBoletoByte(List<BoletoModel> boletoModel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] imprimirBoletoBanco(BoletoModel boletoModel) {
        try {
            BoletoModel consultarBoleto = this.consultarBoleto(boletoModel);
            byte[] boletoBytes = BoletoUtil.downloadFile(consultarBoleto.getUrlPdf());
            return boletoBytes;
        }
        catch (IOException ex) {
            throw new BoletoException("Erro ao fazer download de boleto do banco", ex);
        }
    }

    @Override
    public void imprimirBoletoJasperDesktop(BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BoletoModel enviarBoleto(BoletoModel boletoModel) {
        try {
            String toSoapIncluiBoleto = new BancoCaixaApiConverterInclusao((ConfiguracaoCaixa)this.getConfiguracao()).toSoapIncluiBoleto(boletoModel);
            BasicHeader headerContentType = new BasicHeader("Content-Type", "text/xml");
            BasicHeader headerSoapAction = new BasicHeader("SOAPAction", "INCLUI_BOLETO");
            Header[] headers = new Header[]{headerContentType, headerSoapAction};
            String retornoXml = SoapUtil.postSoap(toSoapIncluiBoleto, ((ConfiguracaoCaixa)this.getConfiguracao()).getEndPointCrudBoleto(), headers);
            return BancoCaixaApiConverterInclusao.toResponseIncluiBoleto(boletoModel, retornoXml);
        }
        catch (JAXBException ex) {
            throw new BoletoException("Erro ao converter envio de boleto " + ex.getMessage(), ex);
        }
        catch (SOAPException ex) {
            throw new BoletoException("Erro ao consumir soap de inclus\u00e3o  boleto ", ex);
        }
    }

    @Override
    public BoletoModel alterarBoleto(BoletoModel boletoModel) {
        try {
            String toSoapIncluiBoleto = new BancoCaixaApiConverterInclusao((ConfiguracaoCaixa)this.getConfiguracao()).toSoapIncluiBoleto(boletoModel);
            BasicHeader headerContentType = new BasicHeader("Content-Type", "text/xml");
            BasicHeader headerSoapAction = new BasicHeader("SOAPAction", "INCLUI_BOLETO");
            Header[] headers = new Header[]{headerContentType, headerSoapAction};
            String retornoXml = SoapUtil.postSoap(toSoapIncluiBoleto, ((ConfiguracaoCaixa)this.getConfiguracao()).getEndPointCrudBoleto(), headers);
            return BancoCaixaApiConverterInclusao.toResponseIncluiBoleto(boletoModel, retornoXml);
        }
        catch (JAXBException ex) {
            throw new BoletoException("Erro ao converter envio de boleto " + ex.getMessage(), ex);
        }
        catch (SOAPException ex) {
            throw new BoletoException("Erro ao consumir soap de inclus\u00e3o  boleto ", ex);
        }
    }

    @Override
    public BoletoModel consultarBoleto(BoletoModel boletoModel) {
        String retorno = "";
        try {
            String xmlEnvioSoap = new BancoCaixaApiConverterConsulta((ConfiguracaoCaixa)this.getConfiguracao()).toConsultaBoletoXmlSoapEnv(boletoModel);
            ConfiguracaoCaixa cfg = (ConfiguracaoCaixa)this.getConfiguracao();
            String endPointConsultaBoleto = cfg.getEndPointConsultaBoleto();
            retorno = SoapUtil.postSoap(xmlEnvioSoap, endPointConsultaBoleto, null);
            SoapEnvelope soapEnv = (SoapEnvelope)JaxbXmlUtil.jaxbXMLToObject(retorno, SoapEnvelope.class);
            SERVICOSAIDANEGOCIALTYPE servicoSaidaNegocialType = soapEnv.getBody().getServicoSaidaNegocialType();
            return BancoCaixaApiConverterConsulta.montaResponseConsultaBoleto(boletoModel, servicoSaidaNegocialType);
        }
        catch (SOAPException ex) {
            throw new BoletoException("Erro ao consumir soap", ex, retorno);
        }
        catch (JAXBException ex) {
            throw new BoletoException("Erro ao criar objeto jaxb para soap.", ex, retorno);
        }
    }

    @Override
    public BoletoModel baixarBoleto(BoletoModel boletoModel) {
        try {
            String toSoapBaixaBoleto = new BancoCaixaApiConverterBaixa((ConfiguracaoCaixa)this.getConfiguracao()).toSoapBaixaBoleto(boletoModel);
            BasicHeader headerContentType = new BasicHeader("Content-Type", "text/xml");
            BasicHeader headerSoapAction = new BasicHeader("SOAPAction", "BAIXA_BOLETO");
            Header[] headers = new Header[]{headerContentType, headerSoapAction};
            String retornoXml = SoapUtil.postSoap(toSoapBaixaBoleto, ((ConfiguracaoCaixa)this.getConfiguracao()).getEndPointCrudBoleto(), headers);
            return BancoCaixaApiConverterBaixa.toResponseIncluiBoleto(boletoModel, retornoXml);
        }
        catch (JAXBException ex) {
            throw new BoletoException("Erro ao converter envio de boleto " + ex.getMessage(), ex);
        }
        catch (SOAPException ex) {
            throw new BoletoException("Erro ao consumir soap de inclus\u00e3o  boleto ", ex);
        }
    }

    @Override
    public String gerarArquivoRemessa(List<RemessaRetornoModel> remessaRetornoModel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(String arquivo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

