/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.caixa_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Endereco;
import br.com.java_brasil.boleto.model.InformacaoModel;
import br.com.java_brasil.boleto.model.enums.TipoJurosEnum;
import br.com.java_brasil.boleto.service.bancos.caixa_api.BancoCaixaApiConverterPai;
import br.com.java_brasil.boleto.service.bancos.caixa_api.ConfiguracaoCaixa;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.Fault;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.SoapBody;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.SoapEnvelope;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.AlteraBoletoDescontoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.AlteraBoletoDescontosType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.AlteraBoletoEnderecoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.AlteraBoletoEntradaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.AlteraBoletoFichaCompensacaoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.AlteraBoletoJurosMoraType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.AlteraBoletoMensagensFichaCompensacaoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.AlteraBoletoPagadorType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.AlteraBoletoPosVencimentoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.AlteraBoletoTituloEntradaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.DadosEntradaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.IncluiBoletoSaidaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.ServicoEntradaNegocialType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.TIPOTYPE;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.sibar.CONTROLENEGOCIALTYPE;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.sibar.HEADERBARRAMENTOTYPE;
import br.com.java_brasil.boleto.util.JaxbXmlUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class BancoCaixaApiConverterAlteracao
extends BancoCaixaApiConverterPai {
    public BancoCaixaApiConverterAlteracao(ConfiguracaoCaixa cfg) {
        super(cfg);
    }

    public String toSoapIncluiBoleto(BoletoModel bolModel) throws JAXBException {
        ServicoEntradaNegocialType servicoEntrada = new ServicoEntradaNegocialType();
        servicoEntrada.setHEADER(this.toIncluiBoleto(bolModel));
        DadosEntradaType dados = new DadosEntradaType();
        servicoEntrada.setDADOS(dados);
        SoapBody soapBody = new SoapBody();
        soapBody.setServicoEntradaNegocialCrud(servicoEntrada);
        SoapEnvelope soapEnvelope = new SoapEnvelope();
        soapEnvelope.setHeader(null);
        soapEnvelope.setBody(soapBody);
        String xmlSoapInclusaoBoleto = JaxbXmlUtil.jaxbObjectToXMLDefault(soapEnvelope);
        return xmlSoapInclusaoBoleto;
    }

    private HEADERBARRAMENTOTYPE toIncluiBoleto(BoletoModel bolModel) {
        HEADERBARRAMENTOTYPE header = this.toHeaderAuthCrud(bolModel);
        return header;
    }

    private AlteraBoletoEntradaType incluiBoleto(BoletoModel bolModel) {
        BoletoModel boletoModel = bolModel;
        AlteraBoletoEntradaType alteraBoleto = new AlteraBoletoEntradaType();
        String codbeneficiario = boletoModel.getBeneficiario().getCodigoBeneficiario();
        alteraBoleto.setCODIGOBENEFICIARIO(codbeneficiario);
        alteraBoleto.setTITULO(this.titulo(bolModel));
        return alteraBoleto;
    }

    private AlteraBoletoTituloEntradaType titulo(BoletoModel bolModel) {
        AlteraBoletoTituloEntradaType titulo = new AlteraBoletoTituloEntradaType();
        titulo.setNOSSONUMERO(bolModel.getNossoNumero());
        titulo.setNUMERODOCUMENTO(bolModel.getNumeroDocumento());
        switch (this.cfg.getVersaoBoletoCrud()) {
            case "3.0": {
                titulo.setTIPO(null);
                break;
            }
            case "3.2": {
                titulo.setTIPO(TIPOTYPE.HIBRIDO);
                break;
            }
            case "4.0": {
                titulo.setTIPO(TIPOTYPE.QRCODE);
            }
        }
        titulo.setNUMERODOCUMENTO(bolModel.getNumeroDocumento());
        titulo.setDATAVENCIMENTO(BancoCaixaApiConverterAlteracao.toDataCaixa(bolModel.getDataVencimento().atStartOfDay(), null));
        titulo.setVALOR(bolModel.getValorBoleto());
        titulo.setTIPOESPECIE((short)99);
        titulo.setFLAGACEITE(bolModel.isAceite() ? "S" : "N");
        AlteraBoletoJurosMoraType jurosMoraType = new AlteraBoletoJurosMoraType();
        jurosMoraType.setTIPO(BancoCaixaApiConverterAlteracao.toTpJuros(bolModel.getTipoJuros()));
        jurosMoraType.setVALOR(bolModel.getValorPercentualJuros());
        titulo.setJUROSMORA(jurosMoraType);
        AlteraBoletoDescontosType descontosType = new AlteraBoletoDescontosType();
        AlteraBoletoDescontoType desconto = new AlteraBoletoDescontoType();
        desconto.setVALOR(BigDecimal.ZERO.setScale(2));
        ArrayList<AlteraBoletoDescontoType> listDesc = new ArrayList<AlteraBoletoDescontoType>();
        listDesc.add(desconto);
        descontosType.getDESCONTO().addAll(listDesc);
        AlteraBoletoPosVencimentoType posVencimentoType = new AlteraBoletoPosVencimentoType();
        posVencimentoType.setACAO("DEVOLVER");
        posVencimentoType.setNUMERODIAS((short)999);
        titulo.setPOSVENCIMENTO(posVencimentoType);
        titulo.setFICHACOMPENSACAO(BancoCaixaApiConverterAlteracao.toFichaCompensacao(bolModel));
        titulo.setPAGADOR(BancoCaixaApiConverterAlteracao.pagador(bolModel));
        return titulo;
    }

    private static AlteraBoletoPagadorType pagador(BoletoModel bolModel) {
        AlteraBoletoPagadorType pagador = new AlteraBoletoPagadorType();
        pagador.setNOME(bolModel.getPagador().getNome().toUpperCase());
        Endereco endereco = bolModel.getPagador().getEndereco();
        pagador.setENDERECO(BancoCaixaApiConverterAlteracao.toEnderecoType(endereco));
        return pagador;
    }

    private static AlteraBoletoEnderecoType toEnderecoType(Endereco endereco) {
        AlteraBoletoEnderecoType enderecoType = new AlteraBoletoEnderecoType();
        enderecoType.setLOGRADOURO(endereco.getLogradouro().toUpperCase());
        enderecoType.setBAIRRO(endereco.getBairro().toUpperCase());
        enderecoType.setCIDADE(endereco.getCidade().toUpperCase());
        enderecoType.setUF(endereco.getUf());
        enderecoType.setCEP(endereco.getCep());
        return enderecoType;
    }

    private static String toTpJuros(TipoJurosEnum tpJuros) {
        switch (tpJuros) {
            case PERCENTUAL_MENSAL: {
                return "TAXA_MENSAL";
            }
            case ISENTO: {
                return "ISENTO";
            }
            case VALOR_DIA: {
                return "VALOR_POR_DIA";
            }
        }
        return "";
    }

    private static XMLGregorianCalendar toDataCaixa(LocalDateTime localDateTime, String pattern) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(Optional.ofNullable(pattern).orElse("yyyy-MM-dd"));
            String formattedDate = localDateTime.format(formatter);
            XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(formattedDate);
            return xmlGregorianCalendar;
        }
        catch (DatatypeConfigurationException ex) {
            Logger.getLogger(BancoCaixaApiConverterAlteracao.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static BoletoModel toResponseIncluiBoleto(BoletoModel bolModel, String xmlRetorno) {
        try {
            SoapEnvelope soapEnv = (SoapEnvelope)JaxbXmlUtil.jaxbXMLToObject(xmlRetorno, SoapEnvelope.class);
            if (soapEnv.getBody().getFaultBody() == null) {
                IncluiBoletoSaidaType incluiboleto = soapEnv.getBody().getServicoSaidaNegocialCrud().getDADOS().getINCLUIBOLETO();
                List<CONTROLENEGOCIALTYPE> controlenegocial = soapEnv.getBody().getServicoSaidaNegocialCrud().getDADOS().getCONTROLENEGOCIAL();
                controlenegocial.get(0).getCODRETORNO();
                bolModel.setCodRetorno(BancoCaixaApiConverterAlteracao.obterCodRetorno(controlenegocial));
                bolModel.setMensagemRetorno(BancoCaixaApiConverterAlteracao.obterMsgRetorno(controlenegocial));
                if (incluiboleto != null) {
                    bolModel.setCodigoBarras(incluiboleto.getCODIGOBARRAS());
                    bolModel.setUrlPdf(incluiboleto.getURL());
                    String urlqrcode = incluiboleto.getURLQRCODE();
                    bolModel.setLinhaDigitavel(incluiboleto.getLINHADIGITAVEL());
                    bolModel.setPixUrlQrCode(urlqrcode);
                    incluiboleto.getQRCODE();
                    Long nossonumero = incluiboleto.getNOSSONUMERO();
                    if (nossonumero > 0L) {
                        bolModel.setNossoNumero(nossonumero + "");
                    }
                } else {
                    throw new BoletoException(xmlRetorno, "Inclus\u00e3o n\u00e3o retornou boleto . C\u00f3digo retorno:" + bolModel.getCodRetorno() + " MSG: " + bolModel.getMensagemRetorno());
                }
                return bolModel;
            }
            StringBuilder msg = new StringBuilder("Erro ao consumir web service.");
            Fault faultBody = soapEnv.getBody().getFaultBody();
            msg.append(faultBody.getFaultcode()).append(" ").append(faultBody.getFaultstring());
            throw new BoletoException(xmlRetorno, msg.toString());
        }
        catch (JAXBException ex) {
            throw new BoletoException("Erro ao converter resposta de boleto ", ex, xmlRetorno);
        }
    }

    private static AlteraBoletoFichaCompensacaoType toFichaCompensacao(BoletoModel bolModel) {
        List<InformacaoModel> instrucoes = bolModel.getInstrucoes();
        if (instrucoes != null && !instrucoes.isEmpty()) {
            AlteraBoletoFichaCompensacaoType ficha = new AlteraBoletoFichaCompensacaoType();
            AlteraBoletoMensagensFichaCompensacaoType mensagens = new AlteraBoletoMensagensFichaCompensacaoType();
            List listMsgInstrucao = instrucoes.stream().map(instrucao -> instrucao.getInformacao()).collect(Collectors.toList());
            mensagens.getMENSAGEM().addAll(listMsgInstrucao);
            ficha.setMENSAGENS(mensagens);
            return ficha;
        }
        return null;
    }
}

