/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.caixa_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.service.bancos.caixa_api.BancoCaixaApiConverterPai;
import br.com.java_brasil.boleto.service.bancos.caixa_api.ConfiguracaoCaixa;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.Fault;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.SoapBody;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.SoapEnvelope;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.BaixaBoletoEntradaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.DadosEntradaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.IncluiBoletoSaidaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.ServicoEntradaNegocialType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.sibar.CONTROLENEGOCIALTYPE;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.sibar.HEADERBARRAMENTOTYPE;
import br.com.java_brasil.boleto.util.JaxbXmlUtil;
import java.util.List;
import javax.xml.bind.JAXBException;

public class BancoCaixaApiConverterBaixa
extends BancoCaixaApiConverterPai {
    public BancoCaixaApiConverterBaixa(ConfiguracaoCaixa cfg) {
        super(cfg);
    }

    public String toSoapBaixaBoleto(BoletoModel bolModel) throws JAXBException {
        ServicoEntradaNegocialType servicoEntrada = new ServicoEntradaNegocialType();
        servicoEntrada.setHEADER(this.toIncluiBoletoHeader(bolModel));
        DadosEntradaType dados = new DadosEntradaType();
        dados.setBAIXABOLETO(BancoCaixaApiConverterBaixa.toBaixaBoletoType(bolModel));
        servicoEntrada.setDADOS(dados);
        SoapBody soapBody = new SoapBody();
        soapBody.setServicoEntradaNegocialCrud(servicoEntrada);
        SoapEnvelope soapEnvelope = new SoapEnvelope();
        soapEnvelope.setHeader(null);
        soapEnvelope.setBody(soapBody);
        String xmlSoapInclusaoBoleto = JaxbXmlUtil.jaxbObjectToXMLDefault(soapEnvelope);
        return xmlSoapInclusaoBoleto;
    }

    private HEADERBARRAMENTOTYPE toIncluiBoletoHeader(BoletoModel bolModel) {
        HEADERBARRAMENTOTYPE header = this.toHeaderAuthCrud(bolModel);
        return header;
    }

    private static BaixaBoletoEntradaType toBaixaBoletoType(BoletoModel bolModel) {
        BaixaBoletoEntradaType baixaBoleto = new BaixaBoletoEntradaType();
        baixaBoleto.setCODIGOBENEFICIARIO(bolModel.getBeneficiario().getCodigoBeneficiario());
        baixaBoleto.setNOSSONUMERO(bolModel.getNossoNumero());
        return baixaBoleto;
    }

    public static BoletoModel toResponseIncluiBoleto(BoletoModel bolModel, String xmlRetorno) {
        try {
            SoapEnvelope soapEnv = (SoapEnvelope)JaxbXmlUtil.jaxbXMLToObject(xmlRetorno, SoapEnvelope.class);
            if (soapEnv.getBody().getFaultBody() == null) {
                IncluiBoletoSaidaType incluiboleto = soapEnv.getBody().getServicoSaidaNegocialCrud().getDADOS().getINCLUIBOLETO();
                List<CONTROLENEGOCIALTYPE> controlenegocial = soapEnv.getBody().getServicoSaidaNegocialCrud().getDADOS().getCONTROLENEGOCIAL();
                controlenegocial.get(0).getCODRETORNO();
                bolModel.setCodRetorno(BancoCaixaApiConverterBaixa.obterCodRetorno(controlenegocial));
                bolModel.setMensagemRetorno(BancoCaixaApiConverterBaixa.obterMsgRetorno(controlenegocial));
                if (incluiboleto != null) {
                    bolModel.setCodigoBarras(incluiboleto.getCODIGOBARRAS());
                    bolModel.setUrlPdf(incluiboleto.getURL());
                    String urlqrcode = incluiboleto.getURLQRCODE();
                    bolModel.setLinhaDigitavel(incluiboleto.getLINHADIGITAVEL());
                    bolModel.setPixUrlQrCode(urlqrcode);
                    incluiboleto.getQRCODE();
                    Long nossonumero = incluiboleto.getNOSSONUMERO();
                    if (nossonumero > 0L) {
                        bolModel.setNossoNumero(nossonumero + "");
                    }
                } else {
                    throw new BoletoException(xmlRetorno, "Inclus\u00e3o n\u00e3o retornou boleto . C\u00f3digo retorno:" + bolModel.getCodRetorno() + " MSG: " + bolModel.getMensagemRetorno());
                }
                return bolModel;
            }
            StringBuilder msg = new StringBuilder("Erro ao consumir web service.");
            Fault faultBody = soapEnv.getBody().getFaultBody();
            msg.append(faultBody.getFaultcode()).append(" ").append(faultBody.getFaultstring());
            throw new BoletoException(xmlRetorno, msg.toString());
        }
        catch (JAXBException ex) {
            throw new BoletoException("Erro ao converter resposta de boleto ", ex, xmlRetorno);
        }
    }
}

