/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.caixa_api;

import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.converters.BancoConverterGenerico;
import br.com.java_brasil.boleto.model.enums.SituacaoEnum;
import br.com.java_brasil.boleto.service.bancos.caixa_api.BancoCaixaApiConverterPai;
import br.com.java_brasil.boleto.service.bancos.caixa_api.ConfiguracaoCaixa;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.SoapBody;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.SoapEnvelope;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoDescontosType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoEntradaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoFichaCompensacaoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoJurosMoraType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoMultaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoSaidaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoTituloType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.DADOSENTRADATYPE;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.SERVICOENTRADANEGOCIALTYPE;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.SERVICOSAIDANEGOCIALTYPE;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.sibar.CONTROLENEGOCIALTYPE;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JaxbXmlUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.XMLGregorianCalendar;

public class BancoCaixaApiConverterConsulta
extends BancoCaixaApiConverterPai {
    public BancoCaixaApiConverterConsulta(ConfiguracaoCaixa cfg) {
        super(cfg);
    }

    private SoapEnvelope toConsultaBoleto(BoletoModel bolModel) {
        SERVICOENTRADANEGOCIALTYPE servEntrada = new SERVICOENTRADANEGOCIALTYPE();
        servEntrada.setHEADER(this.toHeaderAuthConsultaBoleto(bolModel));
        DADOSENTRADATYPE dados = new DADOSENTRADATYPE();
        dados.setCONSULTABOLETO(BancoCaixaApiConverterConsulta.toConsultaBoletoType(bolModel));
        servEntrada.setDADOS(dados);
        SoapBody soapBody = new SoapBody();
        soapBody.setServicoEntradaNegocialType(servEntrada);
        SoapEnvelope soapEnvelope = new SoapEnvelope();
        soapEnvelope.setHeader(null);
        soapEnvelope.setBody(soapBody);
        return soapEnvelope;
    }

    public String toConsultaBoletoXmlSoapEnv(BoletoModel bolModel) {
        try {
            SoapEnvelope toConsultaBoleto = this.toConsultaBoleto(bolModel);
            String jaxbObjectToXML = JaxbXmlUtil.jaxbObjectToXMLDefault(toConsultaBoleto);
            return jaxbObjectToXML;
        }
        catch (JAXBException ex) {
            Logger.getLogger(BancoCaixaApiConverterConsulta.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static ConsultaBoletoEntradaType toConsultaBoletoType(BoletoModel bolModel) {
        ConsultaBoletoEntradaType consultaBolType = new ConsultaBoletoEntradaType();
        consultaBolType.setCODIGOBENEFICIARIO(bolModel.getBeneficiario().getCodigoBeneficiario());
        consultaBolType.setNOSSONUMERO(bolModel.getNossoNumero());
        return consultaBolType;
    }

    public static BoletoModel montaResponseConsultaBoleto(BoletoModel bolModel, SERVICOSAIDANEGOCIALTYPE servSaida) {
        List<CONTROLENEGOCIALTYPE> listControleNegocial = servSaida.getDADOS().getCONTROLENEGOCIAL();
        ConsultaBoletoSaidaType consultaBoleto = servSaida.getDADOS().getCONSULTABOLETO();
        ConsultaBoletoTituloType titulo = consultaBoleto.getTITULO();
        String codigobarras = titulo.getCODIGOBARRAS();
        short codigomoeda = titulo.getCODIGOMOEDA();
        XMLGregorianCalendar dataemissao = titulo.getDATAEMISSAO();
        XMLGregorianCalendar datavencimento = titulo.getDATAVENCIMENTO();
        ConsultaBoletoDescontosType descontos = titulo.getDESCONTOS();
        ConsultaBoletoFichaCompensacaoType fichacompensacao = titulo.getFICHACOMPENSACAO();
        String flagaceite = titulo.getFLAGACEITE();
        ConsultaBoletoJurosMoraType jurosmora = titulo.getJUROSMORA();
        ConsultaBoletoMultaType multa = titulo.getMULTA();
        String numerodocumento = titulo.getNUMERODOCUMENTO();
        short tipoespecie = titulo.getTIPOESPECIE();
        String url = titulo.getURL();
        String urlqrcode = titulo.getURLQRCODE();
        BigDecimal valor = titulo.getVALOR();
        BigDecimal valorpago = titulo.getVALORPAGO();
        bolModel.setCodigoModalidade(Integer.valueOf(tipoespecie));
        bolModel.setCodigoBarras(codigobarras);
        bolModel.setSituacao(BancoCaixaApiConverterConsulta.extrairSituacaoTexto(listControleNegocial));
        bolModel.setCodRetorno(BancoCaixaApiConverterConsulta.obterCodRetorno(listControleNegocial));
        bolModel.setMensagemRetorno(BancoCaixaApiConverterConsulta.obterCodRetorno(listControleNegocial));
        bolModel.setUrlPdf(url);
        bolModel.setLinhaDigitavel(titulo.getLINHADIGITAVEL());
        bolModel.setCodigoBarras(titulo.getCODIGOBARRAS());
        bolModel.setAceite("S".equalsIgnoreCase(flagaceite));
        bolModel.setPixUrlQrCode(urlqrcode);
        bolModel.setValorBoleto(valor);
        bolModel.setDataEmissao(BoletoUtil.converteXMLGregorianCalendarData(dataemissao));
        bolModel.setDataVencimento(BoletoUtil.converteXMLGregorianCalendarData(datavencimento));
        bolModel.setPagador(BancoCaixaApiConverterConsulta.toPagador(titulo.getPAGADOR()));
        if (bolModel.getBeneficiario() != null) {
            bolModel.getBeneficiario().setVariacaoCarteira(titulo.getCARTEIRA());
        }
        bolModel.setNumeroDocumento(numerodocumento);
        bolModel.setValorCobrado(valorpago);
        bolModel.setCodigoEspecieMoeda(codigomoeda);
        if (jurosmora != null) {
            BancoCaixaApiConverterConsulta.toJuros(bolModel, jurosmora);
        }
        if (multa != null) {
            BancoCaixaApiConverterConsulta.toMulta(bolModel, multa);
        }
        bolModel.setRetorno(servSaida);
        return bolModel;
    }

    private static SituacaoEnum extrairSituacaoTexto(List<CONTROLENEGOCIALTYPE> listControleNegocial) {
        for (CONTROLENEGOCIALTYPE controle : listControleNegocial) {
            if (!controle.getCODRETORNO().equals("0")) continue;
            return BancoConverterGenerico.toSituacao(BancoCaixaApiConverterConsulta.extrairSituacaoTexto(controle.getMENSAGENS().getRETORNO()));
        }
        return SituacaoEnum.EM_ABERTO;
    }

    private static String extrairSituacaoTexto(String textoComSituacao) {
        Pattern pattern = Pattern.compile("=\\s*(.*)");
        Matcher matcher = pattern.matcher(textoComSituacao);
        if (matcher.find()) {
            String resultado = matcher.group(1).trim();
            return resultado;
        }
        System.out.println("Nenhuma correspond\u00eancia encontrada.");
        return "";
    }
}

