/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.caixa_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Endereco;
import br.com.java_brasil.boleto.model.InformacaoModel;
import br.com.java_brasil.boleto.model.enums.TipoJurosEnum;
import br.com.java_brasil.boleto.service.bancos.caixa_api.BancoCaixaApiConverterPai;
import br.com.java_brasil.boleto.service.bancos.caixa_api.ConfiguracaoCaixa;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.Fault;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.SoapBody;
import br.com.java_brasil.boleto.service.bancos.caixa_api.model.SoapEnvelope;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.DadosEntradaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.DescontoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.DescontosType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.EnderecoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.FichaCompensacaoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.IncluiBoletoEntradaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.IncluiBoletoSaidaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.JurosMoraType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.MensagensFichaCompensacaoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.PagadorType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.PosVencimentoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.ServicoEntradaNegocialType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.TIPOTYPE;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.externo.TituloEntradaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.sibar.CONTROLENEGOCIALTYPE;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.sibar.HEADERBARRAMENTOTYPE;
import br.com.java_brasil.boleto.util.JaxbXmlUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class BancoCaixaApiConverterInclusao
extends BancoCaixaApiConverterPai {
    public BancoCaixaApiConverterInclusao(ConfiguracaoCaixa cfg) {
        super(cfg);
    }

    public String toSoapIncluiBoleto(BoletoModel bolModel) throws JAXBException {
        ServicoEntradaNegocialType servicoEntrada = new ServicoEntradaNegocialType();
        servicoEntrada.setHEADER(this.toIncluiBoleto(bolModel));
        DadosEntradaType dados = new DadosEntradaType();
        dados.setINCLUIBOLETO(this.incluiBoleto(bolModel));
        servicoEntrada.setDADOS(dados);
        SoapBody soapBody = new SoapBody();
        soapBody.setServicoEntradaNegocialCrud(servicoEntrada);
        SoapEnvelope soapEnvelope = new SoapEnvelope();
        soapEnvelope.setHeader(null);
        soapEnvelope.setBody(soapBody);
        String xmlSoapInclusaoBoleto = JaxbXmlUtil.jaxbObjectToXMLDefault(soapEnvelope);
        return xmlSoapInclusaoBoleto;
    }

    private HEADERBARRAMENTOTYPE toIncluiBoleto(BoletoModel bolModel) {
        HEADERBARRAMENTOTYPE header = this.toHeaderAuthCrud(bolModel);
        return header;
    }

    private IncluiBoletoEntradaType incluiBoleto(BoletoModel bolModel) {
        BoletoModel boletoModel = bolModel;
        IncluiBoletoEntradaType incluiBoleto = new IncluiBoletoEntradaType();
        String codbeneficiario = boletoModel.getBeneficiario().getCodigoBeneficiario();
        incluiBoleto.setCODIGOBENEFICIARIO(codbeneficiario);
        incluiBoleto.setTITULO(this.titulo(bolModel));
        return incluiBoleto;
    }

    private TituloEntradaType titulo(BoletoModel bolModel) {
        TituloEntradaType titulo = new TituloEntradaType();
        titulo.setNOSSONUMERO(bolModel.getNossoNumero());
        titulo.setNUMERODOCUMENTO(bolModel.getNumeroDocumento());
        switch (this.cfg.getVersaoBoletoCrud()) {
            case "3.0": {
                titulo.setTIPO(null);
                break;
            }
            case "3.2": {
                titulo.setTIPO(TIPOTYPE.HIBRIDO);
                break;
            }
            case "4.0": {
                titulo.setTIPO(TIPOTYPE.QRCODE);
            }
        }
        titulo.setNUMERODOCUMENTO(bolModel.getNumeroDocumento());
        titulo.setDATAVENCIMENTO(BancoCaixaApiConverterInclusao.toDataCaixa(bolModel.getDataVencimento().atStartOfDay(), null));
        titulo.setVALOR(bolModel.getValorBoleto());
        titulo.setTIPOESPECIE((short)99);
        titulo.setFLAGACEITE(bolModel.isAceite() ? "S" : "N");
        titulo.setDATAEMISSAO(BancoCaixaApiConverterInclusao.toDataCaixa(bolModel.getDataEmissao().atStartOfDay(), null));
        JurosMoraType jurosMoraType = new JurosMoraType();
        jurosMoraType.setTIPO(BancoCaixaApiConverterInclusao.toTpJuros(bolModel.getTipoJuros()));
        jurosMoraType.setVALOR(bolModel.getValorPercentualJuros());
        titulo.setJUROSMORA(jurosMoraType);
        titulo.setCodigomoeda("9");
        DescontosType descontosType = new DescontosType();
        DescontoType desconto = new DescontoType();
        desconto.setTIPO("ISENTO");
        desconto.setVALOR(BigDecimal.ZERO.setScale(2));
        ArrayList<DescontoType> listDesc = new ArrayList<DescontoType>();
        listDesc.add(desconto);
        descontosType.setDesconto(listDesc);
        titulo.setDESCONTOS(descontosType);
        titulo.setFICHACOMPENSACAO(BancoCaixaApiConverterInclusao.toFichaCompensacao(bolModel));
        PosVencimentoType posVencimentoType = new PosVencimentoType();
        posVencimentoType.setACAO("DEVOLVER");
        posVencimentoType.setNUMERODIAS(999);
        titulo.setPOSVENCIMENTO(posVencimentoType);
        titulo.setPAGADOR(BancoCaixaApiConverterInclusao.pagador(bolModel));
        return titulo;
    }

    private static PagadorType pagador(BoletoModel bolModel) {
        PagadorType pagador = new PagadorType();
        pagador.setCPF(bolModel.getPagador().getDocumento());
        pagador.setNOME(bolModel.getPagador().getNome().toUpperCase());
        Endereco endereco = bolModel.getPagador().getEndereco();
        pagador.setENDERECO(BancoCaixaApiConverterInclusao.toEnderecoType(endereco));
        return pagador;
    }

    private static EnderecoType toEnderecoType(Endereco endereco) {
        EnderecoType enderecoType = new EnderecoType();
        enderecoType.setLOGRADOURO(endereco.getLogradouro().toUpperCase());
        enderecoType.setBAIRRO(endereco.getBairro().toUpperCase());
        enderecoType.setCIDADE(endereco.getCidade().toUpperCase());
        enderecoType.setUF(endereco.getUf());
        enderecoType.setCEP(endereco.getCep());
        return enderecoType;
    }

    private static String toTpJuros(TipoJurosEnum tpJuros) {
        switch (tpJuros) {
            case PERCENTUAL_MENSAL: {
                return "TAXA_MENSAL";
            }
            case ISENTO: {
                return "ISENTO";
            }
            case VALOR_DIA: {
                return "VALOR_POR_DIA";
            }
        }
        return "";
    }

    private static XMLGregorianCalendar toDataCaixa(LocalDateTime localDateTime, String pattern) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(Optional.ofNullable(pattern).orElse("yyyy-MM-dd"));
            String formattedDate = localDateTime.format(formatter);
            XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(formattedDate);
            return xmlGregorianCalendar;
        }
        catch (DatatypeConfigurationException ex) {
            Logger.getLogger(BancoCaixaApiConverterInclusao.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static BoletoModel toResponseIncluiBoleto(BoletoModel bolModel, String xmlRetorno) {
        try {
            SoapEnvelope soapEnv = (SoapEnvelope)JaxbXmlUtil.jaxbXMLToObject(xmlRetorno, SoapEnvelope.class);
            if (soapEnv.getBody().getFaultBody() == null) {
                IncluiBoletoSaidaType incluiboleto = soapEnv.getBody().getServicoSaidaNegocialCrud().getDADOS().getINCLUIBOLETO();
                List<CONTROLENEGOCIALTYPE> controlenegocial = soapEnv.getBody().getServicoSaidaNegocialCrud().getDADOS().getCONTROLENEGOCIAL();
                controlenegocial.get(0).getCODRETORNO();
                bolModel.setCodRetorno(BancoCaixaApiConverterInclusao.obterCodRetorno(controlenegocial));
                bolModel.setMensagemRetorno(BancoCaixaApiConverterInclusao.obterMsgRetorno(controlenegocial));
                if (incluiboleto != null) {
                    bolModel.setCodigoBarras(incluiboleto.getCODIGOBARRAS());
                    bolModel.setUrlPdf(incluiboleto.getURL());
                    String urlqrcode = incluiboleto.getURLQRCODE();
                    bolModel.setLinhaDigitavel(incluiboleto.getLINHADIGITAVEL());
                    bolModel.setPixUrlQrCode(urlqrcode);
                    incluiboleto.getQRCODE();
                    Long nossonumero = incluiboleto.getNOSSONUMERO();
                    if (nossonumero > 0L) {
                        bolModel.setNossoNumero(nossonumero + "");
                    }
                } else {
                    throw new BoletoException(xmlRetorno, "Inclus\u00e3o n\u00e3o retornou boleto . C\u00f3digo retorno:" + bolModel.getCodRetorno() + " MSG: " + bolModel.getMensagemRetorno());
                }
                return bolModel;
            }
            StringBuilder msg = new StringBuilder("Erro ao consumir web service.");
            Fault faultBody = soapEnv.getBody().getFaultBody();
            msg.append(faultBody.getFaultcode()).append(" ").append(faultBody.getFaultstring());
            throw new BoletoException(xmlRetorno, msg.toString());
        }
        catch (JAXBException ex) {
            throw new BoletoException("Erro ao converter resposta de boleto ", ex, xmlRetorno);
        }
    }

    private static FichaCompensacaoType toFichaCompensacao(BoletoModel bolModel) {
        List<InformacaoModel> instrucoes = bolModel.getInstrucoes();
        if (instrucoes != null && !instrucoes.isEmpty()) {
            FichaCompensacaoType ficha = new FichaCompensacaoType();
            MensagensFichaCompensacaoType mensagens = new MensagensFichaCompensacaoType();
            List listMsgInstrucao = instrucoes.stream().map(instrucao -> instrucao.getInformacao()).collect(Collectors.toList());
            mensagens.getMENSAGEM().addAll(listMsgInstrucao);
            ficha.setMENSAGENS(mensagens);
            return ficha;
        }
        return null;
    }
}

