/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.caixa_api;

import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Endereco;
import br.com.java_brasil.boleto.model.Pagador;
import br.com.java_brasil.boleto.model.converters.BancoConverterGenerico;
import br.com.java_brasil.boleto.service.bancos.caixa_api.BancoCaixaApiUtil;
import br.com.java_brasil.boleto.service.bancos.caixa_api.ConfiguracaoCaixa;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoEnderecoType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoJurosMoraType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoMultaType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.boleto.ConsultaBoletoPagadorType;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.sibar.CONTROLENEGOCIALTYPE;
import br.com.java_brasil.boleto.service.bancos.caixa_api.xsd.sibar.HEADERBARRAMENTOTYPE;
import br.com.java_brasil.boleto.util.BoletoUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class BancoCaixaApiConverterPai {
    @NonNull
    public ConfiguracaoCaixa cfg;

    public BancoCaixaApiConverterPai(ConfiguracaoCaixa cfg) {
        this.cfg = cfg;
    }

    protected String autenticacaoCrud(BoletoModel bolModel, String operacao) {
        String dtVenc = "0";
        String vrStr = "0";
        switch (operacao) {
            case "INCLUI_BOLETO": 
            case "ALTERA_BOLETO": {
                dtVenc = BoletoUtil.getDataFormato(bolModel.getDataVencimento(), "ddMMyyyy");
                vrStr = BoletoUtil.formatarValorSemPonto(bolModel.getValorBoleto(), 2, 15);
                break;
            }
        }
        String documento = bolModel.getBeneficiario().getDocumento();
        String autenticacao = BancoCaixaApiUtil.autenticacaoCrud(bolModel.getBeneficiario().getCodigoBeneficiario(), bolModel.getNossoNumero(), dtVenc, vrStr, documento);
        return autenticacao;
    }

    protected static String autenticacaoConsulta(BoletoModel bolModel) {
        String autenticacao = BancoCaixaApiUtil.autenticacaoConsutaBaixa(bolModel.getBeneficiario().getCodigoBeneficiario(), bolModel.getNossoNumero(), bolModel.getBeneficiario().getDocumento());
        return autenticacao;
    }

    protected HEADERBARRAMENTOTYPE toHeaderAuthConsultaBoleto(BoletoModel bolModel) {
        return this.toHeaderAuth(bolModel, "CONSULTA_BOLETO", "5.2", "SGCBS02P", false);
    }

    protected HEADERBARRAMENTOTYPE toHeaderAuthCrud(BoletoModel bolModel) {
        return this.toHeaderAuth(bolModel, "INCLUI_BOLETO", this.cfg.getVersaoBoletoCrud(), "SGCBS02P", true);
    }

    private HEADERBARRAMENTOTYPE toHeaderAuth(BoletoModel bolModel, String operacao, String versao, String usuarioServico, boolean crud) {
        HEADERBARRAMENTOTYPE header = new HEADERBARRAMENTOTYPE();
        header.setVERSAO(versao);
        header.setAUTENTICACAO(crud ? this.autenticacaoCrud(bolModel, operacao) : BancoCaixaApiConverterPai.autenticacaoConsulta(bolModel));
        header.setUSUARIOSERVICO(usuarioServico);
        header.setUSUARIO(null);
        header.setOPERACAO(operacao);
        header.setINDICE(null);
        header.setSISTEMAORIGEM("SIGCB");
        header.setUNIDADE(bolModel.getBeneficiario().getAgencia());
        header.setIDENTIFICADORORIGEM(null);
        String dh = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        header.setDATAHORA(dh);
        header.setIDPROCESSO(null);
        return header;
    }

    protected static String obterCodRetorno(List<CONTROLENEGOCIALTYPE> listControleNegocial) {
        return listControleNegocial.get(0).getCODRETORNO();
    }

    protected static String obterMsgRetorno(List<CONTROLENEGOCIALTYPE> listControleNegocial) {
        return listControleNegocial.get(0).getMENSAGENS().getRETORNO();
    }

    protected static Pagador toPagador(ConsultaBoletoPagadorType pagadorConsulta) {
        Pagador pagador = new Pagador();
        pagador.setDocumento((String)StringUtils.defaultIfBlank((CharSequence)pagadorConsulta.getCNPJ(), (CharSequence)pagadorConsulta.getCPF()));
        pagador.setNome((String)StringUtils.defaultIfBlank((CharSequence)pagadorConsulta.getNOME(), (CharSequence)pagadorConsulta.getRAZAOSOCIAL()));
        ConsultaBoletoEnderecoType endereco = pagadorConsulta.getENDERECO();
        if (endereco != null) {
            pagador.setEndereco(BancoCaixaApiConverterPai.toEndereco(endereco));
        }
        return pagador;
    }

    protected static Endereco toEndereco(ConsultaBoletoEnderecoType enderecoConsulta) {
        Endereco endereco = new Endereco();
        endereco.setBairro(enderecoConsulta.getBAIRRO());
        endereco.setCidade(enderecoConsulta.getCIDADE());
        endereco.setCep(enderecoConsulta.getCEP());
        return endereco;
    }

    protected static void toJuros(BoletoModel bolModel, ConsultaBoletoJurosMoraType jurosConsulta) {
        String tipo = jurosConsulta.getTIPO();
        bolModel.setTipoJuros(BancoConverterGenerico.toTpJuros(tipo));
        XMLGregorianCalendar data = jurosConsulta.getDATA();
        if (data != null) {
            bolModel.setDataJuros(BoletoUtil.converteXMLGregorianCalendarData(data));
        }
        BigDecimal percentual = jurosConsulta.getPERCENTUAL();
        bolModel.setPercentualJuros(percentual);
        BigDecimal valor = jurosConsulta.getVALOR();
        bolModel.setValorJuros(valor);
        bolModel.setValorPercentualJuros((BigDecimal)ObjectUtils.defaultIfNull((Object)percentual, (Object)valor));
    }

    protected static void toMulta(BoletoModel bolModel, ConsultaBoletoMultaType multaConsulta) {
        XMLGregorianCalendar data = multaConsulta.getDATA();
        if (data != null) {
            bolModel.setDataMulta(BoletoUtil.converteXMLGregorianCalendarData(data));
        }
        BigDecimal percentual = multaConsulta.getPERCENTUAL();
        bolModel.setPercentualMulta(percentual);
        BigDecimal valor = multaConsulta.getVALOR();
        bolModel.setValorMulta(valor);
        bolModel.setValorPercentualMulta((BigDecimal)ObjectUtils.defaultIfNull((Object)percentual, (Object)valor));
    }
}

