/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.inter_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.SituacaoEnum;
import br.com.java_brasil.boleto.service.bancos.inter_api.ConfiguracaoInterAPI;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.Token;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.cobranca.BoletoInterAPIRequest;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.cobranca.BoletoInterAPIResponse;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.cobranca.Desconto;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.cobranca.Mensagem;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.cobranca.Mora;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.cobranca.Multa;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.cobranca.Pagador;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.cobranca.RecuperacaoBoletoResponse;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.RestUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class BancoInterAPI
extends BoletoController {
    private static final Logger log = Logger.getLogger(BancoInterAPI.class.getName());
    Token token;

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoInterAPI configuracao = (ConfiguracaoInterAPI)this.getConfiguracao();
            this.token = this.getToken(configuracao);
            String nossoNumero = boletoModel.getNossoNumero();
            String url = configuracao.getURLBase() + configuracao.getUrlBoleto() + "/" + nossoNumero + "/pdf";
            HttpGet get = new HttpGet(url);
            get.setHeader((Header)new BasicHeader("Authorization", "Bearer " + this.token.getAccess_token()));
            CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)get, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            String retorno = RestUtil.validaResponseERetornaBody(response);
            ObjectMapper mapper = new ObjectMapper();
            JsonFactory factory = mapper.getFactory();
            JsonParser parser = factory.createParser(retorno);
            JsonNode actualObj = (JsonNode)mapper.readTree(parser);
            JsonNode pdfStringBase64 = actualObj.get("pdf");
            String toString = pdfStringBase64.toString();
            boletoModel.setImpressaoBase64(toString);
            return boletoModel.getImpressaoBase64().getBytes("UTF-8");
        }
        catch (IOException e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            BoletoInterAPIRequest boletoInterAPIRequest = this.montaBoletoRequest(boletoModel);
            BoletoInterAPIResponse BoletoInterAPIResponse2 = this.enviarBoleto(boletoInterAPIRequest);
            return this.montaBoletoResponse(boletoModel, BoletoInterAPIResponse2);
        }
        catch (IOException e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    public Token getToken(ConfiguracaoInterAPI configuracao) throws IOException {
        if (this.token == null || this.getToken().expired()) {
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/x-www-form-urlencoded")};
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("grant_type", "client_credentials"));
            nvps.add(new BasicNameValuePair("client_id", configuracao.getClientId()));
            nvps.add(new BasicNameValuePair("client_secret", configuracao.getClientSecret()));
            nvps.add(new BasicNameValuePair("scope", new Token.TpScopeBuilder().todos().build()));
            String url = configuracao.getURLBase() + configuracao.getUrlToken();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
            httpPost.setHeaders(headers);
            CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)httpPost, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Token banco inter: " + retorno);
            JsonObject json = com.google.gson.JsonParser.parseString((String)retorno).getAsJsonObject();
            this.token = new Token().create(json.toString());
            String token = json.get("access_token").getAsString();
            LocalDateTime expires = LocalDateTime.now().plusSeconds(json.get("expires_in").getAsInt());
            log.config("Token Banco inter: " + token);
            log.config("Expira: " + expires);
        }
        return this.token;
    }

    public BoletoInterAPIResponse enviarBoleto(@NonNull BoletoInterAPIRequest boletoRequest) throws IOException {
        if (boletoRequest == null) {
            throw new NullPointerException("boletoRequest is marked non-null but is null");
        }
        ConfiguracaoInterAPI configuracao = (ConfiguracaoInterAPI)this.getConfiguracao();
        this.token = this.getToken(configuracao);
        String json = RestUtil.ObjectToJson(boletoRequest);
        log.config("Json envio Banco Inter: " + json);
        Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json;charset=ISO-8859-1"), new BasicHeader("Authorization", "Bearer " + this.token.getAccess_token())};
        String url = configuracao.getURLBase() + configuracao.getUrlBoleto();
        CloseableHttpResponse response = RestUtil.post(url, headers, json, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
        String retorno = RestUtil.validaResponseERetornaBody(response);
        log.config("Retorno envio Banco Inter: " + retorno);
        return RestUtil.JsonToObject(retorno, BoletoInterAPIResponse.class);
    }

    private BoletoInterAPIRequest montaBoletoRequest(BoletoModel boletoModel) {
        return BoletoInterAPIRequest.builder().dataVencimento(boletoModel.getDataVencimento()).valorNominal(boletoModel.getValorBoleto()).seuNumero(boletoModel.getNumeroDocumento()).pagador(Pagador.builder().cpfCnpj(boletoModel.getPagador().getDocumento()).endereco(boletoModel.getPagador().getEndereco().getLogradouro()).numero(boletoModel.getPagador().getEndereco().getNumero()).complemento(boletoModel.getPagador().getEndereco().getComplemento()).nome(boletoModel.getPagador().getNome()).cep(boletoModel.getPagador().getEndereco().getCep()).cidade(boletoModel.getPagador().getEndereco().getCidade()).bairro(boletoModel.getPagador().getEndereco().getBairro()).uf(boletoModel.getPagador().getEndereco().getUf()).telefone(boletoModel.getPagador().getTelefone()).ddd(boletoModel.getPagador().getDdd()).build().identificaTipo()).numDiasAgenda(boletoModel.getDiasParaBaixaDevolver()).mensagem(Mensagem.toMensagem(boletoModel.getInstrucoes())).desconto1(this.geraDesconto(boletoModel.getValorPercentualDescontos(), boletoModel, boletoModel.getDataLimiteParaDesconto())).desconto2(this.geraDesconto(boletoModel.getValorPercentualDescontos2(), boletoModel, boletoModel.getDataLimiteParaDesconto2())).desconto3(this.geraDesconto(boletoModel.getValorPercentualDescontos3(), boletoModel, boletoModel.getDataLimiteParaDesconto3())).multa(this.geraMulta(boletoModel)).mora(this.geraMora(boletoModel)).build();
    }

    private Desconto geraDesconto(BigDecimal vrPercentualDesconto, BoletoModel boletoModel, LocalDate dtLimiteDesc) {
        if (BoletoUtil.isNotNullEMaiorQZero(vrPercentualDesconto)) {
            switch (boletoModel.getTipoDesconto()) {
                case VALOR_FIXO: {
                    return Desconto.builder().codigoDesconto(Desconto.Codigo.VALORFIXODATAINFORMADA).valor(vrPercentualDesconto).data(dtLimiteDesc).build();
                }
                case PERCENTUAL_FIXO: {
                    return Desconto.builder().codigoDesconto(Desconto.Codigo.PERCENTUALDATAINFORMADA).taxa(vrPercentualDesconto).data(dtLimiteDesc).build();
                }
                case VALOR_DIA: {
                    return Desconto.builder().codigoDesconto(Desconto.Codigo.PERCENTUALDATAINFORMADA).taxa(vrPercentualDesconto).data(dtLimiteDesc).build();
                }
            }
            Desconto.builder().taxa(BigDecimal.ZERO.setScale(0)).valor(BigDecimal.ZERO.setScale(0)).codigoDesconto(Desconto.Codigo.NAOTEMDESCONTO).build();
        }
        return Desconto.builder().codigoDesconto(Desconto.Codigo.NAOTEMDESCONTO).build();
    }

    private Multa geraMulta(BoletoModel boletoModel) {
        BigDecimal valorPercentualMulta = boletoModel.getValorPercentualMulta();
        if (BoletoUtil.isNotNullEMaiorQZero(valorPercentualMulta)) {
            switch (boletoModel.getTipoMulta()) {
                case ISENTO: {
                    return Multa.builder().codigoMulta(Multa.Codigo.NAOTEMMULTA).build();
                }
                case PERCENTUAL: {
                    return Multa.builder().codigoMulta(Multa.Codigo.PERCENTUAL).taxa(valorPercentualMulta).data(boletoModel.getDataMulta()).build();
                }
                case VALOR: {
                    return Multa.builder().codigoMulta(Multa.Codigo.VALORFIXO).valor(valorPercentualMulta).data(boletoModel.getDataMulta()).build();
                }
            }
            Multa.builder().codigoMulta(Multa.Codigo.NAOTEMMULTA).build();
        }
        return Multa.builder().codigoMulta(Multa.Codigo.NAOTEMMULTA).build();
    }

    private Mora geraMora(BoletoModel boletoModel) {
        BigDecimal valorPercentualMulta = boletoModel.getValorPercentualMulta();
        if (BoletoUtil.isNotNullEMaiorQZero(valorPercentualMulta)) {
            switch (boletoModel.getTipoJuros()) {
                case ISENTO: {
                    return Mora.builder().codigoMora(Mora.Codigo.ISENTO).build();
                }
                case PERCENTUAL_MENSAL: {
                    return Mora.builder().codigoMora(Mora.Codigo.TAXAMENSAL).taxa(boletoModel.getValorPercentualJuros()).data(boletoModel.getDataJuros()).build();
                }
                case VALOR_DIA: {
                    return Mora.builder().codigoMora(Mora.Codigo.VALORDIA).taxa(boletoModel.getValorPercentualJuros()).data(boletoModel.getDataJuros()).build();
                }
            }
            return Mora.builder().codigoMora(Mora.Codigo.ISENTO).build();
        }
        return Mora.builder().codigoMora(Mora.Codigo.ISENTO).build();
    }

    private BoletoModel montaBoletoResponse(BoletoModel boletoModel, BoletoInterAPIResponse boletoInterAPIResponse) {
        boletoModel.setLinhaDigitavel(boletoInterAPIResponse.getLinhaDigitavel());
        boletoModel.setCodigoBarras(boletoInterAPIResponse.getCodigoBarras());
        boletoModel.setNossoNumero(boletoInterAPIResponse.getNossoNumero());
        return boletoModel;
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco!");
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        RecuperacaoBoletoResponse consultarBoleto = this.consultarBoleto(boletoModel.getNossoNumero());
        String situacao = consultarBoleto.getSituacao();
        switch (situacao = situacao.toUpperCase()) {
            case "PAGO": {
                boletoModel.setSituacao(SituacaoEnum.LIQUIDADO);
                break;
            }
            case "EM ABERTO": {
                boletoModel.setSituacao(SituacaoEnum.EM_ABERTO);
                break;
            }
            case "CANCELADO": {
                boletoModel.setSituacao(SituacaoEnum.BAIXADO);
                break;
            }
            case "EXPIRADO": {
                boletoModel.setSituacao(SituacaoEnum.BAIXADO);
            }
        }
        boletoModel.setDataSituacao(consultarBoleto.getDataHoraSituacao());
        boletoModel.setValorCobrado(consultarBoleto.getValorTotalRecebimento());
        return boletoModel;
    }

    public RecuperacaoBoletoResponse consultarBoleto(String nossoNumero) throws BoletoException {
        try {
            ConfiguracaoInterAPI configuracao = (ConfiguracaoInterAPI)this.getConfiguracao();
            this.token = this.getToken(configuracao);
            String url = configuracao.getURLBase() + configuracao.getUrlBoleto() + "/" + nossoNumero;
            HttpGet get = new HttpGet(url);
            get.setHeader((Header)new BasicHeader("Authorization", "Bearer " + this.token.getAccess_token()));
            CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)get, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno envio Banco Inter: " + retorno);
            RecuperacaoBoletoResponse boletoRecuperado = RestUtil.JsonToObject(retorno, RecuperacaoBoletoResponse.class);
            return boletoRecuperado;
        }
        catch (IOException ex) {
            throw new BoletoException("Erro ao consultar boleto", ex);
        }
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }
}

