/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.inter_api.util;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateDeserializeJson
extends JsonDeserializer<LocalDate> {
    private final DateTimeFormatter format16 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final DateTimeFormatter format10 = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public LocalDate deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JacksonException {
        LocalDate data = null;
        try {
            String dtStr = jp.getText().trim();
            int length = dtStr.length();
            switch (length) {
                case 10: {
                    data = LocalDate.parse(jp.getText().trim(), this.format10);
                    break;
                }
                case 16: {
                    data = LocalDate.parse(jp.getText().trim(), this.format16);
                }
            }
            return data;
        }
        catch (IOException ex) {
            System.out.println("util.LocalDateAdapterBr.deserialize() - Erro ao deserializar json");
            throw ex;
        }
    }
}

