/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.itau_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import br.com.java_brasil.boleto.service.bancos.itau_api.ConfiguracaoItauAPI;
import br.com.java_brasil.boleto.service.bancos.itau_api.model.BoletoItauAPIRequest;
import br.com.java_brasil.boleto.service.bancos.itau_api.model.BoletoItauAPIResponse;
import br.com.java_brasil.boleto.service.bancos.itau_api.model.BoletoItauModelConverter;
import br.com.java_brasil.boleto.service.bancos.itau_cnab400.ItauUtil;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.RestUtil;
import br.com.java_brasil.boleto.util.ValidaUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class BancoItauAPI
extends BoletoController {
    private static final Logger log = Logger.getLogger(BancoItauAPI.class.getName());

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            boletos.forEach(this::preparaValidaBoletoImpressao);
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return Base64.decodeBase64((String)Optional.ofNullable(boletoModel.getImpressaoBase64()).orElseThrow(() -> new BoletoException("Campo Impress\u00e3oBase64 n\u00e3o est\u00e1 preenchido, consulte o boleto para receber a impress\u00e3o.")));
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoItauAPI configuracao = (ConfiguracaoItauAPI)this.getConfiguracao();
            BoletoItauAPIRequest apiRequest = BoletoItauModelConverter.montaBoletoRequest(boletoModel, configuracao.getAmbiente());
            BoletoItauAPIResponse apiResponse = this.registraBoleto(apiRequest, configuracao);
            return BoletoItauModelConverter.montaBoletoResponse(boletoModel, apiResponse);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    private BoletoItauAPIResponse registraBoleto(BoletoItauAPIRequest boletoRequest, ConfiguracaoItauAPI configuracao) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException, InvalidKeyException {
        this.validaAutenticacao(configuracao);
        String json = RestUtil.ObjectToJson(boletoRequest);
        log.config("Json Envio Itau: " + json);
        Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), this.getHeadAutorization(configuracao.getToken(), configuracao.getAmbiente())};
        CloseableHttpResponse response = RestUtil.post(configuracao.getURLRegistroBoleto(), headers, json, configuracao.getCaminhoCertificado(), configuracao.getSenhaCertificado());
        String retorno = RestUtil.validaResponseERetornaBody(response);
        log.config("Retorno Envio Itau: " + retorno);
        JsonObject jsonRetorno = JsonParser.parseString((String)retorno).getAsJsonObject();
        retorno = jsonRetorno.get("data").getAsString();
        return RestUtil.JsonToObject(retorno, BoletoItauAPIResponse.class);
    }

    private BasicHeader getHeadAutorization(String token, AmbienteEnum ambienteEnum) {
        return ambienteEnum.equals((Object)AmbienteEnum.PRODUCAO) ? new BasicHeader("Authorization", "Bearer " + token) : new BasicHeader("x-sandbox-token", token);
    }

    private void validaAutenticacao(ConfiguracaoItauAPI configuracao) {
        try {
            if (StringUtils.isBlank((CharSequence)configuracao.getToken()) || configuracao.getExpiracaoToken() == null || configuracao.getExpiracaoToken().isBefore(LocalDateTime.now())) {
                log.config("Token est\u00e1 expirado. Gerando novo Token.");
                BancoItauAPI.capturaToken(configuracao);
            }
        }
        catch (IOException e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    private static void capturaToken(ConfiguracaoItauAPI configuracao) throws IOException {
        Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/x-www-form-urlencoded")};
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("grant_type", "client_credentials"));
        nvps.add(new BasicNameValuePair("client_id", configuracao.getClientId()));
        nvps.add(new BasicNameValuePair("client_secret", configuracao.getClientSecret()));
        HttpPost httpPost = new HttpPost(configuracao.getURLToken());
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        httpPost.setHeaders(headers);
        CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)httpPost, configuracao.getCaminhoCertificado(), configuracao.getSenhaCertificado());
        String retorno = RestUtil.validaResponseERetornaBody(response);
        log.config("Retorno Token Itau: " + retorno);
        JsonObject json = JsonParser.parseString((String)retorno).getAsJsonObject();
        String token = json.get("access_token").getAsString();
        LocalDateTime expires = LocalDateTime.now().plusSeconds(json.get("expires_in").getAsInt());
        log.config("Token Itau: " + token);
        log.config("Expiracao: " + expires);
        configuracao.setToken(token);
        configuracao.setExpiracaoToken(expires);
    }

    private void preparaValidaBoletoImpressao(BoletoModel boletoModel) {
        boletoModel.getBeneficiario().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiario().getDocumento()));
        boletoModel.getPagador().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getPagador().getDocumento()));
        if (boletoModel.getBeneficiarioFinal() != null) {
            boletoModel.getBeneficiarioFinal().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiarioFinal().getDocumento()));
        }
        StringBuilder codigoBarras = new StringBuilder();
        codigoBarras.append("3419");
        codigoBarras.append("X");
        codigoBarras.append(ItauUtil.fatorData(boletoModel.getDataVencimento()));
        codigoBarras.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
        StringBuilder campoLivre = new StringBuilder();
        campoLivre.append(boletoModel.getBeneficiario().getCarteira());
        campoLivre.append(StringUtils.leftPad((String)boletoModel.getNossoNumero(), (int)8, (String)"0"));
        Integer dacAgenContCartNossNum = ItauUtil.modulo10(boletoModel.getBeneficiario().getAgencia() + boletoModel.getBeneficiario().getConta() + boletoModel.getBeneficiario().getCarteira() + boletoModel.getNossoNumero());
        campoLivre.append(dacAgenContCartNossNum);
        campoLivre.append(StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (String)"0"));
        campoLivre.append(StringUtils.leftPad((String)boletoModel.getBeneficiario().getConta(), (int)5, (String)"0"));
        Integer dacAgenCont = ItauUtil.modulo10(boletoModel.getBeneficiario().getAgencia() + boletoModel.getBeneficiario().getConta());
        campoLivre.append(dacAgenCont);
        codigoBarras.append("000");
        codigoBarras.append((CharSequence)campoLivre);
        Integer digitoVerificadorGeral = ItauUtil.modulo11(codigoBarras.toString().replace("X", ""));
        boletoModel.setCodigoBarras(codigoBarras.toString().replace("X", digitoVerificadorGeral.toString()));
        StringBuilder linhaParte1 = new StringBuilder();
        linhaParte1.append("3419");
        linhaParte1.append(campoLivre.toString(), 0, 5);
        linhaParte1.append(ItauUtil.modulo10(linhaParte1.toString()));
        StringBuilder linhaParte2 = new StringBuilder();
        linhaParte2.append(campoLivre.toString(), 5, 15);
        linhaParte2.append(ItauUtil.modulo10(linhaParte2.toString()));
        StringBuilder linhaParte3 = new StringBuilder();
        linhaParte3.append(campoLivre.substring(15, 22));
        linhaParte3.append("000");
        linhaParte3.append(ItauUtil.modulo10(linhaParte3.toString()));
        StringBuilder linhaParte4 = new StringBuilder();
        linhaParte4.append(digitoVerificadorGeral);
        StringBuilder linhaParte5 = new StringBuilder();
        linhaParte5.append(codigoBarras.toString(), 5, 19);
        StringBuilder linhaDigitavel = new StringBuilder();
        linhaDigitavel.append(linhaParte1.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte1.toString(), 5, 10);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte2.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte2.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte3.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte3.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append((CharSequence)linhaParte4);
        linhaDigitavel.append("  ");
        linhaDigitavel.append((CharSequence)linhaParte5);
        boletoModel.setLinhaDigitavel(linhaDigitavel.toString());
        this.validaDadosImpressao(boletoModel);
    }

    private void validaDadosImpressao(BoletoModel boleto) {
        ValidaUtils.validaBoletoModel(boleto, Arrays.asList("locaisDePagamento", "dataVencimento", "beneficiario.nomeBeneficiario", "beneficiario.documento", "beneficiario.agencia", "beneficiario.conta", "dataEmissao", "numeroDocumento", "especieDocumento", "aceite", "nossoNumero", "digitoNossoNumero", "especieMoeda", "valorBoleto", "pagador.nome", "pagador.documento", "pagador.endereco.logradouro", "pagador.endereco.cep", "linhaDigitavel", "codigoBarras", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.uf", "beneficiario.carteira", "beneficiario.digitoConta", "beneficiario.endereco.logradouro", "beneficiario.endereco.numero", "beneficiario.endereco.bairro", "beneficiario.endereco.cidade", "beneficiario.endereco.uf", "beneficiario.endereco.cep"));
    }
}

