/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.itau_cnab400;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.Beneficiario;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Pagador;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.TipoMultaEnum;
import br.com.java_brasil.boleto.service.bancos.itau_cnab400.ItauUtil;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.ValidaUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang3.StringUtils;

public class BancoItauCnab400
extends BoletoController {
    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            boletos.forEach(this::preparaValidaBoletoImpressao);
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        return this.gerarArquivo(remessaRetornoModel);
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        return this.importarArquivo(arquivo);
    }

    public String gerarArquivo(List<RemessaRetornoModel> list) {
        list.forEach(boleto -> ValidaUtils.validaBoletoModel(boleto.getBoleto(), this.getConfiguracao().camposObrigatoriosBoleto()));
        Integer contador = 1;
        StringBuilder linhaArquivo = new StringBuilder();
        linhaArquivo.append("0");
        linhaArquivo.append("1");
        linhaArquivo.append("REMESSA");
        linhaArquivo.append("01");
        linhaArquivo.append(StringUtils.rightPad((String)"COBRANCA", (int)15, (char)' '));
        linhaArquivo.append(StringUtils.leftPad((String)list.get(0).getBoleto().getBeneficiario().getAgencia(), (int)4, (String)"0"));
        linhaArquivo.append("00");
        linhaArquivo.append(StringUtils.leftPad((String)list.get(0).getBoleto().getBeneficiario().getConta(), (int)5, (String)"0"));
        linhaArquivo.append(ItauUtil.modulo10(list.get(0).getBoleto().getBeneficiario().getAgencia() + list.get(0).getBoleto().getBeneficiario().getConta()));
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)8));
        linhaArquivo.append(StringUtils.rightPad((String)BoletoUtil.limitarTamanhoString(list.get(0).getBoleto().getBeneficiario().getNomeBeneficiario(), 30), (int)30, (String)" "));
        linhaArquivo.append("341");
        linhaArquivo.append(StringUtils.rightPad((String)"BANCO ITAU SA", (int)15, (char)' '));
        linhaArquivo.append(BoletoUtil.getDataFormato(LocalDate.now(), "ddMMyy"));
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)294));
        linhaArquivo.append(StringUtils.leftPad((String)contador.toString(), (int)6, (String)"0"));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        Integer n = contador;
        Integer n2 = contador = Integer.valueOf(contador + 1);
        for (RemessaRetornoModel boleto2 : list) {
            linhaArquivo.append("1");
            linhaArquivo.append(list.get(0).getBoleto().getBeneficiario().isClienteCpf() ? "01" : "02");
            linhaArquivo.append(StringUtils.leftPad((String)list.get(0).getBoleto().getBeneficiario().getDocumento(), (int)14, (String)"0"));
            linhaArquivo.append(StringUtils.leftPad((String)list.get(0).getBoleto().getBeneficiario().getAgencia(), (int)4, (String)"0"));
            linhaArquivo.append("00");
            linhaArquivo.append(StringUtils.leftPad((String)list.get(0).getBoleto().getBeneficiario().getConta(), (int)5, (String)"0"));
            linhaArquivo.append(ItauUtil.modulo10(list.get(0).getBoleto().getBeneficiario().getAgencia() + list.get(0).getBoleto().getBeneficiario().getConta()));
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)4));
            linhaArquivo.append(StringUtils.repeat((String)"0", (int)4));
            linhaArquivo.append(StringUtils.rightPad((String)boleto2.getBoleto().getNumeroDocumento(), (int)25, (String)" "));
            linhaArquivo.append(StringUtils.leftPad((String)boleto2.getBoleto().getNossoNumero(), (int)8, (String)"0"));
            linhaArquivo.append(StringUtils.repeat((String)"0", (int)13));
            linhaArquivo.append(StringUtils.leftPad((String)list.get(0).getBoleto().getBeneficiario().getCarteira(), (int)3, (String)"0"));
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)21));
            linhaArquivo.append(list.get(0).getBoleto().getBeneficiario().getCodigoCarteira());
            linhaArquivo.append(StringUtils.leftPad((String)boleto2.getInstrucao(), (int)2, (String)"0"));
            linhaArquivo.append(StringUtils.rightPad((String)boleto2.getBoleto().getNumeroDocumento(), (int)10, (String)" "));
            linhaArquivo.append(BoletoUtil.getDataFormato(boleto2.getBoleto().getDataVencimento(), "ddMMyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorBoleto(), 2, 13));
            linhaArquivo.append("341");
            linhaArquivo.append(StringUtils.repeat((String)"0", (int)5));
            linhaArquivo.append(StringUtils.leftPad((String)boleto2.getBoleto().getEspecieDocumento(), (int)2, (String)"0"));
            linhaArquivo.append(boleto2.getBoleto().isAceite() ? "A" : "N");
            linhaArquivo.append(BoletoUtil.getDataFormato(boleto2.getBoleto().getDataEmissao(), "ddMMyy"));
            String instrucaoCobranca = boleto2.getBoleto().isProtesto() ? "81" : "10";
            linhaArquivo.append(instrucaoCobranca);
            linhaArquivo.append(instrucaoCobranca);
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorJuros(), 2, 13));
            linhaArquivo.append(boleto2.getBoleto().getDataLimiteParaDesconto() == null ? "000000" : BoletoUtil.getDataFormato(boleto2.getBoleto().getDataLimiteParaDesconto(), "ddMMyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorDescontos(), 2, 13));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorIof(), 2, 13));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorDeducoes(), 2, 13));
            linhaArquivo.append(boleto2.getBoleto().getPagador().isClienteCpf() ? "01" : "02");
            linhaArquivo.append(StringUtils.leftPad((String)boleto2.getBoleto().getPagador().getDocumento(), (int)14, (String)"0"));
            linhaArquivo.append(StringUtils.rightPad((String)BoletoUtil.limitarTamanhoString(boleto2.getBoleto().getPagador().getNome(), 30), (int)30, (String)" "));
            linhaArquivo.append(StringUtils.repeat((String)"0", (int)10));
            String enderecoCompleto = boleto2.getBoleto().getPagador().getEndereco().getLogradouro();
            enderecoCompleto = enderecoCompleto + ", " + boleto2.getBoleto().getPagador().getEndereco().getNumero();
            if (boleto2.getBoleto().getPagador().getEndereco().getComplemento() != null) {
                enderecoCompleto = enderecoCompleto + " " + boleto2.getBoleto().getPagador().getEndereco().getComplemento();
            }
            linhaArquivo.append(StringUtils.rightPad((String)BoletoUtil.limitarTamanhoString(enderecoCompleto, 40), (int)40, (String)" "));
            linhaArquivo.append(StringUtils.rightPad((String)boleto2.getBoleto().getPagador().getEndereco().getBairro(), (int)12, (String)" "));
            linhaArquivo.append(StringUtils.leftPad((String)boleto2.getBoleto().getPagador().getEndereco().getCep(), (int)8, (String)"0"));
            linhaArquivo.append(StringUtils.rightPad((String)boleto2.getBoleto().getPagador().getEndereco().getCidade(), (int)15, (String)" "));
            linhaArquivo.append(StringUtils.leftPad((String)boleto2.getBoleto().getPagador().getEndereco().getUf(), (int)2, (String)" "));
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)30));
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)4));
            linhaArquivo.append(StringUtils.repeat((String)"0", (int)6));
            linhaArquivo.append(StringUtils.leftPad((String)String.valueOf(boleto2.getBoleto().getDiasProtesto()), (int)2));
            linhaArquivo.append(" ");
            linhaArquivo.append(StringUtils.leftPad((String)contador.toString(), (int)6, (String)"0"));
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
            Integer n3 = contador;
            Integer n4 = contador = Integer.valueOf(contador + 1);
            linhaArquivo.append("2");
            if (!boleto2.getBoleto().getTipoMulta().equals((Object)TipoMultaEnum.ISENTO) && BoletoUtil.isNotNullEMaiorQZero(boleto2.getBoleto().getValorPercentualMulta())) {
                linhaArquivo.append("2");
                linhaArquivo.append(BoletoUtil.getDataFormato(boleto2.getBoleto().getDataVencimento(), "ddMMyyyy"));
                linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualMulta(), 2, 13));
            } else {
                linhaArquivo.append("0");
                linhaArquivo.append(StringUtils.repeat((String)"0", (int)8));
                linhaArquivo.append(StringUtils.repeat((String)"0", (int)13));
            }
            linhaArquivo.append(StringUtils.repeat((String)" ", (int)371));
            linhaArquivo.append(StringUtils.leftPad((String)contador.toString(), (int)6, (String)"0"));
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
            n3 = contador;
            n4 = contador = Integer.valueOf(contador + 1);
        }
        linhaArquivo.append("9");
        linhaArquivo.append(StringUtils.repeat((String)" ", (int)393));
        linhaArquivo.append(StringUtils.leftPad((String)contador.toString(), (int)6, (String)"0"));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        String arquivoRemessa = linhaArquivo.toString();
        StringBuilder sbRemessa = new StringBuilder();
        for (int i = 0; i < arquivoRemessa.length(); ++i) {
            char ch = arquivoRemessa.charAt(i);
            if (ItauUtil.isASCIIItau(ch)) {
                sbRemessa.append(ch);
                continue;
            }
            sbRemessa.append(' ');
        }
        return sbRemessa.toString();
    }

    private List<RemessaRetornoModel> importarArquivo(String arquivo) {
        ArrayList<RemessaRetornoModel> list = new ArrayList<RemessaRetornoModel>();
        String numeroRetorno = null;
        try (Scanner scanner = new Scanner(arquivo);){
            while (scanner.hasNextLine()) {
                String linha = scanner.nextLine();
                if (linha.length() <= 1) continue;
                if (linha.charAt(0) == '0') {
                    if (!linha.substring(1, 2).equals("2")) {
                        throw new BoletoException("Formato do aquivo inv\u00e1lido.");
                    }
                    if (!linha.substring(76, 79).equals("341")) {
                        throw new BoletoException("N\u00famero do Banco inv\u00e1lido.");
                    }
                    numeroRetorno = linha.substring(108, 113);
                }
                if (linha.charAt(0) != '1') continue;
                RemessaRetornoModel remessaRetornoModel = new RemessaRetornoModel();
                remessaRetornoModel.setBoleto(new BoletoModel());
                remessaRetornoModel.getBoleto().setPagador(new Pagador());
                remessaRetornoModel.getBoleto().setBeneficiario(new Beneficiario());
                remessaRetornoModel.getBoleto().setCodRetorno(numeroRetorno);
                remessaRetornoModel.getBoleto().getBeneficiario().setDocumento(linha.substring(3, 17));
                remessaRetornoModel.getBoleto().setNossoNumero(linha.substring(85, 93));
                remessaRetornoModel.getBoleto().setDigitoNossoNumero(linha.substring(93, 94));
                remessaRetornoModel.setOcorrencia(linha.substring(108, 110));
                remessaRetornoModel.getBoleto().setNumeroDocumento(linha.substring(116, 126));
                remessaRetornoModel.getBoleto().setDataVencimento(BoletoUtil.formataStringPadraoDDMMYYParaLocalDate(linha.substring(146, 152)));
                remessaRetornoModel.getBoleto().setValorBoleto(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(152, 165)));
                remessaRetornoModel.setDespesaCobranca(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(175, 188)));
                remessaRetornoModel.setMotivoOcorrencia(linha.substring(377, 385));
                remessaRetornoModel.setAbatimentoConcedido(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(227, 240)));
                remessaRetornoModel.setDataOcorrencia(BoletoUtil.formataStringPadraoDDMMYYParaLocalDate(linha.substring(110, 116)));
                remessaRetornoModel.setDescontoConcedido(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(240, 253)));
                remessaRetornoModel.setJuroDeMora(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(266, 279)));
                remessaRetornoModel.setValorEfetivamentePago(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(253, 266)));
                remessaRetornoModel.setDataPrevisaoLancamento(BoletoUtil.formataStringPadraoDDMMYYParaLocalDate(linha.substring(295, 301)));
                list.add(remessaRetornoModel);
            }
        }
        return list;
    }

    private void preparaValidaBoletoImpressao(BoletoModel boletoModel) {
        boletoModel.getBeneficiario().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiario().getDocumento()));
        boletoModel.getPagador().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getPagador().getDocumento()));
        if (boletoModel.getBeneficiarioFinal() != null) {
            boletoModel.getBeneficiarioFinal().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiarioFinal().getDocumento()));
        }
        StringBuilder codigoBarras = new StringBuilder();
        codigoBarras.append("3419");
        codigoBarras.append("X");
        codigoBarras.append(ItauUtil.fatorData(boletoModel.getDataVencimento()));
        codigoBarras.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
        StringBuilder campoLivre = new StringBuilder();
        campoLivre.append(boletoModel.getBeneficiario().getCarteira());
        campoLivre.append(StringUtils.leftPad((String)boletoModel.getNossoNumero(), (int)8, (String)"0"));
        Integer dacAgenContCartNossNum = ItauUtil.modulo10(boletoModel.getBeneficiario().getAgencia() + boletoModel.getBeneficiario().getConta() + boletoModel.getBeneficiario().getCarteira() + boletoModel.getNossoNumero());
        campoLivre.append(dacAgenContCartNossNum);
        campoLivre.append(StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (String)"0"));
        campoLivre.append(StringUtils.leftPad((String)boletoModel.getBeneficiario().getConta(), (int)5, (String)"0"));
        Integer dacAgenCont = ItauUtil.modulo10(boletoModel.getBeneficiario().getAgencia() + boletoModel.getBeneficiario().getConta());
        campoLivre.append(dacAgenCont);
        codigoBarras.append((CharSequence)campoLivre);
        codigoBarras.append("000");
        Integer digitoVerificadorGeral = ItauUtil.modulo11(codigoBarras.toString().replace("X", ""));
        boletoModel.setCodigoBarras(codigoBarras.toString().replace("X", digitoVerificadorGeral.toString()));
        StringBuilder linhaParte1 = new StringBuilder();
        linhaParte1.append("3419");
        linhaParte1.append(campoLivre.toString(), 0, 5);
        linhaParte1.append(ItauUtil.modulo10(linhaParte1.toString()));
        StringBuilder linhaParte2 = new StringBuilder();
        linhaParte2.append(campoLivre.toString(), 5, 15);
        linhaParte2.append(ItauUtil.modulo10(linhaParte2.toString()));
        StringBuilder linhaParte3 = new StringBuilder();
        linhaParte3.append(campoLivre.substring(15, 22));
        linhaParte3.append("000");
        linhaParte3.append(ItauUtil.modulo10(linhaParte3.toString()));
        StringBuilder linhaParte4 = new StringBuilder();
        linhaParte4.append(digitoVerificadorGeral);
        StringBuilder linhaParte5 = new StringBuilder();
        linhaParte5.append(codigoBarras.toString(), 5, 19);
        StringBuilder linhaDigitavel = new StringBuilder();
        linhaDigitavel.append(linhaParte1.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte1.toString(), 5, 10);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte2.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte2.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte3.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte3.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append((CharSequence)linhaParte4);
        linhaDigitavel.append("  ");
        linhaDigitavel.append((CharSequence)linhaParte5);
        boletoModel.setLinhaDigitavel(linhaDigitavel.toString());
        this.validaDadosImpressao(boletoModel);
    }

    private void validaDadosImpressao(BoletoModel boleto) {
        ValidaUtils.validaBoletoModel(boleto, Arrays.asList("locaisDePagamento", "dataVencimento", "beneficiario.nomeBeneficiario", "beneficiario.documento", "beneficiario.agencia", "beneficiario.conta", "dataEmissao", "numeroDocumento", "especieDocumento", "aceite", "nossoNumero", "digitoNossoNumero", "especieMoeda", "valorBoleto", "pagador.nome", "pagador.documento", "pagador.endereco.logradouro", "pagador.endereco.cep", "linhaDigitavel", "codigoBarras", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.uf", "beneficiario.carteira", "beneficiario.digitoConta", "beneficiario.endereco.logradouro", "beneficiario.endereco.numero", "beneficiario.endereco.bairro", "beneficiario.endereco.cidade", "beneficiario.endereco.uf", "beneficiario.endereco.cep"));
    }
}

