/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.itau_cnab400;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.StringUtils;

public class ItauUtil {
    public static String fatorData(LocalDate dataVencimento) {
        LocalDate dataBase = LocalDate.of(1997, 10, 7);
        if (dataVencimento.isAfter(LocalDate.of(2025, 2, 21))) {
            dataBase = dataBase.plusDays(9000L);
        }
        long difDia = ChronoUnit.DAYS.between(dataBase, dataVencimento);
        return StringUtils.leftPad((String)("" + difDia), (int)4, (char)'0');
    }

    public static Integer modulo10(String codigo) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < codigo.length(); ++i) {
            int valor = (codigo.charAt(codigo.length() - 1 - i) - 48) * peso;
            if (valor > 9) {
                valor -= 9;
            }
            total += valor;
            if (peso == 2) {
                --peso;
                continue;
            }
            ++peso;
        }
        int resto = total < 10 ? total : total % 10;
        int digito = resto == 0 ? 0 : 10 - resto;
        return digito;
    }

    public static Integer modulo11(String codigo) {
        int s = 0;
        int p = 2;
        int cont = 43;
        for (int i = codigo.length() - 1; i >= 0; --i) {
            s += Integer.parseInt(codigo.substring(i, cont)) * p;
            p = p == 9 ? 2 : ++p;
            --cont;
        }
        int r = s % 11;
        int digito = 11 - r;
        return digito == 0 || digito == 1 || digito == 10 || digito == 11 ? 1 : digito;
    }

    public static boolean isASCIIItau(char ch) {
        if (ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9') {
            return true;
        }
        if (ch == ' ' || ch == '!' || ch == '#' || ch == '$' || ch == '%' || ch == '&' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == '-' || ch == '.' || ch == '/' || ch == ':' || ch == ';' || ch == '@' || ch == '[' || ch == '\\' || ch == ']' || ch == '{' || ch == '}') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        return ch == '\n' || ch == '\r';
    }
}

