/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.pjbank_api.recebimento;

import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.enums.StatusPagamentoBoleto;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.PJBankClient;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.auth.PJBankAuthenticatedService;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.exceptions.PJBankException;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.models.recebimento.ExtratoBoleto;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class BoletosManager
extends PJBankAuthenticatedService {
    private String endPoint = "recebimentos/{{credencial}}";

    public BoletosManager(String credencial, String chave) {
        super(credencial, chave);
        this.endPoint = this.endPoint.replace("{{credencial}}", credencial);
    }

    public BoletoModel create(BoletoModel boletoModel) throws IOException, PJBankException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes"));
        HttpPost httpPost = client.getHttpPostClient();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        JSONObject params = new JSONObject();
        params.put("vencimento", (Object)dateFormat.format(boletoModel.getDataVencimento()));
        params.put("valor", (Object)boletoModel.getValorBoleto());
        params.put("juros", (Object)boletoModel.getValorJuros());
        params.put("dias_juros", boletoModel.getDiasJuros());
        params.put("multa", (Object)boletoModel.getValorMulta());
        params.put("dias_multa", boletoModel.getDiasMulta());
        params.put("desconto", (Object)boletoModel.getValorDescontos());
        params.put("nome_cliente", (Object)boletoModel.getPagador().getNome());
        params.put("cpf_cliente", (Object)boletoModel.getPagador().getDocumento());
        params.put("endereco_cliente", (Object)boletoModel.getPagador().getEndereco().getLogradouro());
        params.put("numero_cliente", (Object)boletoModel.getPagador().getEndereco().getNumero());
        params.put("complemento_cliente", (Object)boletoModel.getPagador().getEndereco().getComplemento());
        params.put("bairro_cliente", (Object)boletoModel.getPagador().getEndereco().getBairro());
        params.put("cidade_cliente", (Object)boletoModel.getPagador().getEndereco().getCidade());
        params.put("estado_cliente", (Object)boletoModel.getPagador().getEndereco().getUf());
        params.put("cep_cliente", (Object)boletoModel.getPagador().getEndereco().getCep());
        params.put("logo_url", (Object)boletoModel.getLogoUrl());
        params.put("texto", boletoModel.getDescricoes());
        params.put("grupo", (Object)boletoModel.getGrupo());
        params.put("pedido_numero", (Object)boletoModel.getNumeroDocumento());
        httpPost.setEntity((HttpEntity)new StringEntity(params.toString(), StandardCharsets.UTF_8));
        String response = EntityUtils.toString((HttpEntity)client.doRequest((HttpRequestBase)httpPost).getEntity());
        JSONObject responseObject = new JSONObject(response);
        boletoModel.setNossoNumero(responseObject.getString("nossonumero"));
        boletoModel.setLinkBoleto(responseObject.getString("linkBoleto"));
        boletoModel.setLinkGrupo(responseObject.getString("linkGrupo"));
        boletoModel.setLinhaDigitavel(responseObject.getString("linhaDigitavel"));
        return boletoModel;
    }

    public String getByIds(Set<String> pedidos) throws IOException, PJBankException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes/lotes"));
        HttpPost httpPost = client.getHttpPostClient();
        httpPost.addHeader("x-chave", this.getChave());
        JSONArray pedidosArray = new JSONArray(pedidos);
        JSONObject params = new JSONObject();
        params.put("pedido_numero", (Object)pedidosArray);
        httpPost.setEntity((HttpEntity)new StringEntity(params.toString(), StandardCharsets.UTF_8));
        String response = EntityUtils.toString((HttpEntity)client.doRequest((HttpRequestBase)httpPost).getEntity());
        JSONObject responseObject = new JSONObject(response);
        return responseObject.getString("linkBoleto");
    }

    public List<ExtratoBoleto> get(Date inicio, Date fim, StatusPagamentoBoleto pago) throws URISyntaxException, IOException, PJBankException, ParseException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes"));
        HttpGet httpGet = client.getHttpGetClient();
        httpGet.addHeader("x-chave", this.getChave());
        this.adicionarFiltros((HttpRequestBase)httpGet, inicio, fim, pago);
        String response = EntityUtils.toString((HttpEntity)client.doRequest((HttpRequestBase)httpGet).getEntity());
        JSONArray extratoObject = new JSONArray(response);
        int totalItensExtrato = extratoObject.length();
        ArrayList<ExtratoBoleto> extratos = new ArrayList<ExtratoBoleto>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        for (int i = 0; i < totalItensExtrato; ++i) {
            String dataCredito;
            String dataPagamento;
            JSONObject itemExtrato = extratoObject.getJSONObject(i);
            ExtratoBoleto extrato = new ExtratoBoleto(itemExtrato.getDouble("valor"), itemExtrato.optDouble("valor_pago", 0.0), itemExtrato.getDouble("valor_liquido"), itemExtrato.optDouble("valor_tarifa", 0.0), itemExtrato.getString("nosso_numero"), itemExtrato.getString("nosso_numero_original"), itemExtrato.getString("banco_numero"), itemExtrato.getString("token_facilitador"));
            String dataVencimento = itemExtrato.getString("data_vencimento");
            if (!StringUtils.isBlank((CharSequence)dataVencimento)) {
                extrato.setDataVencimento(dateFormat.parse(dataVencimento));
            }
            if (!StringUtils.isBlank((CharSequence)(dataPagamento = itemExtrato.getString("data_pagamento")))) {
                extrato.setDataPagamento(dateFormat.parse(dataPagamento));
            }
            if (!StringUtils.isBlank((CharSequence)(dataCredito = itemExtrato.getString("data_credito")))) {
                extrato.setDataCredito(dateFormat.parse(dataCredito));
            }
            extratos.add(extrato);
        }
        return extratos;
    }

    private void adicionarFiltros(HttpRequestBase httpRequestClient, Date inicio, Date fim, StatusPagamentoBoleto pago) throws URISyntaxException {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        URIBuilder uriBuilder = new URIBuilder(httpRequestClient.getURI());
        uriBuilder.addParameter("data_inicio", formatter.format(inicio));
        uriBuilder.addParameter("data_fim", formatter.format(fim));
        uriBuilder.addParameter("pago", pago.getName());
        httpRequestClient.setURI(uriBuilder.build());
    }
}

