/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.pjbank_api.recebimento;

import br.com.java_brasil.boleto.service.bancos.pjbank_api.PJBankClient;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.auth.PJBankAuthenticatedService;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.exceptions.PJBankException;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.models.recebimento.CartaoCredito;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.models.recebimento.PagamentoCartaoCredito;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.models.recebimento.TransacaoCartaoCredito;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class CartaoCreditoManager
extends PJBankAuthenticatedService {
    private String endPoint = "recebimentos/{{credencial}}";

    public CartaoCreditoManager(String credencial, String chave) {
        super(credencial, chave);
        this.endPoint = this.endPoint.replace("{{credencial}}", credencial);
    }

    public String tokenize(CartaoCredito cartaoCredito) throws IOException, PJBankException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/tokens"));
        HttpPost httpPost = client.getHttpPostClient();
        httpPost.addHeader("x-chave", this.getChave());
        JSONObject params = new JSONObject();
        params.put("nome_cartao", (Object)cartaoCredito.getNome());
        params.put("numero_cartao", (Object)cartaoCredito.getNumero());
        params.put("mes_vencimento", cartaoCredito.getMesVencimento());
        params.put("ano_vencimento", cartaoCredito.getAnoVencimento());
        params.put("cpf_cartao", (Object)cartaoCredito.getCpfCnpj());
        params.put("email_cartao", (Object)cartaoCredito.getEmail());
        params.put("celular_cartao", cartaoCredito.getCelular());
        params.put("codigo_cvv", (Object)cartaoCredito.getCvv());
        httpPost.setEntity((HttpEntity)new StringEntity(params.toString(), StandardCharsets.UTF_8));
        String response = EntityUtils.toString((HttpEntity)client.doRequest((HttpRequestBase)httpPost).getEntity());
        JSONObject responseObject = new JSONObject(response);
        return responseObject.getString("token_cartao");
    }

    public TransacaoCartaoCredito createWithToken(String token, String descricao, double valor, int parcelas) throws IOException, ParseException, PJBankException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes"));
        HttpPost httpPost = client.getHttpPostClient();
        httpPost.addHeader("x-chave", this.getChave());
        JSONObject params = new JSONObject();
        params.put("token_cartao", (Object)token);
        params.put("descricao_pagamento", (Object)descricao);
        params.put("valor", valor);
        params.put("parcela", parcelas);
        httpPost.setEntity((HttpEntity)new StringEntity(params.toString(), StandardCharsets.UTF_8));
        String response = EntityUtils.toString((HttpEntity)client.doRequest((HttpRequestBase)httpPost).getEntity());
        JSONObject responseObject = new JSONObject(response);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        TransacaoCartaoCredito transacaoCartaoCredito = new TransacaoCartaoCredito();
        transacaoCartaoCredito.setId(responseObject.getString("tid"));
        transacaoCartaoCredito.setPrevisaoCredito(dateFormat.parse(responseObject.getString("previsao_credito")));
        transacaoCartaoCredito.setIdConciliacao(responseObject.getString("tid_conciliacao"));
        transacaoCartaoCredito.setBandeira(responseObject.getString("bandeira"));
        transacaoCartaoCredito.setAutorizacao(responseObject.getString("autorizacao"));
        transacaoCartaoCredito.setCartaoTruncado(responseObject.getString("cartao_truncado"));
        transacaoCartaoCredito.setStatusCartao(responseObject.getInt("statuscartao"));
        transacaoCartaoCredito.setTarifa(responseObject.getDouble("tarifa"));
        transacaoCartaoCredito.setTaxa(responseObject.getDouble("taxa"));
        return transacaoCartaoCredito;
    }

    public TransacaoCartaoCredito createWithCreditCardData(CartaoCredito cartaoCredito, String descricao, double valor, int parcelas) throws IOException, ParseException, PJBankException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes"));
        HttpPost httpPost = client.getHttpPostClient();
        httpPost.addHeader("x-chave", this.getChave());
        JSONObject params = new JSONObject();
        params.put("nome_cartao", (Object)cartaoCredito.getNome());
        params.put("numero_cartao", (Object)cartaoCredito.getNumero());
        params.put("mes_vencimento", cartaoCredito.getMesVencimento());
        params.put("ano_vencimento", cartaoCredito.getAnoVencimento());
        params.put("cpf_cartao", (Object)cartaoCredito.getCpfCnpj());
        params.put("email_cartao", (Object)cartaoCredito.getEmail());
        params.put("celular_cartao", cartaoCredito.getCelular());
        params.put("codigo_cvv", (Object)cartaoCredito.getCvv());
        params.put("descricao_pagamento", (Object)descricao);
        params.put("valor", valor);
        params.put("parcela", parcelas);
        httpPost.setEntity((HttpEntity)new StringEntity(params.toString(), StandardCharsets.UTF_8));
        String response = EntityUtils.toString((HttpEntity)client.doRequest((HttpRequestBase)httpPost).getEntity());
        JSONObject responseObject = new JSONObject(response);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        TransacaoCartaoCredito transacaoCartaoCredito = new TransacaoCartaoCredito();
        transacaoCartaoCredito.setId(responseObject.getString("tid"));
        transacaoCartaoCredito.setPrevisaoCredito(dateFormat.parse(responseObject.getString("previsao_credito")));
        transacaoCartaoCredito.setIdConciliacao(responseObject.getString("tid_conciliacao"));
        transacaoCartaoCredito.setBandeira(responseObject.getString("bandeira"));
        transacaoCartaoCredito.setAutorizacao(responseObject.getString("autorizacao"));
        transacaoCartaoCredito.setCartaoTruncado(responseObject.getString("cartao_truncado"));
        transacaoCartaoCredito.setStatusCartao(responseObject.getInt("statuscartao"));
        transacaoCartaoCredito.setTarifa(responseObject.getDouble("tarifa"));
        transacaoCartaoCredito.setTaxa(responseObject.getDouble("taxa"));
        return transacaoCartaoCredito;
    }

    public boolean delete(String idTransacao) throws IOException, ParseException, PJBankException {
        if (StringUtils.isBlank((CharSequence)idTransacao)) {
            throw new IllegalArgumentException("ID da transa\u00e7\u00e3o n\u00e3o informado");
        }
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes/").concat(idTransacao));
        HttpDelete httpDelete = client.getHttpDeleteClient();
        httpDelete.addHeader("x-chave", this.getChave());
        return client.doRequest((HttpRequestBase)httpDelete).getStatusLine().getStatusCode() == 200;
    }

    public List<PagamentoCartaoCredito> get(Map<String, String> filters) throws IOException, ParseException, URISyntaxException, PJBankException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes"));
        HttpGet httpGet = client.getHttpGetClient();
        httpGet.addHeader("x-chave", this.getChave());
        this.adicionarFiltros((HttpRequestBase)httpGet, filters);
        String response = EntityUtils.toString((HttpEntity)client.doRequest((HttpRequestBase)httpGet).getEntity());
        JSONObject responseObject = new JSONObject(response);
        JSONArray extratoObject = responseObject.getJSONArray("extrato");
        int totalItensExtrato = extratoObject.length();
        ArrayList<PagamentoCartaoCredito> pagamentosCartaoCredito = new ArrayList<PagamentoCartaoCredito>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        for (int i = 0; i < totalItensExtrato; ++i) {
            String dataCancelamento;
            JSONObject itemExtrato = extratoObject.getJSONObject(i);
            PagamentoCartaoCredito pagamentoCartaoCredito = new PagamentoCartaoCredito();
            pagamentoCartaoCredito.setId(itemExtrato.getString("tid"));
            pagamentoCartaoCredito.setValor(itemExtrato.getDouble("valor"));
            pagamentoCartaoCredito.setValorLiquido(itemExtrato.getDouble("valor_liquido"));
            pagamentoCartaoCredito.setPedidoNumero(itemExtrato.getString("pedido_numero"));
            pagamentoCartaoCredito.setAutorizada("1".equals(itemExtrato.getString("autorizada")));
            pagamentoCartaoCredito.setCancelada("1".equals(itemExtrato.getString("cancelada")));
            pagamentoCartaoCredito.setParcelas(itemExtrato.getInt("parcelas"));
            String dataTransacao = itemExtrato.getString("data_transacao");
            if (!StringUtils.isBlank((CharSequence)dataTransacao)) {
                pagamentoCartaoCredito.setDataTransacao(dateFormat.parse(dataTransacao));
            }
            if (!StringUtils.isBlank((CharSequence)(dataCancelamento = itemExtrato.getString("data_cancelamento")))) {
                pagamentoCartaoCredito.setDataCancelamento(dateFormat.parse(dataCancelamento));
            }
            pagamentoCartaoCredito.setMotivoCancelamento(itemExtrato.getString("motivo_cancelamento"));
            String previsaoCredito = itemExtrato.getString("previsao_credito");
            if (!StringUtils.isBlank((CharSequence)previsaoCredito)) {
                pagamentoCartaoCredito.setPrevisaoCredito(dateFormat.parse(previsaoCredito));
            }
            pagamentoCartaoCredito.setConvenioProprio(itemExtrato.getString("convenio_proprio"));
            pagamentoCartaoCredito.setIdConciliacao(itemExtrato.getString("tid_conciliacao"));
            pagamentoCartaoCredito.setMsgErro(itemExtrato.getString("msg_erro"));
            pagamentoCartaoCredito.setMsgErroEstorno(itemExtrato.getString("msg_erro_estorno"));
            pagamentosCartaoCredito.add(pagamentoCartaoCredito);
        }
        return pagamentosCartaoCredito;
    }

    private void adicionarFiltros(HttpRequestBase httpRequestClient, Map<String, String> filters) throws URISyntaxException {
        if (filters != null && !filters.isEmpty()) {
            URIBuilder uriBuilder = new URIBuilder(httpRequestClient.getURI());
            for (String key : filters.keySet()) {
                uriBuilder.addParameter(key, filters.get(key));
            }
            httpRequestClient.setURI(uriBuilder.build());
        }
    }
}

