/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.safe2pay_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.ConfiguracaoSafe2PayAPI;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.model.BoletoSafe2PayModelConverter;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.model.cancelamento.BoletoSafe2PayAPICancelarResponse;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.model.consulta.BoletoSafe2PayAPIConsultaResponse;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.model.envio.BoletoSafe2PayAPIEnvioResponse;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.model.envio.Payment;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.RestUtil;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.message.BasicHeader;

public class BancoSafe2PayAPI
extends BoletoController {
    private static final Logger log = Logger.getLogger(BancoSafe2PayAPI.class.getName());

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            String urlPdf = boletoModel.getUrlPdf();
            return BoletoUtil.downloadFile(urlPdf);
        }
        catch (IOException e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    private ConfiguracaoSafe2PayAPI getConfiguracaoSicoob() {
        return (ConfiguracaoSafe2PayAPI)this.getConfiguracao();
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSafe2PayAPI configuracao = this.getConfiguracaoSicoob();
            Payment request = BoletoSafe2PayModelConverter.montaEnviarBoletoRequest(boletoModel, configuracao);
            String json = RestUtil.ObjectToJson(request);
            log.config("Json Envio Boleto: " + json);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("x-api-key", configuracao.getToken())};
            CloseableHttpResponse response = RestUtil.post(configuracao.getUrlBaseBoleto() + configuracao.getUrlBoleto(), headers, json);
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Envio Boleto: " + retorno);
            BoletoSafe2PayAPIEnvioResponse boletoSafe2PayAPIEnvioResponse = RestUtil.JsonToObject(retorno, BoletoSafe2PayAPIEnvioResponse.class);
            if (boletoSafe2PayAPIEnvioResponse == null) {
                throw new BoletoException("Erro ao enviar boleto, retorno nulo.");
            }
            if (boletoSafe2PayAPIEnvioResponse.getHasError() != null && boletoSafe2PayAPIEnvioResponse.getHasError().booleanValue()) {
                throw new BoletoException("Erro ao enviar boleto, c\u00f3digo erro: " + boletoSafe2PayAPIEnvioResponse.getErrorCode());
            }
            return BoletoSafe2PayModelConverter.montaEnviarBoletoResponse(boletoModel, boletoSafe2PayAPIEnvioResponse);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSafe2PayAPI configuracao = this.getConfiguracaoSicoob();
            String numeroBoleto = boletoModel.getNumeroBoleto();
            log.config("numeroBoleto Consulta Boleto: " + numeroBoleto);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("x-api-key", configuracao.getToken())};
            String urlConsulta = configuracao.getUrlBaseTransacao().concat(configuracao.getUrlTransacao()).concat("/Get?Id=").concat(numeroBoleto);
            log.config("Url Consulta Boleto: " + urlConsulta);
            CloseableHttpResponse response = RestUtil.get(urlConsulta, headers);
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Envio Boleto: " + retorno);
            BoletoSafe2PayAPIConsultaResponse boletoSafe2PayAPIConsultaResponse = RestUtil.JsonToObject(retorno, BoletoSafe2PayAPIConsultaResponse.class);
            if (boletoSafe2PayAPIConsultaResponse == null) {
                throw new BoletoException("Erro ao consultar boleto, retorno nulo.");
            }
            if (boletoSafe2PayAPIConsultaResponse.getHasError() != null && boletoSafe2PayAPIConsultaResponse.getHasError().booleanValue()) {
                throw new BoletoException("Erro ao consultar boleto, c\u00f3digo erro: " + boletoSafe2PayAPIConsultaResponse.getErrorCode());
            }
            return BoletoSafe2PayModelConverter.montaConsultarBoletoResponse(boletoModel, boletoSafe2PayAPIConsultaResponse);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSafe2PayAPI configuracao = this.getConfiguracaoSicoob();
            Payment request = BoletoSafe2PayModelConverter.montaAlterarBoletoRequest(boletoModel);
            String json = RestUtil.ObjectToJson(request);
            log.config("Json Alterar Boleto: " + json);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("x-api-key", configuracao.getToken())};
            CloseableHttpResponse response = RestUtil.post(configuracao.getUrlBaseBoleto() + configuracao.getUrlBoleto(), headers, json);
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Alterar Boleto: " + retorno);
            BoletoSafe2PayAPIEnvioResponse boletoSafe2PayAPIEnvioResponse = RestUtil.JsonToObject(retorno, BoletoSafe2PayAPIEnvioResponse.class);
            if (boletoSafe2PayAPIEnvioResponse == null) {
                throw new BoletoException("Erro ao Alterar boleto, retorno nulo.");
            }
            if (boletoSafe2PayAPIEnvioResponse.getHasError() != null && boletoSafe2PayAPIEnvioResponse.getHasError().booleanValue()) {
                throw new BoletoException("Erro ao Alterar boleto, c\u00f3digo erro: " + boletoSafe2PayAPIEnvioResponse.getErrorCode());
            }
            return BoletoSafe2PayModelConverter.montaEnviarBoletoResponse(boletoModel, boletoSafe2PayAPIEnvioResponse);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSafe2PayAPI configuracao = this.getConfiguracaoSicoob();
            String numeroBoleto = boletoModel.getNumeroBoleto();
            log.config("numeroBoleto baixa Boleto: " + numeroBoleto);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("x-api-key", configuracao.getToken())};
            String urlBaixa = configuracao.getUrlBaseTransacao().concat(configuracao.getUrlCancelamento()).concat("/?idTransaction=").concat(numeroBoleto);
            log.config("Url baixa Boleto: " + urlBaixa);
            CloseableHttpResponse response = RestUtil.del(urlBaixa, headers);
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno baixa Boleto: " + retorno);
            BoletoSafe2PayAPICancelarResponse boletoSafe2PayAPICancelarResponse = RestUtil.JsonToObject(retorno, BoletoSafe2PayAPICancelarResponse.class);
            if (boletoSafe2PayAPICancelarResponse == null) {
                throw new BoletoException("Erro ao baixar boleto, retorno nulo.");
            }
            if (boletoSafe2PayAPICancelarResponse.isHasError()) {
                throw new BoletoException("Erro ao baixar boleto, c\u00f3digo erro: " + boletoSafe2PayAPICancelarResponse.getError());
            }
            return BoletoSafe2PayModelConverter.montaBaixaBoletoResponse(boletoModel, boletoSafe2PayAPICancelarResponse);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }
}

