/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.safe2pay_api;

import br.com.java_brasil.boleto.model.Configuracao;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;

public class ConfiguracaoSafe2PayAPI
implements Configuracao {
    @NotEmpty
    private String token;
    @NotEmpty
    private String urlBaseBoleto = "https://payment.safe2pay.com.br";
    @NotEmpty
    private String urlBaseTransacao = "https://api.safe2pay.com.br";
    @NotEmpty
    private String urlBoleto = "/v2/Payment";
    @NotEmpty
    private String urlTransacao = "/v2/transaction";
    @NotEmpty
    private String urlCancelamento = "/v2/BankSlip/WriteOffBankSlip";
    @NotNull
    private boolean sandbox;
    private final String arquivoJasper = "Safe2Pay";
    private final String logo = "LogoSafe2Pay.png";
    private InputStream modeloImpressaoBoleto;
    private HashMap<String, Object> parametrosImpressaoBoleto = new HashMap();

    public HashMap<String, Object> getParametrosImpressaoBoleto() {
        return this.parametrosImpressaoBoleto;
    }

    public void setModeloImpressaoBoleto(InputStream modeloImpressaoBoleto) {
        this.modeloImpressaoBoleto = modeloImpressaoBoleto;
    }

    @Override
    public InputStream modeloImpressaoBoleto() {
        if (this.modeloImpressaoBoleto == null) {
            try {
                this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/Safe2Pay.jasper");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.modeloImpressaoBoleto;
    }

    @Override
    public void usarModeloImpressaoBoletoCarne() {
        try {
            this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoCarne.jasper");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public HashMap<String, Object> parametrosImpressaoBoleto() {
        Image imageLogo = null;
        try {
            InputStream inputStreamLogo = this.getClass().getResourceAsStream("/logo/LogoSafe2Pay.png");
            imageLogo = new ImageIcon(IOUtils.toByteArray((InputStream)inputStreamLogo)).getImage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.parametrosImpressaoBoleto.put("LogoBanco", imageLogo);
        this.parametrosImpressaoBoleto.put("REPORT_LOCALE", new Locale("pt", "BR"));
        return this.parametrosImpressaoBoleto;
    }

    @Override
    public List<String> camposObrigatoriosBoleto() {
        return new ArrayList<String>();
    }

    public String getToken() {
        return this.token;
    }

    public String getUrlBaseBoleto() {
        return this.urlBaseBoleto;
    }

    public String getUrlBaseTransacao() {
        return this.urlBaseTransacao;
    }

    public String getUrlBoleto() {
        return this.urlBoleto;
    }

    public String getUrlTransacao() {
        return this.urlTransacao;
    }

    public String getUrlCancelamento() {
        return this.urlCancelamento;
    }

    @NotNull
    public boolean isSandbox() {
        return this.sandbox;
    }

    public String getArquivoJasper() {
        return this.arquivoJasper;
    }

    public String getLogo() {
        return this.logo;
    }

    public InputStream getModeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setUrlBaseBoleto(String urlBaseBoleto) {
        this.urlBaseBoleto = urlBaseBoleto;
    }

    public void setUrlBaseTransacao(String urlBaseTransacao) {
        this.urlBaseTransacao = urlBaseTransacao;
    }

    public void setUrlBoleto(String urlBoleto) {
        this.urlBoleto = urlBoleto;
    }

    public void setUrlTransacao(String urlTransacao) {
        this.urlTransacao = urlTransacao;
    }

    public void setUrlCancelamento(String urlCancelamento) {
        this.urlCancelamento = urlCancelamento;
    }

    public void setSandbox(@NotNull boolean sandbox) {
        this.sandbox = sandbox;
    }

    public void setParametrosImpressaoBoleto(HashMap<String, Object> parametrosImpressaoBoleto) {
        this.parametrosImpressaoBoleto = parametrosImpressaoBoleto;
    }
}

