/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.safe2pay_api.model.envio;

import br.com.java_brasil.boleto.model.BoletoModel;
import com.fasterxml.jackson.annotation.JsonAlias;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class PaymentObject {
    @JsonAlias(value={"BankSlipNumber"})
    private String bankSlipNumber;
    @JsonAlias(value={"DueDate"})
    private String dueDate;
    @JsonAlias(value={"DigitableLine"})
    private String digitableLine;
    @JsonAlias(value={"Barcode"})
    private String barcode;
    @JsonAlias(value={"BankSlipUrl"})
    private String bankSlipUrl;
    @JsonAlias(value={"Instruction"})
    private String instruction;
    @JsonAlias(value={"Message"})
    private List<String> message = new ArrayList<String>();
    @JsonAlias(value={"PenaltyRate"})
    private Float penaltyRate;
    @JsonAlias(value={"InterestRate"})
    private Float interestRate;
    @JsonAlias(value={"CancelAfterDue"})
    private Boolean cancelAfterDue;
    @JsonAlias(value={"IsEnablePartialPayment"})
    private Boolean isEnablePartialPayment;
    @JsonAlias(value={"DiscountType"})
    private String discountType;
    @JsonAlias(value={"DiscountAmount"})
    private Integer discountAmount;
    @JsonAlias(value={"DiscountDue"})
    private String discountDue;
    @JsonAlias(value={"Command"})
    private Integer command;

    public PaymentObject(LocalDate dataVencimento, int command) {
        this.setDueDate(dataVencimento.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
        this.setCommand(command);
    }

    public PaymentObject(BoletoModel boletoModel) {
        this.setDueDate(boletoModel.getDataVencimento().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
        boletoModel.getDescricoes().forEach(s -> this.getMessage().add(s.getInformacao()));
    }

    public Integer getCommand() {
        return this.command;
    }

    public void setCommand(Integer command) {
        this.command = command;
    }

    public String getBankSlipNumber() {
        return this.bankSlipNumber;
    }

    public void setBankSlipNumber(String bankSlipNumber) {
        this.bankSlipNumber = bankSlipNumber;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public String getDigitableLine() {
        return this.digitableLine;
    }

    public void setDigitableLine(String digitableLine) {
        this.digitableLine = digitableLine;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getBankSlipUrl() {
        return this.bankSlipUrl;
    }

    public void setBankSlipUrl(String bankSlipUrl) {
        this.bankSlipUrl = bankSlipUrl;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public List<String> getMessage() {
        return this.message;
    }

    public void setMessage(List<String> message) {
        this.message = message;
    }

    public Float getPenaltyRate() {
        return this.penaltyRate;
    }

    public void setPenaltyRate(Float penaltyRate) {
        this.penaltyRate = penaltyRate;
    }

    public Float getInterestRate() {
        return this.interestRate;
    }

    public void setInterestRate(Float interestRate) {
        this.interestRate = interestRate;
    }

    public Boolean getCancelAfterDue() {
        return this.cancelAfterDue;
    }

    public void setCancelAfterDue(Boolean cancelAfterDue) {
        this.cancelAfterDue = cancelAfterDue;
    }

    public Boolean getIsEnablePartialPayment() {
        return this.isEnablePartialPayment;
    }

    public void setIsEnablePartialPayment(Boolean isEnablePartialPayment) {
        this.isEnablePartialPayment = isEnablePartialPayment;
    }

    public String getDiscountType() {
        return this.discountType;
    }

    public void setDiscountType(String discountType) {
        this.discountType = discountType;
    }

    public Integer getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(Integer discountAmount) {
        this.discountAmount = discountAmount;
    }

    public String getDiscountDue() {
        return this.discountDue;
    }

    public void setDiscountDue(String discountDue) {
        this.discountDue = discountDue;
    }

    public String toString() {
        return "PaymentObjectBoleto{bankSlipNumber=" + this.bankSlipNumber + ", dueDate=" + this.dueDate + ", digitableLine=" + this.digitableLine + ", barcode=" + this.barcode + ", bankSlipUrl=" + this.bankSlipUrl + ", instruction=" + this.instruction + ", message=" + this.message + ", penaltyRate=" + this.penaltyRate + ", interestRate=" + this.interestRate + ", cancelAfterDue=" + this.cancelAfterDue + ", isEnablePartialPayment=" + this.isEnablePartialPayment + ", discountType=" + this.discountType + ", discountAmount=" + this.discountAmount + ", discountDue=" + this.discountDue + '}';
    }
}

