/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.santander_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.exception.RestException;
import br.com.java_brasil.boleto.model.Beneficiario;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Endereco;
import br.com.java_brasil.boleto.model.Pagador;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import br.com.java_brasil.boleto.model.enums.SituacaoEnum;
import br.com.java_brasil.boleto.service.bancos.santander_api.ConfiguracaoSantanderAPI;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.Beneficiary;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.Boleto;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.Covenant;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.Payer;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.Workspace;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.discount.Discount;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.discount.DiscountRule;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.enums.DiscountType;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.enums.DocumentKind;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.enums.DocumentType;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.enums.EnvironmentType;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.enums.PaymentType;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.enums.ProtestType;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.response.SantanderResponseDTO;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.RestUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Image;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.swing.ImageIcon;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class BancoSantanderAPI
extends BoletoController {
    private static final Logger log = Logger.getLogger("BoletoBancoSantander");
    private static final long MINUTOS_VALIDADE_TOKEN = 15L;
    private final ObjectMapper mapper = new ObjectMapper();
    private static DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new UnsupportedOperationException("N\u00e3o Implementado.");
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        throw new UnsupportedOperationException("N\u00e3o Implementado.");
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            return this.imprimir(boletoModel);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new UnsupportedOperationException("N\u00e3o Implementado.");
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new UnsupportedOperationException("N\u00e3o Implementado.");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new UnsupportedOperationException("N\u00e3o Implementado.");
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        ConfiguracaoSantanderAPI configuracao = (ConfiguracaoSantanderAPI)this.getConfiguracao();
        this.preparaWorkspace();
        HttpPost request = new HttpPost(configuracao.getURLBase() + "/collection_bill_management/v2/workspaces/" + configuracao.getWorkspaceId() + "/bank_slips");
        request.setHeaders(this.headerAuth());
        Boleto boleto = this.converteBoletoModelToBoleto(boletoModel);
        String json = RestUtil.ObjectToJson(boleto);
        request.setEntity((HttpEntity)new StringEntity(json));
        try {
            CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)request, configuracao.getCaminhoCertificado(), configuracao.getSenhaCertificado());
            String s = RestUtil.validaResponseERetornaBody(response);
            Boleto b = RestUtil.JsonToObject(s, Boleto.class);
            return this.converteBoletoToBoletoModel(Objects.requireNonNull(b));
        }
        catch (Exception e) {
            String msg = this.parseMessage(e.getMessage());
            throw new BoletoException("Erro ao enviar boleto: " + msg);
        }
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        ConfiguracaoSantanderAPI configuracao = (ConfiguracaoSantanderAPI)this.getConfiguracao();
        this.preparaWorkspace();
        HttpPatch request = new HttpPatch(configuracao.getURLBase() + "/collection_bill_management/v2/workspaces/" + configuracao.getWorkspaceId() + "/bank_slips");
        request.setHeaders(this.headerAuth());
        Boleto boleto = new Boleto();
        if (boletoModel.getDataVencimento() != null) {
            boleto.setDueDate(String.valueOf(boletoModel.getDataVencimento()));
        }
        if (boletoModel.getEspecieDocumento() != null && (boletoModel.getEspecieDocumento().equals("BCC") || boletoModel.getEspecieDocumento().equals("BDP")) && boletoModel.getValorBoleto() != null) {
            boleto.setNominalValue(boletoModel.getValorBoleto());
        }
        if (Objects.nonNull(boletoModel.getDiasProtesto()) && boletoModel.getDiasProtesto() >= 0 && boletoModel.getDiasProtesto() <= 99) {
            boleto.setProtestQuantityDays(boletoModel.getDiasProtesto());
        }
        if (this.converteDesconto(boletoModel).getDiscountOne() != null || this.converteDesconto(boletoModel).getDiscountTwo() != null || this.converteDesconto(boletoModel).getDiscountThree() != null) {
            boleto.setDiscount(this.converteDesconto(boletoModel));
        }
        if (boletoModel.getPercentualMulta() != null && boletoModel.getPercentualMulta().compareTo(BigDecimal.ZERO) >= 0 && Objects.nonNull(boletoModel.getDiasMulta()) && boletoModel.getDiasMulta() >= 0 && boletoModel.getDiasMulta() <= 99) {
            String dataMulta = LocalDate.now().plusDays(boletoModel.getDiasMulta()).format(DATE_FORMATTER);
            boleto.setFinePercentage(boletoModel.getPercentualMulta());
            boleto.setFineDate(dataMulta);
        }
        if (boletoModel.getPercentualMinPagamentoParcial() != null && boletoModel.getPercentualMinPagamentoParcial().compareTo(BigDecimal.ZERO) > 0 && boletoModel.getPercentualMinPagamentoParcial().compareTo(BigDecimal.valueOf(100L)) <= 0) {
            boleto.setMinValueOrPercentage(String.valueOf(boletoModel.getValorMinPagamentoParcial()));
        }
        if (boletoModel.getPercentualMaxPagamentoParcial() != null && boletoModel.getPercentualMaxPagamentoParcial().compareTo(BigDecimal.ZERO) > 0 && boletoModel.getPercentualMaxPagamentoParcial().compareTo(BigDecimal.valueOf(100L)) <= 0) {
            boleto.setMaxValueOrPercentage(String.valueOf(boletoModel.getValorMaxPagamentoParcial()));
        }
        boleto.setNsuCode(boletoModel.getNumeroBoleto());
        boleto.setCovenantCode(boletoModel.getCodigoConvenio());
        boleto.setDocumentKind(null);
        boleto.setMessages(null);
        boleto.setBankNumber(boletoModel.getNossoNumero());
        boleto.setCovenantCode(boletoModel.getCodigoConvenio());
        String json = RestUtil.ObjectToJson(boleto);
        request.setEntity((HttpEntity)new StringEntity(json));
        try {
            CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)request, configuracao.getCaminhoCertificado(), configuracao.getSenhaCertificado());
            String s = RestUtil.validaResponseERetornaBody(response);
            Boleto b = RestUtil.JsonToObject(s, Boleto.class);
            b.setIssueDate(b.getIssueDate() == null ? boletoModel.getDataEmissao().format(DATE_FORMATTER) : b.getIssueDate());
            b.setDueDate(b.getDueDate() == null ? boletoModel.getDataVencimento().format(DATE_FORMATTER) : b.getDueDate());
            b.setFineQuantityDays(b.getFineQuantityDays() == null ? boletoModel.getDiasMulta() : b.getFineQuantityDays().intValue());
            b.setBeneficiary(b.getBeneficiary() == null ? this.converteBeneficiario(boletoModel) : b.getBeneficiary());
            b.setPayer(b.getPayer() == null ? this.convertePagador(boletoModel) : b.getPayer());
            b.setDiscount(b.getDiscount() == null ? this.converteDesconto(boletoModel) : b.getDiscount());
            b.setCovenantCode(boletoModel.getCodigoConvenio());
            return this.converteBoletoToBoletoModel(b);
        }
        catch (Exception e) {
            String formattedError = this.parseMessage(e.getMessage());
            throw new BoletoException("Erro ao alterar boleto: " + formattedError);
        }
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        String ambiente;
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        ConfiguracaoSantanderAPI configuracao = (ConfiguracaoSantanderAPI)this.getConfiguracao();
        String string = ambiente = configuracao.getAmbiente().equals((Object)AmbienteEnum.PRODUCAO) ? "P" : "T";
        if (configuracao.getWorkspaceId() == null) {
            this.preparaWorkspace();
        }
        String bankSlipId = boletoModel.getNumeroBoleto() + "." + boletoModel.getDataEmissao().format(DATE_FORMATTER) + "." + ambiente + "." + configuracao.getCodigoConvenio() + "." + boletoModel.getNossoNumero();
        HttpGet request = new HttpGet(configuracao.getURLBase() + "/collection_bill_management/v2/workspaces/" + configuracao.getWorkspaceId() + "/bank_slips/" + bankSlipId);
        request.setHeaders(this.headerAuth());
        try {
            CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)request, configuracao.getCaminhoCertificado(), configuracao.getSenhaCertificado());
            String s = RestUtil.validaResponseERetornaBody(response);
            Boleto b = RestUtil.JsonToObject(s, Boleto.class);
            HttpGet get = new HttpGet(configuracao.getURLBase() + "/collection_bill_management/v2/bills/" + configuracao.getCodigoConvenio() + "." + boletoModel.getNossoNumero() + "?tipoConsulta=settlement");
            get.setHeaders(this.headerAuth());
            CloseableHttpResponse resp = RestUtil.enviaComandoCertificado((HttpUriRequest)get, configuracao.getCaminhoCertificado(), configuracao.getSenhaCertificado());
            String body = RestUtil.validaResponseERetornaBody(resp);
            Boleto bb = RestUtil.JsonToObject(body, Boleto.class);
            if (bb.getStatus() != null) {
                b.setStatus(bb.getStatus());
            }
            b.setCovenantCode(boletoModel.getCodigoConvenio());
            return this.converteBoletoToBoletoModel(b);
        }
        catch (RestException e) {
            String msg = this.parseMessage(e.getMessage());
            throw new BoletoException("Erro ao consultar boleto: " + msg);
        }
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        ConfiguracaoSantanderAPI configuracao = (ConfiguracaoSantanderAPI)this.getConfiguracao();
        this.preparaWorkspace();
        HttpPatch request = new HttpPatch(configuracao.getURLBase() + "/collection_bill_management/v2/workspaces/" + configuracao.getWorkspaceId() + "/bank_slips");
        request.setHeaders(this.headerAuth());
        Boleto boleto = new Boleto();
        boleto.setNsuCode(boletoModel.getNumeroBoleto());
        boleto.setCovenantCode(boletoModel.getCodigoConvenio());
        if (Objects.isNull(boletoModel.getOperacao()) || boletoModel.getOperacao().isEmpty()) {
            throw new BoletoException("Informe a opera\u00e7\u00e3o a ser realizada: BAIXAR, PROTESTAR ou CANCELAR_PROTESTO.");
        }
        if (boletoModel.getOperacao().equals("BAIXAR")) {
            boleto.setOperation("BAIXAR");
        } else if (boletoModel.getOperacao().equals("PROTESTAR")) {
            boleto.setOperation("PROTESTAR");
        } else if (boletoModel.getOperacao().equals("CANCELAR_PROTESTO")) {
            boleto.setOperation("CANCELAR_PROTESTO");
        } else {
            throw new BoletoException("Opera\u00e7\u00e3o inv\u00e1lida. Informe BAIXAR, PROTESTAR ou CANCELAR_PROTESTO.");
        }
        boleto.setDocumentKind(null);
        boleto.setMessages(null);
        boleto.setBankNumber(boletoModel.getNossoNumero());
        boleto.setCovenantCode(boletoModel.getCodigoConvenio());
        String json = RestUtil.ObjectToJson(boleto);
        request.setEntity((HttpEntity)new StringEntity(json));
        try {
            CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)request, configuracao.getCaminhoCertificado(), configuracao.getSenhaCertificado());
            String s = RestUtil.validaResponseERetornaBody(response);
            Boleto b = RestUtil.JsonToObject(s, Boleto.class);
            b.setIssueDate(b.getIssueDate() == null ? boletoModel.getDataEmissao().format(DATE_FORMATTER) : b.getIssueDate());
            b.setDueDate(b.getDueDate() == null ? boletoModel.getDataVencimento().format(DATE_FORMATTER) : b.getDueDate());
            b.setFineQuantityDays(b.getFineQuantityDays() == null ? boletoModel.getDiasMulta() : b.getFineQuantityDays().intValue());
            b.setBeneficiary(b.getBeneficiary() == null ? this.converteBeneficiario(boletoModel) : b.getBeneficiary());
            b.setPayer(b.getPayer() == null ? this.convertePagador(boletoModel) : b.getPayer());
            b.setDiscount(b.getDiscount() == null ? this.converteDesconto(boletoModel) : b.getDiscount());
            b.setCovenantCode(boletoModel.getCodigoConvenio());
            return this.converteBoletoToBoletoModel(b);
        }
        catch (Exception e) {
            String formattedError = this.parseMessage(e.getMessage());
            throw new BoletoException("Erro ao alterar boleto: " + formattedError);
        }
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    private void preparaWorkspace() {
        ConfiguracaoSantanderAPI configuracao = (ConfiguracaoSantanderAPI)this.getConfiguracao();
        HttpGet request = new HttpGet(configuracao.getURLBase() + "/collection_bill_management/v2/workspaces");
        request.setHeaders(this.headerAuth());
        CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)request, configuracao.getCaminhoCertificado(), configuracao.getSenhaCertificado());
        String json = RestUtil.validaResponseERetornaBody(response);
        SantanderResponseDTO dto = RestUtil.JsonToObject(json, SantanderResponseDTO.class);
        if (dto.getContent() == null || dto.getContent().isEmpty()) {
            this.registrarWorkspace();
        } else {
            List workspaces = dto.getContent();
            Workspace workspace = (Workspace)this.mapper.convertValue(workspaces.get(0), Workspace.class);
            configuracao.setWorkspaceId(workspace.getId());
        }
    }

    private void registrarWorkspace() {
        ConfiguracaoSantanderAPI configuracao = (ConfiguracaoSantanderAPI)this.getConfiguracao();
        Workspace workSpaceDefault = Workspace.builder().type("BILLING").covenants(Collections.singletonList(Covenant.builder().code(configuracao.getCodigoConvenio()).build())).description("Workspace default").build();
        String json = RestUtil.ObjectToJson(workSpaceDefault);
        HttpPost request = new HttpPost(configuracao.getURLBase() + "/collection_bill_management/v2/workspaces");
        request.setHeaders(this.headerAuth());
        request.setEntity((HttpEntity)new StringEntity(json, "UTF-8"));
        try {
            CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)request, configuracao.getCaminhoCertificado(), configuracao.getSenhaCertificado());
            String s = RestUtil.validaResponseERetornaBody(response);
            Workspace workspace = RestUtil.JsonToObject(s, Workspace.class);
            configuracao.setWorkspaceId(workspace.getId());
        }
        catch (Exception e) {
            String msg = this.parseMessage(e.getMessage());
            throw new RestException("Erro ao registrar workspace: " + msg);
        }
    }

    private void autenticar() {
        ConfiguracaoSantanderAPI configuracao = (ConfiguracaoSantanderAPI)this.getConfiguracao();
        Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/x-www-form-urlencoded")};
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("grant_type", "client_credentials"));
        nvps.add(new BasicNameValuePair("client_id", configuracao.getClientId()));
        nvps.add(new BasicNameValuePair("client_secret", configuracao.getClientSecret()));
        HttpPost httpPost = new HttpPost(configuracao.getURLToken());
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        httpPost.setHeaders(headers);
        CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)httpPost, configuracao.getCaminhoCertificado(), configuracao.getSenhaCertificado());
        try {
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Token Santander: " + retorno);
            JsonObject json = JsonParser.parseString((String)retorno).getAsJsonObject();
            String token = json.get("access_token").getAsString();
            LocalDateTime expires = LocalDateTime.now().plusSeconds(json.get("expires_in").getAsInt());
            log.config("Token Santander: " + token);
            log.config("Expiracao: " + expires);
            configuracao.setToken(token);
            configuracao.setExpiracaoToken(expires);
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    private Header[] headerAuth() {
        ConfiguracaoSantanderAPI configuracao = (ConfiguracaoSantanderAPI)this.getConfiguracao();
        if (Objects.isNull(configuracao.getToken()) || configuracao.getToken().isEmpty() || configuracao.getExpiracaoToken() == null || configuracao.getExpiracaoToken().isBefore(LocalDateTime.now().minusMinutes(15L))) {
            this.autenticar();
        }
        return new Header[]{new BasicHeader("Authorization", "Bearer " + configuracao.getToken()), new BasicHeader("X-Application-Key", configuracao.getClientId())};
    }

    private BoletoModel converteBoletoToBoletoModel(Boleto b) {
        BoletoModel boletoModel = new BoletoModel();
        boletoModel.setNumeroBoleto(b.getNsuCode());
        boletoModel.setNumeroDocumento(b.getClientNumber());
        boletoModel.setCodigoBarras(b.getBarCode());
        boletoModel.setLinhaDigitavel(b.getDigitableLine());
        boletoModel.setDataVencimento(LocalDate.parse(b.getDueDate(), DATE_FORMATTER));
        boletoModel.setDataEmissao(LocalDate.parse(b.getIssueDate(), DATE_FORMATTER));
        boletoModel.setValorBoleto(b.getNominalValue());
        boletoModel.setPercentualMulta(b.getFinePercentage());
        boletoModel.setDiasMulta(b.getFineQuantityDays() == null ? 0 : b.getFineQuantityDays());
        boletoModel.setPercentualJuros(b.getInterestPercentage());
        boletoModel.setDiasProtesto(b.getProtestQuantityDays() == null ? 0 : b.getProtestQuantityDays());
        boletoModel.setNumeroTotalDeParcelasCarne(b.getParcelsQuantity() == null ? 0 : b.getParcelsQuantity());
        boletoModel.setNossoNumero(b.getBankNumber());
        boletoModel.setCodigoConvenio(b.getCovenantCode());
        if (b.getStatus() != null) {
            switch (b.getStatus()) {
                case "ATIVO": 
                case "LIQUIDADO_PARCIAL": {
                    boletoModel.setSituacao(SituacaoEnum.EM_ABERTO);
                    break;
                }
                case "BAIXADO": {
                    boletoModel.setSituacao(SituacaoEnum.BAIXADO);
                    break;
                }
                case "LIQUIDADO": {
                    boletoModel.setSituacao(SituacaoEnum.LIQUIDADO);
                }
            }
        }
        boletoModel.setBeneficiario(this.converteBeneficiario(b));
        boletoModel.setPagador(this.convertePagador(b));
        this.converteDesconto(b, boletoModel);
        return boletoModel;
    }

    private Boleto converteBoletoModelToBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        ConfiguracaoSantanderAPI configuracao = (ConfiguracaoSantanderAPI)this.getConfiguracao();
        LocalDateTime now = LocalDateTime.now();
        return Boleto.builder().nsuCode(boletoModel.getNumeroBoleto()).nsuDate(now.format(DATE_FORMATTER)).environment(configuracao.getAmbiente().equals((Object)AmbienteEnum.PRODUCAO) ? EnvironmentType.PRODUCAO : EnvironmentType.TESTE).clientNumber(boletoModel.getNumeroDocumento()).bankNumber(boletoModel.getNossoNumero()).covenantCode(configuracao.getCodigoConvenio()).beneficiary(this.converteBeneficiario(boletoModel)).payer(this.convertePagador(boletoModel)).barCode(boletoModel.getCodigoBarras()).dueDate(boletoModel.getDataVencimento().format(DATE_FORMATTER)).issueDate(boletoModel.getDataEmissao().format(DATE_FORMATTER)).nominalValue(boletoModel.getValorBoleto()).discount(this.converteDesconto(boletoModel)).documentKind(DocumentKind.OUTROS.name()).finePercentage(boletoModel.getPercentualMulta()).fineQuantityDays(boletoModel.getDiasMulta()).interestPercentage(boletoModel.getPercentualJuros()).protestQuantityDays(boletoModel.getDiasProtesto()).protestType(ProtestType.DIAS_CORRIDOS.name()).paymentType(PaymentType.REGISTRO.name()).parcelsQuantity(boletoModel.getNumeroTotalDeParcelasCarne() == 0 ? null : Integer.valueOf(boletoModel.getNumeroTotalDeParcelasCarne())).build();
    }

    private Discount converteDesconto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        DiscountRule one = new DiscountRule();
        if (!Objects.equals(boletoModel.getValorPercentualDescontos(), BigDecimal.ZERO)) {
            one.setLimitDate(boletoModel.getDataLimiteParaDesconto().format(DATE_FORMATTER));
            one.setValue(boletoModel.getValorPercentualDescontos());
        }
        DiscountRule two = new DiscountRule();
        if (!Objects.equals(boletoModel.getValorPercentualDescontos2(), BigDecimal.ZERO)) {
            two.setLimitDate(boletoModel.getDataLimiteParaDesconto2().format(DATE_FORMATTER));
            two.setValue(boletoModel.getValorPercentualDescontos2());
        }
        DiscountRule three = new DiscountRule();
        if (!Objects.equals(boletoModel.getValorPercentualDescontos3(), BigDecimal.ZERO)) {
            three.setLimitDate(boletoModel.getDataLimiteParaDesconto3().format(DATE_FORMATTER));
            three.setValue(boletoModel.getValorPercentualDescontos3());
        }
        Discount discount = new Discount();
        discount.setDiscountOne(one.getValue() == null ? null : one);
        discount.setDiscountTwo(two.getValue() == null ? null : two);
        discount.setDiscountThree(three.getValue() == null ? null : three);
        discount.setType(DiscountType.VALOR_DATA_FIXA.name());
        return discount;
    }

    private void converteDesconto(@NonNull Boleto boleto, BoletoModel boletoModel) {
        if (boleto == null) {
            throw new NullPointerException("boleto is marked non-null but is null");
        }
        if (boleto.getDiscount() != null) {
            BigDecimal value;
            String limitDate;
            if (boleto.getDiscount().getDiscountOne() != null && boleto.getDiscount().getDiscountOne().getValue() != null) {
                limitDate = boleto.getDiscount().getDiscountOne().getLimitDate();
                value = boleto.getDiscount().getDiscountOne().getValue();
                boletoModel.setDataLimiteParaDesconto(LocalDate.parse(limitDate, DATE_FORMATTER));
                boletoModel.setValorPercentualDescontos(value);
            }
            if (boleto.getDiscount().getDiscountTwo() != null && boleto.getDiscount().getDiscountTwo().getValue() != null) {
                limitDate = boleto.getDiscount().getDiscountTwo().getLimitDate();
                value = boleto.getDiscount().getDiscountTwo().getValue();
                boletoModel.setDataLimiteParaDesconto2(LocalDate.parse(limitDate, DATE_FORMATTER));
                boletoModel.setValorPercentualDescontos2(value);
            }
            if (boleto.getDiscount().getDiscountThree() != null && boleto.getDiscount().getDiscountThree().getValue() != null) {
                limitDate = boleto.getDiscount().getDiscountThree().getLimitDate();
                value = boleto.getDiscount().getDiscountThree().getValue();
                boletoModel.setDataLimiteParaDesconto3(LocalDate.parse(limitDate, DATE_FORMATTER));
                boletoModel.setValorPercentualDescontos3(value);
            }
        }
    }

    private Payer convertePagador(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        Payer payer = new Payer();
        Pagador pagador = boletoModel.getPagador();
        Endereco endereco = pagador.getEndereco();
        payer.setName(pagador.getNome());
        payer.setDocumentNumber(pagador.getDocumento());
        payer.setDocumentType(pagador.getDocumento() != null && pagador.getDocumento().replaceAll("\\D", "").length() == 11 ? DocumentType.CPF.name() : DocumentType.CNPJ.name());
        payer.setAddress(endereco.getLogradouro());
        payer.setCity(endereco.getCidade());
        payer.setState(endereco.getUf());
        payer.setNeighborhood(endereco.getBairro());
        payer.setZipCode(endereco.getCep());
        return payer;
    }

    private Pagador convertePagador(@NonNull Boleto boleto) {
        if (boleto == null) {
            throw new NullPointerException("boleto is marked non-null but is null");
        }
        Pagador pagador = new Pagador();
        pagador.setNome(boleto.getPayer().getName());
        pagador.setDocumento(boleto.getPayer().getDocumentNumber());
        Endereco endereco = new Endereco();
        endereco.setLogradouro(boleto.getPayer().getAddress());
        endereco.setCidade(boleto.getPayer().getCity());
        endereco.setUf(boleto.getPayer().getState());
        endereco.setBairro(boleto.getPayer().getNeighborhood());
        endereco.setCep(boleto.getPayer().getZipCode());
        pagador.setEndereco(endereco);
        return pagador;
    }

    private Beneficiary converteBeneficiario(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        Beneficiary beneficiary = new Beneficiary();
        Beneficiario beneficiario = boletoModel.getBeneficiario();
        beneficiary.setName(beneficiario.getNomeBeneficiario());
        beneficiary.setDocumentNumber(beneficiario.getDocumento());
        beneficiary.setDocumentType(beneficiario.getDocumento() != null && beneficiario.getDocumento().replaceAll("\\D", "").length() == 11 ? DocumentType.CPF.name() : DocumentType.CNPJ.name());
        return beneficiary;
    }

    private Beneficiario converteBeneficiario(@NonNull Boleto boleto) {
        if (boleto == null) {
            throw new NullPointerException("boleto is marked non-null but is null");
        }
        Beneficiario beneficiario = new Beneficiario();
        beneficiario.setNomeBeneficiario(boleto.getBeneficiary().getName());
        beneficiario.setDocumento(boleto.getBeneficiary().getDocumentNumber());
        return beneficiario;
    }

    private byte[] imprimir(BoletoModel boletoModel) throws Exception {
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("REPORT_LOCALE", new Locale("pt", "BR"));
        parametros.put("CodigoBanco", "033");
        String caminhoLogo = "/logo/LogoBancoSantander.png";
        InputStream logoStream = this.getClass().getResourceAsStream(caminhoLogo);
        if (logoStream == null) {
            throw new BoletoException("ERRO: Imagem do logo n\u00e3o encontrada em 'src/main/resources" + caminhoLogo + "'.");
        }
        Image logoImage = new ImageIcon(IOUtils.toByteArray((InputStream)logoStream)).getImage();
        parametros.put("LogoBanco", logoImage);
        return JasperUtil.geraRelatorio(Collections.singletonList(boletoModel), parametros, "BoletoSantander", this.getClass(), new HashMap<String, String>());
    }

    private String parseMessage(String message) {
        try {
            ObjectMapper mapper;
            JsonNode json;
            JsonNode errors;
            if (message == null) {
                return "_";
            }
            int jsonStart = message.indexOf("{");
            if (jsonStart > 0) {
                message = message.substring(jsonStart);
            }
            if ((errors = (json = (mapper = new ObjectMapper()).readTree(message)).get("_errors")) != null && errors.isArray() && errors.size() > 0) {
                JsonNode firstError = errors.get(0);
                String code = firstError.has("_code") ? firstError.get("_code").asText() : "";
                String msg = firstError.has("_message") ? firstError.get("_message").asText() : "";
                return code + "_" + msg;
            }
            String code = json.has("_errorCode") ? json.get("_errorCode").asText() : "";
            String msg = json.has("_message") ? json.get("_message").asText() : "";
            return code + "_" + msg;
        }
        catch (Exception ex) {
            return message;
        }
    }
}

