/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.santander_api;

import br.com.java_brasil.boleto.model.Configuracao;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class ConfiguracaoSantanderAPI
implements Configuracao {
    @NotEmpty
    private String clientId;
    @NotEmpty
    private String clientSecret;
    @NotEmpty
    private String caminhoCertificado;
    @NotEmpty
    private String senhaCertificado;
    @NotNull
    private AmbienteEnum ambiente;
    @NotEmpty
    private String urlTokenProducao = "https://trust-open.api.santander.com.br/auth/oauth/v2/token";
    @NotEmpty
    private String urlTokenHomologacao = "https://trust-sandbox.api.santander.com.br/auth/oauth/v2/token";
    @NotEmpty
    private String urlBaseProducao = "https://trust-open.api.santander.com.br";
    @NotEmpty
    private String urlBaseHomologacao = "https://trust-sandbox.api.santander.com.br";
    private String codigoConvenio;
    private String token;
    private LocalDateTime expiracaoToken;
    private String workspaceId;
    private final String arquivoJasper = "BoletoBancoSantander";
    private final String logo = "LogoBancoSantander.png";
    private InputStream modeloImpressaoBoleto;
    private HashMap<String, Object> parametrosImpressaoBoleto = new HashMap();

    @Override
    public InputStream modeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    @Override
    public void usarModeloImpressaoBoletoCarne() {
        try {
            this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoCarne.jasper");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public HashMap<String, Object> parametrosImpressaoBoleto() throws IOException {
        return this.parametrosImpressaoBoleto;
    }

    @Override
    public List<String> camposObrigatoriosBoleto() {
        return Arrays.asList("dataVencimento", "dataEmissao", "beneficiario.numeroConvenio", "beneficiario.carteira", "beneficiario.variacaoCarteira", "beneficiario.documento", "beneficiario.agencia", "beneficiario.conta", "codigoModalidade", "dataVencimento", "valorBoleto", "aceite", "especieDocumento", "numeroDocumento", "numeroDaParcelaCarne,max:3", "pagador.documento", "pagador.nome", "pagador.endereco.logradouro", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.cep", "pagador.endereco.uf", "pagador");
    }

    public String getURLBase() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlBaseProducao : this.urlBaseHomologacao;
    }

    public String getURLToken() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlTokenProducao : this.urlTokenHomologacao;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getCaminhoCertificado() {
        return this.caminhoCertificado;
    }

    public String getSenhaCertificado() {
        return this.senhaCertificado;
    }

    @NotNull
    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    public String getUrlTokenProducao() {
        return this.urlTokenProducao;
    }

    public String getUrlTokenHomologacao() {
        return this.urlTokenHomologacao;
    }

    public String getUrlBaseProducao() {
        return this.urlBaseProducao;
    }

    public String getUrlBaseHomologacao() {
        return this.urlBaseHomologacao;
    }

    public String getCodigoConvenio() {
        return this.codigoConvenio;
    }

    public String getToken() {
        return this.token;
    }

    public LocalDateTime getExpiracaoToken() {
        return this.expiracaoToken;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getArquivoJasper() {
        return this.arquivoJasper;
    }

    public String getLogo() {
        return this.logo;
    }

    public InputStream getModeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    public HashMap<String, Object> getParametrosImpressaoBoleto() {
        return this.parametrosImpressaoBoleto;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setCaminhoCertificado(String caminhoCertificado) {
        this.caminhoCertificado = caminhoCertificado;
    }

    public void setSenhaCertificado(String senhaCertificado) {
        this.senhaCertificado = senhaCertificado;
    }

    public void setAmbiente(@NotNull AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public void setUrlTokenProducao(String urlTokenProducao) {
        this.urlTokenProducao = urlTokenProducao;
    }

    public void setUrlTokenHomologacao(String urlTokenHomologacao) {
        this.urlTokenHomologacao = urlTokenHomologacao;
    }

    public void setUrlBaseProducao(String urlBaseProducao) {
        this.urlBaseProducao = urlBaseProducao;
    }

    public void setUrlBaseHomologacao(String urlBaseHomologacao) {
        this.urlBaseHomologacao = urlBaseHomologacao;
    }

    public void setCodigoConvenio(String codigoConvenio) {
        this.codigoConvenio = codigoConvenio;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setExpiracaoToken(LocalDateTime expiracaoToken) {
        this.expiracaoToken = expiracaoToken;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public void setModeloImpressaoBoleto(InputStream modeloImpressaoBoleto) {
        this.modeloImpressaoBoleto = modeloImpressaoBoleto;
    }

    public void setParametrosImpressaoBoleto(HashMap<String, Object> parametrosImpressaoBoleto) {
        this.parametrosImpressaoBoleto = parametrosImpressaoBoleto;
    }
}

