/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.santander_api.model.request;

import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.Beneficiary;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.Key;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.Payer;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.Sharing;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.discount.Discount;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.enums.DocumentKind;
import br.com.java_brasil.boleto.service.bancos.santander_api.model.request.enums.EnvironmentType;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class Boleto {
    private EnvironmentType environment;
    @Size(min=1, max=20, message="Valor tem que ser entre 1 e 20")
    @Pattern(regexp="^[A-Za-z0-9]{1,20}$")
    @NotBlank
    private @Size(min=1, max=20, message="Valor tem que ser entre 1 e 20") @Pattern(regexp="^[A-Za-z0-9]{1,20}$") @NotBlank String nsuCode;
    @Pattern(regexp="yyyy-MM-dd")
    @NotBlank
    private @Pattern(regexp="yyyy-MM-dd") @NotBlank String nsuDate;
    @Size(min=1, max=9, message="Valor tem que ser entre 1 e 9")
    @Pattern(regexp="^[0-9]{1,9}$")
    @NotBlank
    private @Size(min=1, max=9, message="Valor tem que ser entre 1 e 9") @Pattern(regexp="^[0-9]{1,9}$") @NotBlank String covenantCode;
    @Size(min=1, max=13, message="Valor tem que ser entre 1 e 13")
    @Pattern(regexp="^[0-9]{1,13}$")
    @NotBlank
    private @Size(min=1, max=13, message="Valor tem que ser entre 1 e 13") @Pattern(regexp="^[0-9]{1,13}$") @NotBlank String bankNumber;
    @Size(min=1, max=15, message="Valor tem que ser entre 1 e 15")
    @Pattern(regexp="^[0-9a-zA-Z ]{1,15}$")
    private @Size(min=1, max=15, message="Valor tem que ser entre 1 e 15") @Pattern(regexp="^[0-9a-zA-Z ]{1,15}$") String clientNumber;
    @Pattern(regexp="yyyy-MM-dd")
    @NotBlank
    private @Pattern(regexp="yyyy-MM-dd") @NotBlank String dueDate;
    @Pattern(regexp="yyyy-MM-dd")
    @NotBlank
    private @Pattern(regexp="yyyy-MM-dd") @NotBlank String issueDate;
    @Pattern(regexp="^[0-9a-zA-Z ]{1,25}$")
    private @Pattern(regexp="^[0-9a-zA-Z ]{1,25}$") String participantCode;
    @Pattern(regexp="^[0-9]{1,13}\\.[0-9]{2}$")
    @NotBlank
    private @Pattern(regexp="^[0-9]{1,13}\\.[0-9]{2}$") @NotBlank BigDecimal nominalValue;
    @Valid
    private Payer payer;
    @Valid
    private Beneficiary beneficiary;
    private String documentKind = DocumentKind.DUPLICATA_MERCANTIL.name();
    @Valid
    private Discount discount;
    @Pattern(regexp="^[0-9]{1,3}\\.[0-9]{2}$")
    private @Pattern(regexp="^[0-9]{1,3}\\.[0-9]{2}$") BigDecimal finePercentage;
    @Pattern(regexp="^[0-9]{1,2}")
    private @Pattern(regexp="^[0-9]{1,2}") Integer fineQuantityDays;
    @Pattern(regexp="yyyy-MM-dd")
    private @Pattern(regexp="yyyy-MM-dd") String fineDate;
    @Pattern(regexp="^[0-9]{1,3}\\.[0-9]{2}$")
    private @Pattern(regexp="^[0-9]{1,3}\\.[0-9]{2}$") BigDecimal interestPercentage;
    @Pattern(regexp="^[0-9]{1,13}\\.[0-9]{2}$")
    private @Pattern(regexp="^[0-9]{1,13}\\.[0-9]{2}$") BigDecimal deductionValue;
    private String protestType;
    @Size(min=1, max=2, message="Valor tem que ser entre 1 e 2")
    private @Size(min=1, max=2, message="Valor tem que ser entre 1 e 2") Integer protestQuantityDays;
    @Size(min=1, max=2, message="Valor tem que ser entre 1 e 2")
    private @Size(min=1, max=2, message="Valor tem que ser entre 1 e 2") String writeOffQuantityDays;
    private String paymentType;
    private Integer parcelsQuantity;
    private String valueType;
    @Pattern(regexp="\\d{15}$\\.\\d{2}")
    private @Pattern(regexp="\\d{15}$\\.\\d{2}") String minValueOrPercentage;
    @Pattern(regexp="\\d{15}$\\.\\d{2}")
    private @Pattern(regexp="\\d{15}$\\.\\d{2}") String maxValueOrPercentage;
    @Pattern(regexp="\\d{3}$\\.\\d{5}")
    private @Pattern(regexp="\\d{3}$\\.\\d{5}") String iofPercentage;
    private ArrayList<Sharing> sharing;
    private Key key;
    private String txId;
    private ArrayList<String> messages = new ArrayList();
    private String barCode;
    private String digitableLine;
    private String entryDate;
    private String qrCodePix;
    private String qrCodeUrl;
    private String status;
    private String statusComplement;
    private String operation;

    public static BoletoBuilder builder() {
        return new BoletoBuilder();
    }

    public BoletoBuilder toBuilder() {
        return new BoletoBuilder().environment(this.environment).nsuCode(this.nsuCode).nsuDate(this.nsuDate).covenantCode(this.covenantCode).bankNumber(this.bankNumber).clientNumber(this.clientNumber).dueDate(this.dueDate).issueDate(this.issueDate).participantCode(this.participantCode).nominalValue(this.nominalValue).payer(this.payer).beneficiary(this.beneficiary).documentKind(this.documentKind).discount(this.discount).finePercentage(this.finePercentage).fineQuantityDays(this.fineQuantityDays).fineDate(this.fineDate).interestPercentage(this.interestPercentage).deductionValue(this.deductionValue).protestType(this.protestType).protestQuantityDays(this.protestQuantityDays).writeOffQuantityDays(this.writeOffQuantityDays).paymentType(this.paymentType).parcelsQuantity(this.parcelsQuantity).valueType(this.valueType).minValueOrPercentage(this.minValueOrPercentage).maxValueOrPercentage(this.maxValueOrPercentage).iofPercentage(this.iofPercentage).sharing(this.sharing).key(this.key).txId(this.txId).messages(this.messages).barCode(this.barCode).digitableLine(this.digitableLine).entryDate(this.entryDate).qrCodePix(this.qrCodePix).qrCodeUrl(this.qrCodeUrl).status(this.status).statusComplement(this.statusComplement).operation(this.operation);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Boleto)) {
            return false;
        }
        Boleto other = (Boleto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$fineQuantityDays = this.getFineQuantityDays();
        Integer other$fineQuantityDays = other.getFineQuantityDays();
        if (this$fineQuantityDays == null ? other$fineQuantityDays != null : !((Object)this$fineQuantityDays).equals(other$fineQuantityDays)) {
            return false;
        }
        Integer this$protestQuantityDays = this.getProtestQuantityDays();
        Integer other$protestQuantityDays = other.getProtestQuantityDays();
        if (this$protestQuantityDays == null ? other$protestQuantityDays != null : !((Object)this$protestQuantityDays).equals(other$protestQuantityDays)) {
            return false;
        }
        Integer this$parcelsQuantity = this.getParcelsQuantity();
        Integer other$parcelsQuantity = other.getParcelsQuantity();
        if (this$parcelsQuantity == null ? other$parcelsQuantity != null : !((Object)this$parcelsQuantity).equals(other$parcelsQuantity)) {
            return false;
        }
        EnvironmentType this$environment = this.getEnvironment();
        EnvironmentType other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)((Object)this$environment)).equals((Object)other$environment)) {
            return false;
        }
        String this$nsuCode = this.getNsuCode();
        String other$nsuCode = other.getNsuCode();
        if (this$nsuCode == null ? other$nsuCode != null : !this$nsuCode.equals(other$nsuCode)) {
            return false;
        }
        String this$nsuDate = this.getNsuDate();
        String other$nsuDate = other.getNsuDate();
        if (this$nsuDate == null ? other$nsuDate != null : !this$nsuDate.equals(other$nsuDate)) {
            return false;
        }
        String this$covenantCode = this.getCovenantCode();
        String other$covenantCode = other.getCovenantCode();
        if (this$covenantCode == null ? other$covenantCode != null : !this$covenantCode.equals(other$covenantCode)) {
            return false;
        }
        String this$bankNumber = this.getBankNumber();
        String other$bankNumber = other.getBankNumber();
        if (this$bankNumber == null ? other$bankNumber != null : !this$bankNumber.equals(other$bankNumber)) {
            return false;
        }
        String this$clientNumber = this.getClientNumber();
        String other$clientNumber = other.getClientNumber();
        if (this$clientNumber == null ? other$clientNumber != null : !this$clientNumber.equals(other$clientNumber)) {
            return false;
        }
        String this$dueDate = this.getDueDate();
        String other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !this$dueDate.equals(other$dueDate)) {
            return false;
        }
        String this$issueDate = this.getIssueDate();
        String other$issueDate = other.getIssueDate();
        if (this$issueDate == null ? other$issueDate != null : !this$issueDate.equals(other$issueDate)) {
            return false;
        }
        String this$participantCode = this.getParticipantCode();
        String other$participantCode = other.getParticipantCode();
        if (this$participantCode == null ? other$participantCode != null : !this$participantCode.equals(other$participantCode)) {
            return false;
        }
        BigDecimal this$nominalValue = this.getNominalValue();
        BigDecimal other$nominalValue = other.getNominalValue();
        if (this$nominalValue == null ? other$nominalValue != null : !((Object)this$nominalValue).equals(other$nominalValue)) {
            return false;
        }
        Payer this$payer = this.getPayer();
        Payer other$payer = other.getPayer();
        if (this$payer == null ? other$payer != null : !((Object)this$payer).equals(other$payer)) {
            return false;
        }
        Beneficiary this$beneficiary = this.getBeneficiary();
        Beneficiary other$beneficiary = other.getBeneficiary();
        if (this$beneficiary == null ? other$beneficiary != null : !((Object)this$beneficiary).equals(other$beneficiary)) {
            return false;
        }
        String this$documentKind = this.getDocumentKind();
        String other$documentKind = other.getDocumentKind();
        if (this$documentKind == null ? other$documentKind != null : !this$documentKind.equals(other$documentKind)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        BigDecimal this$finePercentage = this.getFinePercentage();
        BigDecimal other$finePercentage = other.getFinePercentage();
        if (this$finePercentage == null ? other$finePercentage != null : !((Object)this$finePercentage).equals(other$finePercentage)) {
            return false;
        }
        String this$fineDate = this.getFineDate();
        String other$fineDate = other.getFineDate();
        if (this$fineDate == null ? other$fineDate != null : !this$fineDate.equals(other$fineDate)) {
            return false;
        }
        BigDecimal this$interestPercentage = this.getInterestPercentage();
        BigDecimal other$interestPercentage = other.getInterestPercentage();
        if (this$interestPercentage == null ? other$interestPercentage != null : !((Object)this$interestPercentage).equals(other$interestPercentage)) {
            return false;
        }
        BigDecimal this$deductionValue = this.getDeductionValue();
        BigDecimal other$deductionValue = other.getDeductionValue();
        if (this$deductionValue == null ? other$deductionValue != null : !((Object)this$deductionValue).equals(other$deductionValue)) {
            return false;
        }
        String this$protestType = this.getProtestType();
        String other$protestType = other.getProtestType();
        if (this$protestType == null ? other$protestType != null : !this$protestType.equals(other$protestType)) {
            return false;
        }
        String this$writeOffQuantityDays = this.getWriteOffQuantityDays();
        String other$writeOffQuantityDays = other.getWriteOffQuantityDays();
        if (this$writeOffQuantityDays == null ? other$writeOffQuantityDays != null : !this$writeOffQuantityDays.equals(other$writeOffQuantityDays)) {
            return false;
        }
        String this$paymentType = this.getPaymentType();
        String other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        String this$valueType = this.getValueType();
        String other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        String this$minValueOrPercentage = this.getMinValueOrPercentage();
        String other$minValueOrPercentage = other.getMinValueOrPercentage();
        if (this$minValueOrPercentage == null ? other$minValueOrPercentage != null : !this$minValueOrPercentage.equals(other$minValueOrPercentage)) {
            return false;
        }
        String this$maxValueOrPercentage = this.getMaxValueOrPercentage();
        String other$maxValueOrPercentage = other.getMaxValueOrPercentage();
        if (this$maxValueOrPercentage == null ? other$maxValueOrPercentage != null : !this$maxValueOrPercentage.equals(other$maxValueOrPercentage)) {
            return false;
        }
        String this$iofPercentage = this.getIofPercentage();
        String other$iofPercentage = other.getIofPercentage();
        if (this$iofPercentage == null ? other$iofPercentage != null : !this$iofPercentage.equals(other$iofPercentage)) {
            return false;
        }
        ArrayList<Sharing> this$sharing = this.getSharing();
        ArrayList<Sharing> other$sharing = other.getSharing();
        if (this$sharing == null ? other$sharing != null : !((Object)this$sharing).equals(other$sharing)) {
            return false;
        }
        Key this$key = this.getKey();
        Key other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        String this$txId = this.getTxId();
        String other$txId = other.getTxId();
        if (this$txId == null ? other$txId != null : !this$txId.equals(other$txId)) {
            return false;
        }
        ArrayList<String> this$messages = this.getMessages();
        ArrayList<String> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$barCode = this.getBarCode();
        String other$barCode = other.getBarCode();
        if (this$barCode == null ? other$barCode != null : !this$barCode.equals(other$barCode)) {
            return false;
        }
        String this$digitableLine = this.getDigitableLine();
        String other$digitableLine = other.getDigitableLine();
        if (this$digitableLine == null ? other$digitableLine != null : !this$digitableLine.equals(other$digitableLine)) {
            return false;
        }
        String this$entryDate = this.getEntryDate();
        String other$entryDate = other.getEntryDate();
        if (this$entryDate == null ? other$entryDate != null : !this$entryDate.equals(other$entryDate)) {
            return false;
        }
        String this$qrCodePix = this.getQrCodePix();
        String other$qrCodePix = other.getQrCodePix();
        if (this$qrCodePix == null ? other$qrCodePix != null : !this$qrCodePix.equals(other$qrCodePix)) {
            return false;
        }
        String this$qrCodeUrl = this.getQrCodeUrl();
        String other$qrCodeUrl = other.getQrCodeUrl();
        if (this$qrCodeUrl == null ? other$qrCodeUrl != null : !this$qrCodeUrl.equals(other$qrCodeUrl)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$statusComplement = this.getStatusComplement();
        String other$statusComplement = other.getStatusComplement();
        if (this$statusComplement == null ? other$statusComplement != null : !this$statusComplement.equals(other$statusComplement)) {
            return false;
        }
        String this$operation = this.getOperation();
        String other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !this$operation.equals(other$operation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Boleto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $fineQuantityDays = this.getFineQuantityDays();
        result = result * 59 + ($fineQuantityDays == null ? 43 : ((Object)$fineQuantityDays).hashCode());
        Integer $protestQuantityDays = this.getProtestQuantityDays();
        result = result * 59 + ($protestQuantityDays == null ? 43 : ((Object)$protestQuantityDays).hashCode());
        Integer $parcelsQuantity = this.getParcelsQuantity();
        result = result * 59 + ($parcelsQuantity == null ? 43 : ((Object)$parcelsQuantity).hashCode());
        EnvironmentType $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)((Object)$environment)).hashCode());
        String $nsuCode = this.getNsuCode();
        result = result * 59 + ($nsuCode == null ? 43 : $nsuCode.hashCode());
        String $nsuDate = this.getNsuDate();
        result = result * 59 + ($nsuDate == null ? 43 : $nsuDate.hashCode());
        String $covenantCode = this.getCovenantCode();
        result = result * 59 + ($covenantCode == null ? 43 : $covenantCode.hashCode());
        String $bankNumber = this.getBankNumber();
        result = result * 59 + ($bankNumber == null ? 43 : $bankNumber.hashCode());
        String $clientNumber = this.getClientNumber();
        result = result * 59 + ($clientNumber == null ? 43 : $clientNumber.hashCode());
        String $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : $dueDate.hashCode());
        String $issueDate = this.getIssueDate();
        result = result * 59 + ($issueDate == null ? 43 : $issueDate.hashCode());
        String $participantCode = this.getParticipantCode();
        result = result * 59 + ($participantCode == null ? 43 : $participantCode.hashCode());
        BigDecimal $nominalValue = this.getNominalValue();
        result = result * 59 + ($nominalValue == null ? 43 : ((Object)$nominalValue).hashCode());
        Payer $payer = this.getPayer();
        result = result * 59 + ($payer == null ? 43 : ((Object)$payer).hashCode());
        Beneficiary $beneficiary = this.getBeneficiary();
        result = result * 59 + ($beneficiary == null ? 43 : ((Object)$beneficiary).hashCode());
        String $documentKind = this.getDocumentKind();
        result = result * 59 + ($documentKind == null ? 43 : $documentKind.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        BigDecimal $finePercentage = this.getFinePercentage();
        result = result * 59 + ($finePercentage == null ? 43 : ((Object)$finePercentage).hashCode());
        String $fineDate = this.getFineDate();
        result = result * 59 + ($fineDate == null ? 43 : $fineDate.hashCode());
        BigDecimal $interestPercentage = this.getInterestPercentage();
        result = result * 59 + ($interestPercentage == null ? 43 : ((Object)$interestPercentage).hashCode());
        BigDecimal $deductionValue = this.getDeductionValue();
        result = result * 59 + ($deductionValue == null ? 43 : ((Object)$deductionValue).hashCode());
        String $protestType = this.getProtestType();
        result = result * 59 + ($protestType == null ? 43 : $protestType.hashCode());
        String $writeOffQuantityDays = this.getWriteOffQuantityDays();
        result = result * 59 + ($writeOffQuantityDays == null ? 43 : $writeOffQuantityDays.hashCode());
        String $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        String $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        String $minValueOrPercentage = this.getMinValueOrPercentage();
        result = result * 59 + ($minValueOrPercentage == null ? 43 : $minValueOrPercentage.hashCode());
        String $maxValueOrPercentage = this.getMaxValueOrPercentage();
        result = result * 59 + ($maxValueOrPercentage == null ? 43 : $maxValueOrPercentage.hashCode());
        String $iofPercentage = this.getIofPercentage();
        result = result * 59 + ($iofPercentage == null ? 43 : $iofPercentage.hashCode());
        ArrayList<Sharing> $sharing = this.getSharing();
        result = result * 59 + ($sharing == null ? 43 : ((Object)$sharing).hashCode());
        Key $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        String $txId = this.getTxId();
        result = result * 59 + ($txId == null ? 43 : $txId.hashCode());
        ArrayList<String> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $barCode = this.getBarCode();
        result = result * 59 + ($barCode == null ? 43 : $barCode.hashCode());
        String $digitableLine = this.getDigitableLine();
        result = result * 59 + ($digitableLine == null ? 43 : $digitableLine.hashCode());
        String $entryDate = this.getEntryDate();
        result = result * 59 + ($entryDate == null ? 43 : $entryDate.hashCode());
        String $qrCodePix = this.getQrCodePix();
        result = result * 59 + ($qrCodePix == null ? 43 : $qrCodePix.hashCode());
        String $qrCodeUrl = this.getQrCodeUrl();
        result = result * 59 + ($qrCodeUrl == null ? 43 : $qrCodeUrl.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $statusComplement = this.getStatusComplement();
        result = result * 59 + ($statusComplement == null ? 43 : $statusComplement.hashCode());
        String $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        return result;
    }

    public String toString() {
        return "Boleto(environment=" + (Object)((Object)this.getEnvironment()) + ", nsuCode=" + this.getNsuCode() + ", nsuDate=" + this.getNsuDate() + ", covenantCode=" + this.getCovenantCode() + ", bankNumber=" + this.getBankNumber() + ", clientNumber=" + this.getClientNumber() + ", dueDate=" + this.getDueDate() + ", issueDate=" + this.getIssueDate() + ", participantCode=" + this.getParticipantCode() + ", nominalValue=" + this.getNominalValue() + ", payer=" + this.getPayer() + ", beneficiary=" + this.getBeneficiary() + ", documentKind=" + this.getDocumentKind() + ", discount=" + this.getDiscount() + ", finePercentage=" + this.getFinePercentage() + ", fineQuantityDays=" + this.getFineQuantityDays() + ", fineDate=" + this.getFineDate() + ", interestPercentage=" + this.getInterestPercentage() + ", deductionValue=" + this.getDeductionValue() + ", protestType=" + this.getProtestType() + ", protestQuantityDays=" + this.getProtestQuantityDays() + ", writeOffQuantityDays=" + this.getWriteOffQuantityDays() + ", paymentType=" + this.getPaymentType() + ", parcelsQuantity=" + this.getParcelsQuantity() + ", valueType=" + this.getValueType() + ", minValueOrPercentage=" + this.getMinValueOrPercentage() + ", maxValueOrPercentage=" + this.getMaxValueOrPercentage() + ", iofPercentage=" + this.getIofPercentage() + ", sharing=" + this.getSharing() + ", key=" + this.getKey() + ", txId=" + this.getTxId() + ", messages=" + this.getMessages() + ", barCode=" + this.getBarCode() + ", digitableLine=" + this.getDigitableLine() + ", entryDate=" + this.getEntryDate() + ", qrCodePix=" + this.getQrCodePix() + ", qrCodeUrl=" + this.getQrCodeUrl() + ", status=" + this.getStatus() + ", statusComplement=" + this.getStatusComplement() + ", operation=" + this.getOperation() + ")";
    }

    public EnvironmentType getEnvironment() {
        return this.environment;
    }

    public String getNsuCode() {
        return this.nsuCode;
    }

    public String getNsuDate() {
        return this.nsuDate;
    }

    public String getCovenantCode() {
        return this.covenantCode;
    }

    public String getBankNumber() {
        return this.bankNumber;
    }

    public String getClientNumber() {
        return this.clientNumber;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public String getIssueDate() {
        return this.issueDate;
    }

    public String getParticipantCode() {
        return this.participantCode;
    }

    public BigDecimal getNominalValue() {
        return this.nominalValue;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public Beneficiary getBeneficiary() {
        return this.beneficiary;
    }

    public String getDocumentKind() {
        return this.documentKind;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public BigDecimal getFinePercentage() {
        return this.finePercentage;
    }

    public Integer getFineQuantityDays() {
        return this.fineQuantityDays;
    }

    public String getFineDate() {
        return this.fineDate;
    }

    public BigDecimal getInterestPercentage() {
        return this.interestPercentage;
    }

    public BigDecimal getDeductionValue() {
        return this.deductionValue;
    }

    public String getProtestType() {
        return this.protestType;
    }

    public Integer getProtestQuantityDays() {
        return this.protestQuantityDays;
    }

    public String getWriteOffQuantityDays() {
        return this.writeOffQuantityDays;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public Integer getParcelsQuantity() {
        return this.parcelsQuantity;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getMinValueOrPercentage() {
        return this.minValueOrPercentage;
    }

    public String getMaxValueOrPercentage() {
        return this.maxValueOrPercentage;
    }

    public String getIofPercentage() {
        return this.iofPercentage;
    }

    public ArrayList<Sharing> getSharing() {
        return this.sharing;
    }

    public Key getKey() {
        return this.key;
    }

    public String getTxId() {
        return this.txId;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public String getDigitableLine() {
        return this.digitableLine;
    }

    public String getEntryDate() {
        return this.entryDate;
    }

    public String getQrCodePix() {
        return this.qrCodePix;
    }

    public String getQrCodeUrl() {
        return this.qrCodeUrl;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusComplement() {
        return this.statusComplement;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setEnvironment(EnvironmentType environment) {
        this.environment = environment;
    }

    public void setNsuCode(String nsuCode) {
        this.nsuCode = nsuCode;
    }

    public void setNsuDate(String nsuDate) {
        this.nsuDate = nsuDate;
    }

    public void setCovenantCode(String covenantCode) {
        this.covenantCode = covenantCode;
    }

    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }

    public void setClientNumber(String clientNumber) {
        this.clientNumber = clientNumber;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public void setIssueDate(String issueDate) {
        this.issueDate = issueDate;
    }

    public void setParticipantCode(String participantCode) {
        this.participantCode = participantCode;
    }

    public void setNominalValue(BigDecimal nominalValue) {
        this.nominalValue = nominalValue;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public void setBeneficiary(Beneficiary beneficiary) {
        this.beneficiary = beneficiary;
    }

    public void setDocumentKind(String documentKind) {
        this.documentKind = documentKind;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public void setFinePercentage(BigDecimal finePercentage) {
        this.finePercentage = finePercentage;
    }

    public void setFineQuantityDays(Integer fineQuantityDays) {
        this.fineQuantityDays = fineQuantityDays;
    }

    public void setFineDate(String fineDate) {
        this.fineDate = fineDate;
    }

    public void setInterestPercentage(BigDecimal interestPercentage) {
        this.interestPercentage = interestPercentage;
    }

    public void setDeductionValue(BigDecimal deductionValue) {
        this.deductionValue = deductionValue;
    }

    public void setProtestType(String protestType) {
        this.protestType = protestType;
    }

    public void setProtestQuantityDays(Integer protestQuantityDays) {
        this.protestQuantityDays = protestQuantityDays;
    }

    public void setWriteOffQuantityDays(String writeOffQuantityDays) {
        this.writeOffQuantityDays = writeOffQuantityDays;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public void setParcelsQuantity(Integer parcelsQuantity) {
        this.parcelsQuantity = parcelsQuantity;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public void setMinValueOrPercentage(String minValueOrPercentage) {
        this.minValueOrPercentage = minValueOrPercentage;
    }

    public void setMaxValueOrPercentage(String maxValueOrPercentage) {
        this.maxValueOrPercentage = maxValueOrPercentage;
    }

    public void setIofPercentage(String iofPercentage) {
        this.iofPercentage = iofPercentage;
    }

    public void setSharing(ArrayList<Sharing> sharing) {
        this.sharing = sharing;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public void setTxId(String txId) {
        this.txId = txId;
    }

    public void setMessages(ArrayList<String> messages) {
        this.messages = messages;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public void setDigitableLine(String digitableLine) {
        this.digitableLine = digitableLine;
    }

    public void setEntryDate(String entryDate) {
        this.entryDate = entryDate;
    }

    public void setQrCodePix(String qrCodePix) {
        this.qrCodePix = qrCodePix;
    }

    public void setQrCodeUrl(String qrCodeUrl) {
        this.qrCodeUrl = qrCodeUrl;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatusComplement(String statusComplement) {
        this.statusComplement = statusComplement;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public Boleto() {
    }

    public Boleto(EnvironmentType environment, String nsuCode, String nsuDate, String covenantCode, String bankNumber, String clientNumber, String dueDate, String issueDate, String participantCode, BigDecimal nominalValue, Payer payer, Beneficiary beneficiary, String documentKind, Discount discount, BigDecimal finePercentage, Integer fineQuantityDays, String fineDate, BigDecimal interestPercentage, BigDecimal deductionValue, String protestType, Integer protestQuantityDays, String writeOffQuantityDays, String paymentType, Integer parcelsQuantity, String valueType, String minValueOrPercentage, String maxValueOrPercentage, String iofPercentage, ArrayList<Sharing> sharing, Key key, String txId, ArrayList<String> messages, String barCode, String digitableLine, String entryDate, String qrCodePix, String qrCodeUrl, String status, String statusComplement, String operation) {
        this.environment = environment;
        this.nsuCode = nsuCode;
        this.nsuDate = nsuDate;
        this.covenantCode = covenantCode;
        this.bankNumber = bankNumber;
        this.clientNumber = clientNumber;
        this.dueDate = dueDate;
        this.issueDate = issueDate;
        this.participantCode = participantCode;
        this.nominalValue = nominalValue;
        this.payer = payer;
        this.beneficiary = beneficiary;
        this.documentKind = documentKind;
        this.discount = discount;
        this.finePercentage = finePercentage;
        this.fineQuantityDays = fineQuantityDays;
        this.fineDate = fineDate;
        this.interestPercentage = interestPercentage;
        this.deductionValue = deductionValue;
        this.protestType = protestType;
        this.protestQuantityDays = protestQuantityDays;
        this.writeOffQuantityDays = writeOffQuantityDays;
        this.paymentType = paymentType;
        this.parcelsQuantity = parcelsQuantity;
        this.valueType = valueType;
        this.minValueOrPercentage = minValueOrPercentage;
        this.maxValueOrPercentage = maxValueOrPercentage;
        this.iofPercentage = iofPercentage;
        this.sharing = sharing;
        this.key = key;
        this.txId = txId;
        this.messages = messages;
        this.barCode = barCode;
        this.digitableLine = digitableLine;
        this.entryDate = entryDate;
        this.qrCodePix = qrCodePix;
        this.qrCodeUrl = qrCodeUrl;
        this.status = status;
        this.statusComplement = statusComplement;
        this.operation = operation;
    }

    public static class BoletoBuilder {
        private EnvironmentType environment;
        private String nsuCode;
        private String nsuDate;
        private String covenantCode;
        private String bankNumber;
        private String clientNumber;
        private String dueDate;
        private String issueDate;
        private String participantCode;
        private BigDecimal nominalValue;
        private Payer payer;
        private Beneficiary beneficiary;
        private String documentKind;
        private Discount discount;
        private BigDecimal finePercentage;
        private Integer fineQuantityDays;
        private String fineDate;
        private BigDecimal interestPercentage;
        private BigDecimal deductionValue;
        private String protestType;
        private Integer protestQuantityDays;
        private String writeOffQuantityDays;
        private String paymentType;
        private Integer parcelsQuantity;
        private String valueType;
        private String minValueOrPercentage;
        private String maxValueOrPercentage;
        private String iofPercentage;
        private ArrayList<Sharing> sharing;
        private Key key;
        private String txId;
        private ArrayList<String> messages;
        private String barCode;
        private String digitableLine;
        private String entryDate;
        private String qrCodePix;
        private String qrCodeUrl;
        private String status;
        private String statusComplement;
        private String operation;

        BoletoBuilder() {
        }

        public BoletoBuilder environment(EnvironmentType environment) {
            this.environment = environment;
            return this;
        }

        public BoletoBuilder nsuCode(String nsuCode) {
            this.nsuCode = nsuCode;
            return this;
        }

        public BoletoBuilder nsuDate(String nsuDate) {
            this.nsuDate = nsuDate;
            return this;
        }

        public BoletoBuilder covenantCode(String covenantCode) {
            this.covenantCode = covenantCode;
            return this;
        }

        public BoletoBuilder bankNumber(String bankNumber) {
            this.bankNumber = bankNumber;
            return this;
        }

        public BoletoBuilder clientNumber(String clientNumber) {
            this.clientNumber = clientNumber;
            return this;
        }

        public BoletoBuilder dueDate(String dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public BoletoBuilder issueDate(String issueDate) {
            this.issueDate = issueDate;
            return this;
        }

        public BoletoBuilder participantCode(String participantCode) {
            this.participantCode = participantCode;
            return this;
        }

        public BoletoBuilder nominalValue(BigDecimal nominalValue) {
            this.nominalValue = nominalValue;
            return this;
        }

        public BoletoBuilder payer(Payer payer) {
            this.payer = payer;
            return this;
        }

        public BoletoBuilder beneficiary(Beneficiary beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        public BoletoBuilder documentKind(String documentKind) {
            this.documentKind = documentKind;
            return this;
        }

        public BoletoBuilder discount(Discount discount) {
            this.discount = discount;
            return this;
        }

        public BoletoBuilder finePercentage(BigDecimal finePercentage) {
            this.finePercentage = finePercentage;
            return this;
        }

        public BoletoBuilder fineQuantityDays(Integer fineQuantityDays) {
            this.fineQuantityDays = fineQuantityDays;
            return this;
        }

        public BoletoBuilder fineDate(String fineDate) {
            this.fineDate = fineDate;
            return this;
        }

        public BoletoBuilder interestPercentage(BigDecimal interestPercentage) {
            this.interestPercentage = interestPercentage;
            return this;
        }

        public BoletoBuilder deductionValue(BigDecimal deductionValue) {
            this.deductionValue = deductionValue;
            return this;
        }

        public BoletoBuilder protestType(String protestType) {
            this.protestType = protestType;
            return this;
        }

        public BoletoBuilder protestQuantityDays(Integer protestQuantityDays) {
            this.protestQuantityDays = protestQuantityDays;
            return this;
        }

        public BoletoBuilder writeOffQuantityDays(String writeOffQuantityDays) {
            this.writeOffQuantityDays = writeOffQuantityDays;
            return this;
        }

        public BoletoBuilder paymentType(String paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        public BoletoBuilder parcelsQuantity(Integer parcelsQuantity) {
            this.parcelsQuantity = parcelsQuantity;
            return this;
        }

        public BoletoBuilder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        public BoletoBuilder minValueOrPercentage(String minValueOrPercentage) {
            this.minValueOrPercentage = minValueOrPercentage;
            return this;
        }

        public BoletoBuilder maxValueOrPercentage(String maxValueOrPercentage) {
            this.maxValueOrPercentage = maxValueOrPercentage;
            return this;
        }

        public BoletoBuilder iofPercentage(String iofPercentage) {
            this.iofPercentage = iofPercentage;
            return this;
        }

        public BoletoBuilder sharing(ArrayList<Sharing> sharing) {
            this.sharing = sharing;
            return this;
        }

        public BoletoBuilder key(Key key) {
            this.key = key;
            return this;
        }

        public BoletoBuilder txId(String txId) {
            this.txId = txId;
            return this;
        }

        public BoletoBuilder messages(ArrayList<String> messages) {
            this.messages = messages;
            return this;
        }

        public BoletoBuilder barCode(String barCode) {
            this.barCode = barCode;
            return this;
        }

        public BoletoBuilder digitableLine(String digitableLine) {
            this.digitableLine = digitableLine;
            return this;
        }

        public BoletoBuilder entryDate(String entryDate) {
            this.entryDate = entryDate;
            return this;
        }

        public BoletoBuilder qrCodePix(String qrCodePix) {
            this.qrCodePix = qrCodePix;
            return this;
        }

        public BoletoBuilder qrCodeUrl(String qrCodeUrl) {
            this.qrCodeUrl = qrCodeUrl;
            return this;
        }

        public BoletoBuilder status(String status) {
            this.status = status;
            return this;
        }

        public BoletoBuilder statusComplement(String statusComplement) {
            this.statusComplement = statusComplement;
            return this;
        }

        public BoletoBuilder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public Boleto build() {
            return new Boleto(this.environment, this.nsuCode, this.nsuDate, this.covenantCode, this.bankNumber, this.clientNumber, this.dueDate, this.issueDate, this.participantCode, this.nominalValue, this.payer, this.beneficiary, this.documentKind, this.discount, this.finePercentage, this.fineQuantityDays, this.fineDate, this.interestPercentage, this.deductionValue, this.protestType, this.protestQuantityDays, this.writeOffQuantityDays, this.paymentType, this.parcelsQuantity, this.valueType, this.minValueOrPercentage, this.maxValueOrPercentage, this.iofPercentage, this.sharing, this.key, this.txId, this.messages, this.barCode, this.digitableLine, this.entryDate, this.qrCodePix, this.qrCodeUrl, this.status, this.statusComplement, this.operation);
        }

        public String toString() {
            return "Boleto.BoletoBuilder(environment=" + (Object)((Object)this.environment) + ", nsuCode=" + this.nsuCode + ", nsuDate=" + this.nsuDate + ", covenantCode=" + this.covenantCode + ", bankNumber=" + this.bankNumber + ", clientNumber=" + this.clientNumber + ", dueDate=" + this.dueDate + ", issueDate=" + this.issueDate + ", participantCode=" + this.participantCode + ", nominalValue=" + this.nominalValue + ", payer=" + this.payer + ", beneficiary=" + this.beneficiary + ", documentKind=" + this.documentKind + ", discount=" + this.discount + ", finePercentage=" + this.finePercentage + ", fineQuantityDays=" + this.fineQuantityDays + ", fineDate=" + this.fineDate + ", interestPercentage=" + this.interestPercentage + ", deductionValue=" + this.deductionValue + ", protestType=" + this.protestType + ", protestQuantityDays=" + this.protestQuantityDays + ", writeOffQuantityDays=" + this.writeOffQuantityDays + ", paymentType=" + this.paymentType + ", parcelsQuantity=" + this.parcelsQuantity + ", valueType=" + this.valueType + ", minValueOrPercentage=" + this.minValueOrPercentage + ", maxValueOrPercentage=" + this.maxValueOrPercentage + ", iofPercentage=" + this.iofPercentage + ", sharing=" + this.sharing + ", key=" + this.key + ", txId=" + this.txId + ", messages=" + this.messages + ", barCode=" + this.barCode + ", digitableLine=" + this.digitableLine + ", entryDate=" + this.entryDate + ", qrCodePix=" + this.qrCodePix + ", qrCodeUrl=" + this.qrCodeUrl + ", status=" + this.status + ", statusComplement=" + this.statusComplement + ", operation=" + this.operation + ")";
        }
    }
}

