/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicoob_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.InformacaoModel;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.SituacaoEnum;
import br.com.java_brasil.boleto.model.enums.TipoJurosEnum;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.ConfiguracaoSicoobAPI;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobBoleto;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobConsultaResponse;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobEnvioResponse;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobModelConverter;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobResultado;
import br.com.java_brasil.boleto.service.bancos.sicoob_cnab240.SicoobUtil;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.RestUtil;
import br.com.java_brasil.boleto.util.ValidaUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JsonUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;

public class BancoSicoobAPI
extends BoletoController {
    private static final Logger log = Logger.getLogger(BancoSicoobAPI.class.getName());

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            boletos.forEach(this::preparaValidaBoletoImpressao);
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return Base64.decodeBase64((String)Optional.ofNullable(boletoModel.getImpressaoBase64()).orElseThrow(() -> new BoletoException("Campo Impress\u00e3oBase64 n\u00e3o est\u00e1 preenchido, consulte o boleto para receber a impress\u00e3o.")));
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSicoobAPI configuracao = this.getConfiguracaoSicoob();
            configuracao.setToken(configuracao.getToken(configuracao));
            BoletoSicoobBoleto request = BoletoSicoobModelConverter.montaBoletoRequest(boletoModel, configuracao);
            String json = RestUtil.ObjectToJson(Collections.singletonList(request));
            log.config("Json Envio Boleto: " + json);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccess_token()), new BasicHeader("x-sicoob-clientid", configuracao.getClientId())};
            CloseableHttpResponse response = RestUtil.post(configuracao.getURLBase() + configuracao.getUrlRegistraBoleto(), headers, json, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Envio Boleto: " + retorno);
            BoletoSicoobEnvioResponse boletoSicoobResponse = RestUtil.JsonToObject(retorno, BoletoSicoobEnvioResponse.class);
            BoletoSicoobBoleto boletoResponse = boletoSicoobResponse.getResultado().get(0).getBoleto();
            if (boletoResponse == null) {
                throw new BoletoException("Erro ao enviar boleto, c\u00f3digo erro: " + boletoSicoobResponse.getResultado().get(0).getStatus().getCodigo());
            }
            if (boletoSicoobResponse.getResultado().get(0).getStatus().getCodigo() != 200) {
                throw new BoletoException("Erro ao gerar boleto", json);
            }
            return BoletoSicoobModelConverter.montaBoletoResponse(boletoModel, boletoResponse);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        JsonNode retorno = this.baixarBoletoRetJsonNode(boletoModel);
        try {
            List<BoletoSicoobResultado> resultadoBaixa = BoletoSicoobModelConverter.resultadoBaixa(retorno);
            BoletoSicoobResultado resultado = resultadoBaixa.get(0);
            BoletoSicoobBoleto boletoResponse = resultado.getBoleto();
            if (boletoResponse == null) {
                throw new BoletoException("Erro ao enviar boleto, c\u00f3digo erro: " + resultado.getStatus().getCodigo() + " mensagem :" + resultado.getStatus().getMensagem());
            }
            switch (resultado.getStatus().getCodigo()) {
                case 200: {
                    boletoModel.setSituacao(SituacaoEnum.BAIXADO);
                    return boletoModel;
                }
            }
            throw new BoletoException("Erro ao enviar boleto, c\u00f3digo erro: " + resultado.getStatus().getCodigo() + " mensagem :" + resultado.getStatus().getMensagem());
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e, retorno.toString());
        }
    }

    public String baixarBoletoRetJson(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSicoobAPI configuracao = this.getConfiguracaoSicoob();
            configuracao.setToken(configuracao.getToken(configuracao));
            BasicHeader basicHeaderClientId = new BasicHeader("x-sicoob-clientid", configuracao.getClientId());
            String json = BoletoSicoobModelConverter.patchBaixa(boletoModel, configuracao);
            log.config("Json Envio Boleto: " + json);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccess_token()), new BasicHeader("x-sicoob-clientid", configuracao.getClientId())};
            CloseableHttpResponse response = RestUtil.patch(configuracao.getURLBase() + configuracao.getUrlRegistraBoleto() + "/baixa", headers, json, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            return RestUtil.validaResponseERetornaBody(response);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    public JsonNode baixarBoletoRetJsonNode(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            String baixarBoletoRetJson = this.baixarBoletoRetJson(boletoModel);
            return new ObjectMapper().readTree(baixarBoletoRetJson);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    private ConfiguracaoSicoobAPI getConfiguracaoSicoob() {
        return (ConfiguracaoSicoobAPI)this.getConfiguracao();
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSicoobAPI configuracao = (ConfiguracaoSicoobAPI)this.getConfiguracao();
            configuracao.setToken(configuracao.getToken(configuracao));
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccess_token())};
            String parametros = "?numeroContrato=" + configuracao.getNumeroContrato();
            parametros = parametros + "&modalidade=1";
            if (StringUtils.isNotBlank((CharSequence)boletoModel.getNossoNumero())) {
                parametros = parametros + "&nossoNumero=" + boletoModel.getNossoNumero();
            } else if (StringUtils.isNotBlank((CharSequence)boletoModel.getLinhaDigitavel())) {
                parametros = parametros + "linhaDigitavel=" + boletoModel.getLinhaDigitavel();
            } else if (StringUtils.isNotBlank((CharSequence)boletoModel.getCodigoBarras())) {
                parametros = parametros + "codigoBarras=" + boletoModel.getCodigoBarras();
            }
            HttpGet get = new HttpGet(configuracao.getURLBase() + "/boletos" + parametros);
            get.setHeader((Header)new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccess_token()));
            get.setHeader("Content-Type", "application/json");
            get.setHeader("Accept", "application/json");
            get.setHeader((Header)new BasicHeader("x-sicoob-clientid", configuracao.getClientId()));
            CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)get, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Consulta Boleto: " + retorno);
            BoletoSicoobConsultaResponse boletoSicoobResponse = RestUtil.JsonToObject(retorno, BoletoSicoobConsultaResponse.class);
            return BoletoSicoobModelConverter.montaBoletoResponse(boletoModel, boletoSicoobResponse.getResultado());
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    private void validaAutenticacao(ConfiguracaoSicoobAPI configuracao) {
        try {
            Optional.ofNullable(configuracao.getToken()).orElseThrow(() -> new BoletoException("Token n\u00e3o pode ser vazio."));
            if (configuracao.getExpiracaoToken() == null || configuracao.getExpiracaoToken().isBefore(LocalDateTime.now())) {
                log.config("Token existe por\u00e9m est\u00e1 expirado. Executando RefreshToken.");
                Optional.ofNullable(configuracao.getRefreshToken()).orElseThrow(() -> new BoletoException("Refresh Token n\u00e3o pode ser vazio."));
                this.getConfiguracaoSicoob().getToken(configuracao);
            }
        }
        catch (IOException e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    private void preparaValidaBoletoImpressao(BoletoModel boletoModel) {
        boletoModel.getBeneficiario().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiario().getDocumento()));
        boletoModel.getPagador().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getPagador().getDocumento()));
        if (boletoModel.getBeneficiarioFinal() != null) {
            boletoModel.getBeneficiarioFinal().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiarioFinal().getDocumento()));
        }
        StringBuilder codigoBarras = new StringBuilder();
        codigoBarras.append("7569");
        codigoBarras.append("X");
        codigoBarras.append(SicoobUtil.fatorData(boletoModel.getDataVencimento()));
        codigoBarras.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
        StringBuilder campoLivre = new StringBuilder();
        campoLivre.append("1");
        campoLivre.append(StringUtils.leftPad((String)boletoModel.getBeneficiario().getAgencia(), (int)4, (String)"0"));
        campoLivre.append("01");
        campoLivre.append(boletoModel.getBeneficiario().getNumeroConvenio());
        campoLivre.append(boletoModel.getNossoNumero().substring(2));
        campoLivre.append(boletoModel.getDigitoNossoNumero());
        campoLivre.append("001");
        codigoBarras.append((CharSequence)campoLivre);
        Integer digitoVerificadorGeral = SicoobUtil.modulo11(codigoBarras.toString().replace("X", ""));
        boletoModel.setCodigoBarras(codigoBarras.toString().replace("X", digitoVerificadorGeral.toString()));
        StringBuilder linhaParte1 = new StringBuilder();
        linhaParte1.append("75691");
        linhaParte1.append(boletoModel.getBeneficiario().getAgencia());
        linhaParte1.append(SicoobUtil.modulo10(linhaParte1.toString()));
        StringBuilder linhaParte2 = new StringBuilder();
        linhaParte2.append("01");
        linhaParte2.append(boletoModel.getBeneficiario().getNumeroConvenio());
        linhaParte2.append(boletoModel.getNossoNumero().substring(2, 3));
        linhaParte2.append(SicoobUtil.modulo10(linhaParte2.toString()));
        StringBuilder linhaParte3 = new StringBuilder();
        linhaParte3.append(boletoModel.getNossoNumero().substring(3));
        linhaParte3.append(boletoModel.getDigitoNossoNumero());
        linhaParte3.append("001");
        linhaParte3.append(SicoobUtil.modulo10(linhaParte3.toString()));
        StringBuilder linhaParte4 = new StringBuilder();
        linhaParte4.append(digitoVerificadorGeral);
        StringBuilder linhaParte5 = new StringBuilder();
        linhaParte5.append(SicoobUtil.fatorData(boletoModel.getDataVencimento()));
        linhaParte5.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
        if (StringUtils.isEmpty((CharSequence)boletoModel.getLinhaDigitavel())) {
            this.montaLinhaDigitavel(boletoModel, linhaParte1, linhaParte2, linhaParte3, linhaParte4, linhaParte5);
        }
        if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorPercentualMulta())) {
            String instrucaoMulta = "APOS VENCIMENTO COBRAR MULTA DE " + BoletoUtil.formatarCasasDecimais(boletoModel.getValorPercentualMulta(), 2) + "%";
            boletoModel.getInstrucoes().add(new InformacaoModel(instrucaoMulta));
        }
        if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorPercentualJuros())) {
            BigDecimal valorPercentualJuros = boletoModel.getValorPercentualJuros();
            BigDecimal valorMoraDia = boletoModel.getValorPercentualJuros();
            if (boletoModel.getTipoJuros().equals((Object)TipoJurosEnum.PERCENTUAL_MENSAL) && BoletoUtil.isNotNullEMaiorQZero(valorPercentualJuros)) {
                valorPercentualJuros = valorPercentualJuros.divide(BigDecimal.valueOf(30L), MathContext.DECIMAL32);
                valorMoraDia = boletoModel.getValorBoleto().multiply(valorPercentualJuros, MathContext.DECIMAL32);
                valorMoraDia = valorMoraDia.divide(BigDecimal.valueOf(100L), MathContext.DECIMAL32);
            }
            String instrucaoJuros = "APOS VENCIMENTO COBRAR MORA DIARIA DE R$ " + BoletoUtil.formatarCasasDecimais(valorMoraDia, 2);
            boletoModel.getInstrucoes().add(new InformacaoModel(instrucaoJuros));
        }
        this.validaDadosImpressao(boletoModel);
    }

    private void validaRequestProtesto(List<BoletoModel> listBoletoModel) {
        if (listBoletoModel.isEmpty()) {
            throw new BoletoException("Boleto n\u00e3o foram enviados");
        }
        if (listBoletoModel.size() > 10) {
            throw new BoletoException("Requisi\u00e7\u00f5es limitadas pelo banco em 10 boletos por requisi\u00e7\u00e3o");
        }
    }

    public JsonNode protestarBoletos(@NonNull List<BoletoModel> listBoletoModel) {
        if (listBoletoModel == null) {
            throw new NullPointerException("listBoletoModel is marked non-null but is null");
        }
        this.validaRequestProtesto(listBoletoModel);
        try {
            ConfiguracaoSicoobAPI configuracao = this.getConfiguracaoSicoob();
            configuracao.setToken(configuracao.getToken(configuracao));
            String json = BoletoSicoobModelConverter.gerarJsonProtesto(listBoletoModel, configuracao);
            log.log(Level.CONFIG, "Json Envio Boleto Prostesto: {0}", json);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccess_token()), new BasicHeader("x-sicoob-clientid", configuracao.getClientId())};
            CloseableHttpResponse response = RestUtil.post(configuracao.getURLBase() + configuracao.getUrlProtestaBoleto(), headers, json, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            String retorno = RestUtil.validaResponseERetornaBody(response);
            ObjectMapper createObjectMapper = JsonUtil.createObjectMapper();
            JsonNode readTree = createObjectMapper.readTree(retorno);
            return readTree;
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    public JsonNode negativarBoletos(@NonNull List<BoletoModel> listBoletoModel) {
        if (listBoletoModel == null) {
            throw new NullPointerException("listBoletoModel is marked non-null but is null");
        }
        this.validaRequestProtesto(listBoletoModel);
        try {
            ConfiguracaoSicoobAPI configuracao = this.getConfiguracaoSicoob();
            configuracao.setToken(configuracao.getToken(configuracao));
            String json = BoletoSicoobModelConverter.gerarJsonProtesto(listBoletoModel, configuracao);
            log.log(Level.CONFIG, "Json Envio Boleto negativa\u00e7\u00e3o SERASA: {0}", json);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccess_token()), new BasicHeader("x-sicoob-clientid", configuracao.getClientId())};
            CloseableHttpResponse response = RestUtil.post(configuracao.getURLBase() + configuracao.getUrlNegativacaoBoleto(), headers, json, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            String retorno = RestUtil.validaResponseERetornaBody(response);
            ObjectMapper createObjectMapper = JsonUtil.createObjectMapper();
            JsonNode readTree = createObjectMapper.readTree(retorno);
            return readTree;
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    public JsonNode cancelarNegativacaoBoletos(@NonNull List<BoletoModel> listBoletoModel) {
        if (listBoletoModel == null) {
            throw new NullPointerException("listBoletoModel is marked non-null but is null");
        }
        this.validaRequestProtesto(listBoletoModel);
        try {
            ConfiguracaoSicoobAPI configuracao = this.getConfiguracaoSicoob();
            configuracao.setToken(configuracao.getToken(configuracao));
            String json = BoletoSicoobModelConverter.gerarJsonProtesto(listBoletoModel, configuracao);
            log.log(Level.CONFIG, "Json cancela Boleto negativa\u00e7\u00e3o SERASA: {0}", json);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccess_token()), new BasicHeader("x-sicoob-clientid", configuracao.getClientId())};
            CloseableHttpResponse response = RestUtil.patch(configuracao.getURLBase() + configuracao.getUrlNegativacaoBoleto(), headers, json, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            String retorno = RestUtil.validaResponseERetornaBody(response);
            ObjectMapper createObjectMapper = JsonUtil.createObjectMapper();
            JsonNode readTree = createObjectMapper.readTree(retorno);
            return readTree;
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    public JsonNode baixarNegativacaoBoletos(@NonNull List<BoletoModel> listBoletoModel) {
        if (listBoletoModel == null) {
            throw new NullPointerException("listBoletoModel is marked non-null but is null");
        }
        this.validaRequestProtesto(listBoletoModel);
        try {
            ConfiguracaoSicoobAPI configuracao = this.getConfiguracaoSicoob();
            configuracao.setToken(configuracao.getToken(configuracao));
            String json = BoletoSicoobModelConverter.gerarJsonProtesto(listBoletoModel, configuracao);
            log.log(Level.CONFIG, "Json baixa Boleto negativa\u00e7\u00e3o SERASA: {0}", json);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccess_token()), new BasicHeader("x-sicoob-clientid", configuracao.getClientId())};
            CloseableHttpResponse response = RestUtil.del(configuracao.getURLBase() + configuracao.getUrlNegativacaoBoleto(), headers, json, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            String retorno = RestUtil.validaResponseERetornaBody(response);
            ObjectMapper createObjectMapper = JsonUtil.createObjectMapper();
            JsonNode readTree = createObjectMapper.readTree(retorno);
            return readTree;
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    private void montaLinhaDigitavel(BoletoModel boletoModel, StringBuilder linhaParte1, StringBuilder linhaParte2, StringBuilder linhaParte3, StringBuilder linhaParte4, StringBuilder linhaParte5) {
        StringBuilder linhaDigitavel = new StringBuilder();
        linhaDigitavel.append(linhaParte1.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte1.toString(), 5, 10);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte2.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte2.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte3.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte3.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append((CharSequence)linhaParte4);
        linhaDigitavel.append("  ");
        linhaDigitavel.append((CharSequence)linhaParte5);
        boletoModel.setLinhaDigitavel(linhaDigitavel.toString());
    }

    private void validaDadosImpressao(BoletoModel boleto) {
        ValidaUtils.validaBoletoModel(boleto, Arrays.asList("locaisDePagamento", "dataVencimento", "beneficiario.nomeBeneficiario", "beneficiario.documento", "beneficiario.agencia", "beneficiario.numeroConvenio", "beneficiario.conta", "dataEmissao", "numeroDocumento", "especieDocumento", "aceite", "nossoNumero", "digitoNossoNumero", "especieMoeda", "valorBoleto", "pagador.nome", "pagador.documento", "pagador.endereco.logradouro", "pagador.endereco.cep", "linhaDigitavel", "codigoBarras", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.uf"));
    }
}

