/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicoob_api;

import br.com.java_brasil.boleto.model.Configuracao;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.Token;
import br.com.java_brasil.boleto.util.RestUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class ConfiguracaoSicoobAPI
implements Configuracao {
    private static final Logger log = Logger.getLogger(ConfiguracaoSicoobAPI.class.getName());
    @NotEmpty
    private String clientId;
    @NotEmpty
    private String cooperativa;
    @NotEmpty
    private String contaCorrente;
    @NotNull
    private Integer numeroContrato;
    private Integer numeroContratoCobranca;
    @NotNull
    private AmbienteEnum ambiente;
    @NotEmpty
    @Deprecated
    private String urlBaseHomologacao = "https://api.sicoob.com.br/cobranca-bancaria/v2";
    @NotEmpty
    private String urlBaseProducao = "https://api.sicoob.com.br/cobranca-bancaria/v2";
    @NotEmpty
    private String urlToken = "https://auth.sicoob.com.br/auth/realms/cooperado/protocol/openid-connect/token";
    @NotEmpty
    private String urlRegistraBoleto = "/boletos";
    @NotEmpty
    private String urlConsultaBoleto = "/boletos";
    @NotEmpty
    private String urlProtestaBoleto = "/boletos/protestos";
    @NotEmpty
    private String urlNegativacaoBoleto = "/boletos/negativacoes";
    private Token token;
    private String refreshToken;
    private LocalDateTime expiracaoToken;
    @NonNull
    private File keyFile;
    @NotEmpty
    private String keyPassword;
    private final String arquivoJasper = "BoletoSicoob";
    private final String logo = "LogoSicoob.png";
    private InputStream modeloImpressaoBoleto;
    private HashMap<String, Object> parametrosImpressaoBoleto = new HashMap();

    public String getURLBase() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlBaseProducao : this.urlBaseHomologacao;
    }

    public HashMap<String, Object> getParametrosImpressaoBoleto() {
        return this.parametrosImpressaoBoleto;
    }

    public void setModeloImpressaoBoleto(InputStream modeloImpressaoBoleto) {
        this.modeloImpressaoBoleto = modeloImpressaoBoleto;
    }

    @Override
    public InputStream modeloImpressaoBoleto() {
        if (this.modeloImpressaoBoleto == null) {
            try {
                this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoSicoob.jasper");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.modeloImpressaoBoleto;
    }

    @Override
    public void usarModeloImpressaoBoletoCarne() {
        try {
            this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoCarne.jasper");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public HashMap<String, Object> parametrosImpressaoBoleto() {
        Image imageLogo = null;
        try {
            InputStream inputStreamLogo = this.getClass().getResourceAsStream("/logo/LogoSicoob.png");
            imageLogo = new ImageIcon(IOUtils.toByteArray((InputStream)inputStreamLogo)).getImage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.parametrosImpressaoBoleto.put("LogoBanco", imageLogo);
        this.parametrosImpressaoBoleto.put("REPORT_LOCALE", new Locale("pt", "BR"));
        return this.parametrosImpressaoBoleto;
    }

    public Token getToken(ConfiguracaoSicoobAPI configuracao) throws IOException {
        if (this.token == null || this.getToken().expired()) {
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/x-www-form-urlencoded")};
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("grant_type", "client_credentials"));
            nvps.add(new BasicNameValuePair("client_id", configuracao.getClientId()));
            nvps.add(new BasicNameValuePair("scope", Token.TpScopeSicoob.COBRANCA_BOLETOS_BAIXA.todos()));
            String url = configuracao.getUrlToken();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
            httpPost.setHeaders(headers);
            CloseableHttpResponse response = RestUtil.enviaComandoCertificado((HttpUriRequest)httpPost, configuracao.getKeyFile().getAbsolutePath(), configuracao.getKeyPassword());
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Token banco sicoob: " + retorno);
            JsonObject json = JsonParser.parseString((String)retorno).getAsJsonObject();
            this.token = new Token().create(json.toString());
            String token = json.get("access_token").getAsString();
            LocalDateTime expires = LocalDateTime.now().plusSeconds(json.get("expires_in").getAsInt());
            log.config("Token Banco sicoob: " + token);
            log.config("Expira: " + expires);
        }
        return this.token;
    }

    @Override
    public List<String> camposObrigatoriosBoleto() {
        return Arrays.asList("numeroContrato", "modalidade", "numeroContaCorrente", "especieDocumento", "numeroBoleto", "valor", "dataVencimento", "pagador", "pagador.numeroCpfCnpj", "pagador.nome", "pagador.endereco", "pagador.endereco.logradouro", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.cep", "pagador.endereco.uf", "beneficiario", "beneficiario.numeroCpfCnpj", "beneficiario.nome");
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getCooperativa() {
        return this.cooperativa;
    }

    public String getContaCorrente() {
        return this.contaCorrente;
    }

    @NotNull
    public Integer getNumeroContrato() {
        return this.numeroContrato;
    }

    public Integer getNumeroContratoCobranca() {
        return this.numeroContratoCobranca;
    }

    @NotNull
    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    @Deprecated
    public String getUrlBaseHomologacao() {
        return this.urlBaseHomologacao;
    }

    public String getUrlBaseProducao() {
        return this.urlBaseProducao;
    }

    public String getUrlToken() {
        return this.urlToken;
    }

    public String getUrlRegistraBoleto() {
        return this.urlRegistraBoleto;
    }

    public String getUrlConsultaBoleto() {
        return this.urlConsultaBoleto;
    }

    public String getUrlProtestaBoleto() {
        return this.urlProtestaBoleto;
    }

    public String getUrlNegativacaoBoleto() {
        return this.urlNegativacaoBoleto;
    }

    public Token getToken() {
        return this.token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public LocalDateTime getExpiracaoToken() {
        return this.expiracaoToken;
    }

    @NonNull
    public File getKeyFile() {
        return this.keyFile;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getArquivoJasper() {
        return this.arquivoJasper;
    }

    public String getLogo() {
        return this.logo;
    }

    public InputStream getModeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setCooperativa(String cooperativa) {
        this.cooperativa = cooperativa;
    }

    public void setContaCorrente(String contaCorrente) {
        this.contaCorrente = contaCorrente;
    }

    public void setNumeroContrato(@NotNull Integer numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    public void setNumeroContratoCobranca(Integer numeroContratoCobranca) {
        this.numeroContratoCobranca = numeroContratoCobranca;
    }

    public void setAmbiente(@NotNull AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    @Deprecated
    public void setUrlBaseHomologacao(String urlBaseHomologacao) {
        this.urlBaseHomologacao = urlBaseHomologacao;
    }

    public void setUrlBaseProducao(String urlBaseProducao) {
        this.urlBaseProducao = urlBaseProducao;
    }

    public void setUrlToken(String urlToken) {
        this.urlToken = urlToken;
    }

    public void setUrlRegistraBoleto(String urlRegistraBoleto) {
        this.urlRegistraBoleto = urlRegistraBoleto;
    }

    public void setUrlConsultaBoleto(String urlConsultaBoleto) {
        this.urlConsultaBoleto = urlConsultaBoleto;
    }

    public void setUrlProtestaBoleto(String urlProtestaBoleto) {
        this.urlProtestaBoleto = urlProtestaBoleto;
    }

    public void setUrlNegativacaoBoleto(String urlNegativacaoBoleto) {
        this.urlNegativacaoBoleto = urlNegativacaoBoleto;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setExpiracaoToken(LocalDateTime expiracaoToken) {
        this.expiracaoToken = expiracaoToken;
    }

    public void setKeyFile(@NonNull File keyFile) {
        if (keyFile == null) {
            throw new NullPointerException("keyFile is marked non-null but is null");
        }
        this.keyFile = keyFile;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setParametrosImpressaoBoleto(HashMap<String, Object> parametrosImpressaoBoleto) {
        this.parametrosImpressaoBoleto = parametrosImpressaoBoleto;
    }
}

