/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicoob_cnab240;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SicoobUtil {
    public static String fatorData(LocalDate dataVencimento) {
        LocalDate dataBase = LocalDate.of(2000, 7, 3);
        if (dataVencimento.isAfter(LocalDate.of(2025, 2, 21))) {
            dataBase = LocalDate.of(2025, 2, 22);
        }
        long difDia = ChronoUnit.DAYS.between(dataBase, dataVencimento);
        return StringUtils.leftPad((String)("" + (difDia += 1000L)), (int)4, (char)'0');
    }

    public static Integer modulo11(String codigo) {
        try {
            int total = 0;
            int peso = 2;
            for (int i = 0; i < codigo.length(); ++i) {
                total += (codigo.charAt(codigo.length() - 1 - i) - 48) * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            int resto = total % 11;
            int digito = 11 - resto;
            return digito == 0 || digito > 9 ? 1 : digito;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static Integer modulo10(String codigo) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < codigo.length(); ++i) {
            int valor = (codigo.charAt(codigo.length() - 1 - i) - 48) * peso;
            valor = SicoobUtil.ajustaPeso(valor);
            total += valor;
            if (peso == 2) {
                --peso;
                continue;
            }
            ++peso;
        }
        int resto = total % 10;
        int dezena = total + (10 - resto);
        int digito = dezena - total;
        if (digito > 9) {
            digito = 0;
        }
        return digito;
    }

    private static int ajustaPeso(int valor) {
        if (valor <= 9) {
            return valor;
        }
        char[] digitos = String.valueOf(valor).toCharArray();
        int novoValor = 0;
        for (char d : digitos) {
            novoValor += Character.getNumericValue(d);
        }
        if (novoValor > 9) {
            return SicoobUtil.ajustaPeso(novoValor);
        }
        return novoValor;
    }

    public static int geraDigitoNossoNumero(String codigoAgencia, String codigoBeneficiario, String nossoNumero) {
        String digitoVerificador = StringUtils.leftPad((String)codigoAgencia, (int)4, (String)"0") + StringUtils.leftPad((String)codigoBeneficiario, (int)10, (String)"0") + StringUtils.leftPad((String)nossoNumero, (int)7, (String)"0");
        return SicoobUtil.digitoVerificadorNossoNumero(digitoVerificador);
    }

    public static Integer digitoVerificadorNossoNumero(String codigo) {
        try {
            int total = 0;
            int peso = 3;
            block8: for (int i = 0; i < codigo.length(); ++i) {
                total += (codigo.charAt(i) - 48) * peso;
                switch (peso) {
                    case 3: {
                        peso = 1;
                        continue block8;
                    }
                    case 1: {
                        peso = 9;
                        continue block8;
                    }
                    case 9: {
                        peso = 7;
                        continue block8;
                    }
                    case 7: {
                        peso = 3;
                        continue block8;
                    }
                }
            }
            int resto = total % 11;
            int digito = 11 - resto;
            return digito == 0 || digito > 9 ? 0 : digito;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static Map<String, String> getMapOcorrencia() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("02", "Entrada confirmada");
            map.put("03", "Entrada rejeitada");
            map.put("04", "Transfer\u00eancia de Carteira/Entrada");
            map.put("05", "Transfer\u00eancia de Carteira/Baixa");
            map.put("06", "Liquida\u00e7\u00e3o");
            map.put("07", "Confirma\u00e7\u00e3o do Recebimento da Instru\u00e7\u00e3o de Desconto");
            map.put("08", "Confirma\u00e7\u00e3o do Recebimento do Cancelamento do Desconto");
            map.put("09", "Baixa");
            map.put("11", "T\u00edtulos em Carteira (Em Ser)");
            map.put("12", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Abatimento");
            map.put("13", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Cancelamento Abatimento");
            map.put("14", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o Altera\u00e7\u00e3o de Vencimento");
            map.put("15", "Franco de Pagamento");
            map.put("17", "Liquida\u00e7\u00e3o Ap\u00f3s Baixa ou Liquida\u00e7\u00e3o T\u00edtulo N\u00e3o Registrado");
            map.put("19", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Protesto");
            map.put("20", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o de Susta\u00e7\u00e3o/Cancelamento de Protesto");
            map.put("23", "Remessa a Cart\u00f3rio (Aponte em Cart\u00f3rio)");
            map.put("24", "Retirada de Cart\u00f3rio e Manuten\u00e7\u00e3o em Carteira");
            map.put("25", "Protestado e Baixado (Baixa por Ter Sido Protestado)");
            map.put("26", "Instru\u00e7\u00e3o Rejeitada");
            map.put("27", "Confirma\u00e7\u00e3o do Pedido de Altera\u00e7\u00e3o de Outros Dados");
            map.put("28", "D\u00e9bito de Tarifas/Custas");
            map.put("29", "Ocorr\u00eancias do Pagador");
            map.put("30", "Altera\u00e7\u00e3o de Dados Rejeitada");
            map.put("33", "Confirma\u00e7\u00e3o da Altera\u00e7\u00e3o dos Dados do Rateio de Cr\u00e9dito");
            map.put("34", "Confirma\u00e7\u00e3o do Cancelamento dos Dados do Rateio de Cr\u00e9dito");
            map.put("35", "Confirma\u00e7\u00e3o do Desagendamento do D\u00e9bito Autom\u00e1tico");
            map.put("36", "Confirma\u00e7\u00e3o de envio de e-mail/SMS");
            map.put("37", "Envio de e-mail/SMS rejeitado");
            map.put("38", "Confirma\u00e7\u00e3o de altera\u00e7\u00e3o do Prazo Limite de Recebimento (a data deve ser\"");
            map.put("39", "Confirma\u00e7\u00e3o de Dispensa de Prazo Limite de Recebimento");
            map.put("40", "Confirma\u00e7\u00e3o da altera\u00e7\u00e3o do n\u00famero do t\u00edtulo dado pelo Benefici\u00e1rio");
            map.put("41", "Confirma\u00e7\u00e3o da altera\u00e7\u00e3o do n\u00famero controle do Participante");
            map.put("42", "Confirma\u00e7\u00e3o da altera\u00e7\u00e3o dos dados do Pagador");
            map.put("43", "Confirma\u00e7\u00e3o da altera\u00e7\u00e3o dos dados do Pagadorr/Avalista");
            map.put("44", "T\u00edtulo pago com cheque devolvido");
            map.put("45", "T\u00edtulo pago com cheque compensado");
            map.put("46", "Instru\u00e7\u00e3o para cancelar protesto confirmada");
            map.put("47", "Instru\u00e7\u00e3o para protesto para fins falimentares confirmada");
            map.put("48", "Confirma\u00e7\u00e3o de instru\u00e7\u00e3o de transfer\u00eancia de carteira/modalidade de cobran\u00e7a");
            map.put("49", "Altera\u00e7\u00e3o de contrato de cobran\u00e7a");
            map.put("50", "T\u00edtulo pago com cheque pendente de liquida\u00e7\u00e3o");
            map.put("51", "T\u00edtulo DDA reconhecido pelo Pagador");
            map.put("52", "T\u00edtulo DDA n\u00e3o reconhecido pelo Pagador");
            map.put("53", "T\u00edtulo DDA recusado pela CIP");
            map.put("54", "Confirma\u00e7\u00e3o da Instru\u00e7\u00e3o de Baixa/Cancelamento de T\u00edtulo Negativado sem Protesto");
            map.put("55", "Confirma\u00e7\u00e3o de Pedido de Dispensa de Multa");
            map.put("56", "Confirma\u00e7\u00e3o do Pedido de Cobran\u00e7a de Multa");
            map.put("57", "Confirma\u00e7\u00e3o do Pedido de Altera\u00e7\u00e3o de Cobran\u00e7a de Juros");
            map.put("58", "Confirma\u00e7\u00e3o do Pedido de Altera\u00e7\u00e3o do Valor/Data de Desconto");
            map.put("59", "Confirma\u00e7\u00e3o do Pedido de Altera\u00e7\u00e3o do Benefici\u00e1rio do T\u00edtulo");
            map.put("60", "Confirma\u00e7\u00e3o do Pedido de Dispensa de Juros de Mora");
            map.put("80", "Confirma\u00e7\u00e3o da instru\u00e7\u00e3o de negativa\u00e7\u00e3o");
            map.put("85", "Confirma\u00e7\u00e3o de Desist\u00eancia de Protesto");
            map.put("86", "Confirma\u00e7\u00e3o de cancelamento do Protesto");
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static String getOcorrencia(String ocorrencia) {
        try {
            Map<String, String> map = SicoobUtil.getMapOcorrencia();
            return map.get(ocorrencia) == null ? "Ocorr\u00eancia n\u00e3o catalogada" : map.get(ocorrencia);
        }
        catch (Exception e) {
            return "Error - Ocorr\u00eancia n\u00e3o catalogada";
        }
    }

    public static Map<String, String> getMapMotivoOcorrencia(String ocorrencia) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            switch (ocorrencia) {
                case "02": 
                case "03": 
                case "26": 
                case "30": {
                    map.put("00", "");
                    map.put("02", "C\u00f3digo do registro detalhe inv\u00e1lido");
                    map.put("03", "C\u00f3digo da ocorr\u00eancia inv\u00e1lida");
                    map.put("04", "C\u00f3digo de ocorr\u00eancia n\u00e3o permitida para a carteira");
                    map.put("05", "C\u00f3digo de ocorr\u00eancia n\u00e3o num\u00e9rico");
                    map.put("07", "Ag\u00eancia/conta/Digito - |Inv\u00e1lido");
                    map.put("08", "Nosso n\u00famero inv\u00e1lido");
                    map.put("09", "Nosso n\u00famero duplicado");
                    map.put("10", "Carteira inv\u00e1lida");
                    map.put("13", "Identifica\u00e7\u00e3o da emiss\u00e3o do bloqueto inv\u00e1lida (NOVO)");
                    map.put("16", "Data de vencimento inv\u00e1lida");
                    map.put("18", "Vencimento fora do prazo de opera\u00e7\u00e3o");
                    map.put("20", "Valor do T\u00edtulo inv\u00e1lido");
                    map.put("21", "Esp\u00e9cie do T\u00edtulo inv\u00e1lida");
                    map.put("22", "Esp\u00e9cie n\u00e3o permitida para a carteira");
                    map.put("24", "Data de emiss\u00e3o inv\u00e1lida");
                    map.put("28", "C\u00f3digo do desconto inv\u00e1lido (NOVO)");
                    map.put("38", "Prazo para protesto/ Negativa\u00e7\u00e3o inv\u00e1lido (ALTERADO)");
                    map.put("39", "Pedido de Protesto/Negativa\u00e7\u00e3o N\u00e3o Permitido para o T\u00edtulo");
                    map.put("40", "T\u00edtulo com Ordem de Protesto/Negativa\u00e7\u00e3o Emitida");
                    map.put("41", "Pedido de Cancelamento/Susta\u00e7\u00e3o para T\u00edtulos sem Instru\u00e7\u00e3o de Negativa\u00e7\u00e3o/Protesto");
                    map.put("44", "Ag\u00eancia Benefici\u00e1rio n\u00e3o prevista");
                    map.put("45", "Nome do pagador n\u00e3o informado (NOVO)");
                    map.put("46", "Tipo/n\u00famero de inscri\u00e7\u00e3o do pagador inv\u00e1lidos (NOVO)");
                    map.put("47", "Endere\u00e7o do pagador n\u00e3o informado (NOVO)");
                    map.put("48", "CEP Inv\u00e1lido (NOVO)");
                    map.put("50", "CEP irregular - Banco Correspondente");
                    map.put("58", "Data da Multa Inv\u00e1lida");
                    map.put("63", "Entrada para T\u00edtulo j\u00e1 cadastrado");
                    map.put("65", "Limite excedido (NOVO)");
                    map.put("66", "N\u00famero autoriza\u00e7\u00e3o inexistente (NOVO)");
                    map.put("68", "D\u00e9bito n\u00e3o agendado - erro nos dados de remessa");
                    map.put("69", "D\u00e9bito n\u00e3o agendado - Pagador n\u00e3o consta no cadastro de autorizante");
                    map.put("70", "D\u00e9bito n\u00e3o agendado - Benefici\u00e1rio n\u00e3o autorizado pelo Pagador");
                    map.put("71", "D\u00e9bito n\u00e3o agendado - Benefici\u00e1rio n\u00e3o participa do d\u00e9bito Autom\u00e1tico");
                    map.put("72", "D\u00e9bito n\u00e3o agendado - C\u00f3digo de moeda diferente de R$");
                    map.put("73", "D\u00e9bito n\u00e3o agendado - Data de vencimento inv\u00e1lida");
                    map.put("74", "D\u00e9bito n\u00e3o agendado - Conforme seu pedido, T\u00edtulo n\u00e3o registrado");
                    map.put("75", "D\u00e9bito n\u00e3o agendado \u2013 Tipo de n\u00famero de inscri\u00e7\u00e3o do debitado inv\u00e1lido");
                    map.put("79", "Data Juros de Mora Inv\u00e1lido");
                    break;
                }
                case "28": {
                    map.put("00", "");
                    map.put("03", "Tarifa de Desist\u00eancia");
                    map.put("04", "Tarifa de protesto");
                    map.put("08", "Custas de protesto");
                    map.put("11", "Forma de Cadastramento do T\u00edtulo Inv\u00e1lido");
                    map.put("21", "Tarifa de Grava\u00e7\u00e3o Eletr\u00f4nica = CRA");
                    break;
                }
                default: {
                    map.put("00", "");
                    map.put("AA", "Controle inv\u00e1lido");
                    map.put("AB", "Tipo de opera\u00e7\u00e3o inv\u00e1lido");
                    map.put("AC", "Tipo de seri\u00e7o inv\u00e1lido");
                    map.put("AD", "Forma de lan\u00e7amento inv\u00e1lida");
                    map.put("AE", "Tipo/N\u00famero de inscri\u00e7\u00e3o inv\u00e1lido");
                    map.put("AF", "C\u00f3digo de conv\u00eanio inv\u00e1lido");
                    map.put("AG", "Ag\u00eancia/conta/d\u00edgito inv\u00e1lidos");
                    map.put("AH", "Nosso n\u00famero seguencial do registro no lote inv\u00e1lido");
                    map.put("AI", "C\u00f3digo de segmento de detalhe inv\u00e1lido");
                    map.put("AJ", "Tipo de movimento inv\u00e1lido");
                    map.put("AK", "C\u00f3digo da cam\u00e2ra de compensa\u00e7\u00e3o do banco favorecido inv\u00e1lido");
                    map.put("AL", "C\u00f3digo do banco favorecido, institui\u00e7\u00e3o de pagamento ou deposit\u00e1rio inv\u00e1lido");
                    map.put("AM", "Ag\u00eancia mantenedora da conta corrente do favorecido inv\u00e1lida");
                    map.put("AN", "Conta corrente/DV/Conta de pagamento do favorecido inv\u00e1lido");
                    map.put("AO", "Nome do favorecido n\u00e3o informado");
                    map.put("AP", "Data lan\u00e7amento inv\u00e1lido");
                    map.put("AQ", "Tipo/Quantidade da moeda inv\u00e1lido");
                    map.put("AR", "Valor do lan\u00e7amento inv\u00e1lido");
                    map.put("AS", "Aviso ao favorecido - identifica\u00e7\u00e3o inv\u00e1lida");
                    map.put("AT", "Tipo/N\u00famero de incri\u00e7\u00e3o do favorecido inv\u00e1lido");
                    map.put("AU", "Logradouro do favorecido n\u00e3o informado");
                    map.put("AV", "N\u00ba do local do favorecido n\u00e3o informado");
                    map.put("AW", "Cidade do favorecido n\u00e3o informada");
                    map.put("AX", "CEP/Complemento do favorecido inv\u00e1lido");
                    map.put("AY", "Sigla do estado do favorecido inv\u00e1lida");
                    map.put("AZ", "C\u00f3digo/Nome do banco deposit\u00e1rio inv\u00e1lido");
                    map.put("BA", "C\u00f3digo/Nome ag\u00eancia deposit\u00e1ria n\u00e3o inforamdo");
                    map.put("BB", "Seu n\u00famero inv\u00e1lido");
                    map.put("BC", "Nosso n\u00famero inv\u00e1lido");
                    map.put("BD", "Inclus\u00e3o efetuada com sucesso");
                    map.put("BE", "Altera\u00e7\u00e3o efetuada com sucesso");
                    map.put("BF", "Exclus\u00e3o efetuada com sucesso");
                    map.put("BG", "Ag\u00eancia/Conta impedida legalmente/bloqueada");
                    map.put("BH", "Empresa n\u00e3o pagou sal\u00e1rio");
                    map.put("BI", "Falecimento do mutu\u00e1rio");
                    map.put("BJ", "Empresa n\u00e3o envio remessa do mutu\u00e1rio");
                    map.put("BK", "Empresa n\u00e3o enviou remessa no vencimento");
                    map.put("BL", "Valor da parcela inv\u00e1lida");
                    map.put("BM", "Identifica\u00e7\u00e3o do contrato inv\u00e1lida");
                    map.put("BN", "Opera\u00e7\u00e3o de consigna\u00e7\u00e3o incluida com sucesso");
                    map.put("BO", "Opera\u00e7\u00e3o de consigna\u00e7\u00e3o alterada com sucesso");
                    map.put("BP", "Opera\u00e7\u00e3o de consigna\u00e7\u00e3o excluida com sucesso");
                    map.put("BQ", "Opera\u00e7\u00e3o de consigna\u00e7\u00e3o liquidada com sucesso");
                    map.put("BR", "Reativa\u00e7\u00e3o efetuada com sucesso");
                    map.put("BS", "Suspen\u00e7\u00e3o efetuada com sucesso");
                    map.put("CA", "C\u00f3digo de barras - C\u00f3digo de banco inv\u00e1lido");
                    map.put("CB", "C\u00f3digo de barras - C\u00f3digo da moeda inv\u00e1lido");
                    map.put("CC", "C\u00f3digo de barras - D\u00edgito verificador geral inv\u00e1lido");
                    map.put("CD", "C\u00f3digo de barras - Valor do t\u00edtulo inv\u00e1lido");
                    map.put("CE", "C\u00f3digo de barras - Campo livre inv\u00e1lido");
                    map.put("CF", "Valor do documento inv\u00e1lido");
                    map.put("CG", "Valor do abatimento inv\u00e1lido");
                    map.put("CH", "Valor do desconto inv\u00e1lido");
                    map.put("CI", "Valor de mora inv\u00e1lido");
                    map.put("CJ", "Valor da multa inv\u00e1lido");
                    map.put("CK", "Valor do IR inv\u00e1lido");
                    map.put("CL", "Valor do ISS inv\u00e1lido");
                    map.put("CM", "Valor do IOF inv\u00e1lido");
                    map.put("CN", "Valor de outras dedu\u00e7\u00f5es inv\u00e1lido");
                    map.put("CO", "Valor de outros acrescimos inv\u00e1lido");
                    map.put("CP", "Valor do INSS inv\u00e1lido");
                    map.put("HA", "Lote n\u00e3o aceito");
                    map.put("HB", "Inscri\u00e7\u00e3o da empresa inv\u00e1lido para o contrato");
                    map.put("HC", "Conv\u00e9nio com a empresa inexistente/inv\u00e1lido para o contrato");
                    map.put("HD", "Ag\u00eancia/Conta corrente da empresa inexistente/inv\u00e1lido para o contrato");
                    map.put("HE", "Tipo de servi\u00e7o inv\u00e1lido para o contrato");
                    map.put("HF", "Conta corrente da empresa com saldo insuficiente");
                    map.put("HG", "Lote de servi\u00e7o fora de seguencia");
                    map.put("HH", "Lote de servi\u00e7o inv\u00e1lido");
                    map.put("HI", "Arquivo n\u00e3o aceito");
                    map.put("HJ", "Tipo de registo inv\u00e1lido");
                    map.put("HK", "C\u00f3digo remessa/retorno inv\u00e1lido");
                    map.put("HL", "Vers\u00e3o de Layout inv\u00e1lida");
                    map.put("HM", "Mutu\u00e1rio n\u00e3o identificado");
                    map.put("HN", "Tipo do benef\u00edcio n\u00e3o permitido emprestimo");
                    map.put("HO", "Benef\u00edcio cessado/suspenso");
                    map.put("HP", "Benef\u00edcio possui representante legal");
                    map.put("HQ", "Benef\u00edcio \u00e9 do tipo PA(Pens\u00e3o alimenticia)");
                    map.put("HR", "Quantidade de contratos permitida exedida");
                    map.put("HS", "Benef\u00edcio n\u00e3o pertence ao banco informado");
                    map.put("HT", "Inicio do desconto informado j\u00e1 ultrapasado");
                    map.put("HU", "N\u00famero da parcela inv\u00e1lida");
                    map.put("HV", "Quantidade de parcela inv\u00e1lida");
                    map.put("HW", "Marggem consignavel excedida para o mutu\u00e1rio dentro do prazo do contrato");
                    map.put("HX", "Empr\u00e9stimo j\u00e1 cadastrado");
                    map.put("HY", "Empr\u00e9stimo inexistente");
                    map.put("HZ", "Empr\u00e9stimo j\u00e1 encerrado");
                    map.put("H1", "Arquivo sem Traler");
                    map.put("H2", "Mutu\u00e1rio sem cr\u00e9dito na competencia");
                    map.put("H3", "N\u00e3o descontato - Outros motivos");
                    map.put("H4", "Retorno de cr\u00e9dito n\u00e3o pago");
                    map.put("H5", "Cancelamento de empr\u00e9stimo retroativo");
                    map.put("H6", "Outros motivos de Glosa");
                    map.put("H7", "Margem consignavel exedida para o mutu\u00e1rio acima do prazo de contrato");
                    map.put("H8", "Mutu\u00e1rio desligado do empregador");
                    map.put("H9", "Mutu\u00e1rio afastado por licen\u00e7a");
                    map.put("IA", "Primeiro nome do mutu\u00e1rio diferente do primento nome do movimento do censo ou diferente da base de titular do beneficio");
                    map.put("IB", "Benef\u00edcio suspenso/cessado pela APS ou SISOBI");
                    map.put("IC", "Benef\u00edcio suspenso por dependencia de calculo");
                    map.put("ID", "Benef\u00edcio suspenso/cessado pela inspetoria/auditoria");
                    map.put("IE", "Benef\u00edcio bloqueado para emprestimo pelo beneficiario");
                    map.put("IF", "Benef\u00edcio bloqueado para emprestimo por TBM");
                    map.put("IG", "Benef\u00edcio esta em fase de concess\u00e3o de PA ou desdobramento");
                    map.put("IH", "Benef\u00edcio sessado por \u00f3bito");
                    map.put("II", "Benef\u00edcio sessado por fraude");
                    map.put("IJ", "Benef\u00edcio sessado por concess\u00e3o de outro benef\u00edcio");
                    map.put("IK", "Benef\u00edcio sessado: estatut\u00e1rio transferido para \u00f3rg\u00e3o de origem");
                    map.put("IL", "Emprestimo suspenso pela APS");
                    map.put("IM", "Empr\u00e9stimo cancelado pelo banco");
                    map.put("IN", "Cr\u00e9dito transformado em PAB");
                    map.put("IO", "T\u00e9rmino da consigna\u00e7\u00e3o foi alterado");
                    map.put("IP", "Fim do empr\u00e9stimo ocorreu durante per\u00eddo de suspens\u00e3o ou concess\u00e3o");
                    map.put("IQ", "Empr\u00e9stimo suspenso pelo banco");
                    map.put("IR", "N\u00e3o haverba\u00e7\u00e3o de contrato - Quantidade de parcelas/competencias informadas ultrapassou a data limite da extins\u00e3o de cota do dependente t\u00edtulo de beneficions ");
                    map.put("TA", "Lote n\u00e3o aceito - Totais do lote com diferen\u00e7a");
                    map.put("YA", "T\u00edtulo n\u00e3o encontrato");
                    map.put("YB", "Identificador registro opcional inv\u00e1lido");
                    map.put("YC", "C\u00f3digo padr\u00e3o inv\u00e1lido");
                    map.put("YD", "C\u00f3digo de ocorrencia inv\u00e1lido");
                    map.put("YE", "Complemento de ocorrencia inv\u00e1lido");
                    map.put("YF", "Alega\u00e7\u00e3o j\u00e1 informada");
                    map.put("ZA", "Ag\u00eancia/Conta do favorecido substituida");
                    map.put("ZB", "Divergencia entre o primeiro e \u00faltimo do beneficiario versus primento e \u00faltimo nome na receita federal");
                    map.put("ZC", "Confirma\u00e7\u00e3o de antecipa\u00e7\u00e3o de valor");
                    map.put("ZD", "Antecipa\u00e7\u00e3o parcial de valor");
                    map.put("ZE", "T\u00edtulo bloqueado na base");
                    map.put("ZF", "Sistema em conting\u00eancia - t\u00edtulo valor maior que referencia");
                    map.put("ZG", "Sistema em conting\u00eancia - t\u00edtulo vencido");
                    map.put("ZH", "Sistema em contig\u00eancia - t\u00edtulo indexado");
                    map.put("ZI", "Beneficiario divergente");
                    map.put("ZJ", "Limite de pagamento parciais exedido");
                    map.put("ZK", "Boleto j\u00e1 liquidado");
                    map.put("PA", "PIX n\u00e3o efetivado");
                    map.put("PB", "Transa\u00e7\u00e3o interrompida devido a erro no PSP do recebedor");
                    map.put("PC", "N\u00famero da conta transacional encerrada no PSP do recebedor");
                    map.put("PD", "Tipo incorreto para a conta transacional especificada");
                    map.put("PE", "Tipo de transa\u00e7\u00e3o n\u00e3o \u00e9 suportado-autorizado na conta transacional especificada");
                    map.put("PF", "CPF/CNPJ do usu\u00e1rio recebedor n\u00e3o \u00e9 consistente com o t\u00edtulo da conta transacional especificada");
                    map.put("PG", "CPF/CNPJ do usu\u00e1ri recebedor incorreta");
                    map.put("PH", "Ordem rejeitada pelo PSP do recebedor");
                    map.put("PI", "ISPB do PSP do pagador inv\u00e1lido ou inexistente");
                    map.put("PJ", "Chave n\u00e3o cadastrada no DICT");
                    map.put("PK", "QR-CODE inv\u00e1lido/vencido");
                    map.put("PL", "Forma de inicia\u00e7\u00e3o inv\u00e1lida");
                    map.put("PM", "Chave de pagamento inv\u00e1lida");
                    map.put("PN", "Chave de pagamento n\u00e3o informada");
                }
            }
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static String getMotivoOcorrenciaSicredi(String ocorrencia, String motivoOcorrencia) {
        try {
            Map<String, String> map = SicoobUtil.getMapMotivoOcorrencia(ocorrencia);
            return map.get(motivoOcorrencia) == null ? "Motivo Ocorr\u00eancia n\u00e3o catalogada" : map.get(motivoOcorrencia);
        }
        catch (Exception e) {
            return "Error - Motivo Ocorr\u00eancia n\u00e3o catalogada";
        }
    }

    public static boolean isASCIISicoob(char ch) {
        if (ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9') {
            return true;
        }
        if (ch == ' ' || ch == '!' || ch == '#' || ch == '$' || ch == '%' || ch == '&' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == '-' || ch == '.' || ch == '/' || ch == ':' || ch == ';' || ch == '@' || ch == '[' || ch == '\\' || ch == ']' || ch == '{' || ch == '}') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        return ch == '\n' || ch == '\r';
    }

    public static Map<String, String> getMapRemessaInstrucao() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("01", "Entrada de T\u00edtulos");
        map.put("02", "Solicita\u00e7\u00e3o de Baixa");
        map.put("04", "Concess\u00e3o de Abatimento");
        map.put("05", "Cancelamento de Abatimento");
        map.put("06", "Prorroga\u00e7\u00e3o de Vencimento");
        map.put("09", "Protestar");
        map.put("10", "Desist\u00eancia do Protesto e Baixar T\u00edtulo");
        map.put("11", "Desist\u00eancia do Protesto e manter em carteira");
        map.put("12", "Altera\u00e7\u00e3o de Juros de Mora");
        map.put("13", "Dispensar Cobran\u00e7a de Juros de Mora");
        map.put("14", "Altera\u00e7\u00e3o de Valor/Percentual de Multa");
        map.put("15", "Dispensar Cobran\u00e7a de Multa");
        map.put("19", "Prazo limite de recebimento - alterar");
        map.put("20", "Prazo limite de recebimento - dispensar");
        map.put("23", "Alterar dados do pagador");
        map.put("31", "Altera\u00e7\u00f5es de outros dados");
        return map;
    }

    public static boolean isRemessaInstrucaoInvalida(String instrucao) {
        Map<String, String> instrucoes = SicoobUtil.getMapRemessaInstrucao();
        return !instrucoes.entrySet().stream().filter(e -> ((String)e.getKey()).equals(instrucao)).findFirst().isPresent();
    }

    public static Map<String, String> getMapEspecieDoTitulo() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("01", "CH Cheque");
        map.put("02", "DM Duplicata Mercantil");
        map.put("03", "DMI Duplicata Mercantil p/ Indica\u00e7\u00e3o");
        map.put("04", "DS Duplicata de Servi\u00e7o");
        map.put("05", "DSI Duplicata de Servi\u00e7o p/ Indica\u00e7\u00e3o");
        map.put("06", "DR Duplicata Rural");
        map.put("07", "LC Letra de C\u00e2mbio");
        map.put("08", "NCC Nota de Cr\u00e9dito Comercial");
        map.put("09", "NCE Nota de Cr\u00e9dito a Exporta\u00e7\u00e3o");
        map.put("10", "NCI Nota de Cr\u00e9dito Industrial");
        map.put("11", "NCR Nota de Cr\u00e9dito Rural");
        map.put("12", "NP Nota Promiss\u00f3ria");
        map.put("13", "NPR Nota Promiss\u00f3ria Rural");
        map.put("14", "TM Triplicata Mercantil");
        map.put("15", "TS Triplicata de Servi\u00e7o");
        map.put("16", "NS Nota de Seguro");
        map.put("17", "RC Recibo");
        map.put("18", "FAT Fatura");
        map.put("19", "ND Nota de D\u00e9bito");
        map.put("20", "AP Ap\u00f3lice de Seguro");
        map.put("21", "ME Mensalidade Escolar");
        map.put("22", "PC Parcela de Cons\u00f3rcio");
        map.put("23", "NF Nota Fiscal");
        map.put("24", "DD Documento de D\u00edvida\u201825= C\u00e9dula de Produto Rural");
        map.put("31", "Cart\u00e3o de Cr\u00e9dito");
        map.put("32", "BDP Boleto de Proposta");
        map.put("99", "Outros");
        return map;
    }

    public static boolean isEspecieDoTituloInvalida(String especie) {
        Map<String, String> especies = SicoobUtil.getMapEspecieDoTitulo();
        return !especies.entrySet().stream().filter(e -> ((String)e.getKey()).equals(especie)).findFirst().isPresent();
    }
}

