/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicrei_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.InformacaoModel;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.TipoJurosEnum;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.ConfiguracaoSicrediAPI;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediBoleto;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediBoletoResponse;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediInstrucaoResponse;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediModelConverter;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.RestUtil;
import br.com.java_brasil.boleto.util.ValidaUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;

public class BancoSicrediAPI
extends BoletoController {
    private static final Logger log = Logger.getLogger(BancoSicrediAPI.class.getName());

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            boletos.forEach(this::preparaValidaBoletoImpressao);
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSicrediAPI configuracao = this.getConfiguracaoSicredi();
            configuracao.setToken(configuracao.getToken(configuracao));
            BoletoSicrediBoleto request = BoletoSicrediModelConverter.montaBoletoRequest(boletoModel, configuracao);
            String json = RestUtil.ObjectToJson(request);
            log.config("Json Envio Boleto: " + json);
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccessToken()), new BasicHeader("cooperativa", configuracao.getCooperativa()), new BasicHeader("posto", configuracao.getPosto()), new BasicHeader("x-api-key", configuracao.getTokenId())};
            CloseableHttpResponse response = RestUtil.post(configuracao.urlBase(), headers, json);
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Envio Boleto: " + retorno);
            BoletoSicrediBoletoResponse boletoResponse = RestUtil.JsonToObject(retorno, BoletoSicrediBoletoResponse.class);
            if (boletoResponse == null) {
                throw new BoletoException("Erro ao enviar boleto, c\u00f3digo erro: " + boletoResponse.getCode() + " Mensagem : " + boletoResponse.getMessage());
            }
            if (StringUtils.isNotEmpty((CharSequence)boletoResponse.getCode()) && !"200".equals(boletoResponse.getCode())) {
                throw new BoletoException("Erro ao gerar boleto", json);
            }
            return BoletoSicrediModelConverter.montaBoletoResponse(boletoModel, boletoResponse);
        }
        catch (Exception e) {
            String mensagemTratada = this.tratarErro(e, boletoModel);
            throw new BoletoException(mensagemTratada, e);
        }
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSicrediAPI configuracao = (ConfiguracaoSicrediAPI)this.getConfiguracao();
            configuracao.setToken(configuracao.getToken(configuracao));
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json;charset=ISO-8859-1"), new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccessToken()), new BasicHeader("x-api-key", configuracao.getTokenId()), new BasicHeader("cooperativa", configuracao.getCooperativa()), new BasicHeader("posto", configuracao.getPosto()), new BasicHeader("codigoBeneficiario", configuracao.getCodBene())};
            String instrucao = "";
            String jsonEnvio = "";
            if (StringUtils.isNotEmpty((CharSequence)boletoModel.getNumeroDocumentoAlterar())) {
                log.info("N\u00famero Documento para Altera\u00e7\u00e3o est\u00e1 preenchido");
                instrucao = "/seu-numero";
                jsonEnvio = "{\"seuNumero\":\"" + boletoModel.getNumeroDocumento() + "\"}";
            }
            if (boletoModel.getDataVencimentoAlterar() != null) {
                log.info("Data de Vencimento para Altera\u00e7\u00e3o est\u00e1 preenchido");
                instrucao = "/data-vencimento";
                jsonEnvio = "{\"dataVencimento\":\"" + BoletoUtil.getDataFormatoYYYYMMDD(boletoModel.getDataVencimentoAlterar()) + "\"}";
            }
            if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorDescontosAlterar())) {
                log.info("Valor de Desconto para Altera\u00e7\u00e3o est\u00e1 preenchido");
                instrucao = "/desconto";
                jsonEnvio = "{\"valorDesconto1\":" + BoletoUtil.formatarCasasDecimais(boletoModel.getValorDescontosAlterar(), 2) + "}";
            }
            String urlRequisicao = configuracao.urlBase() + "/" + boletoModel.getNossoNumero() + instrucao;
            log.info("URL da requisi\u00e7\u00e3o : " + urlRequisicao);
            CloseableHttpResponse response = RestUtil.patch(urlRequisicao, headers, jsonEnvio);
            String json = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno " + instrucao + " de Boleto: " + json);
            BoletoSicrediInstrucaoResponse instrucaoResponse = RestUtil.JsonToObject(json, BoletoSicrediInstrucaoResponse.class);
            if (instrucaoResponse == null) {
                throw new BoletoException("Erro ao " + instrucao + " boleto");
            }
            return BoletoSicrediModelConverter.montaBoletoInstrucaoResponse(boletoModel, instrucaoResponse);
        }
        catch (Exception e) {
            String mensagemTratada = this.tratarErro(e, boletoModel);
            throw new BoletoException(mensagemTratada, e);
        }
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSicrediAPI configuracao = (ConfiguracaoSicrediAPI)this.getConfiguracao();
            configuracao.setToken(configuracao.getToken(configuracao));
            String parametros = "?codigoBeneficiario=" + boletoModel.getBeneficiario().getCodigoBeneficiario();
            parametros = StringUtils.isNotBlank((CharSequence)boletoModel.getNossoNumero()) ? parametros + "&nossoNumero=" + boletoModel.getNossoNumero() : parametros + "&nossoNumero=NAO_INFORMADO";
            HttpGet get = new HttpGet(configuracao.urlBase() + parametros);
            get.setHeader((Header)new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccessToken()));
            get.setHeader("Content-Type", "application/json");
            get.setHeader("Accept", "application/json");
            get.setHeader((Header)new BasicHeader("x-api-key", configuracao.getTokenId()));
            get.setHeader((Header)new BasicHeader("cooperativa", configuracao.getCooperativa()));
            get.setHeader((Header)new BasicHeader("posto", configuracao.getPosto()));
            CloseableHttpResponse response = RestUtil.enviaComando((HttpUriRequest)get);
            String json = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Consulta Boleto: " + json);
            BoletoSicrediBoletoResponse boletoResponse = RestUtil.JsonToObject(json, BoletoSicrediBoletoResponse.class);
            if (boletoResponse == null) {
                throw new BoletoException("Erro ao enviar boleto, c\u00f3digo erro: " + boletoResponse.getCode() + " Mensagem : " + boletoResponse.getMessage());
            }
            if (StringUtils.isNotEmpty((CharSequence)boletoResponse.getCode()) && !"200".equals(boletoResponse.getCode())) {
                throw new BoletoException("Erro ao gerar boleto", json);
            }
            return BoletoSicrediModelConverter.montaBoletoResponse(boletoModel, boletoResponse);
        }
        catch (Exception e) {
            String mensagemTratada = this.tratarErro(e, boletoModel);
            throw new BoletoException(mensagemTratada, e);
        }
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoSicrediAPI configuracao = (ConfiguracaoSicrediAPI)this.getConfiguracao();
            configuracao.setToken(configuracao.getToken(configuracao));
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json;charset=ISO-8859-1"), new BasicHeader("Authorization", "Bearer " + configuracao.getToken().getAccessToken()), new BasicHeader("x-api-key", configuracao.getTokenId()), new BasicHeader("cooperativa", configuracao.getCooperativa()), new BasicHeader("posto", configuracao.getPosto()), new BasicHeader("codigoBeneficiario", configuracao.getCodBene())};
            String urlRequisicao = configuracao.urlBase() + "/" + boletoModel.getNossoNumero() + "/baixa";
            log.info("URL da requisi\u00e7\u00e3o : " + urlRequisicao);
            CloseableHttpResponse response = RestUtil.patch(urlRequisicao, headers, "{}");
            String json = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Baixa de Boleto: " + json);
            BoletoSicrediInstrucaoResponse instrucaoResponse = RestUtil.JsonToObject(json, BoletoSicrediInstrucaoResponse.class);
            if (instrucaoResponse == null) {
                throw new BoletoException("Erro ao baixar boleto");
            }
            return BoletoSicrediModelConverter.montaBoletoInstrucaoResponse(boletoModel, instrucaoResponse);
        }
        catch (Exception e) {
            String mensagemTratada = this.tratarErro(e, boletoModel);
            throw new BoletoException(mensagemTratada, e);
        }
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco em modelo API.");
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        return Collections.emptyList();
    }

    private ConfiguracaoSicrediAPI getConfiguracaoSicredi() {
        return (ConfiguracaoSicrediAPI)this.getConfiguracao();
    }

    private void preparaValidaBoletoImpressao(BoletoModel boletoModel) {
        boletoModel.getBeneficiario().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiario().getDocumento()));
        boletoModel.getPagador().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getPagador().getDocumento()));
        if (boletoModel.getBeneficiarioFinal() != null) {
            boletoModel.getBeneficiarioFinal().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiarioFinal().getDocumento()));
        }
        if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorPercentualMulta())) {
            String instrucaoMulta = "APOS VENCIMENTO COBRAR MULTA DE " + BoletoUtil.formatarCasasDecimais(boletoModel.getValorPercentualMulta(), 2) + "%";
            boletoModel.getInstrucoes().add(new InformacaoModel(instrucaoMulta));
        }
        if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorPercentualJuros())) {
            BigDecimal valorPercentualJuros = boletoModel.getValorPercentualJuros();
            BigDecimal valorMoraDia = boletoModel.getValorPercentualJuros();
            if (boletoModel.getTipoJuros().equals((Object)TipoJurosEnum.PERCENTUAL_MENSAL) && BoletoUtil.isNotNullEMaiorQZero(valorPercentualJuros)) {
                valorPercentualJuros = valorPercentualJuros.divide(BigDecimal.valueOf(30L), MathContext.DECIMAL32);
                valorMoraDia = boletoModel.getValorBoleto().multiply(valorPercentualJuros, MathContext.DECIMAL32);
                valorMoraDia = valorMoraDia.divide(BigDecimal.valueOf(100L), MathContext.DECIMAL32);
            }
            String instrucaoJuros = "APOS VENCIMENTO COBRAR MORA DIARIA DE R$ " + BoletoUtil.formatarCasasDecimais(valorMoraDia, 2);
            boletoModel.getInstrucoes().add(new InformacaoModel(instrucaoJuros));
        }
        boletoModel.setLocaisDePagamento(new ArrayList<InformacaoModel>());
        boletoModel.getLocaisDePagamento().add(new InformacaoModel("PAG\u00c1VEL PREFERENCIALMENTE EM CANAIS DA SUA INSTITUI\u00c7\u00c3O FINANCEIRA"));
        this.validaDadosImpressao(boletoModel);
    }

    private void validaDadosImpressao(BoletoModel boletoModel) {
        ValidaUtils.validaBoletoModel(boletoModel, Arrays.asList("valor", "dataVencimento", "pagador", "pagador.numeroCpfCnpj", "pagador.nome", "pagador.endereco", "pagador.endereco.logradouro", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.cep", "pagador.endereco.uf", "beneficiario", "beneficiario.numeroCpfCnpj", "beneficiario.nome"));
    }

    private String tratarErro(Exception e, BoletoModel boletoModel) {
        String msg = e.getMessage() != null ? e.getMessage() : "";
        LinkedHashMap<String, String> errosMap = new LinkedHashMap<String, String>();
        errosMap.put("Invalid user credentials", "Credenciais inv\u00e1lidas. Verifique username/password/context.");
        errosMap.put("Missing parameter: username", "Par\u00e2metro 'username' n\u00e3o informado.");
        errosMap.put("Could not find a required Access Token", "Token de acesso (x-api-key) n\u00e3o informado ou inv\u00e1lido.");
        errosMap.put("UNAUTHORIZED", "Token de autoriza\u00e7\u00e3o inv\u00e1lido ou n\u00e3o informado.");
        errosMap.put("codigoBeneficiario", "C\u00f3digo de benefici\u00e1rio informado \u00e9 diferente do usu\u00e1rio autenticado.");
        errosMap.put("Cooperativa", "Cooperativa informada \u00e9 diferente da cooperativa do usu\u00e1rio.");
        errosMap.put("400", "Erro de requisi\u00e7\u00e3o: verifique os par\u00e2metros obrigat\u00f3rios.");
        errosMap.put("nossoNumero", "Erro ao baixar boleto, t\u00edtulo com nosso n\u00famero [ " + boletoModel.getNossoNumero() + " ] n\u00e3o encontrado.");
        errosMap.put("Campo obrigat\u00f3rio em branco", "Par\u00e2metro obrigat\u00f3rio n\u00e3o informado.");
        errosMap.put("grant_type", "Par\u00e2metro 'grant_type' n\u00e3o informado ou inv\u00e1lido.");
        errosMap.put("Content-Type", "Tipo de conte\u00fado inv\u00e1lido. Use 'application/json'.");
        errosMap.put("dataVencimento", "Data de vencimento obrigat\u00f3ria ou inv\u00e1lida.");
        errosMap.put("diasProtestoAuto", "O campo 'diasProtestoAuto' deve estar entre 3 e 99 dias.");
        errosMap.put("juros", "Valor de juros inv\u00e1lido. Deve ser maior que zero e menor que o valor do t\u00edtulo.");
        errosMap.put("multa", "Valor de multa inv\u00e1lido. Deve ser maior que zero.");
        errosMap.put("valorDesconto", "Valor de desconto inv\u00e1lido. Deve ser maior que zero e menor que o valor do t\u00edtulo.");
        errosMap.put("documento", "Documento do pagador/benefici\u00e1rio inv\u00e1lido (CPF/CNPJ).");
        errosMap.put("404", "Recurso n\u00e3o encontrado. Verifique a URL utilizada.");
        errosMap.put("415", "Tipo de conte\u00fado n\u00e3o suportado. Use 'application/json'.");
        errosMap.put("aguardando confirma\u00e7\u00e3o", "T\u00edtulo aguardando confirma\u00e7\u00e3o. Opera\u00e7\u00e3o n\u00e3o permitida.");
        errosMap.put("rejeitado", "T\u00edtulo rejeitado. Opera\u00e7\u00e3o n\u00e3o permitida.");
        errosMap.put("baixado", "T\u00edtulo j\u00e1 baixado.");
        errosMap.put("liquidado", "T\u00edtulo j\u00e1 liquidado.");
        errosMap.put("fluxo de negativa\u00e7\u00e3o", "T\u00edtulo em negativa\u00e7\u00e3o/protesto.");
        errosMap.put("anterior est\u00e1 em processamento", "J\u00e1 existe uma solicita\u00e7\u00e3o em andamento. Aguarde.");
        errosMap.put("n\u00e3o tem contratado", "Benefici\u00e1rio n\u00e3o possui Cobran\u00e7a Online contratada.");
        errosMap.put("convenio encerrado", "Conv\u00eanio do benefici\u00e1rio est\u00e1 encerrado. Verifique com a cooperativa.");
        errosMap.put("H\u00edbrido n\u00e3o contratado", "Produto h\u00edbrido n\u00e3o habilitado. Solicite habilita\u00e7\u00e3o junto \u00e0 cooperativa.");
        errosMap.put("Documento do pagador n\u00e3o pode ser o mesmo", "CPF/CNPJ do pagador n\u00e3o pode ser igual ao do benefici\u00e1rio.");
        errosMap.put("Documento do benefici\u00e1rio n\u00e3o pode ser o mesmo", "CPF/CNPJ do benefici\u00e1rio n\u00e3o pode ser igual ao do pagador/benefici\u00e1rio final.");
        errosMap.put("Data de vencimento tem que ser posterior", "A data de vencimento deve ser maior ou igual \u00e0 data atual.");
        errosMap.put("Esp\u00e9cie de documento n\u00e3o permite protesto", "A esp\u00e9cie do documento n\u00e3o permite protesto/negativa\u00e7\u00e3o.");
        errosMap.put("N\u00e3o permite juros", "N\u00e3o \u00e9 permitido informar juros ou multa para esp\u00e9cie 'Boleto Proposta'.");
        errosMap.put("Percentual juros deve ser menor que 100%", "Percentual de juros inv\u00e1lido. Deve ser menor que 100%.");
        errosMap.put("Percentual desconto", "Percentual de desconto inv\u00e1lido. Deve ser menor que 100%.");
        errosMap.put("Data de desconto", "Data de desconto inv\u00e1lida (n\u00e3o pode ser menor que a data atual).");
        errosMap.put("429", "Muitas requisi\u00e7\u00f5es em um curto espa\u00e7o de tempo. Aguarde e tente novamente.");
        errosMap.put("504", "Tempo limite excedido. O servi\u00e7o n\u00e3o respondeu no tempo esperado.");
        return errosMap.entrySet().stream().filter(entry -> msg.contains((CharSequence)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse("Erro n\u00e3o mapeado pela integra\u00e7\u00e3o. Retorno da API: " + msg);
    }
}

