/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicrei_api;

import br.com.java_brasil.boleto.model.Configuracao;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import br.com.java_brasil.boleto.service.bancos.inter_api.model.Token;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediTokenResponse;
import br.com.java_brasil.boleto.util.RestUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class ConfiguracaoSicrediAPI
implements Configuracao {
    private static final Logger log = Logger.getLogger(ConfiguracaoSicrediAPI.class.getName());
    @NotEmpty
    private String tokenId;
    @NotEmpty
    private String posto;
    @NotEmpty
    private String cooperativa;
    @NotEmpty
    private String codBene;
    @NotEmpty
    private String grandType = "password";
    @NotEmpty
    private String username;
    @NotEmpty
    private String password;
    private Integer diasParaNegativar;
    private Integer diasParaProtesto;
    private Integer validadeAposVencimento;
    @NotNull
    private AmbienteEnum ambiente;
    @NotEmpty
    private String urlBaseHomologacao = "https://api-parceiro.sicredi.com.br/sb/cobranca/boleto/v1/boletos";
    @NotEmpty
    private String urlBaseProducao = "https://api.sicredi.com.br/cobranca-bancaria/v2/cobranca/boleto/v1/boletos";
    @NotEmpty
    private String urlTokenHomologacao = "https://api-parceiro.sicredi.com.br/sb/auth/openapi/token";
    private String urlToken = "https://api-parceiro.sicredi.com.br/auth/openapi/token";
    @NotEmpty.List(value={@NotEmpty, @NotEmpty})
    private String urlImpressaoBoleto = "/pdf";
    private BoletoSicrediTokenResponse token;
    private String refreshToken;
    private LocalDateTime expiracaoToken;
    private final String arquivoJasper = "BoletoSicredi";
    private final String logo = "LogoSicredi.jpg";
    private InputStream modeloImpressaoBoleto;
    private HashMap<String, Object> parametrosImpressaoBoleto = new HashMap();

    public String urlToken() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlToken : this.urlTokenHomologacao;
    }

    public String urlBase() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlBaseProducao : this.urlBaseHomologacao;
    }

    public HashMap<String, Object> getParametrosImpressaoBoleto() {
        return this.parametrosImpressaoBoleto;
    }

    public void setModeloImpressaoBoleto(InputStream modeloImpressaoBoleto) {
        this.modeloImpressaoBoleto = modeloImpressaoBoleto;
    }

    @Override
    public InputStream modeloImpressaoBoleto() {
        if (this.modeloImpressaoBoleto == null) {
            try {
                this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoSicredi.jasper");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.modeloImpressaoBoleto;
    }

    @Override
    public void usarModeloImpressaoBoletoCarne() {
        try {
            this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoCarne.jasper");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public HashMap<String, Object> parametrosImpressaoBoleto() {
        Image imageLogo = null;
        try {
            InputStream inputStreamLogo = this.getClass().getResourceAsStream("/logo/LogoSicredi.jpg");
            imageLogo = new ImageIcon(IOUtils.toByteArray((InputStream)inputStreamLogo)).getImage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.parametrosImpressaoBoleto.put("LogoBanco", imageLogo);
        this.parametrosImpressaoBoleto.put("REPORT_LOCALE", new Locale("pt", "BR"));
        return this.parametrosImpressaoBoleto;
    }

    public BoletoSicrediTokenResponse getToken(ConfiguracaoSicrediAPI configuracao) throws IOException {
        if (this.token == null || this.getToken().expired()) {
            log.info("Gerando Token Sicredi");
            Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/x-www-form-urlencoded")};
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("username", configuracao.getUsername()));
            nvps.add(new BasicNameValuePair("password", configuracao.getPassword()));
            nvps.add(new BasicNameValuePair("scope", Token.TpScopeSicredi.COBRANCA.todos()));
            nvps.add(new BasicNameValuePair("grant_type", "password"));
            String url = configuracao.urlBase() + configuracao.getUrlToken();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
            httpPost.setHeaders(headers);
            CloseableHttpResponse response = RestUtil.enviaComando((HttpUriRequest)httpPost);
            String retorno = RestUtil.validaResponseERetornaBody(response);
            log.config("Retorno Token banco sicredi: " + retorno);
            JsonObject json = JsonParser.parseString((String)retorno).getAsJsonObject();
            this.token = new BoletoSicrediTokenResponse().create(json.toString());
            String token = json.get("access_token").getAsString();
            LocalDateTime expires = LocalDateTime.now().plusSeconds(json.get("expires_in").getAsInt());
            log.config("Token Banco sicredi: " + token);
            log.config("Expira: " + expires);
        }
        return this.token;
    }

    @Override
    public List<String> camposObrigatoriosBoleto() {
        return Arrays.asList("valor", "dataVencimento", "pagador", "pagador.numeroCpfCnpj", "pagador.nome", "pagador.endereco", "pagador.endereco.logradouro", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.cep", "pagador.endereco.uf", "beneficiario", "beneficiario.numeroCpfCnpj", "beneficiario.nome");
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getPosto() {
        return this.posto;
    }

    public String getCooperativa() {
        return this.cooperativa;
    }

    public String getCodBene() {
        return this.codBene;
    }

    public String getGrandType() {
        return this.grandType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getDiasParaNegativar() {
        return this.diasParaNegativar;
    }

    public Integer getDiasParaProtesto() {
        return this.diasParaProtesto;
    }

    public Integer getValidadeAposVencimento() {
        return this.validadeAposVencimento;
    }

    @NotNull
    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    public String getUrlBaseHomologacao() {
        return this.urlBaseHomologacao;
    }

    public String getUrlBaseProducao() {
        return this.urlBaseProducao;
    }

    public String getUrlTokenHomologacao() {
        return this.urlTokenHomologacao;
    }

    public String getUrlToken() {
        return this.urlToken;
    }

    public String getUrlImpressaoBoleto() {
        return this.urlImpressaoBoleto;
    }

    public BoletoSicrediTokenResponse getToken() {
        return this.token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public LocalDateTime getExpiracaoToken() {
        return this.expiracaoToken;
    }

    public String getArquivoJasper() {
        return this.arquivoJasper;
    }

    public String getLogo() {
        return this.logo;
    }

    public InputStream getModeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public void setPosto(String posto) {
        this.posto = posto;
    }

    public void setCooperativa(String cooperativa) {
        this.cooperativa = cooperativa;
    }

    public void setCodBene(String codBene) {
        this.codBene = codBene;
    }

    public void setGrandType(String grandType) {
        this.grandType = grandType;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDiasParaNegativar(Integer diasParaNegativar) {
        this.diasParaNegativar = diasParaNegativar;
    }

    public void setDiasParaProtesto(Integer diasParaProtesto) {
        this.diasParaProtesto = diasParaProtesto;
    }

    public void setValidadeAposVencimento(Integer validadeAposVencimento) {
        this.validadeAposVencimento = validadeAposVencimento;
    }

    public void setAmbiente(@NotNull AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public void setUrlBaseHomologacao(String urlBaseHomologacao) {
        this.urlBaseHomologacao = urlBaseHomologacao;
    }

    public void setUrlBaseProducao(String urlBaseProducao) {
        this.urlBaseProducao = urlBaseProducao;
    }

    public void setUrlTokenHomologacao(String urlTokenHomologacao) {
        this.urlTokenHomologacao = urlTokenHomologacao;
    }

    public void setUrlToken(String urlToken) {
        this.urlToken = urlToken;
    }

    public void setUrlImpressaoBoleto(String urlImpressaoBoleto) {
        this.urlImpressaoBoleto = urlImpressaoBoleto;
    }

    public void setToken(BoletoSicrediTokenResponse token) {
        this.token = token;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setExpiracaoToken(LocalDateTime expiracaoToken) {
        this.expiracaoToken = expiracaoToken;
    }

    public void setParametrosImpressaoBoleto(HashMap<String, Object> parametrosImpressaoBoleto) {
        this.parametrosImpressaoBoleto = parametrosImpressaoBoleto;
    }
}

