/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicrei_api;

import br.com.java_brasil.boleto.service.bancos.inter_api.model.Token;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.ConfiguracaoSicrediAPI;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediTokenResponse;
import br.com.java_brasil.boleto.util.RestUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class SicrediUtil {
    private static final Logger log = Logger.getLogger(SicrediUtil.class.getName());

    public static void acessToken(ConfiguracaoSicrediAPI configuracao) throws IOException {
        Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/x-www-form-urlencoded"), new BasicHeader("x-api-key", configuracao.getTokenId()), new BasicHeader("context", Token.TpScopeSicredi.COBRANCA.todos())};
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add((NameValuePair)new BasicNameValuePair("username", configuracao.getUsername()));
        nvps.add((NameValuePair)new BasicNameValuePair("password", configuracao.getPassword()));
        nvps.add((NameValuePair)new BasicNameValuePair("scope", "cobranca"));
        nvps.add((NameValuePair)new BasicNameValuePair("grant_type", "password"));
        SicrediUtil.capturaToken(configuracao, nvps, headers);
    }

    public static void refreshToken(ConfiguracaoSicrediAPI configuracao) throws IOException {
        Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/x-www-form-urlencoded"), new BasicHeader("x-api-key", configuracao.getTokenId()), new BasicHeader("context", Token.TpScopeSicredi.COBRANCA.todos())};
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add((NameValuePair)new BasicNameValuePair("username", configuracao.getUsername()));
        nvps.add((NameValuePair)new BasicNameValuePair("password", configuracao.getPassword()));
        nvps.add((NameValuePair)new BasicNameValuePair("scope", "COBRANCA"));
        nvps.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        nvps.add((NameValuePair)new BasicNameValuePair("refresh_token", configuracao.getRefreshToken()));
        SicrediUtil.capturaToken(configuracao, nvps, headers);
    }

    private static void capturaToken(ConfiguracaoSicrediAPI configuracao, List<NameValuePair> nvps, Header[] headers) throws IOException {
        HttpPost httpPost = new HttpPost(configuracao.urlToken());
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        httpPost.setHeaders(headers);
        CloseableHttpResponse response = RestUtil.enviaComando((HttpUriRequest)httpPost);
        String retorno = RestUtil.validaResponseERetornaBody(response);
        log.config("Retorno Token Sicredi: " + retorno);
        JsonObject json = JsonParser.parseString((String)retorno).getAsJsonObject();
        String token = json.get("access_token").getAsString();
        String refreshToken = json.get("refresh_token").getAsString();
        LocalDateTime expires = LocalDateTime.now().plusSeconds(json.get("expires_in").getAsInt());
        log.config("Token Sicredi: " + token);
        log.config("Refresh Token Sicredi: " + refreshToken);
        log.config("Expiracao: " + expires);
        configuracao.setToken(new BoletoSicrediTokenResponse().create(json.toString()));
        configuracao.setRefreshToken(refreshToken);
        configuracao.setExpiracaoToken(expires);
    }
}

