/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicrei_api.model;

import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.InformacaoModel;
import br.com.java_brasil.boleto.model.enums.SituacaoEnum;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.ConfiguracaoSicrediAPI;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediBeneficiarioFinal;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediBoleto;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediBoletoResponse;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediInstrucaoResponse;
import br.com.java_brasil.boleto.service.bancos.sicrei_api.model.BoletoSicrediPagador;
import br.com.java_brasil.boleto.util.BoletoUtil;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BoletoSicrediModelConverter {
    public static BoletoModel montaBoletoInstrucaoResponse(BoletoModel boletoModel, BoletoSicrediInstrucaoResponse response) {
        switch (response.getStatusComando()) {
            case "MOVIMENTO_ENVIADO": {
                if (!"BAIXA".equals(response.getTipoMensagem())) break;
                boletoModel.setSituacao(SituacaoEnum.BAIXADO);
            }
        }
        return boletoModel;
    }

    public static BoletoModel montaBoletoResponse(BoletoModel boletoModel, BoletoSicrediBoletoResponse boletoResponse) {
        boletoModel.setCodigoBarras(boletoResponse.getCodigoBarras());
        boletoModel.setLinhaDigitavel(boletoResponse.getLinhaDigitavel());
        boletoModel.setPixCopiaCola(boletoResponse.getCodigoQrCode());
        boletoModel.setNossoNumero(boletoResponse.getNossoNumero());
        if (StringUtils.isBlank((CharSequence)boletoResponse.getSituacao())) {
            boletoModel.setSituacao(SituacaoEnum.EM_ABERTO);
        } else {
            switch (boletoResponse.getSituacao()) {
                case "EM CARTEIRA": 
                case "EM CARTEIRA PIX": 
                case "VENCIDO": 
                case "PROTESTADO": 
                case "EM CARTORIO": 
                case "NEGATIVADO": 
                case "AGUARDANDO ENTRADA EM CARTORIO": 
                case "AGUARDANDO SUSTACAO DE CARTORIO": {
                    boletoModel.setSituacao(SituacaoEnum.EM_ABERTO);
                    break;
                }
                case "BAIXADO POR SOLICITACAO": {
                    boletoModel.setSituacao(SituacaoEnum.BAIXADO);
                    break;
                }
                case "LIQUIDADO": 
                case "LIQUIDADO CARTORIO": 
                case "LIQUIDADO REDE": 
                case "LIQUIDADO COMPE": 
                case "LIQUIDADO PIX": 
                case "LIQUIDADO CHEQUE": {
                    boletoModel.setSituacao(SituacaoEnum.LIQUIDADO);
                }
            }
        }
        return boletoModel;
    }

    public static BoletoSicrediBoleto montaBoletoRequest(BoletoModel boletoModel, ConfiguracaoSicrediAPI config) {
        BoletoSicrediBoleto boleto = new BoletoSicrediBoleto();
        if (config.getDiasParaProtesto() > 0) {
            boleto.setDiasProtestoAuto(config.getDiasParaProtesto());
        }
        if (config.getDiasParaNegativar() > 0) {
            boleto.setDiasNegativacaoAuto(config.getDiasParaNegativar());
        }
        if (config.getValidadeAposVencimento() > 0) {
            boleto.setValidadeAposVencimento(config.getValidadeAposVencimento());
        }
        boleto.setTipoCobranca(boletoModel.getTipoCobranca());
        boleto.setEspecieDocumento(boletoModel.getEspecieDocumento());
        boleto.setCodigoBeneficiario(boletoModel.getBeneficiario().getCodigoBeneficiario());
        boleto.setDataVencimento(BoletoUtil.getDataFormatoYYYYMMDD(boletoModel.getDataVencimento()));
        boleto.setSeuNumero(boletoModel.getNumeroBoleto());
        boleto.setValor(boletoModel.getValorBoleto().setScale(2, RoundingMode.HALF_UP));
        boleto.setDataVencimento(BoletoUtil.getDataFormatoYYYYMMDD(boletoModel.getDataVencimento()));
        boleto.setInformativos(BoletoSicrediModelConverter.toBoletoSicrediMsgInstrucao(boletoModel.getInstrucoes()));
        boleto.setMensagens(BoletoSicrediModelConverter.toBoletoSicrediMsgInstrucao(boletoModel.getDescricoes()));
        BoletoSicrediModelConverter.preenchedadosPagador(boletoModel, boleto);
        BoletoSicrediModelConverter.preecheDadosBeneficiario(boletoModel, boleto);
        BoletoSicrediModelConverter.preencheDadosJuros(boletoModel, boleto);
        BoletoSicrediModelConverter.preencheDadosMulta(boletoModel, boleto);
        BoletoSicrediModelConverter.preencheDesconto(boletoModel, boleto);
        return boleto;
    }

    private static List<String> toBoletoSicrediMsgInstrucao(List<InformacaoModel> listInfModel) {
        ArrayList<String> instrucoes = new ArrayList<String>();
        if (listInfModel != null && !listInfModel.isEmpty()) {
            listInfModel.forEach(infModel -> instrucoes.add(infModel.getInformacao()));
            return instrucoes;
        }
        return null;
    }

    private static void preecheDadosBeneficiario(BoletoModel boletoModel, BoletoSicrediBoleto boletoRequest) {
        BoletoSicrediBeneficiarioFinal beneficiario = new BoletoSicrediBeneficiarioFinal();
        beneficiario.setCodigo(boletoRequest.getCodigoBeneficiario());
        beneficiario.setTipoPessoa(boletoModel.getBeneficiario().getTipoPessoa());
        beneficiario.setNome(boletoModel.getBeneficiario().getNomeBeneficiario());
        beneficiario.setDocumento(boletoModel.getBeneficiario().getDocumento());
        if (boletoModel.getBeneficiario().getEndereco() != null) {
            beneficiario.setLogradouro(boletoModel.getBeneficiario().getEndereco().getLogradouro());
            beneficiario.setCidade(boletoModel.getBeneficiario().getEndereco().getCidade());
            beneficiario.setCep(Integer.parseInt(boletoModel.getBeneficiario().getEndereco().getCep()));
            beneficiario.setUf(boletoModel.getBeneficiario().getEndereco().getUf());
        }
        boletoRequest.setBeneficiarioFinal(beneficiario);
    }

    private static void preenchedadosPagador(BoletoModel boletoModel, BoletoSicrediBoleto boletoRequest) {
        BoletoSicrediPagador pagador = new BoletoSicrediPagador();
        pagador.setTipoPessoa(boletoModel.getPagador().getTipoPessoa());
        pagador.setDocumento(boletoModel.getPagador().getDocumento());
        pagador.setNome(BoletoUtil.limitarTamanhoString(boletoModel.getPagador().getNome(), 50));
        if (boletoModel.getPagador().getEndereco() != null) {
            pagador.setEndereco(boletoModel.getPagador().getEndereco().getLogradouro());
            pagador.setCidade(boletoModel.getPagador().getEndereco().getCidade());
            pagador.setCep(boletoModel.getPagador().getEndereco().getCep());
            pagador.setUf(boletoModel.getPagador().getEndereco().getUf());
        }
        boletoRequest.setPagador(pagador);
    }

    private static void preencheDesconto(BoletoModel boletoModel, BoletoSicrediBoleto boleto) {
        if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorDescontos())) {
            boleto.setTipoDesconto("VALOR");
            boleto.setDescontos(boletoModel.getValorDescontos().setScale(2, RoundingMode.HALF_UP));
        } else if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorPercentualDescontos())) {
            boleto.setTipoDesconto("PERCENTUAL");
            boleto.setDescontos(boletoModel.getValorPercentualDescontos().setScale(2, RoundingMode.HALF_UP));
        }
    }

    private static void preencheDadosJuros(BoletoModel boletoModel, BoletoSicrediBoleto boletoRequest) {
        switch (boletoModel.getTipoJuros()) {
            case PERCENTUAL_MENSAL: {
                if (!BoletoUtil.maiorQZero(boletoModel.getPercentualJuros())) break;
                boletoRequest.setTipoJuros("B");
                boletoRequest.setJuros(boletoModel.getPercentualJuros().setScale(2, RoundingMode.HALF_UP));
                break;
            }
            case VALOR_DIA: {
                if (!BoletoUtil.maiorQZero(boletoModel.getValorAcrescimos())) break;
                boletoRequest.setTipoJuros("A");
                boletoRequest.setJuros(boletoModel.getValorAcrescimos().setScale(2, RoundingMode.HALF_UP));
            }
        }
    }

    private static void preencheDadosMulta(BoletoModel boletoModel, BoletoSicrediBoleto boletoRequest) {
        switch (boletoModel.getTipoMulta()) {
            case VALOR: {
                if (!BoletoUtil.maiorQZero(boletoModel.getValorMulta())) break;
                boletoRequest.setMulta(boletoModel.getValorMulta().setScale(2, RoundingMode.HALF_UP));
                break;
            }
            case PERCENTUAL: {
                if (!BoletoUtil.maiorQZero(boletoModel.getPercentualMulta())) break;
                boletoRequest.setMulta(boletoModel.getPercentualMulta().setScale(2, RoundingMode.HALF_UP));
            }
        }
    }
}

