/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicrei_api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.time.LocalDateTime;

public class BoletoSicrediTokenResponse {
    @SerializedName(value="scope")
    private String scope;
    @SerializedName(value="access_token")
    private String accessToken;
    @SerializedName(value="expires_in")
    private int expiresIn;
    @SerializedName(value="refresh_expires_in")
    private int refreshExpiresIn;
    @SerializedName(value="refresh_token")
    private String refreshToken;
    @SerializedName(value="token_type")
    private String tokenType;
    @SerializedName(value="id_token")
    private String idToken;
    @SerializedName(value="not-before-policy")
    private String notBeforePolicy;
    @SerializedName(value="session_state")
    private String sessionState;
    @JsonIgnore
    private LocalDateTime dtExp;

    public BoletoSicrediTokenResponse create(String jsonToken) {
        JsonObject json = JsonParser.parseString((String)jsonToken).getAsJsonObject();
        this.accessToken = json.get("access_token").getAsString();
        this.refreshToken = json.get("refresh_token").getAsString();
        this.expiresIn = Integer.parseInt(json.get("expires_in").toString());
        JsonElement refreshNode = json.get("refresh_expires_in");
        if (refreshNode != null) {
            this.refreshExpiresIn = Integer.parseInt(json.get("refresh_expires_in").toString());
        }
        this.scope = json.get("scope").toString();
        this.tokenType = json.get("token_type").toString();
        LocalDateTime localDateTime = LocalDateTime.now();
        LocalDateTime plusNanos = localDateTime.plusSeconds(this.expiresIn);
        this.setDtExp(plusNanos);
        return this;
    }

    public boolean expired() {
        if (this.getDtExp() != null) {
            return this.getDtExp().isBefore(LocalDateTime.now());
        }
        return true;
    }

    public static BoletoSicrediTokenResponseBuilder builder() {
        return new BoletoSicrediTokenResponseBuilder();
    }

    public String getScope() {
        return this.scope;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public int getRefreshExpiresIn() {
        return this.refreshExpiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public String getNotBeforePolicy() {
        return this.notBeforePolicy;
    }

    public String getSessionState() {
        return this.sessionState;
    }

    public LocalDateTime getDtExp() {
        return this.dtExp;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setRefreshExpiresIn(int refreshExpiresIn) {
        this.refreshExpiresIn = refreshExpiresIn;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public void setNotBeforePolicy(String notBeforePolicy) {
        this.notBeforePolicy = notBeforePolicy;
    }

    public void setSessionState(String sessionState) {
        this.sessionState = sessionState;
    }

    @JsonIgnore
    public void setDtExp(LocalDateTime dtExp) {
        this.dtExp = dtExp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoletoSicrediTokenResponse)) {
            return false;
        }
        BoletoSicrediTokenResponse other = (BoletoSicrediTokenResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiresIn() != other.getExpiresIn()) {
            return false;
        }
        if (this.getRefreshExpiresIn() != other.getRefreshExpiresIn()) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
            return false;
        }
        String this$idToken = this.getIdToken();
        String other$idToken = other.getIdToken();
        if (this$idToken == null ? other$idToken != null : !this$idToken.equals(other$idToken)) {
            return false;
        }
        String this$notBeforePolicy = this.getNotBeforePolicy();
        String other$notBeforePolicy = other.getNotBeforePolicy();
        if (this$notBeforePolicy == null ? other$notBeforePolicy != null : !this$notBeforePolicy.equals(other$notBeforePolicy)) {
            return false;
        }
        String this$sessionState = this.getSessionState();
        String other$sessionState = other.getSessionState();
        if (this$sessionState == null ? other$sessionState != null : !this$sessionState.equals(other$sessionState)) {
            return false;
        }
        LocalDateTime this$dtExp = this.getDtExp();
        LocalDateTime other$dtExp = other.getDtExp();
        return !(this$dtExp == null ? other$dtExp != null : !((Object)this$dtExp).equals(other$dtExp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoletoSicrediTokenResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExpiresIn();
        result = result * 59 + this.getRefreshExpiresIn();
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        String $idToken = this.getIdToken();
        result = result * 59 + ($idToken == null ? 43 : $idToken.hashCode());
        String $notBeforePolicy = this.getNotBeforePolicy();
        result = result * 59 + ($notBeforePolicy == null ? 43 : $notBeforePolicy.hashCode());
        String $sessionState = this.getSessionState();
        result = result * 59 + ($sessionState == null ? 43 : $sessionState.hashCode());
        LocalDateTime $dtExp = this.getDtExp();
        result = result * 59 + ($dtExp == null ? 43 : ((Object)$dtExp).hashCode());
        return result;
    }

    public String toString() {
        return "BoletoSicrediTokenResponse(scope=" + this.getScope() + ", accessToken=" + this.getAccessToken() + ", expiresIn=" + this.getExpiresIn() + ", refreshExpiresIn=" + this.getRefreshExpiresIn() + ", refreshToken=" + this.getRefreshToken() + ", tokenType=" + this.getTokenType() + ", idToken=" + this.getIdToken() + ", notBeforePolicy=" + this.getNotBeforePolicy() + ", sessionState=" + this.getSessionState() + ", dtExp=" + this.getDtExp() + ")";
    }

    public BoletoSicrediTokenResponse() {
    }

    public BoletoSicrediTokenResponse(String scope, String accessToken, int expiresIn, int refreshExpiresIn, String refreshToken, String tokenType, String idToken, String notBeforePolicy, String sessionState, LocalDateTime dtExp) {
        this.scope = scope;
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.refreshExpiresIn = refreshExpiresIn;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
        this.idToken = idToken;
        this.notBeforePolicy = notBeforePolicy;
        this.sessionState = sessionState;
        this.dtExp = dtExp;
    }

    public static class BoletoSicrediTokenResponseBuilder {
        private String scope;
        private String accessToken;
        private int expiresIn;
        private int refreshExpiresIn;
        private String refreshToken;
        private String tokenType;
        private String idToken;
        private String notBeforePolicy;
        private String sessionState;
        private LocalDateTime dtExp;

        BoletoSicrediTokenResponseBuilder() {
        }

        public BoletoSicrediTokenResponseBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public BoletoSicrediTokenResponseBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public BoletoSicrediTokenResponseBuilder expiresIn(int expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public BoletoSicrediTokenResponseBuilder refreshExpiresIn(int refreshExpiresIn) {
            this.refreshExpiresIn = refreshExpiresIn;
            return this;
        }

        public BoletoSicrediTokenResponseBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public BoletoSicrediTokenResponseBuilder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public BoletoSicrediTokenResponseBuilder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public BoletoSicrediTokenResponseBuilder notBeforePolicy(String notBeforePolicy) {
            this.notBeforePolicy = notBeforePolicy;
            return this;
        }

        public BoletoSicrediTokenResponseBuilder sessionState(String sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        @JsonIgnore
        public BoletoSicrediTokenResponseBuilder dtExp(LocalDateTime dtExp) {
            this.dtExp = dtExp;
            return this;
        }

        public BoletoSicrediTokenResponse build() {
            return new BoletoSicrediTokenResponse(this.scope, this.accessToken, this.expiresIn, this.refreshExpiresIn, this.refreshToken, this.tokenType, this.idToken, this.notBeforePolicy, this.sessionState, this.dtExp);
        }

        public String toString() {
            return "BoletoSicrediTokenResponse.BoletoSicrediTokenResponseBuilder(scope=" + this.scope + ", accessToken=" + this.accessToken + ", expiresIn=" + this.expiresIn + ", refreshExpiresIn=" + this.refreshExpiresIn + ", refreshToken=" + this.refreshToken + ", tokenType=" + this.tokenType + ", idToken=" + this.idToken + ", notBeforePolicy=" + this.notBeforePolicy + ", sessionState=" + this.sessionState + ", dtExp=" + this.dtExp + ")";
        }
    }
}

