/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.util;

import br.com.java_brasil.boleto.exception.BoletoException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterName;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import net.sf.jasperreports.view.JasperViewer;

public class JasperUtil {
    private static final Logger log = Logger.getLogger(JasperUtil.class.getName());

    public static byte[] geraRelatorio(List<?> dados, HashMap<String, Object> parametros, String arquivoJasper, Class<?> classe, HashMap<String, String> arquivoJasperSub) throws Exception {
        try {
            JasperPrint jasperPrint = JasperUtil.geraJasperPrint(classe, arquivoJasper, arquivoJasperSub, parametros, dados);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    public static byte[] geraRelatorioXml(File fileXml, HashMap<String, Object> parametros, String expression, String arquivoJasper, Class<?> classe, HashMap<String, String> arquivoJasperSub) throws Exception {
        try {
            InputStream inputStream = classe.getResourceAsStream("/impressao/" + arquivoJasper + ".jasper");
            arquivoJasperSub.forEach((nome, jasperSub) -> {
                InputStream inputStreamSub = classe.getResourceAsStream("/impressao/" + jasperSub + ".jasper");
                parametros.put((String)nome, inputStreamSub);
            });
            JRXmlDataSource xmlDataSource = new JRXmlDataSource(fileXml, expression);
            JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)inputStream, parametros, (JRDataSource)xmlDataSource);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    public static byte[] geraBytesRelatorio(JasperPrint jasperPrint) throws Exception {
        try {
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static JasperPrint unirJasperPrints(List<JasperPrint> list) throws Exception {
        try {
            if (list.isEmpty()) {
                throw new Exception("N\u00e3o informado nenhum arquivo JasperPrint para unir.");
            }
            JasperPrint primeiroArquivo = list.get(0);
            list.stream().skip(1L).map(jp -> jp.getPages()).flatMap(Collection::stream).forEach(arg_0 -> ((JasperPrint)primeiroArquivo).addPage(arg_0));
            return primeiroArquivo;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static byte[] unirRelatorio(List<byte[]> list) throws Exception {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Document document = new Document();
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            for (byte[] in : list) {
                PdfReader reader = new PdfReader(in);
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(reader, i);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                }
            }
            outputStream.flush();
            document.close();
            outputStream.close();
            return outputStream.toByteArray();
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void geraRelatorioDesktop(List<?> dados, HashMap<String, Object> parametros, String arquivoJasper, Class<?> classe, HashMap<String, String> arquivoJasperSub, boolean diretoImpressora, PrintService printService) throws Exception {
        JasperPrint jasperPrint = JasperUtil.geraJasperPrint(classe, arquivoJasper, arquivoJasperSub, parametros, dados);
        JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
    }

    public static void geraRelatorioDesktop(JasperPrint jasperPrint, boolean diretoImpressora, PrintService printService) throws Exception {
        try {
            if (diretoImpressora) {
                if (printService == null) {
                    JasperPrintManager.printReport((JasperPrint)jasperPrint, (boolean)false);
                } else {
                    HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
                    printRequestAttributeSet.add(MediaSizeName.NA_LETTER);
                    HashPrintServiceAttributeSet printServiceAttributeSet = new HashPrintServiceAttributeSet();
                    printServiceAttributeSet.add(new PrinterName(printService.getName(), null));
                    JRPrintServiceExporter exporter = new JRPrintServiceExporter();
                    exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
                    configuration.setPrintRequestAttributeSet((PrintRequestAttributeSet)printRequestAttributeSet);
                    configuration.setPrintServiceAttributeSet((PrintServiceAttributeSet)printServiceAttributeSet);
                    configuration.setDisplayPageDialog(Boolean.valueOf(false));
                    configuration.setDisplayPrintDialog(Boolean.valueOf(false));
                    exporter.setConfiguration((ExporterConfiguration)configuration);
                    exporter.exportReport();
                }
            } else {
                JasperViewer.viewReport((JasperPrint)jasperPrint, (boolean)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    public static JasperPrint geraJasperPrint(Class<?> classe, String arquivoJasper, HashMap<String, String> arquivoJasperSub, HashMap<String, Object> parametros, List<?> dados) throws JRException {
        InputStream inputStream = classe.getResourceAsStream("/impressao/" + arquivoJasper + ".jasper");
        arquivoJasperSub.forEach((nome, jasperSub) -> {
            InputStream inputStreamSub = classe.getResourceAsStream("/impressao/" + jasperSub + ".jasper");
            parametros.put((String)nome, inputStreamSub);
        });
        JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)inputStream, parametros, (JRDataSource)new JRBeanCollectionDataSource(dados));
        return jasperPrint;
    }

    public static JasperPrint geraJasperPrint(InputStream arquivoJasper, HashMap<String, Object> parametros, List<?> dados) throws JRException {
        return JasperFillManager.fillReport((InputStream)arquivoJasper, parametros, (JRDataSource)new JRBeanCollectionDataSource(dados));
    }

    public static PrintService getImpressora(String impressora) throws Exception {
        PrintService[] services;
        PrintService serviceFound = null;
        for (PrintService service : services = PrintServiceLookup.lookupPrintServices(null, null)) {
            log.config("Impressora: " + service.getName());
            if (!service.getName().trim().equals(impressora.trim())) continue;
            serviceFound = service;
        }
        return serviceFound;
    }

    public static List<String> getImpressorasDisponiveis() throws Exception {
        PrintService[] services;
        ArrayList<String> list = new ArrayList<String>();
        for (PrintService service : services = PrintServiceLookup.lookupPrintServices(null, null)) {
            list.add(service.getName().trim());
        }
        return list;
    }
}

