/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.util;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.exception.RestException;
import br.com.java_brasil.boleto.util.HttpDeleteWithBody;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public final class RestUtil {
    private RestUtil() {
    }

    public static CloseableHttpResponse post(String url, Header[] headers, String json) {
        return RestUtil.post(url, headers, json, null, null);
    }

    public static CloseableHttpResponse post(String url, Header[] headers, String json, String caminhoCertificado, String senhaCertificado) {
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(json, "UTF-8");
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeaders(headers);
        if (StringUtils.isNotBlank((CharSequence)caminhoCertificado)) {
            return RestUtil.enviaComandoCertificado((HttpUriRequest)httpPost, caminhoCertificado, senhaCertificado);
        }
        return RestUtil.enviaComando((HttpUriRequest)httpPost);
    }

    public static CloseableHttpResponse patch(String url, Header[] headers, String json) {
        return RestUtil.patch(url, headers, json, null, null);
    }

    public static CloseableHttpResponse patch(String url, Header[] headers, String json, String caminhoCertificado, String senhaCertificado) {
        HttpPatch httpPatch = new HttpPatch(url);
        StringEntity entity = new StringEntity(json, "UTF-8");
        httpPatch.setEntity((HttpEntity)entity);
        httpPatch.setHeaders(headers);
        if (StringUtils.isNotBlank((CharSequence)caminhoCertificado)) {
            return RestUtil.enviaComandoCertificado((HttpUriRequest)httpPatch, caminhoCertificado, senhaCertificado);
        }
        return RestUtil.enviaComando((HttpUriRequest)httpPatch);
    }

    public static CloseableHttpResponse put(String url, Header[] headers, String json) {
        HttpPut httpPut = new HttpPut(url);
        StringEntity entity = new StringEntity(json, "UTF-8");
        httpPut.setEntity((HttpEntity)entity);
        httpPut.setHeaders(headers);
        return RestUtil.enviaComando((HttpUriRequest)httpPut);
    }

    public static CloseableHttpResponse get(String url, Header[] headers) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeaders(headers);
        return RestUtil.enviaComando((HttpUriRequest)httpGet);
    }

    public static CloseableHttpResponse del(String url, Header[] headers) {
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.setHeaders(headers);
        return RestUtil.enviaComando((HttpUriRequest)httpDelete);
    }

    public static CloseableHttpResponse del(String url, Header[] headers, String json, String caminhoCertificado, String senhaCertificado) {
        HttpDeleteWithBody httpDeleteWithBody = new HttpDeleteWithBody(url);
        StringEntity entity = new StringEntity(json, "UTF-8");
        httpDeleteWithBody.setEntity((HttpEntity)entity);
        httpDeleteWithBody.setHeaders(headers);
        return RestUtil.enviaComandoCertificado((HttpUriRequest)httpDeleteWithBody, caminhoCertificado, senhaCertificado);
    }

    public static CloseableHttpResponse enviaComando(HttpUriRequest request) {
        try {
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
            return client.execute(request);
        }
        catch (IOException e) {
            throw new RestException(e.getMessage(), e);
        }
    }

    public static CloseableHttpResponse enviaComandoCertificado(HttpUriRequest request, String caminhoCertificado, String senha) {
        try {
            KeyStore keyStore;
            try (InputStream keyStoreStream = Files.newInputStream(Paths.get(caminhoCertificado, new String[0]), new OpenOption[0]);){
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(keyStoreStream, StringUtils.isNotBlank((CharSequence)senha) ? senha.toCharArray() : null);
            }
            catch (CertificateException e) {
                throw new RestException(e.getMessage(), e);
            }
            SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(keyStore, StringUtils.isNotBlank((CharSequence)senha) ? senha.toCharArray() : null).build();
            CloseableHttpClient client = HttpClientBuilder.create().setSSLContext(sslContext).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
            return client.execute(request);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RestException(e.getMessage(), e);
        }
    }

    public static CloseableHttpResponse enviaComandoCertificadoByteArr(HttpUriRequest request, byte[] certificado, String senha) {
        SSLContext sslContext;
        KeyStore keyStore;
        try (ByteArrayInputStream certStream = new ByteArrayInputStream(certificado);){
            keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(certStream, StringUtils.isNotBlank((CharSequence)senha) ? senha.toCharArray() : null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RestException(e.getMessage(), e);
        }
        try {
            sslContext = SSLContexts.custom().loadKeyMaterial(keyStore, StringUtils.isNotBlank((CharSequence)senha) ? senha.toCharArray() : null).build();
        }
        catch (Exception e) {
            throw new RestException(e.getMessage(), e);
        }
        CloseableHttpClient client = HttpClientBuilder.create().setSSLContext(sslContext).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
        try {
            return client.execute(request);
        }
        catch (Exception e) {
            throw new BoletoException("Houve um erro com a execu\u00e7\u00e3o do comando com certificado", e);
        }
    }

    public static String validaResponseERetornaBody(CloseableHttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201 && response.getStatusLine().getStatusCode() != 202 && response.getStatusLine().getStatusCode() != 207) {
            String erro = response.getStatusLine().getStatusCode() + " - " + EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            throw new RestException(erro);
        }
        return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
    }

    public static String ObjectToJson(Object objeto) throws JsonProcessingException {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString(objeto);
    }

    public static <T> T JsonToObject(String json, Class<T> clazz) throws IOException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, false).readValue(json, clazz);
    }
}

