/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte;

import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.enuns.EstadosEnum;
import br.com.swconsultoria.cte.dom.enuns.ServicosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.schema_300.consReciCTe.TConsReciCTe;
import br.com.swconsultoria.cte.schema_300.retConsReciCTe.TRetConsReciCTe;
import br.com.swconsultoria.cte.util.LoggerUtil;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import br.com.swconsultoria.cte.util.WebServiceCteUtil;
import br.com.swconsultoria.cte.util.XmlCteUtil;
import br.com.swconsultoria.cte.wsdl.cteRetRecepcao.CteRetRecepcaoStub;
import br.com.swconsultoria.cte.wsdl.cteRetRecepcaoMS.CteRetRecepcaoStub;
import java.rmi.RemoteException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class ConsultaRecibo {
    ConsultaRecibo() {
    }

    static TRetConsReciCTe reciboCte(ConfiguracoesCte config, String recibo) throws CteException {
        try {
            TConsReciCTe consReciCTe = new TConsReciCTe();
            consReciCTe.setVersao("3.00");
            consReciCTe.setTpAmb(config.getAmbiente().getCodigo());
            consReciCTe.setNRec(recibo);
            String xml = XmlCteUtil.objectToXml(consReciCTe);
            LoggerUtil.log(ConsultaRecibo.class, "[XML-ENVIO]: " + xml);
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            if (config.getEstado().equals((Object)EstadosEnum.MS)) {
                return ConsultaRecibo.envioStubMS(config, ome);
            }
            return ConsultaRecibo.envioStub(config, ome);
        }
        catch (RemoteException | JAXBException | XMLStreamException e) {
            throw new CteException(e.getMessage());
        }
    }

    private static TRetConsReciCTe envioStubMS(ConfiguracoesCte config, OMElement ome) throws CteException, RemoteException, JAXBException {
        CteRetRecepcaoStub.CteDadosMsg dadosMsg = new CteRetRecepcaoStub.CteDadosMsg();
        dadosMsg.setExtraElement(ome);
        CteRetRecepcaoStub stub = new CteRetRecepcaoStub(WebServiceCteUtil.getUrl(config, ServicosEnum.CONSULTA_RECIBO));
        CteRetRecepcaoStub.CTeCabecMsg cteCabecMsg = new CteRetRecepcaoStub.CTeCabecMsg();
        cteCabecMsg.setCUF(String.valueOf(config.getEstado().getCodigoUF()));
        cteCabecMsg.setVersaoDados("3.00");
        CteRetRecepcaoStub.CteCabecMsgE cteCabecMsgE = new CteRetRecepcaoStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        if (ObjetoCTeUtil.verifica(config.getTimeout()).isPresent()) {
            stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
            stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
        }
        CteRetRecepcaoStub.CteRetRecepcaoResult result = stub.cteRetRecepcao(dadosMsg, cteCabecMsgE);
        LoggerUtil.log(ConsultaRecibo.class, "[XML-RETORNO]: " + result.getExtraElement().toString());
        return XmlCteUtil.xmlToObject(result.getExtraElement().toString(), TRetConsReciCTe.class);
    }

    private static TRetConsReciCTe envioStub(ConfiguracoesCte config, OMElement ome) throws CteException, RemoteException, JAXBException {
        CteRetRecepcaoStub.CteDadosMsg dadosMsg = new CteRetRecepcaoStub.CteDadosMsg();
        dadosMsg.setExtraElement(ome);
        br.com.swconsultoria.cte.wsdl.cteRetRecepcao.CteRetRecepcaoStub stub = new br.com.swconsultoria.cte.wsdl.cteRetRecepcao.CteRetRecepcaoStub(WebServiceCteUtil.getUrl(config, ServicosEnum.CONSULTA_RECIBO));
        CteRetRecepcaoStub.CteCabecMsg cteCabecMsg = new CteRetRecepcaoStub.CteCabecMsg();
        cteCabecMsg.setCUF(String.valueOf(config.getEstado().getCodigoUF()));
        cteCabecMsg.setVersaoDados("3.00");
        CteRetRecepcaoStub.CteCabecMsgE cteCabecMsgE = new CteRetRecepcaoStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        if (ObjetoCTeUtil.verifica(config.getTimeout()).isPresent()) {
            stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
            stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
        }
        CteRetRecepcaoStub.CteRetRecepcaoResult result = stub.cteRetRecepcao(dadosMsg, cteCabecMsgE);
        LoggerUtil.log(ConsultaRecibo.class, "[XML-RETORNO]: " + result.getExtraElement().toString());
        return XmlCteUtil.xmlToObject(result.getExtraElement().toString(), TRetConsReciCTe.class);
    }
}

