/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte;

import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.enuns.ServicosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.schema_300.consSitCTe.TConsSitCTe;
import br.com.swconsultoria.cte.schema_300.retConsSitCTe.TRetConsSitCTe;
import br.com.swconsultoria.cte.util.LoggerUtil;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import br.com.swconsultoria.cte.util.WebServiceCteUtil;
import br.com.swconsultoria.cte.util.XmlCteUtil;
import br.com.swconsultoria.cte.wsdl.CteConsulta.CteConsultaStub;
import java.rmi.RemoteException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class ConsultaXml {
    ConsultaXml() {
    }

    static TRetConsSitCTe consultaXml(ConfiguracoesCte config, String chave) throws CteException {
        try {
            TConsSitCTe consSitCTe = new TConsSitCTe();
            consSitCTe.setVersao("3.00");
            consSitCTe.setTpAmb(config.getAmbiente().getCodigo());
            consSitCTe.setXServ("CONSULTAR");
            consSitCTe.setChCTe(chave);
            String xml = XmlCteUtil.objectToXml(consSitCTe);
            LoggerUtil.log(ConsultaXml.class, "[XML-ENVIO]: " + xml);
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            CteConsultaStub.CteDadosMsg dadosMsg = new CteConsultaStub.CteDadosMsg();
            dadosMsg.setExtraElement(ome);
            CteConsultaStub stub = new CteConsultaStub(WebServiceCteUtil.getUrl(config, ServicosEnum.CONSULTA_XML));
            CteConsultaStub.CteCabecMsg cteCabecMsg = new CteConsultaStub.CteCabecMsg();
            cteCabecMsg.setCUF(String.valueOf(config.getEstado().getCodigoUF()));
            cteCabecMsg.setVersaoDados("3.00");
            CteConsultaStub.CteCabecMsgE cteCabecMsgE = new CteConsultaStub.CteCabecMsgE();
            cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
            if (ObjetoCTeUtil.verifica(config.getTimeout()).isPresent()) {
                stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
                stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
            }
            CteConsultaStub.CteConsultaCTResult result = stub.cteConsultaCT(dadosMsg, cteCabecMsgE);
            LoggerUtil.log(ConsultaXml.class, "[XML-RETORNO]: " + result.getExtraElement().toString());
            return XmlCteUtil.xmlToObject(result.getExtraElement().toString(), TRetConsSitCTe.class);
        }
        catch (RemoteException | JAXBException | XMLStreamException e) {
            throw new CteException(e.getMessage());
        }
    }
}

