/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte;

import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.enuns.ConsultaDFeEnum;
import br.com.swconsultoria.cte.dom.enuns.PessoaEnum;
import br.com.swconsultoria.cte.dom.enuns.ServicosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.schema_300.distdfeint.DistDFeInt;
import br.com.swconsultoria.cte.schema_300.retdistdfeint.RetDistDFeInt;
import br.com.swconsultoria.cte.util.LoggerUtil;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import br.com.swconsultoria.cte.util.WebServiceCteUtil;
import br.com.swconsultoria.cte.util.XmlCteUtil;
import br.com.swconsultoria.cte.wsdl.CTeDistribuicaoDFe.CTeDistribuicaoDFeStub;
import java.rmi.RemoteException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class DistribuicaoDFe {
    DistribuicaoDFe() {
    }

    static RetDistDFeInt consultaCte(ConfiguracoesCte config, PessoaEnum tipoPessoa, String cpfCnpj, ConsultaDFeEnum tipoConsulta, String nsuChave) throws CteException {
        try {
            DistDFeInt distDFeInt = new DistDFeInt();
            distDFeInt.setVersao("1.00");
            distDFeInt.setTpAmb(config.getAmbiente().getCodigo());
            distDFeInt.setCUFAutor(config.getEstado().getCodigoUF());
            if (PessoaEnum.JURIDICA.equals((Object)tipoPessoa)) {
                distDFeInt.setCNPJ(cpfCnpj);
            } else {
                distDFeInt.setCPF(cpfCnpj);
            }
            switch (tipoConsulta) {
                case NSU: {
                    DistDFeInt.DistNSU distNSU = new DistDFeInt.DistNSU();
                    distNSU.setUltNSU(nsuChave);
                    distDFeInt.setDistNSU(distNSU);
                    break;
                }
                case NSU_UNICO: {
                    DistDFeInt.ConsNSU consNSU = new DistDFeInt.ConsNSU();
                    consNSU.setNSU(nsuChave);
                    distDFeInt.setConsNSU(consNSU);
                }
            }
            String xml = XmlCteUtil.objectToXml(distDFeInt);
            LoggerUtil.log(DistribuicaoDFe.class, "[XML-ENVIO]: " + xml);
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            CTeDistribuicaoDFeStub.CteDadosMsg_type0 dadosMsgType0 = new CTeDistribuicaoDFeStub.CteDadosMsg_type0();
            dadosMsgType0.setExtraElement(ome);
            CTeDistribuicaoDFeStub.CteDistDFeInteresse distDFeInteresse = new CTeDistribuicaoDFeStub.CteDistDFeInteresse();
            distDFeInteresse.setCteDadosMsg(dadosMsgType0);
            CTeDistribuicaoDFeStub stub = new CTeDistribuicaoDFeStub(WebServiceCteUtil.getUrl(config, ServicosEnum.DISTRIBUICAO_DFE));
            if (ObjetoCTeUtil.verifica(config.getTimeout()).isPresent()) {
                stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
                stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
            }
            CTeDistribuicaoDFeStub.CteDistDFeInteresseResponse result = stub.cteDistDFeInteresse(distDFeInteresse);
            LoggerUtil.log(DistribuicaoDFe.class, "[XML-RETORNO]: " + result.getCteDistDFeInteresseResult().getExtraElement().toString());
            return XmlCteUtil.xmlToObject(result.getCteDistDFeInteresseResult().getExtraElement().toString(), RetDistDFeInt.class);
        }
        catch (RemoteException | JAXBException | XMLStreamException e) {
            throw new CteException(e.getMessage());
        }
    }
}

