/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte;

import br.com.swconsultoria.cte.Assinar;
import br.com.swconsultoria.cte.Validar;
import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.cte.dom.enuns.EstadosEnum;
import br.com.swconsultoria.cte.dom.enuns.ServicosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.util.LoggerUtil;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import br.com.swconsultoria.cte.util.WebServiceCteUtil;
import br.com.swconsultoria.cte.wsdl.cterecepcaoevento.CteRecepcaoEventoStub;
import br.com.swconsultoria.cte.wsdl.cterecepcaoeventoMS.CteRecepcaoEventoStub;
import java.rmi.RemoteException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class Eventos {
    Eventos() {
    }

    static String enviarEvento(ConfiguracoesCte config, String xml, ServicosEnum tipoEvento, boolean valida) throws CteException {
        try {
            xml = Assinar.assinaCte(config, xml, AssinaturaEnum.EVENTO);
            LoggerUtil.log(Eventos.class, "[XML-ENVIO-" + (Object)((Object)tipoEvento) + "]: " + xml);
            if (valida) {
                new Validar().validaXml(config, xml, ServicosEnum.EVENTO);
            }
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            if (config.getEstado().equals((Object)EstadosEnum.MS) || config.getEstado().equals((Object)EstadosEnum.MT)) {
                return Eventos.envioMS(config, tipoEvento, ome);
            }
            return Eventos.envio(config, tipoEvento, ome);
        }
        catch (RemoteException | XMLStreamException e) {
            throw new CteException(e.getMessage());
        }
    }

    private static String envio(ConfiguracoesCte config, ServicosEnum tipoEvento, OMElement ome) throws CteException, RemoteException {
        CteRecepcaoEventoStub.CteDadosMsg dadosMsg = new CteRecepcaoEventoStub.CteDadosMsg();
        dadosMsg.setExtraElement(ome);
        CteRecepcaoEventoStub.CteCabecMsg cteCabecMsg = new CteRecepcaoEventoStub.CteCabecMsg();
        cteCabecMsg.setCUF(String.valueOf(config.getEstado().getCodigoUF()));
        cteCabecMsg.setVersaoDados("3.00");
        CteRecepcaoEventoStub.CteCabecMsgE cteCabecMsgE = new CteRecepcaoEventoStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        String url = WebServiceCteUtil.getUrl(config, tipoEvento);
        CteRecepcaoEventoStub stub = new CteRecepcaoEventoStub(url);
        if (ObjetoCTeUtil.verifica(config.getTimeout()).isPresent()) {
            stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
            stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
        }
        CteRecepcaoEventoStub.CteRecepcaoEventoResult result = stub.cteRecepcaoEvento(dadosMsg, cteCabecMsgE);
        LoggerUtil.log(Eventos.class, "[XML-RETORNO-" + (Object)((Object)tipoEvento) + "]: " + result.getExtraElement().toString());
        return result.getExtraElement().toString();
    }

    private static String envioMS(ConfiguracoesCte config, ServicosEnum tipoEvento, OMElement ome) throws CteException, RemoteException {
        CteRecepcaoEventoStub.CteDadosMsg dadosMsg = new CteRecepcaoEventoStub.CteDadosMsg();
        dadosMsg.setExtraElement(ome);
        CteRecepcaoEventoStub.CTeCabecMsg cteCabecMsg = new CteRecepcaoEventoStub.CTeCabecMsg();
        cteCabecMsg.setCUF(String.valueOf(config.getEstado().getCodigoUF()));
        cteCabecMsg.setVersaoDados("3.00");
        CteRecepcaoEventoStub.CteCabecMsgE cteCabecMsgE = new CteRecepcaoEventoStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        String url = WebServiceCteUtil.getUrl(config, tipoEvento);
        br.com.swconsultoria.cte.wsdl.cterecepcaoeventoMS.CteRecepcaoEventoStub stub = new br.com.swconsultoria.cte.wsdl.cterecepcaoeventoMS.CteRecepcaoEventoStub(url);
        if (ObjetoCTeUtil.verifica(config.getTimeout()).isPresent()) {
            stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
            stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
        }
        CteRecepcaoEventoStub.CteRecepcaoEventoResult result = stub.cteRecepcaoEvento(dadosMsg, cteCabecMsgE);
        LoggerUtil.log(Eventos.class, "[XML-RETORNO-" + (Object)((Object)tipoEvento) + "]: " + result.getExtraElement().toString());
        return result.getExtraElement().toString();
    }
}

