/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte;

import br.com.swconsultoria.cte.Assinar;
import br.com.swconsultoria.cte.Validar;
import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.cte.dom.enuns.EstadosEnum;
import br.com.swconsultoria.cte.dom.enuns.ServicosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.schema_300.inutCTe.TInutCTe;
import br.com.swconsultoria.cte.schema_300.inutCTe.TRetInutCTe;
import br.com.swconsultoria.cte.util.LoggerUtil;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import br.com.swconsultoria.cte.util.WebServiceCteUtil;
import br.com.swconsultoria.cte.util.XmlCteUtil;
import br.com.swconsultoria.cte.wsdl.cteinutilizacao.CteInutilizacaoStub;
import br.com.swconsultoria.cte.wsdl.cteinutilizacaoMS.CteInutilizacaoStub;
import java.rmi.RemoteException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class Inutilizar {
    Inutilizar() {
    }

    static TRetInutCTe inutiliza(ConfiguracoesCte config, TInutCTe inutCTe, boolean validar) throws CteException {
        try {
            String xml = XmlCteUtil.objectToXml(inutCTe);
            xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
            xml = Assinar.assinaCte(config, xml, AssinaturaEnum.INUTILIZACAO);
            LoggerUtil.log(Inutilizar.class, "[XML-ENVIO]: " + xml);
            if (validar) {
                new Validar().validaXml(config, xml, ServicosEnum.INUTILIZACAO);
            }
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            if (config.getEstado().equals((Object)EstadosEnum.MS)) {
                return Inutilizar.enviaMS(config, ome);
            }
            return Inutilizar.envia(config, ome);
        }
        catch (RemoteException | JAXBException | XMLStreamException e) {
            throw new CteException(e.getMessage());
        }
    }

    private static TRetInutCTe enviaMS(ConfiguracoesCte config, OMElement ome) throws JAXBException, CteException, RemoteException {
        CteInutilizacaoStub stub = new CteInutilizacaoStub(WebServiceCteUtil.getUrl(config, ServicosEnum.INUTILIZACAO));
        CteInutilizacaoStub.CteDadosMsg dadosMsg = new CteInutilizacaoStub.CteDadosMsg();
        dadosMsg.setExtraElement(ome);
        CteInutilizacaoStub.CTeCabecMsg cteCabecMsg = new CteInutilizacaoStub.CTeCabecMsg();
        cteCabecMsg.setCUF(String.valueOf(config.getEstado().getCodigoUF()));
        cteCabecMsg.setVersaoDados("3.00");
        CteInutilizacaoStub.CteCabecMsgE cteCabecMsgE = new CteInutilizacaoStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        if (ObjetoCTeUtil.verifica(config.getTimeout()).isPresent()) {
            stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
            stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
        }
        CteInutilizacaoStub.CteInutilizacaoCTResult result = stub.cteInutilizacaoCT(dadosMsg, cteCabecMsgE);
        LoggerUtil.log(Inutilizar.class, "[XML-RETORNO]: " + result.getExtraElement().toString());
        return XmlCteUtil.xmlToObject(result.getExtraElement().toString(), TRetInutCTe.class);
    }

    private static TRetInutCTe envia(ConfiguracoesCte config, OMElement ome) throws JAXBException, CteException, RemoteException {
        br.com.swconsultoria.cte.wsdl.cteinutilizacao.CteInutilizacaoStub stub = new br.com.swconsultoria.cte.wsdl.cteinutilizacao.CteInutilizacaoStub(WebServiceCteUtil.getUrl(config, ServicosEnum.INUTILIZACAO));
        CteInutilizacaoStub.CteDadosMsg dadosMsg = new CteInutilizacaoStub.CteDadosMsg();
        dadosMsg.setExtraElement(ome);
        CteInutilizacaoStub.CteCabecMsg cteCabecMsg = new CteInutilizacaoStub.CteCabecMsg();
        cteCabecMsg.setCUF(String.valueOf(config.getEstado().getCodigoUF()));
        cteCabecMsg.setVersaoDados("3.00");
        CteInutilizacaoStub.CteCabecMsgE cteCabecMsgE = new CteInutilizacaoStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        if (ObjetoCTeUtil.verifica(config.getTimeout()).isPresent()) {
            stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
            stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
        }
        CteInutilizacaoStub.CteInutilizacaoCTResult result = stub.cteInutilizacaoCT(dadosMsg, cteCabecMsgE);
        LoggerUtil.log(Inutilizar.class, "[XML-RETORNO]: " + result.getExtraElement().toString());
        return XmlCteUtil.xmlToObject(result.getExtraElement().toString(), TRetInutCTe.class);
    }
}

