/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte;

import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.enuns.ServicosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.exception.CteValidacaoException;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import java.io.File;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

class Validar
implements ErrorHandler {
    private String listaComErrosDeValidacao = "";

    Validar() {
    }

    void validaXml(ConfiguracoesCte config, String xml, ServicosEnum servico) throws CteException {
        System.setProperty("jdk.xml.maxOccurLimit", "99999");
        String xsd = config.getPastaSchemas() + "/" + servico.getXsd();
        if (!new File(xsd).exists()) {
            throw new CteException("Schema Cte n\u00e3o Localizado: " + xsd);
        }
        String errosValidacao = this.validateXml(xml, xsd);
        if (ObjetoCTeUtil.verifica(errosValidacao).isPresent()) {
            throw new CteValidacaoException("Erro na valida\u00e7\u00e3o: " + errosValidacao);
        }
    }

    private String validateXml(String xml, String xsd) throws CteException {
        DocumentBuilder builder;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(true);
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", xsd);
        try {
            builder = docBuilderFactory.newDocumentBuilder();
            builder.setErrorHandler(this);
        }
        catch (ParserConfigurationException ex) {
            throw new CteException(ex.getMessage());
        }
        try {
            builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception ex) {
            throw new CteException(ex.toString());
        }
        return this.getListaComErrosDeValidacao();
    }

    @Override
    public void error(SAXParseException exception) {
        if (this.isError(exception)) {
            this.listaComErrosDeValidacao = this.listaComErrosDeValidacao + this.tratamentoRetorno(exception.getMessage());
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.listaComErrosDeValidacao = this.listaComErrosDeValidacao + this.tratamentoRetorno(exception.getMessage());
    }

    @Override
    public void warning(SAXParseException exception) {
        this.listaComErrosDeValidacao = this.listaComErrosDeValidacao + this.tratamentoRetorno(exception.getMessage());
    }

    private String tratamentoRetorno(String message) {
        message = message.replaceAll("cvc-type.3.1.3:", "-");
        message = message.replaceAll("cvc-attribute.3:", "-");
        message = message.replaceAll("cvc-complex-type.2.4.a:", "-");
        message = message.replaceAll("cvc-complex-type.2.4.b:", "-");
        message = message.replaceAll("cvc-complex-type.2.4.c:", "-");
        message = message.replaceAll("cvc-complex-type.2.4.d:", "-");
        message = message.replaceAll("cvc-complex-type.4:", "-");
        message = message.replaceAll("cvc-minLength-valid:", "-");
        message = message.replaceAll("The value", "O valor");
        message = message.replaceAll("Value", "Valor");
        message = message.replaceAll("with length", "com tamanho");
        message = message.replaceAll("is not facet-valid with respect to minLength", "n\u00e3o equivale ao tamanho m\u00ednimo");
        message = message.replaceAll("for type", "para o tipo");
        message = message.replaceAll("The content", "O conte\u00fado");
        message = message.replaceAll("of element", "do campo");
        message = message.replaceAll("is not complete", "n\u00e3o est\u00e1 completo");
        message = message.replaceAll("is not valid", "n\u00e3o \u00e9 v\u00e1lido");
        message = message.replaceAll("Attribute", "Campo");
        message = message.replaceAll("must appear on element", "precisa estar em");
        message = message.replaceAll("Invalid content was found starting with element", "Conte\u00fado inv\u00e1lido encontrado iniciando com o campo");
        message = message.replaceAll("One of", "Um dos Campos");
        message = message.replaceAll("is expected", "\u00e9 esperado");
        message = message.replaceAll("\\{", "");
        message = message.replaceAll("\\}", "");
        message = message.replaceAll("\"", "");
        message = message.replaceAll("http://www.portalfiscal.inf.br/cte:", "");
        return System.getProperty("line.separator") + message.trim();
    }

    private String getListaComErrosDeValidacao() {
        return this.listaComErrosDeValidacao;
    }

    private boolean isError(SAXParseException exception) {
        return !exception.getMessage().startsWith("cvc-enumeration-valid") && !exception.getMessage().startsWith("cvc-pattern-valid") && !exception.getMessage().startsWith("cvc-maxLength-valid") && !exception.getMessage().startsWith("cvc-datatype");
    }
}

