/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte.dom;

import br.com.swconsultoria.certificado.Certificado;
import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.cte.dom.enuns.AmbienteEnum;
import br.com.swconsultoria.cte.dom.enuns.EstadosEnum;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfiguracoesCte {
    private EstadosEnum estado;
    private AmbienteEnum ambiente;
    private Certificado certificado;
    private String pastaSchemas;
    private Integer timeout;
    private boolean validacaoDocumento = true;
    private String arquivoWebService;
    private InputStream cacert;

    public static ConfiguracoesCte criarConfiguracoes(EstadosEnum estado, AmbienteEnum ambiente, Certificado certificado, String pastaSchemas) throws CertificadoException {
        ObjetoCTeUtil.verifica(estado).orElseThrow(() -> new IllegalArgumentException("Estado n\u00e3o pode ser Nulo."));
        ObjetoCTeUtil.verifica(ambiente).orElseThrow(() -> new IllegalArgumentException("Ambiente n\u00e3o pode ser Nulo."));
        ObjetoCTeUtil.verifica(certificado).orElseThrow(() -> new IllegalArgumentException("Certificado n\u00e3o pode ser Nulo."));
        ConfiguracoesCte configuracoesCte = new ConfiguracoesCte();
        configuracoesCte.setEstado(estado);
        configuracoesCte.setAmbiente(ambiente);
        configuracoesCte.setCertificado(certificado);
        configuracoesCte.setPastaSchemas(pastaSchemas);
        try {
            System.setProperty("file.encoding", "UTF-8");
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new CertificadoException("Erro ao setar Encoding.");
        }
        if (Logger.getLogger("").isLoggable(Level.SEVERE)) {
            System.err.println("####################################################################");
            System.err.println("              Api Java Cte - Vers\u00e3o 3.00.8 - 15/01/2022         ");
            if (Logger.getLogger("").isLoggable(Level.WARNING)) {
                System.err.println(" Samuel Olivera - samuel@swconsultoria.com.br ");
            }
            System.err.println(" Pasta Schemas: " + pastaSchemas);
            System.err.println(" Ambiente: " + (ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? "Produ\u00e7\u00e3o" : "Homologa\u00e7\u00e3o") + " - Estado: " + estado.getNome());
            System.err.println("####################################################################");
        }
        if (!certificado.isValido()) {
            throw new CertificadoException("Certificado Vencido/Inv\u00e1lido");
        }
        return configuracoesCte;
    }

    public String getPastaSchemas() {
        return this.pastaSchemas;
    }

    private void setPastaSchemas(String pastaSchemas) {
        this.pastaSchemas = pastaSchemas;
    }

    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public Certificado getCertificado() {
        return this.certificado;
    }

    private void setCertificado(Certificado certificado) {
        this.certificado = certificado;
    }

    public EstadosEnum getEstado() {
        return this.estado;
    }

    public void setEstado(EstadosEnum estado) {
        this.estado = estado;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean isValidacaoDocumento() {
        return this.validacaoDocumento;
    }

    public void setValidacaoDocumento(boolean validacaoDocumento) {
        this.validacaoDocumento = validacaoDocumento;
    }

    public String getArquivoWebService() {
        return this.arquivoWebService;
    }

    public void setArquivoWebService(String arquivoWebService) {
        this.arquivoWebService = arquivoWebService;
    }

    public InputStream getCacert() {
        return this.cacert;
    }

    public void setCacert(InputStream cacert) {
        this.cacert = cacert;
    }
}

