/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte.util;

import br.com.swconsultoria.cte.Assinar;
import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.Evento;
import br.com.swconsultoria.cte.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.cte.dom.enuns.EventosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.schema_300.evCancCTe.EvCancCTe;
import br.com.swconsultoria.cte.schema_300.evCancCTe.TEvento;
import br.com.swconsultoria.cte.schema_300.evCancCTe.TProcEvento;
import br.com.swconsultoria.cte.schema_300.evCancCTe.TRetEvento;
import br.com.swconsultoria.cte.util.ConfiguracoesUtil;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import br.com.swconsultoria.cte.util.XmlCteUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.xml.bind.JAXBException;

public class CancelamentoUtil {
    public static TEvento montaCancelamento(Evento cancela, ConfiguracoesCte configuracao) throws CteException {
        return CancelamentoUtil.montaCancelamento(cancela, configuracao, ZoneId.systemDefault());
    }

    public static TEvento montaCancelamento(Evento evento2, ConfiguracoesCte config, ZoneId zoneId) throws CteException {
        TEvento enviEvento = new TEvento();
        enviEvento.setVersao("3.00");
        String id = "ID" + EventosEnum.CANCELAMENTO.getCodigo() + evento2.getChave() + "01";
        TEvento eventoCancela = new TEvento();
        eventoCancela.setVersao("3.00");
        TEvento.InfEvento infoEvento = new TEvento.InfEvento();
        infoEvento.setId(id);
        infoEvento.setCOrgao(config.getEstado().getCodigoUF());
        infoEvento.setTpAmb(config.getAmbiente().getCodigo());
        infoEvento.setCNPJ(evento2.getCnpj());
        infoEvento.setChCTe(evento2.getChave());
        infoEvento.setDhEvento(XmlCteUtil.dataCte(LocalDateTime.now(zoneId)));
        infoEvento.setTpEvento(EventosEnum.CANCELAMENTO.getCodigo());
        infoEvento.setNSeqEvento("1");
        EvCancCTe evCancCTe = new EvCancCTe();
        evCancCTe.setDescEvento("Cancelamento");
        evCancCTe.setNProt(evento2.getProtocolo());
        evCancCTe.setXJust(evento2.getMotivo());
        TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
        detEvento.setVersaoEvento("3.00");
        detEvento.setAny(ObjetoCTeUtil.objectToElement(evCancCTe, EvCancCTe.class, "evCancCTe"));
        infoEvento.setDetEvento(detEvento);
        enviEvento.setInfEvento(infoEvento);
        return enviEvento;
    }

    public static String criaProcEventoCancelamento(ConfiguracoesCte config, TEvento enviEvento, TRetEvento retorno) throws JAXBException, CteException {
        String xml = XmlCteUtil.objectToXml(enviEvento);
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        xml = xml.replaceAll("<evento v", "<evento xmlns=\"http://www.portalfiscal.inf.br/cte\" v");
        String assinado = Assinar.assinaCte(ConfiguracoesUtil.iniciaConfiguracoes(config), xml, AssinaturaEnum.EVENTO);
        TProcEvento procEvento2 = new TProcEvento();
        procEvento2.setVersao("3.00");
        procEvento2.setEventoCTe(XmlCteUtil.xmlToObject(assinado, TEvento.class));
        procEvento2.setRetEventoCTe(retorno);
        return XmlCteUtil.objectToXml(procEvento2);
    }
}

