/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte.util;

import br.com.swconsultoria.cte.Assinar;
import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.Evento;
import br.com.swconsultoria.cte.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.cte.dom.enuns.EventosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.schema_300.evCCeCTe.EvCCeCTe;
import br.com.swconsultoria.cte.schema_300.evCCeCTe.TEvento;
import br.com.swconsultoria.cte.schema_300.evCCeCTe.TProcEvento;
import br.com.swconsultoria.cte.schema_300.evCCeCTe.TRetEvento;
import br.com.swconsultoria.cte.util.ChaveUtil;
import br.com.swconsultoria.cte.util.ConfiguracoesUtil;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import br.com.swconsultoria.cte.util.XmlCteUtil;
import java.time.ZoneId;
import javax.xml.bind.JAXBException;

public class CartaCorrecaoUtil {
    public static TEvento montaCCe(Evento cce, ConfiguracoesCte configuracao) throws CteException {
        return CartaCorrecaoUtil.montaCCe(cce, configuracao, ZoneId.systemDefault());
    }

    public static TEvento montaCCe(Evento cce, ConfiguracoesCte configuracao, ZoneId zoneId) throws CteException {
        String id = "ID" + EventosEnum.CCE.getCodigo() + cce.getChave() + ChaveUtil.completarComZerosAEsquerda(String.valueOf(cce.getSequencia()), 2);
        TEvento evento2 = new TEvento();
        evento2.setVersao("3.00");
        TEvento.InfEvento infEvento = new TEvento.InfEvento();
        infEvento.setId(id);
        infEvento.setCOrgao(configuracao.getEstado().getCodigoUF());
        infEvento.setTpAmb(configuracao.getAmbiente().getCodigo());
        infEvento.setCNPJ(cce.getCnpj());
        infEvento.setChCTe(cce.getChave());
        infEvento.setDhEvento(XmlCteUtil.dataCte(cce.getDataEvento(), zoneId));
        infEvento.setTpEvento(EventosEnum.CCE.getCodigo());
        infEvento.setNSeqEvento(String.valueOf(cce.getSequencia()));
        EvCCeCTe evCCeCTe = new EvCCeCTe();
        evCCeCTe.setDescEvento("Carta de Correcao");
        evCCeCTe.setXCondUso("A Carta de Correcao e disciplinada pelo Art. 58-B do CONVENIO/SINIEF 06/89: Fica permitida a utilizacao de carta de correcao, para regularizacao de erro ocorrido na emissao de documentos fiscais relativos a prestacao de servico de transporte, desde que o erro nao esteja relacionado com: I - as variaveis que determinam o valor do imposto tais como: base de calculo, aliquota, diferenca de preco, quantidade, valor da prestacao;II - a correcao de dados cadastrais que implique mudanca do emitente, tomador, remetente ou do destinatario;III - a data de emissao ou de saida.");
        evCCeCTe.getInfCorrecao().addAll(cce.getListaCorrecoesCCe());
        TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
        detEvento.setVersaoEvento("3.00");
        detEvento.setAny(ObjetoCTeUtil.objectToElement(evCCeCTe, EvCCeCTe.class, "evCCeCTe"));
        infEvento.setDetEvento(detEvento);
        evento2.setInfEvento(infEvento);
        return evento2;
    }

    public static String criaProcEventoCCe(ConfiguracoesCte configuracoesCte, TEvento enviEvento, TRetEvento retorno) throws JAXBException, CteException {
        String xml = XmlCteUtil.objectToXml(enviEvento);
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        xml = xml.replaceAll("<evento v", "<evento xmlns=\"http://www.portalfiscal.inf.br/cte\" v");
        String assinado = Assinar.assinaCte(ConfiguracoesUtil.iniciaConfiguracoes(configuracoesCte), xml, AssinaturaEnum.EVENTO);
        TProcEvento procEvento2 = new TProcEvento();
        procEvento2.setEventoCTe(enviEvento);
        procEvento2.setRetEventoCTe(retorno);
        procEvento2.setVersao("3.00");
        return XmlCteUtil.objectToXml(procEvento2);
    }
}

